/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ckkloverdos.source.SourceType;

public class SourceTypeRegistry {
    private Map name2type = new HashMap();
    private Map ext2type = new HashMap();

    private String fixExt(String ext) {
        while ('.' == ext.charAt(0)) {
            ext = ext.substring(1);
        }
        return ext.toLowerCase();
    }

    public SourceType register(String name, String extension) {
        SourceType type = this.getTypeFromName(name);
        if (null == type) {
            type = new SourceType(name);
            this.name2type.put(name, type);
        }
        this.ext2type.put(this.fixExt(extension), type);
        return type;
    }

    public SourceType register(String name, String[] extensions) {
        SourceType type = this.getTypeFromName(name);
        if (null == type) {
            type = new SourceType(name);
            this.name2type.put(name, type);
        }
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.ext2type.put(this.fixExt(extension), type);
        }
        return type;
    }

    public SourceType getTypeFromExt(String extension) {
        return (SourceType)this.ext2type.get(this.fixExt(extension));
    }

    public SourceType getTypeFromName(String name) {
        return (SourceType)this.name2type.get(name);
    }

    public String[] getExtensionsForType(String name) {
        SourceType type = this.getTypeFromName(name);
        if (null == type) {
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        Iterator exts = this.ext2type.keySet().iterator();
        while (exts.hasNext()) {
            String ext = (String)exts.next();
            SourceType extType = (SourceType)this.ext2type.get(ext);
            if (!type.is(extType)) continue;
            retVal.add(ext);
        }
        return retVal.toArray(new String[retVal.size()]);
    }
}

