/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.resource;

import java.net.URL;
import org.ckkloverdos.resource.ClassLoaderResource;
import org.ckkloverdos.resource.EmptyResource;
import org.ckkloverdos.resource.IResource;
import org.ckkloverdos.resource.IResourceContext;
import org.ckkloverdos.resource.ResourseContextSkeleton;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.util.Assert;

public class ClassLoaderResourceContext
extends ResourseContextSkeleton
implements IToStringAware {
    private ClassLoader loader;

    public ClassLoaderResourceContext(ClassLoader loader) {
        this(loader, null);
    }

    public ClassLoaderResourceContext(ClassLoader loader, IResourceContext parent) {
        super(parent);
        Assert.notNull("Class loader cannot be null");
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public IResource getLocalResource(String name) {
        URL url = this.loader.getResource(name = this.normalize(name));
        if (null == url) {
            return EmptyResource.INSTANCE;
        }
        return new ClassLoaderResource(url);
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        ts.add(this.loader);
    }
}

