/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.ckkloverdos.resource.IResource;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;

public class ClassLoaderResource
implements IResource,
IToStringAware {
    private URL url;

    public ClassLoaderResource(URL url) {
        this.url = url;
    }

    public String getName() {
        return this.url.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.exists()) {
            return null;
        }
        return this.getURL().openStream();
    }

    public boolean exists() {
        return null != this.getURL();
    }

    public boolean isFile() {
        return this.exists() && this.getURL().getProtocol().equals("file");
    }

    public File getFile() {
        if (!this.isFile()) {
            return null;
        }
        return new File(this.getURL().getPath());
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        ts.add(this.url);
    }
}

