/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.ckkloverdos.reflect.FieldReflectiveAccessor;
import org.ckkloverdos.reflect.IReflectiveAccessor;
import org.ckkloverdos.reflect.MethodReflectiveAccessor;
import org.ckkloverdos.util.ClassUtil;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static IReflectiveAccessor getPropertyAccessor(Class c, String name) {
        String mname = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method method = ReflectUtil.getMethodNoArgs(c, mname);
        if (null != method) {
            return new MethodReflectiveAccessor(method);
        }
        mname = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
        method = ReflectUtil.getMethodNoArgs(c, mname);
        if (null != method) {
            return new MethodReflectiveAccessor(method);
        }
        Field field = ReflectUtil.getField(c, name);
        if (null != field) {
            return new FieldReflectiveAccessor(field);
        }
        return null;
    }

    public static Method getMethodNoArgs(Class clazz, String name) {
        return ReflectUtil.getMethod(clazz, name, new Class[0]);
    }

    public static Method getMethod(Class clazz, String name, Class[] types) {
        Method m = null;
        try {
            m = clazz.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return m;
    }

    public static Field getField(Class clazz, String name) {
        Field f = null;
        try {
            f = clazz.getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return f;
    }

    public static Constructor getConstructor(Class clazz, Class[] types, int yesModifiers) {
        return ReflectUtil.getConstructor(clazz, types, yesModifiers, 0);
    }

    public static Constructor getConstructor(Class clazz, Class[] types, int yesMod, int noMod) {
        Constructor c = null;
        try {
            c = clazz.getDeclaredConstructor(types);
            if ((c.getModifiers() & yesMod & ~noMod) == 0) {
                c = null;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return c;
    }

    public static Object newInstance(String className) {
        Class _class = ClassUtil.forName(className, null);
        if (_class == null) {
            return null;
        }
        return ReflectUtil.newInstance(_class);
    }

    public static Object newInstance(Class clazz) {
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return instance;
    }

    public static IReflectiveAccessor getAccesorForSelect(Class c, String propertyName, boolean isMethodCall) {
        if (isMethodCall) {
            return new MethodReflectiveAccessor(ReflectUtil.getMethodNoArgs(c, propertyName));
        }
        return ReflectUtil.getPropertyAccessor(c, propertyName);
    }
}

