/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.type.java.JavaType;
import org.ckkloverdos.type.java.JavaTypeRegistry;
import org.ckkloverdos.type.java.NameAndType;

public class JavaBeanProperty {
    private String name;
    private Class c;
    private JavaType jt;
    private boolean loaded;
    private Map properties;
    private JavaBeanProperty parent;
    private PropertyDescriptor pd;
    private JavaTypeRegistry typeRegistry;

    public JavaBeanProperty(Class c) {
        this(c, null);
    }

    public JavaBeanProperty(Class c, JavaTypeRegistry typeRegistry) {
        this("", c, typeRegistry);
    }

    public JavaBeanProperty(String name, Class c, JavaTypeRegistry typeRegistry) {
        this(name, c, null, null, typeRegistry);
    }

    private JavaBeanProperty(String name, Class c, JavaBeanProperty parent, PropertyDescriptor pd, JavaTypeRegistry typeRegistry) {
        this.name = name;
        this.c = c;
        this.properties = new HashMap();
        this.parent = parent;
        this.pd = pd;
        this.typeRegistry = typeRegistry;
    }

    public JavaTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.c);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                String pname = pd.getName();
                Class<?> ptype = pd.getPropertyType();
                JavaBeanProperty p = new JavaBeanProperty(pname, ptype, this, pd, this.typeRegistry);
                this.properties.put(pname, p);
            }
            this.loaded = true;
        }
        catch (IntrospectionException e) {
            StdLog.error(e);
        }
    }

    public JavaBeanProperty[] getProperties() {
        return this.properties.values().toArray(new JavaBeanProperty[0]);
    }

    public JavaBeanProperty getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public JavaType getType() {
        if (null != this.typeRegistry) {
            return this.typeRegistry.getByClass(this.c);
        }
        if (null == this.jt) {
            this.jt = new JavaType(this.c);
        }
        return this.jt;
    }

    public NameAndType getNameType() {
        return new NameAndType(this.getName(), this.getType());
    }

    public NameAndType getFullNameType() {
        return this.getFullNameType(true);
    }

    public NameAndType getFullNameType(boolean includeTopParent) {
        return new NameAndType(this.getFullName(includeTopParent), this.getType());
    }

    public String getFullName() {
        return this.getFullName(true);
    }

    public String getFullName(boolean includeTopParent) {
        String name = this.name;
        JavaBeanProperty parent = this.parent;
        while (null != parent) {
            if (parent.name.length() > 0 && (includeTopParent || null != parent.parent)) {
                name = parent.name + "." + name;
            }
            parent = parent.parent;
        }
        return name;
    }

    public Class getJavaClass() {
        return this.c;
    }

    public String getReadMethodName() {
        return this.pd.getReadMethod().getName();
    }

    public boolean hasProperty(String name) {
        this.load();
        return null != this.getProperty(name);
    }

    public String getPropertyAccessor(boolean fullyQualified) {
        return this.getPropertyAccessor(fullyQualified, true);
    }

    public String getPropertyAccessor(boolean fullyQualified, boolean includeTopParent) {
        if (fullyQualified) {
            return this.getFullName(includeTopParent);
        }
        return this.getName();
    }

    public String getReadMethodAccesor(boolean fullyQualified) {
        return this.getReadMethodAccesor(fullyQualified, true);
    }

    public String getReadMethodAccesor(boolean fullyQualified, boolean includeTopParent) {
        String pname;
        String accessor = this.getReadMethodName() + "()";
        JavaBeanProperty parent = this.parent;
        if (fullyQualified && (pname = parent.name).length() > 0) {
            accessor = null == parent.parent && includeTopParent ? pname + "." + accessor : parent.getReadMethodAccesor(fullyQualified) + "." + accessor;
        }
        return accessor;
    }

    public JavaBeanProperty getProperty(String name) {
        this.load();
        if (this.properties.containsKey(name)) {
            return (JavaBeanProperty)this.properties.get(name);
        }
        if (-1 == name.indexOf(46)) {
            return null;
        }
        return this.getNestedProperty(name);
    }

    private JavaBeanProperty getNestedProperty(String name) {
        this.load();
        String[] parts = name.split("\\.");
        String partialNestedName = "";
        JavaBeanProperty jbp = this;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!jbp.hasProperty(part)) {
                return null;
            }
            JavaBeanProperty jbppart = (JavaBeanProperty)jbp.properties.get(part);
            partialNestedName = "".equals(partialNestedName) ? part : partialNestedName + "." + part;
            this.properties.put(partialNestedName, new JavaBeanProperty(jbppart.name, jbppart.c, jbp, jbppart.pd, jbppart.typeRegistry));
            jbp = jbppart;
        }
        return jbp;
    }

    public String toString() {
        String repr = this.getFullName();
        if (repr.length() > this.name.length()) {
            int pos = repr.lastIndexOf(this.name);
            repr = "[" + repr.substring(0, pos) + "]" + repr.substring(pos);
        }
        String par = null == this.parent ? "" : this.parent.getFullName();
        return repr + ": " + this.c.getName() + ", parent = " + par;
    }
}

