/*
     Copyright (c) 1999,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
// StringComparison
//#include <stdio.h>
//#include <string.h>
//#include <stdlib.h>

signed short int StringComparison(unsigned char *ToCompare, unsigned char *CompVar, unsigned char Type);
void StringConversion(unsigned char *StringToConvert, unsigned short int max_size);
signed short int StringParseGrid(unsigned char *GridArray);

signed short int StringComparison(unsigned char *ToCompare, unsigned char *CompVar, unsigned char Type)
{
	unsigned char GridArray[15] = "\x0";
	signed short int Parsed = 0;
	StringConversion(ToCompare, strlen(CompVar));
	if (ToCompare[0] == '-' && Type == 0) // Unsigned values only
	{
		return (-2); // Invalid value
	}
	if (ToCompare[0] == '-' && CompVar[0] == '+')
	{
		return (-1); // Value is too small for comparison
	}
	else if (ToCompare[0] == '+' && CompVar[0] == '-')
	{
		return (1); // Value is larger than Comparing Variable
	}
	else
	{
		for (unsigned short int a = 1; a < (strlen(CompVar)); a++)
		{
			if (ToCompare[a] > CompVar[a])
			{
				strcat(GridArray, "1");
			}
			else if (ToCompare[a] < CompVar[a])
			{
				strcat(GridArray, "0");
			}
			else if (ToCompare[a] == CompVar[a])
			{
				strcat(GridArray, "2");
			}
		}
	}
	Parsed = StringParseGrid(GridArray);
	return (Parsed);
}

void StringConversion(unsigned char *StringToConvert, unsigned short int max_size)
{
	unsigned char TemporaryString[15] = "\x0";
	if (strlen(StringToConvert) < max_size)
	{
		if (StringToConvert[0] == '-')
		{
			strcpy(TemporaryString, "-");
		}
		else
		{
			strcpy(TemporaryString, "+");
		}
		for (signed short int a = 0; a < ((max_size - 1) - (strlen(StringToConvert) - ((StringToConvert[0] == '-' || StringToConvert[0] == '+') ? 1 : 0))); a++)
		{
			strcat(TemporaryString, "0");
		}
		if (StringToConvert[0] == '-' || StringToConvert[0] == '+')
			strcat(TemporaryString, StringToConvert + 1);
		else
			strcat(TemporaryString, StringToConvert);
	}
	if (strlen(StringToConvert) == max_size)
	{
		strcpy(TemporaryString, StringToConvert);
	}
	strcpy(StringToConvert, TemporaryString);
}

signed short int StringParseGrid(unsigned char *GridArray)
{
	unsigned char Equal = 0;
	unsigned char Ok = 0;
	unsigned char Watcher = 0;
	for (unsigned short int a = 0; a < strlen(GridArray); a++)
	{
		if (GridArray[a] == '0')
		{
			Watcher = 0;
			Ok = 1;
			break;
		}
		if (GridArray[a] == '2')
		{
			Watcher = 1;
			Equal = 1;
		}
		if (GridArray[a] == '1' && Equal == 1)
		{
			Watcher = 0;
			Ok = 0;
			break;
		}
	}
	if (Watcher == 1)
	{
		Ok = 1; // Set because string was equal
	}
	return ((Ok == 1 ? 2 : -2));
}
