/*
     Copyright (c) 1999,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
/*
  This copy of the code is exactly as it was when V0.22 was released.
  While some information in here is no longer relevant, much of it is.
*/

/*
	Legend Of the Red Dragon (L.O.R.D.) Editor

	This program opens LENEMY.DAT and PLAYER.DAT to modify the
	player and monster records and then rewrites them to the data
	files.
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include "FILEIO.CPP" // File IO routines
#include "KEYIO.CPP" // Keyboard IO routines

#include "lordstrc.h"
#define MAXPATH 80 // normally in DIR.h

#define ALE_DOS

const unsigned char *PROGNAME = "ALE (Advanced LORD Editor)"; // Advanced LORD Editor
const unsigned char *PROGNAME_COLOR = "`0FALE `08(`0FA`07dva`08nced `0FLORD E`07di`08tor`08)"; // Colorized Name
const unsigned char *VERSION = "V0.22";
const unsigned char *VERSION_COLOR = "`0FV`080`03.`0822"; // Colorized Version
const unsigned char *Author = "Mike Dillon";
const unsigned char *Member = "Elysium Software";
const unsigned char *CREATION_DATE = __DATE__;
const unsigned char *CREATION_TIME = __TIME__;

unsigned char *TString;
unsigned char ColorCodeOverride = 0;
unsigned char QuestionLine = 0;

struct _lightbar {
	unsigned char string[80];
	unsigned char x_pos;
	unsigned char y_pos;
};

struct _lightbar mlightbar[10] = {
	{ "`0FN`09ame        ", 6, 2 },
	{ "`0FS`09trength    ", 6, 3 },
	{ "`0FH`09itpoints   ", 6, 4 },
	{ "`0FW`09eapon Name ", 6, 5 },
	{ "`0FG`09old        ", 6, 6 },
	{ "`0FE`09xperience  ", 6, 7 },
	{ "`0FD`09eath       ", 6, 8 },
};

struct _lightbar plightbar[35] = {
	{ "`0FR`09eal `0FN`09ame  ", 6, 2 }, { "`0FH`09andle     ", 6, 3 },	{ "`0FE`09xperience         ", 6, 4 },
	{ "`0FH`09itpoints `0FN`09ow      ", 6, 5 },         { "`0FH`09itpoints `0FM`09ax      ", 6, 6 },
	{ "`0FS`09trength           ", 6, 7 },               { "`0FD`09efense            ", 6, 8 },
	{ "`0FC`09harm              ", 6, 9 },               { "`0FW`09eapon `0FN`09umber      ", 6, 10 },
	{ "`0FW`09eapon `0FN`09ame        ", 6, 11 },        { "`0FA`09rmor `0FN`09umber       ", 6, 12 },
	{ "`0FA`09rmor `0FN`09ame         ", 6, 13 },        { "`0FF`09orest `0FF`09ights `0FL`09eft ", 6, 14 },
	{ "`0FH`09uman `0FF`09ights `0FL`09eft  ", 6, 15 },  { "`0FG`09old `0FI`09n `0FH`09and       ", 6, 16 },
	{ "`0FG`09old `0FI`09n `0FB`09ank       ", 6, 17 },  { "`0FM`09arried `0FT`09o         ", 6, 18 },
	{ "`0FO`09n `0FN`09ow`01?            ", 6, 19 },     { "`0FL`09evel             ", 46, 3 },
	{ "`0FC`09lass             ", 46, 4 },               { "`0FS`09kills `0FL`09evel      ", 46, 5 },
	{ "`0FS`09kills `0FL`09eft `0FT`09oday ", 46, 6 },   { "`0FG`09ender            ", 46, 7 },
	{ "`0FL`09ays              ", 46, 8 },               { "`0FK`09ids              ", 46, 9 },
	{ "`0FP`09layer `0FK`09ills      ", 46, 10 },        { "`0FG`09ame `0FW`09ins         ", 46, 11 },
	{ "`0FG`09ems              ", 46, 12 },              { "`0FH`09orse`01?            ", 46, 13 },
	{ "`0FA`09t `0FI`09nn`01?           ", 46, 14 },     { "`0FS`09een `0FD`09ragon`01?      ", 46, 15 },
	{ "`0FS`09een `0FM`09aster`01?      ", 46, 16 },     { "`0FS`09een `0FB`09ard`01?        ", 46, 17 },
	{ "`0FS`09een `0FV`09iolet`01?      ", 46, 18 },     { "`0FD`09ead`01?             ", 46, 19 }
};

unsigned char *CompletePath(unsigned char *File_Name);
unsigned short int NumberOfFileEntries(unsigned char *FileName, unsigned short int S_Size, unsigned char *FileMode);
void IntroMenu(void);
void DisplayMonster(monst Monster, unsigned short int MRec);
void UpdateMonster(monst Monster, unsigned short int MRec, signed short int pos);
void DisplayPlayer(player_info Player);
void UpdatePlayer(player_info Player, signed short int pos);
void DisplaySetup(void);
void BasePrompt(unsigned short int Position, signed short int Records);
void EditPlayer(player_info *Players, signed short int PRecords);
void EditMonster(monst *Monsters, signed short int MRecords);
void Setup(void);
void PlayerChange(player_info &Player, unsigned short int Ask);
void MonsterChange(monst &Monster, unsigned short int Ask);
void GetDirectory(void);
unsigned char *ptc(unsigned char *pas_string);
void ctp(unsigned char *c_string);
unsigned char *limit(unsigned char *string, unsigned short int length);
unsigned char *yesno(unsigned short int Value);
unsigned short int Check_OnNow(signed short int PRecords);
unsigned short int OnNow_Disclaimer(void);
void PLightBar(signed short int position, signed short int direction);
void MLightBar(signed short int position, signed short int direction);

/* Intermediary Gets*/
void GetS(unsigned char *string, unsigned short int length, unsigned char *orig);
void GetN(signed short int &Var, signed short int min, signed short int max, signed short int Original, unsigned char NegFlag = 0);
void GetNC(signed char &Var, signed short int min, signed short int max, signed char Original);
void GetNL(signed long int &Var, signed long int min, unsigned long int max, signed long int Original);
void GetB(signed short int &Var);
void GetBC(signed char &Var);
void GetSkT(player_info &Player);
void GetSkL(player_info &Player);

// Color Routine
void ColorCodePrintf(unsigned char *Format_String,...);

int main(void)
{
	unsigned char ch = '0';
	player_info *Player = (player_info *)malloc(sizeof(player_info));
	monst *Monster = (monst *)malloc(sizeof(monst));
//	player_info Players[255]; // Array of 255 Players
//	monst Monsters[255]; // Array of 255 Monsters
	unsigned short int check = 0, override = 0;
	signed short int PRecords = 0, MRecords = 0; // Records count
	signed short int SetupChange = 0;
	signed short int PEIndex = 0, MEIndex = 0; // Entry Index
	unsigned char File[4][80] = {
	"ALE.DAT", "PLAYER.DAT", "LENEMY.DAT" };
	textattr(LIGHTGRAY); // set default color
	if ((!Player) || (!Monster))
	{
		printf("Error allocating memory for the player and monster structures!!!!!");
		exit(0);
	}
#ifdef ALE_DOS
	FindMultiTasker();
#endif
	LoadBinaryFile(File[0], &setup, sizeof(struct _setup));
	PRecords = NumberOfFileEntries(CompletePath(File[1]), sizeof(struct player_info), "rb");
	MRecords = NumberOfFileEntries(CompletePath(File[2]), sizeof(struct monst), "rb");
//	PRecords = LoadBinaryFile(CompletePath(File[1]), Players, sizeof(struct player_info));
//	MRecords = LoadBinaryFile(CompletePath(File[2]), Monsters, sizeof(struct monst));
	check = Check_OnNow(PRecords);
	clrscr();
	while (ch != '4' && ch != '\x1B')
	{
		if (SetupChange == 1)
		{
			PRecords = LoadBinaryFile(CompletePath(File[1]), Players, sizeof(struct player_info));
			MRecords = LoadBinaryFile(CompletePath(File[2]), Monsters, sizeof(struct monst));
			SetupChange = 0;
		}
		if (ch >= '0' && ch <= '3')
		{
			clrscr();
			IntroMenu();
		}
		ch = getch();
		switch (ch)
		{
			case '1': if (check != 0 && override != 1 && PRecords != -1)
				  {
					override = OnNow_Disclaimer();
				  }
				  else
				  {
					override = 1;
				  }
				  if (override == 1)
				  {
					EditPlayer(Players, PRecords);
				  }
				  break;
			case '2': EditMonster(Monsters, MRecords); break;
			case '3': Setup();
				  SetupChange = 1;
				  break;
		}
	}
	clrscr();
	ColorCodePrintf("`0FS`08aving files`03.................");
	SaveBinaryFile(File[0], &setup, sizeof(struct _setup), 1);
	if (PRecords != -1)
	{
		SaveBinaryFile(CompletePath(File[1]), Players, sizeof(struct player_info), PRecords);
	}
	else
	{
		ColorCodePrintf("`0FPlayer`01.`0Fdat `04skipped`03...");
	}
	if (MRecords != -1)
	{
		SaveBinaryFile(CompletePath(File[2]), Monsters, sizeof(struct monst), MRecords);
	}
	else
	{
		ColorCodePrintf("`0FLenemy`01.`0Fdat `04skipped`03...");
	}
	ColorCodePrintf(" `0FB`07y`08e `0FB`07y`08e`01!");
	free(Monster);
	free(Player);
	return 0;
}

unsigned char *CompletePath(unsigned char *File_Name)
{
	strcpy(temp_string, setup.lordloc);
	strcat(temp_string, File_Name);
	return (temp_string);
}

unsigned short int NumberOfFileEntries(unsigned char *FileName, unsigned short int S_Size, unsigned char *FileMode)
{
	FILE *FileToCheck;
	unsigned short int CIndex = 0, RStatus = 0, ReadTimes = 1;
	TString = (unsigned char *)malloc(S_Size);
	if (!TString)
	{
		return (-1);
	}
	if ((FileToCheck = fopen(FileName, FileMode)) == NULL)
	{
		return (-1);
	}
	do {
		RStatus = fread(&TString, S_Size, ReadTimes, FileToCheck);
		if (RStatus == ReadTimes)
		{
			CIndex++;
		}
	} while (RStatus == ReadTimes);
	fclose(FileToCheck);
	free(TString);
	return (CIndex);
}

void IntroMenu(void)
{
	unsigned short int cent_title = (80 - (strlen(PROGNAME) + strlen(VERSION) + 1)) / 2;
	unsigned short int cent = (80 - strlen("(3) Setup/Configure")) / 2;
	gotoxy(cent_title, 3);
	ColorCodePrintf("%s %s", PROGNAME_COLOR, VERSION_COLOR);
	gotoxy(cent,10);
	ColorCodePrintf("`08(`0F1`08) `0FP`03layer Editor");
	gotoxy(cent,11);
	ColorCodePrintf("`08(`0F2`08) `0FM`03onster Editor");
	gotoxy(cent,12);
	ColorCodePrintf("`08(`0F3`08) `0FS`03etup`01/`03Configure");
	gotoxy(cent,13);
	ColorCodePrintf("`08(`0F4`08) `0FE`03nd Program");
	gotoxy(2,23);
	ColorCodePrintf("`0FC`08reated by `0FMike Dillon `08of `0FE`09lysium `0FS`09oftware`03.");
	gotoxy(2,24);
	ColorCodePrintf("`0FC`08opyright `0F(`09C`0F) `071999 `0FMike Dillon`03.  `0FA`08ll `0FR`08ights `0FR`08eserved`03.`07");
}

void DisplayMonster(monst Monster, unsigned short int MRec)
{
	clrscr();
	gotoxy(1,2);
	ColorCodePrintf(" `08(`0FA`08) %12s`03: `0D%s\n\r", mlightbar[0].string, ptc(Monster.name));
	ColorCodePrintf(" `08(`0FB`08) %12s`03: `0D%ld\n\r", mlightbar[1].string, Monster.strength);
	ColorCodePrintf(" `08(`0FC`08) %12s`03: `0D%ld\n\r", mlightbar[2].string, Monster.hit_points);
	ColorCodePrintf(" `08(`0FD`08) %12s`03: `0D%s\n\r", mlightbar[3].string, ptc(Monster.weapon));
	ColorCodePrintf(" `08(`0FE`08) %12s`03: `0D%ld\n\r", mlightbar[4].string, Monster.gold);
	ColorCodePrintf(" `08(`0FF`08) %12s`03: `0D%ld\n\r", mlightbar[5].string, Monster.exp_points);
	ColorCodePrintf(" `08(`0FG`08) %12s`03: `0D%s\n\r", mlightbar[6].string, limit(ptc(Monster.death), 60));
	ColorCodePrintf("\n\r `07L`08evel`03: `09%2d  `07M`08onster`03: `09%2d`07", ((MRec / 11) + 1), ((MRec % 11) + 1));
}

void UpdateMonster(monst Monster, unsigned short int MRec, signed short int pos)
{
	if (pos == 0 || pos == 0xFF)
	{
		gotoxy(20, 2); ColorCodePrintf("`0D%-60s", ptc(Monster.name));
	}
	if (pos == 1 || pos == 0xFF)
	{
		gotoxy(20, 3); ColorCodePrintf("`0D%-60ld", Monster.strength);
	}
	if (pos == 2 || pos == 0xFF)
	{
		gotoxy(20, 4); ColorCodePrintf("`0D%-60ld", Monster.hit_points);
	}
	if (pos == 3 || pos == 0xFF)
	{
		gotoxy(20, 5); ColorCodePrintf("`0D%-60s", ptc(Monster.weapon));
	}
	if (pos == 4 || pos == 0xFF)
	{
		gotoxy(20, 6); ColorCodePrintf("`0D%-60ld", Monster.gold);
	}
	if (pos == 5 || pos == 0xFF)
	{
		gotoxy(20, 7); ColorCodePrintf("`0D%-60ld", Monster.exp_points);
	}
	if (pos == 6 || pos == 0xFF)
	{
		gotoxy(20, 8); ColorCodePrintf("`0D%-60s", limit(ptc(Monster.death), 60));
	}
	if (pos == 0xFF)
	{
		gotoxy(9, 10); ColorCodePrintf("`09%2d", ((MRec / 11) + 1));
		gotoxy(22, 10); ColorCodePrintf("`09%2d`07", ((MRec % 11) + 1));
	}
}

void DisplayPlayer(player_info Player)
{
	clrscr();
	unsigned char ClassName[3][50] = {
	{ "`0FD`0Beath `0FK`0Bnight" }, { "`0FM`0Dystic       " }, { "`0FT`0Chief        " } };
	gotoxy(1,2);
	ColorCodePrintf(" `08(`0FA`08) %11s`03: `0D%-60s\n\r", plightbar[0].string, ptc(Player.real_names));
	ColorCodePrintf(" `08(`0FB`08) %11s`03: `0D%-22s `08(`0FS`08) %18s`03: `0D%-10d\n\r", plightbar[1].string, ptc(Player.name), plightbar[18].string, Player.level);
	ColorCodePrintf(" `08(`0FC`08) %19s`03: `0D%-14ld `08(`0FT`08) %18s`03: `0D%-12s\n\r", plightbar[2].string, Player.exp, plightbar[19].string, ClassName[Player._class - 1]);
	ColorCodePrintf(" `08(`0FD`08) %19s`03: `0D%-14d `08(`0FU`08) %18s`03: `0D%02d`03/`0D%02d`03/`0D%02d\n\r", plightbar[3].string, Player.hit_points, plightbar[20].string, Player.skillw, Player.skillm, Player.skillt);
	ColorCodePrintf(" `08(`0FE`08) %19s`03: `0D%-14d `08(`0FV`08) %18s`03: `0D%02d`03/`0D%02d`03/`0D%02d\n\r", plightbar[4].string, Player.hit_max, plightbar[21].string, Player.levelw, Player.levelm, Player.levelt);
	ColorCodePrintf(" `08(`0FF`08) %19s`03: `0D%-14d `08(`0FW`08) %18s`03: `0D%-5s\n\r", plightbar[5].string, Player.strength, plightbar[22].string, (Player.sex == 5 ? "Female" : "Male  "));
	ColorCodePrintf(" `08(`0FG`08) %19s`03: `0D%-14d `08(`0FX`08) %18s`03: `0D%-5d\n\r", plightbar[6].string, Player.def, plightbar[23].string, Player.Lays);
	ColorCodePrintf(" `08(`0FH`08) %19s`03: `0D%-14d `08(`0FY`08) %18s`03: `0D%-5d\n\r", plightbar[7].string, Player.charm, plightbar[24].string, Player.kids);
	ColorCodePrintf(" `08(`0FI`08) %19s`03: `0D%-14d `08(`0FZ`08) %18s`03: `0D%-5d\n\r", plightbar[8].string, Player.weapon_num, plightbar[25].string, Player.v2);
	ColorCodePrintf(" `08(`0FJ`08) %19s`03: `0D%-14s `08(`0F1`08) %18s`03: `0D%-5d\n\r", plightbar[9].string, limit(ptc(Player.weapon), 10), plightbar[26].string, Player.king);
	ColorCodePrintf(" `08(`0FK`08) %19s`03: `0D%-14d `08(`0F2`08) %18s`03: `0D%-5d\n\r", plightbar[10].string, Player.arm_num, plightbar[27].string, Player.gem);
	ColorCodePrintf(" `08(`0FL`08) %19s`03: `0D%-14s `08(`0F3`08) %18s`03: `0D%-4s\n\r", plightbar[11].string, limit(ptc(Player.arm), 10), plightbar[28].string, yesno(Player.extra));
	ColorCodePrintf(" `08(`0FM`08) %19s`03: `0D%-14d `08(`0F4`08) %18s`03: `0D%-4s\n\r", plightbar[12].string, Player.fights_left, plightbar[29].string, yesno(Player.inn));
	ColorCodePrintf(" `08(`0FN`08) %19s`03: `0D%-14d `08(`0F5`08) %18s`03: `0D%-4s\n\r", plightbar[13].string, Player.human_left, plightbar[30].string, yesno(Player.seen_dragon));
	ColorCodePrintf(" `08(`0FO`08) %19s`03: `0D%-14ld `08(`0F6`08) %18s`03: `0D%-4s\n\r", plightbar[14].string, Player.gold, plightbar[31].string, yesno(Player.seen_master));
	ColorCodePrintf(" `08(`0FP`08) %19s`03: `0D%-14ld `08(`0F7`08) %18s`03: `0D%-4s\n\r", plightbar[15].string, Player.bank, plightbar[32].string, yesno(Player.seen_bard));
	ColorCodePrintf(" `08(`0FQ`08) %19s`03: `0D%-14d `08(`0F8`08) %18s`03: `0D%-4s\n\r", plightbar[16].string, Player.married, plightbar[33].string, yesno(Player.seen_violet));
	ColorCodePrintf(" `08(`0FR`08) %19s`03: `0D%-14s `08(`0F9`08) %18s`03: `0D%-4s\n\r", plightbar[17].string, yesno(Player.on_now), plightbar[34].string, yesno(Player.dead));
}

void UpdatePlayer(player_info Player, signed short int pos)
{
	unsigned char ClassName[3][50] = {
	{ "`0FD`0Beath `0FK`0Bnight" }, { "`0FM`0Dystic        " }, { "`0FT`0Chief        " } };
	if (pos == 0 || pos == 0xFF)
	{
		gotoxy(19, 2); ColorCodePrintf("`0D%-60s", ptc(Player.real_names));
	}
	if (pos == 1 || pos == 0xFF)
	{
		gotoxy(19, 3); ColorCodePrintf("`0D%-22s", ptc(Player.name));
	}
	if (pos == 2 || pos == 0xFF)
	{
		gotoxy(27, 4); ColorCodePrintf("`0D%-14ld", Player.exp);
	}
	if (pos == 3 || pos == 0xFF)
	{
		gotoxy(27, 5); ColorCodePrintf("`0D%-14d", Player.hit_points);
	}
	if (pos == 4 || pos == 0xFF)
	{
		gotoxy(27, 6); ColorCodePrintf("`0D%-14d", Player.hit_max);
	}
	if (pos == 5 || pos == 0xFF)
	{
		gotoxy(27, 7); ColorCodePrintf("`0D%-14d", Player.strength);
	}
	if (pos == 6 || pos == 0xFF)
	{
		gotoxy(27, 8); ColorCodePrintf("`0D%-14d", Player.def);
	}
	if (pos == 7 || pos == 0xFF)
	{
		gotoxy(27, 9); ColorCodePrintf("`0D%-14d", Player.charm);
	}
	if (pos == 8 || pos == 0xFF)
	{
		gotoxy(27, 10); ColorCodePrintf("`0D%-14d", Player.weapon_num);
	}
	if (pos == 9 || pos == 0xFF)
	{
		gotoxy(27, 11); ColorCodePrintf("`0D%-14s", limit(ptc(Player.weapon), 10));
	}
	if (pos == 10 || pos == 0xFF)
	{
		gotoxy(27, 12); ColorCodePrintf("`0D%-14d", Player.arm_num);
	}
	if (pos == 11 || pos == 0xFF)
	{
		gotoxy(27, 13); ColorCodePrintf("`0D%-14s", limit(ptc(Player.arm), 10));
	}
	if (pos == 12 || pos == 0xFF)
	{
		gotoxy(27, 14); ColorCodePrintf("`0D%-14d", Player.fights_left);
	}
	if (pos == 13 || pos == 0xFF)
	{
		gotoxy(27, 15); ColorCodePrintf("`0D%-14d", Player.human_left);
	}
	if (pos == 14 || pos == 0xFF)
	{
		gotoxy(27, 16); ColorCodePrintf("`0D%-14ld", Player.gold);
	}
	if (pos == 15 || pos == 0xFF)
	{
		gotoxy(27, 17); ColorCodePrintf("`0D%-14ld", Player.bank);
	}
	if (pos == 16 || pos == 0xFF)
	{
		gotoxy(27, 18); ColorCodePrintf("`0D%-14d", Player.married);
	}
	if (pos == 17 || pos == 0xFF)
	{
		gotoxy(27, 19); ColorCodePrintf("`0D%-14s", yesno(Player.on_now));
	}
	if (pos == 18 || pos == 0xFF)
	{
		gotoxy(66, 3); ColorCodePrintf("`0D%-10d", Player.level);
	}
	if (pos == 19 || pos == 0xFF)
	{
		gotoxy(66, 4); ColorCodePrintf("`0D%-12s", ClassName[Player._class - 1]);
	}
	if (pos == 20 || pos == 0xFF)
	{
		gotoxy(66, 5); ColorCodePrintf("`0D%02d`03/`0D%02d`03/`0D%02d", Player.skillw, Player.skillm, Player.skillt);
	}
	if (pos == 21 || pos == 0xFF)
	{
		gotoxy(66, 6); ColorCodePrintf("`0D%02d`03/`0D%02d`03/`0D%02d", Player.levelw, Player.levelm, Player.levelt);
	}
	if (pos == 22 || pos == 0xFF)
	{
		gotoxy(66, 7); ColorCodePrintf("`0D%-5s", (Player.sex == 5 ? "Female" : "Male  "));
	}
	if (pos == 23 || pos == 0xFF)
	{
		gotoxy(66, 8); ColorCodePrintf("`0D%-5d", Player.Lays);
	}
	if (pos == 24 || pos == 0xFF)
	{
		gotoxy(66, 9); ColorCodePrintf("`0D%-5d", Player.kids);
	}
	if (pos == 25 || pos == 0xFF)
	{
		gotoxy(66, 10); ColorCodePrintf("`0D%-5d", Player.v2);
	}
	if (pos == 26 || pos == 0xFF)
	{
		gotoxy(66, 11); ColorCodePrintf("`0D%-5d", Player.king);
	}
	if (pos == 27 || pos == 0xFF)
	{
		gotoxy(66, 12); ColorCodePrintf("`0D%-5d", Player.gem);
	}
	if (pos == 28 || pos == 0xFF)
	{
		gotoxy(66, 13); ColorCodePrintf("`0D%-4s", yesno(Player.extra));
	}
	if (pos == 29 || pos == 0xFF)
	{
		gotoxy(66, 14); ColorCodePrintf("`0D%-4s", yesno(Player.inn));
	}
	if (pos == 30 || pos == 0xFF)
	{
		gotoxy(66, 15); ColorCodePrintf("`0D%-4s", yesno(Player.seen_dragon));
	}
	if (pos == 31 || pos == 0xFF)
	{
		gotoxy(66, 16); ColorCodePrintf("`0D%-4s", yesno(Player.seen_master));
	}
	if (pos == 32 || pos == 0xFF)
	{
		gotoxy(66, 17); ColorCodePrintf("`0D%-4s", yesno(Player.seen_bard));
	}
	if (pos == 33 || pos == 0xFF)
	{
		gotoxy(66, 18); ColorCodePrintf("`0D%-4s", yesno(Player.seen_violet));
	}
	if (pos == 34 || pos == 0xFF)
	{
		gotoxy(66, 19); ColorCodePrintf("`0D%-4s", yesno(Player.dead));
	}
}

void DisplaySetup(void)
{
	clrscr();
	gotoxy((80 - strlen("Setup/Configuration")) / 2, 3);
	ColorCodePrintf("`0FS`07et`08up`03/`0FC`07onfig`08uration");
	gotoxy(15,12);
	ColorCodePrintf("`08(`0FA`08) `0FLORD H`09ome `0FD`09irectory `03:   `0F");
	gotoxy(2,23);
	ColorCodePrintf("`07Use the letter in `0F() `07to change a value`03.\n\r`0F ESC`07ape to return to the main menu`03.");
	if (strcmp(setup.lordloc, "") == 0)
	{
		gotoxy(43,12);
		ColorCodePrintf("`0FC`09urrent `0FD`09irectory!");
	}
	else
	{
		gotoxy(43,12);
		ColorCodePrintf("`0D%s", limit(setup.lordloc, 30));
	}
}

void BasePrompt(unsigned short int Position, signed short int Records)
{
	// clear the lines
	gotoxy(1,23);
	clreol();
	gotoxy(1,24);
	clreol();
	// perform prompting
	gotoxy(1,23);
	ColorCodePrintf("`07Use %s%s`07and `0FESC`07ape to quit`03.\n\r", (Position > 0 ? "`0F[`07 to go back`03, " : ""), (Position < (Records - 1) ? "`0F]`07 to go forward`03, " : ""));
	ColorCodePrintf("`07Use the letter`03/`07number in `0F()`07 or `0FArrow`07 keys to select an option`03.");
}

void EditPlayer(player_info *Players, signed short int PRecords)
{
	unsigned short int ch = 0;
	signed short int idx = 0, pos = 0, nodisp = 0;
	if (PRecords != -1)
	{
		clrscr();
		DisplayPlayer(Players[0]);
		BasePrompt(0, PRecords);
		PLightBar(0,-1);
		while (ch != 27) // Escape key
		{
			if ((ch = getch()) == 0)
			{
				ch = getch();
				if (ch != 72 && ch != 80 && ch != 75 && ch != 77)
				{
					ch = 0; // Destroy non-valids
				}
				ch = ch | 0xFF00;
			}
			if ((ch & 0x00FF) == 72) // Up-Arrow
			{
				pos--;
				if (pos < 0)
				{
					pos = 0; // Do Not Display Change
				}
				else
				{
					PLightBar(pos, 1); // Display up
				}
			}
			else if ((ch & 0x00FF) == 80) // Down-Arrow
			{
				pos++;
				if (pos > 34)
				{
					pos = 34; // Do Not Display Change
				}
				else
				{
					PLightBar(pos, 0); // Display Down
				}
			}
			else if ((ch & 0x00FF) == 75)
			{
				if (pos != 0)
				{
					if (pos > 17)
					{
						pos -= 17;
						PLightBar(pos, 3);
					}
				}
			}
			else if ((ch & 0x00FF) == 77)
			{
				if (pos != 0)
				{
					if (pos < 18)
					{
						pos += 17;
						PLightBar(pos, 2);
					}
				}
			}
			else if (ch == 13 || ch == 10)
			{
				PlayerChange(Players[idx], pos);
			}
			else if (ch == '[')
			{
				idx--;
				if (idx < 0)
				{
					idx = 0;
					nodisp = 1;
				}
			}
			else if (ch == ']')
			{
				idx++;
				if (idx >= PRecords)
				{
					idx = PRecords - 1;
					nodisp = 1;
				}
			}
			else if (toupper(ch) >= 'A' && toupper(ch) <= 'Z')
			{
				PlayerChange(Players[idx], toupper(ch) - 'A');
			}
			else if (ch >= '0' && ch <= '9')
			{
				PlayerChange(Players[idx], ch - '0' + 25);
			}
			if ((ch & 0x00FF) != 72 && (ch & 0x00FF) != 80 && ch != 0 && (ch & 0x00FF) != 75 && (ch & 0x00FF) != 77)
			{
				if (ch == '[' || ch == ']')
				{
					if (nodisp != 1)
					{
						gotoxy(plightbar[pos].x_pos, plightbar[pos].y_pos);
						ColorCodePrintf(plightbar[pos].string);
						pos = 0; // set default position.
						gotoxy(5,23); clreol(); ColorCodePrintf("%s%s`07and `0FESC`07ape to quit`03.\n\r", (idx > 0 ? "`0F[`07 to go back`03, " : ""), (idx < (PRecords - 1) ? "`0F]`07 to go forward`03, " : ""));
						PLightBar(pos, -1);
					}
				}
				if (nodisp != 1)
				{
					if (ch == ']' || ch == '[')
					{
						UpdatePlayer(Players[idx], 0xFF); // Update all
					}
					else
					{
						if ((toupper(ch) >= 'A' && toupper(ch) <= 'Z') || (ch >= '0' && ch <= '9'))
						{
							if (isdigit(ch))
								UpdatePlayer(Players[idx], ch - '0' + 25);
							else
								UpdatePlayer(Players[idx], toupper(ch) - 'A');
						}
						else
						{
							UpdatePlayer(Players[idx], pos);
						}
					}
				}
				nodisp = 0; // reset default display
			}
		}
	}
	else
	{
		clrscr();
		ColorCodePrintf("`0FPROBLEM`03:\n\r");
		ColorCodePrintf("`0FE`08rror occurred while trying to read data file`03.\n\r");
		ColorCodePrintf("`0FE`08dit `04aborted`03.... `0FP`08ress a key to continue`03.\n\r");
		getch();
	}
}

void EditMonster(monst *Monsters, signed short int MRecords)
{
	unsigned short int ch = 0;
	signed short int idx = 0, pos = 0, nodisp = 0;
	if (MRecords != -1)
	{
		clrscr();
		DisplayMonster(Monsters[0], 0);
		BasePrompt(0, MRecords);
		MLightBar(0, -1);
		while (ch != 27)
		{
			if ((ch = getch()) == 0)
			{
				ch = getch();
				if (ch != 72 && ch != 80)
				{
					ch = 0;
				}
				else
				{
					ch = ch | 0xFF00;
				}
			}
			if ((ch & 0x00FF) == 72) // Up-Arrow
			{
				pos--;
				if (pos < 0)
				{
					pos = 0; // Do Not Display Change
				}
				else
				{
					MLightBar(pos, 1); // Display up
				}
			}
			else if ((ch & 0x00FF) == 80) // Down-Arrow
			{
				pos++;
				if (pos > 6)
				{
					pos = 6; // Do Not Display Change
				}
				else
				{
					MLightBar(pos, 0); // Display Down
				}
			}
			else if (ch == 10 || ch == 13)
			{
				MonsterChange(Monsters[idx], pos);
			}
			else if (ch == '[')
			{
				idx--;
				if (idx < 0)
				{
					idx = 0;
					nodisp = 1;
				}
			}
			else if (ch == ']')
			{
				idx++;
				if (idx >= MRecords)
				{
					idx = MRecords - 1;
					nodisp = 1;
				}
			}
			else if (toupper(ch) >= 'A' && toupper(ch) <= 'G')
			{
				MonsterChange(Monsters[idx], toupper(ch) - 'A');
			}
			if ((ch & 0x00FF) != 72 && (ch & 0x00FF) != 80 && ch != 0)
			{
				if (ch == '[' || ch == ']')
				{
					if (nodisp != 1)
					{
						gotoxy(mlightbar[pos].x_pos, mlightbar[pos].y_pos);
						ColorCodePrintf(mlightbar[pos].string);
						pos = 0;
						// Update Base Prompt
						gotoxy(5,23); clreol(); ColorCodePrintf("%s%s`07and `0FESC`07ape to quit`03.\n\r", (idx > 0 ? "`0F[`07 to go back`03, " : ""), (idx < (MRecords - 1) ? "`0F]`07 to go forward`03, " : ""));
						// Update Complete
						MLightBar(pos, -1);
					}
				}
				if (nodisp != 1)
				{
					if (ch == '[' || ch == ']')
					{
						UpdateMonster(Monsters[idx], idx, 0xFF); // Update ALL
					}
					else
					{
						if (toupper(ch) >= 'A' && toupper(ch) <= 'G')
						{
							UpdateMonster(Monsters[idx], idx, toupper(ch) - 'A');
						}
						else
						{
							UpdateMonster(Monsters[idx], idx, pos);
						}
					}
				}
				nodisp = 0; // reset default display
			}
		}
	}
	else
	{
		clrscr();
		ColorCodePrintf("`0FE`08rror occurred while trying to read data file`03.\n\r");
		ColorCodePrintf("`0FE`08dit `04aborted`03.... `0FP`08ress a key to continue`03.\n\r");
		getch();
	}
}

void Setup(void)
{
	unsigned char ch = 0;
	DisplaySetup();
	while (ch != 27)
	{
		while (ch == 0)
			ch = getch();
		if (toupper(ch) == 'A')
		{
			GetDirectory();
		}
		if (ch != 27)
			ch = 0;
		DisplaySetup();
	}
}

void MonsterChange(monst &Monster, unsigned short int Ask)
{
	gotoxy(1,15);
	switch(Ask)
	{
		case 0: ColorCodePrintf("`0FE`09nter the monster`0B\'`09s name`0B: `0D"); break;
		case 1: ColorCodePrintf("`0FE`09nter the monster`0B\'`09s strength`0B: `0D"); break;
		case 2: ColorCodePrintf("`0FE`09nter the monster`0B\'`09s hitpoints`0B: `0D"); break;
		case 3: ColorCodePrintf("`0FE`09nter the monster`0B\'`09s weapon name`0B: `0D"); break;
		case 4: ColorCodePrintf("`0FE`09nter the amount of gold user gains`0B: `0D"); break;
		case 5: ColorCodePrintf("`0FE`09nter the amount of experience user gains`0B: `0D"); break;
		case 6: ColorCodePrintf("`0FE`09nter the phrase said if monster is killed by power move`0B: `0D"); break;
	}
	QuestionLine = 16;
	switch(Ask)
	{
		case 0: GetS(Monster.name, 60, ptc(Monster.name)); break;
		case 1: GetNL(Monster.strength, 0, 2147483647, Monster.strength); break;
		case 2: GetNL(Monster.hit_points, 0, 2147483647, Monster.hit_points); break;
		case 3: GetS(Monster.weapon, 20, ptc(Monster.weapon)); break;
		case 4: GetNL(Monster.gold, 0, 2147483647, Monster.gold); break;
		case 5: GetNL(Monster.exp_points, 0, 2147483647, Monster.exp_points); break;
		case 6: GetS(Monster.death, 60, limit(ptc(Monster.death), 60)); break;
	}
	gotoxy(1,15);
	clreol();
	gotoxy(1,16);
	clreol();
	gotoxy(1,1);
}

void PlayerChange(player_info &Player, unsigned short int Ask)
{
	gotoxy(1,20);
	if (Ask < 28 && !(Ask >= 20 && Ask <= 22) && Ask != 17)
		ColorCodePrintf("`0FE`09nter the Player`0B\'`09s ");
	switch(Ask)
	{
		case 0: ColorCodePrintf("real name`0B: `08(`0F50 `07characters`08)`0F");
			break;
		case 1: ColorCodePrintf("game name`0B/`09handle`0B: `08(`0F20 `07characters`08)`0F");
			break;
		case 2: ColorCodePrintf("experience`0B: `08(`0F0`07-`0F2147483647`08)`0F");
			break;
		case 3: ColorCodePrintf("hitpoints as of now`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 4: ColorCodePrintf("max hitpoints`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 5: ColorCodePrintf("strength value`0B: `08(`0F0 `07to `0F9000`08)`0F");
			break;
		case 6: ColorCodePrintf("defense value`0B: `08(`0F0 `07to `0F9000`08)`0F");
			break;
		case 7: ColorCodePrintf("charm value`0B: `08(`0F0 `07to `0F9000`08)`0F");
			break;
		case 8: ColorCodePrintf("weapon number`0B: `08(`0F1 `07to `0F15`08)`0F");
			break;
		case 9: ColorCodePrintf("weapon name`0B: `08(`0F20 `07characters`08)`0F");
			break;
		case 10: ColorCodePrintf("armor number`0B: `08(`0F1 `07to `0F15`08)`0F");
			break;
		case 11: ColorCodePrintf("armor name`0B: `08(`0F20 `07characters`08)`0F");
			break;
		case 12: ColorCodePrintf("forest fights left`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 13: ColorCodePrintf("human fights left`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 14: ColorCodePrintf("gold in hand`0B: `08(`0F0 `07to `0F2147483647`08)`0F");
			break;
		case 15: ColorCodePrintf("gold in bank`0B: `08(`0F0 `07to `0F2147483647`08)`0F");
			break;
		case 16: ColorCodePrintf("marital status`0B: `08(`0F-1 `07for single or number of who married to`08)`0F");
			break;
		case 17: //ColorCodePrintf("on now status: (1 for On Now or 2 for Not On Now)\n\r");
			break;
		case 18: ColorCodePrintf("Level`0B: `08(`0F1 `07to `0F12`08)`0F");
			break;
		case 19: ColorCodePrintf("Class`0B: `08(`0F1 `07= `0FD`0Beath `0FK`0Bnight`07, `0F2 `07= `0FM`0Dystical`07, `0F3 `07= `0FT`0Cheif`08)`0F");
			break;
		case 20: ColorCodePrintf("`0FS`09kills left for today for ");
			break;
		case 21: ColorCodePrintf("`0FS`09kill level for ");
			break;
		case 22: //ColorCodePrintf("Gender: (1 = Female, 2 = Male)");
			break;
		case 23: ColorCodePrintf("number of lays`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 24: ColorCodePrintf("number of kids`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 25: ColorCodePrintf("number of player kills`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 26: ColorCodePrintf("number of game wins`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 27: ColorCodePrintf("number of gems`0B: `08(`0F0 `07to `0F32000`08)`0F");
			break;
		case 28: //ColorCodePrintf("Does the player have a horse? (1 = Yes, 2 = No)\n\r");
			break;
		case 29: //ColorCodePrintf("Is the player staying at the inn? (1 = Yes, 2 = No)\n\r");
			break;
		case 30: //ColorCodePrintf("Has the player seen the dragon? (1 = Yes, 2 = No)\n\r");
			break;
		case 31: //ColorCodePrintf("Has the player seen their master? (1 = Yes, 2 = No)\n\r");
			break;
		case 32: //ColorCodePrintf("Has the player seen the bard? (1 = Yes, 2 = No)\n\r");
			break;
		case 33: //ColorCodePrintf("Has the player seen Violet? (1 = Yes, 2 = No)\n\r");
			break;
		case 34: //ColorCodePrintf("Is the player dead? (1 = Yes, 2 = No)\n\r");
			break;
	}
	ColorCodePrintf("\n\r`0F");
	gotoxy(1,20);
	QuestionLine = 21;
	switch (Ask)
	{
		case 0: GetS(Player.real_names, 50, ptc(Player.real_names)); break;
		case 1: GetS(Player.name, 20, ptc(Player.name)); break;
		case 2: GetNL(Player.exp, 0, 2147483647, Player.exp); break;
		case 3: GetN(Player.hit_points, 0, 32000, Player.hit_points); break;
		case 4: GetN(Player.hit_max, 0, 32000, Player.hit_max); break;
		case 5: GetN(Player.strength, 0, 9000, Player.strength); break;
		case 6: GetN(Player.def, 0, 9000, Player.def); break;
		case 7: GetN(Player.charm, 0, 9000, Player.charm); break;
		case 8: GetN(Player.weapon_num, 1, 15, Player.weapon_num); break;
		case 9: GetS(Player.weapon, 20, ptc(Player.weapon)); break;
		case 10: GetN(Player.arm_num, 1, 15, Player.arm_num); break;
		case 11: GetS(Player.arm, 20, ptc(Player.arm)); break;
		case 12: GetN(Player.fights_left, 0, 32000, Player.fights_left); break;
		case 13: GetN(Player.human_left, 0, 32000, Player.human_left); break;
		case 14: GetNL(Player.gold, 0, 2147483647, Player.gold); break;
		case 15: GetNL(Player.bank, 0, 2147483647, Player.bank); break;
		case 16: GetN(Player.married, -1, 255, Player.married, 1); break;
		case 17: GetBC(Player.on_now); break;
		case 18: GetN(Player.level, 1, 12, Player.level); break;
		case 19: GetNC(Player._class, 1, 3, Player._class); break;
		case 20: GetSkT(Player); break;
		case 21: GetSkL(Player); break;
		case 22: GetBC(Player.sex); break;
		case 23: GetN(Player.Lays, 0, 32000, Player.Lays); break;
		case 24: GetN(Player.kids, 0, 32000, Player.kids); break;
		case 25: GetN(Player.v2, 0, 32000, Player.v2); break;
		case 26: GetN(Player.king, 0, 32000, Player.king); break;
		case 27: GetN(Player.gem, 0, 32000, Player.gem); break;
		case 28: GetB(Player.extra); break;
		case 29: GetBC(Player.inn); break;
		case 30: GetB(Player.seen_dragon); break;
		case 31: GetB(Player.seen_master); break;
		case 32: GetBC(Player.seen_bard); break;
		case 33: GetB(Player.seen_violet); break;
		case 34: GetBC(Player.dead); break;
	}
	gotoxy(1,20);
	clreol();
	gotoxy(1,21);
	clreol();
}

void GetDirectory(void)
{
	struct find_t test;
	unsigned char filepath[MAXPATH] = "\x0", secondary[MAXPATH] = "\x0";
	signed short int done = 0, ok = 0;
	gotoxy(1,20);
	ColorCodePrintf("`0FE`09nter the path of the `0FLORD`03.`0FEXE `09file`03...\n\r");
	while (!done)
	{
		gotoxy(1,21);
		clreol();
		QuestionLine = 21;
		GetS(filepath, 70, setup.lordloc);
		strcpy(filepath, ptc(filepath));
		if (filepath[strlen(filepath) - 1] != '\\')
		{
			strcat(filepath,"\\");
		}
		strcpy(secondary, filepath);
		strcat(secondary, "LORD.EXE");
		ok = _dos_findfirst(secondary,0, &test);
		if (ok == 0)
		{
			strcpy(setup.lordloc, strupr(filepath));
			done = 1;
		}
		else
		{
			gotoxy(1,22);
			ColorCodePrintf("`0FUnable to find `0ALORD.EXE `0Fin the specified path`04!!`07");
			sleep(1);
			gotoxy(1,22);
			clreol();
			strcpy(filepath,"");
		}
	}
	gotoxy(1,20);
	clreol();
	gotoxy(1,21);
	clreol();
}

unsigned char *ptc(unsigned char *pas_string)
{
	unsigned short int Length = pas_string[0];
	strcpy(temp_string, pas_string);
	for (unsigned short int z = 0; z < Length; z++)
	{
		temp_string[z] = pas_string[z + 1];
	}
	temp_string[Length] = '\x0'; // Nullify the last space (C-Style)
	return (temp_string);
}

void ctp(unsigned char *c_string)
{
	unsigned short int Length = strlen(c_string);
	for (unsigned short int z = Length; z > 0; z--)
	{
		c_string[z] = c_string[z - 1];
	}
	c_string[0] = Length;
}

unsigned char *limit(unsigned char *string, unsigned short int length)
{
	strcpy(temp_string, string);
	if (strlen(temp_string) > length)
		temp_string[length] = '\x0';
	return (temp_string);
}

unsigned char *yesno(unsigned short int Value)
{
	return (Value != 0 ? "Yes!" : "No!");
}

unsigned short int Check_OnNow(signed short int PRecords)
{
	FILE *PlayerFile;
	if (PRecords != -1)
	{
		if (PlayerFile = fopen(
		for (signed short int z = 0; z < PRecords; z++)
		{
			if (Players[z].on_now != 0)
				return 1; // Kill edit... player is online
		}
		return 0; // no records on_now found...
	}
	else
	{
		return 1;
	}
}

unsigned short int OnNow_Disclaimer(void)
{
	unsigned char ch = 0;
	clrscr();
	ColorCodePrintf("`0FA`08pparently `0FLORD `08is currently in use or a `0FPlayer `08was `09accidently`08\n\r");
	ColorCodePrintf("left as on now due to carrier drop`03.\n\r");
	ColorCodePrintf("\n\r\n\r`0FE`08diting beyond this point may result in `0FLORD `04failure`03...\n\r");
	ColorCodePrintf("`0FAND`03/`0FOR `08no change to player records `07(`08if `0FLORD `08is running`07)`03.\n\r");
	ColorCodePrintf("\n\r\n\r`0FD`09o you wish to continue `08(`0FY`03/`0FN`08)`03? `0F");
	do {
		ch = getch();
	} while (toupper(ch) != 'Y' && toupper(ch) != 'N');
	return ((toupper(ch) == 'Y') ? 1 : 0);
}

void PLightBar(signed short int position, signed short int direction)
{
	gotoxy(plightbar[position].x_pos, plightbar[position].y_pos);
	textattr((BLUE << 4) + WHITE);
	ColorCodeOverride = 1;
	ColorCodePrintf(plightbar[position].string);
	ColorCodeOverride = 0;
	textattr(LIGHTGRAY);
	if (direction == 0)
	{
		gotoxy(plightbar[position - 1].x_pos, plightbar[position - 1].y_pos);
		ColorCodePrintf(plightbar[position - 1].string);
	}
	else if (direction == 1)
	{
		gotoxy(plightbar[position + 1].x_pos, plightbar[position + 1].y_pos);
		ColorCodePrintf(plightbar[position + 1].string);
	}
	else if (direction == 2)
	{
		gotoxy(plightbar[position - 17].x_pos, plightbar[position - 17].y_pos);
		ColorCodePrintf(plightbar[position - 17].string);
	}
	else if (direction == 3)
	{
		gotoxy(plightbar[position + 17].x_pos, plightbar[position + 17].y_pos);
		ColorCodePrintf(plightbar[position + 17].string);
	}
	gotoxy(plightbar[position].x_pos, plightbar[position].y_pos);
}

void MLightBar(signed short int position, signed short int direction)
{
	gotoxy(mlightbar[position].x_pos, mlightbar[position].y_pos);
	textattr((BLUE << 4) + WHITE);
	ColorCodeOverride = 1; // Set Color Code Override
	ColorCodePrintf(mlightbar[position].string);
	ColorCodeOverride = 0;
	textattr(LIGHTGRAY);
	if (direction == 0)
	{
		gotoxy(mlightbar[position - 1].x_pos, mlightbar[position - 1].y_pos);
		ColorCodePrintf(mlightbar[position - 1].string);
	}
	else if (direction == 1)
	{
		gotoxy(mlightbar[position + 1].x_pos, mlightbar[position + 1].y_pos);
		ColorCodePrintf(mlightbar[position + 1].string);
	}
	gotoxy(mlightbar[position].x_pos, mlightbar[position].y_pos);
}

void GetS(unsigned char *string, unsigned short int length, unsigned char *orig)
{
	strcpy(string, orig);
	gotoxy(1, QuestionLine);
	ColorCodePrintf("%s", orig);
	GetString(string, length, orig);
	if (strcmp(string, "") == 0)
	{
		strcpy(string, orig);
	}
	ctp(string);
}

void GetN(signed short int &Var, signed short int min, signed short int max, signed short int Original, unsigned char NegFlag)
{
	Var = 0;
	unsigned char Holder[15] = "\x0";
	unsigned char BFlag = 0;
	ltoa(max, Holder, 10);
	gotoxy(1, QuestionLine);
	do {
		if (BFlag == 1)
		{
			gotoxy(1, QuestionLine);
			clreol();
			ColorCodePrintf("`04Invalid Number`0F!!!!!!!!!`07");
			sleep(1);
		}
		Var = 0;
		gotoxy(1, QuestionLine);
		clreol();
		GetNumeric(Var, strlen(Holder), SSHORT, Original, NegFlag);
		BFlag = 1;
	} while ((Var < min || Var > max));
}

void GetNC(signed char &Var, signed short int min, signed short int max, signed char Original)
{
	Var = 0;
	unsigned char Holder[15] = "\x0";
	unsigned char BFlag = 0;
	ltoa(max, Holder, 10);
	gotoxy(1, QuestionLine);
	do {
		if (BFlag == 1)
		{
			gotoxy(1, QuestionLine);
			clreol();
			ColorCodePrintf("`04Invalid Number`0F!!!!!!!!!!!!`07");
			sleep(1);
		}
		Var = 0;
		gotoxy(1, QuestionLine);
		clreol();
		GetNumeric(Var, strlen(Holder), SCHAR, Original, 0);
		BFlag = 1;
	} while (Var < min || Var > max);
}

void GetNL(signed long int &Var, signed long int min, unsigned long int max, signed long int Original)
{
	Var = 0;
	unsigned char Holder[15] = "\x0";
	unsigned char BFlag = 0;
	ltoa(max, Holder, 10);
	gotoxy(1, QuestionLine);
	do {
		if (BFlag == 1)
		{
			gotoxy(1, QuestionLine);
			clreol();
			ColorCodePrintf("`04Invalid Number`0F!!!!!!!!!!!!!`07");
			sleep(1);
		}
		Var = 0;
		gotoxy(1, QuestionLine);
		clreol();
		GetNumeric(Var, strlen(Holder), SLONG, Original, 0);
		BFlag = 1;
	} while (Var < min || Var > max);
}

void GetB(signed short int &Var)
{
	if (Var == 5)
		Var = 0;
	else
		Var = 5;
}

void GetBC(signed char &Var)
{
	if (Var == 5)
		Var = 0;
	else
		Var = 5;
}

void GetSkT(player_info &Player)
{
	gotoxy(27, 20);
	ColorCodePrintf("`0FD`0Beath `0FK`0Bnight`03: `08(`0F0 `07to `0F40`08)`0B");
	GetNC(Player.skillw, 0, 40, Player.skillw);
	gotoxy(27, 20);
	clreol();
	ColorCodePrintf("`0FM`0Dystical`03: `08(`0F0 `07to `0F40`08)`0B");
	GetNC(Player.skillm, 0, 40, Player.skillm);
	gotoxy(27, 20);
	clreol();
	ColorCodePrintf("`0FT`0Cheiving`03: `08(`0F0 `07to `0F40`08)`0B");
	GetNC(Player.skillt, 0, 40, Player.skillt);
}

void GetSkL(player_info &Player)
{
	gotoxy(17, 20);
	ColorCodePrintf("`0FD`0Beath `0FK`0Bnight`03: `08(`0F0 `07to `0F40`08)`0B");
	GetNC(Player.levelw, 0, 40, Player.levelw);
	gotoxy(17, 20);
	clreol();
	ColorCodePrintf("`0FM`0Dystical`03: `08(`0F0 `07to `0F40`08)`0B");
	GetNC(Player.levelm, 0, 40, Player.levelm);
	gotoxy(17, 20);
	clreol();
	ColorCodePrintf("`0FT`0Cheiving`03: `08(`0F0 `07to `0F40`08)`0B");
	GetNC(Player.levelt, 0, 40, Player.levelt);
}

void ColorCodePrintf(unsigned char *Format_String,...)
{
	unsigned char New_String[1024] = "\x0";
	unsigned char Hex_Format[17] = "0123456789ABCDEF";
	unsigned char *ptr = Hex_Format;
	unsigned short int color = 0, nofound = 0;
	va_list Arguments;
	va_start(Arguments, Format_String);
	vsprintf(New_String, Format_String, Arguments);
	va_end(Arguments);
	for (unsigned long int z = 0; z < strlen(New_String); z++)
	{
		if (New_String[z] == '`')
		{
			if ((z + 1) < strlen(New_String))
			{
				ptr = strchr(Hex_Format, New_String[z + 1]);
				if (ptr)
				{
					color = ((ptr - Hex_Format) << 4);
					//  Color 1 found
					if ((z + 2) < strlen(New_String))
					{
						ptr = strchr(Hex_Format, New_String[z + 2]);
						if (ptr)
						{
							color += (ptr - Hex_Format);
							if (ColorCodeOverride != 1)
							{
								textattr(color);
							}
							z += 2;
						}
						else
						{
							nofound = 1;
						}
					}
					else
					{
						nofound = 1;
					}
				}
				else
				{
					nofound = 1;
				}
			}
			else
			{
				nofound = 1;
			}
		}
		else
		{
			cprintf("%c", New_String[z]);
		}
		if (nofound == 1)
		{
			cprintf("%c", New_String[z]);
		}
		nofound = 0;
	}
}
