/*  PATCH.CMD
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say 'About to apply the D level patches...'
say
say 'Note: To be patched correctly, all of the VX-REXX DLLs must exist in the'
say 'VX-REXX directory. If you have moved your DLLs to another location you'
say 'must copy them back to the VX-REXX directory before applying the patch.'
say
say 'If the DLLs are not in the VX-REXX directory, press X now to exit and'
say 'restore them before applying the patch.'
say
say 'Press C to apply the patch or X to exit.'
c = SysGetKey( NOECHO )
if( c \= 'C' & c \= 'c' ) then do
    say '*** Patch process aborted ***'
    return
end
say
if( Stream("DBIDB22.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching DBIDB22.DLL"
    "@bpatch -p DPATCHES\DLL\DBIDB22.D"
end
if( Stream("DBIODBC.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching DBIODBC.DLL"
    "@bpatch -p DPATCHES\DLL\DBIODBC.D"
end
if( Stream("DBIWSQL.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching DBIWSQL.DLL"
    "@bpatch -p DPATCHES\DLL\DBIWSQL.D"
end
if( Stream("PMDBG.EXE", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching PMDBG.EXE"
    "@bpatch -p DPATCHES\EXE\PMDBG.D"
end
if( Stream("QUERYED.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching QUERYED.DLL"
    "@bpatch -p DPATCHES\DLL\QUERYED.D"
end
if( Stream("VRCHT.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRCHT.DLL"
    "@bpatch -p DPATCHES\DLL\VRCHT.D"
end
if( Stream("VRCHTD.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRCHTD.DLL"
    "@bpatch -p DPATCHES\DLL\VRCHTD.D"
end
if( Stream("VRCHTR.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRCHTR.DLL"
    "@bpatch -p DPATCHES\DLL\VRCHTR.D"
end
if( Stream("VRCHTW.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRCHTW.DLL"
    "@bpatch -p DPATCHES\DLL\VRCHTW.D"
end
if( Stream("VRDB.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRDB.DLL"
    "@bpatch -p DPATCHES\DLL\VRDB.D"
end
if( Stream("VREDIT.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VREDIT.DLL"
    "@bpatch -p DPATCHES\DLL\VREDIT.D"
end
if( Stream("VROBJ.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VROBJ.DLL"
    "@bpatch -p DPATCHES\DLL\VROBJ.D"
end
if( Stream("VRSED.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRSED.DLL"
    "@bpatch -p DPATCHES\DLL\VRSED.D"
end
say 'A number of files are no longer needed.'
say 'Do you want to delete them (you will be prompted for each)?'
parse upper pull response
if( Left( response, 1 ) = 'Y' ) then do
    say 'Delete WDB2213.BND (y/n)?'
    parse upper pull response
    if( Left( response, 1 ) = 'Y' ) then 'erase WDB2213.BND'
end

call BUILDVRX.CMD
call BUILDCSO.CMD

say "You can now erase the DPATCHES directory"
say
say "The patch process has saved an original copy of each file that has been"
say "patched. These files have a .BAK extension and may be used to restore the"
say "original files or may be deleted."
say
say "NOTE: If you are using VX-REXX with DB2/2, you will have to rebind"
say "      your databases to VX-REXX."
