/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* Display the product information as a multiline
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 5
    message.1 = "Chart Rows and Columns Sample"
    message.2 = ""
    message.3 = "This sample application shows how"
    message.4 = "the size of the chart data can"
    message.5 = "change at runtime."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1    
return

/*:VRX         PB_Column_Delete_Click
*/
PB_Column_Delete_Click:
    /* Delete a column in the chart
    */

    call VRSet "Window1", "Pointer", "Wait"
    call VRSet "WC_Data", "Painting", 0

    call VRMethod "WC_Data", "DeleteCol", 1

    /* Check to see if any rows are left.   
    */
        
    temp = VRMethod( "WC_Data", "GetDataSize" )
    parse var temp numRows'.'numColumns
    
    if( (numRows = '0') | (numColumns = '0') ) then do
        call VRSet "PB_Row_Delete", "Enabled", 0
        call VRSet "PB_Column_Delete", "Enabled", 0
    end

    /* Reset painting and the pointer
    */

    call VRSet "WC_Data", "Painting", 1
    call VRSet "Window1", "Pointer", "<default>"
return

/*:VRX         PB_Column_Insert_Click
*/
PB_Column_Insert_Click:
    /* Insert a column into the chart
    */

    call VRSet "Window1", "Pointer", "Wait"
    call VRSet "WC_Data", "painting", 0

    call VRMethod "WC_Data", "InsertCol", 0

    /* Create data for the new rows.
    */

    size = VRMethod( "WC_Data", "GetDataSize" )
    parse var size rows'.'cols
    do i = 1 to rows
        call VRMethod "WC_Data", "SetDataValue", i, 1, 1
    end

    /* Enable the column Delete button
    */
    
    call VRSet "PB_Column_Delete", "Enabled", 1    
    call VRSet "PB_Row_Delete", "Enabled", 1 

    /* Restore the pointer and painting.
    */

    call VRSet "WC_Data", "painting", 1
    call VRSet "Window1", "Pointer", "<default>"
return

/*:VRX         PB_Row_Delete_Click
*/
PB_Row_Delete_Click:
    /* Delete a row in the chart
    */

    call VRSet "Window1", "Pointer", "Wait"
    call VRSet "WC_Data", "Painting", 0

    call VRMethod "WC_Data", "DeleteRow", 1

    /* Check to see if any rows are left.   
    */
        
    temp = VRMethod( "WC_Data", "GetDataSize" )
    parse var temp numRows'.'numColumns
    
    if( (numRows = 0) | (numColumns = 0) ) then do
        call VRSet "PB_Row_Delete", "Enabled", 0
        call VRSet "PB_Column_Delete", "Enabled", 0
    end
        
    /* Reset painting and the pointer type
    */    

    call VRSet "WC_Data", "Painting", 1
    call VRSet "Window1", "Pointer", "<default>"

return

/*:VRX         PB_Row_Insert_Click
*/
PB_Row_Insert_Click:
    /* Insert a row into the chart
    */

    call VRSet "Window1", "Pointer", "Wait"
    call VRSet "WC_Data", "painting", 0

    call VRMethod "WC_Data", "InsertRow", 0

    /* Create data for the new rows.
    */

    size = VRMethod( "WC_Data", "GetDataSize" )
    parse var size rows'.'cols
    do i = 1 to cols
        call VRMethod "WC_Data", "SetDataValue", 1, i, 1
    end

    /* Enable the Row Delete button
    */
    
    call VRSet "PB_Row_Delete", "Enabled", 1 
    call VRSet "PB_Column_Delete", "Enabled", 1     

    /* Restore the pointer and painting.
    */

    call VRSet "WC_Data", "painting", 1
    call VRSet "Window1", "Pointer", "<default>"
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

