/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         DDCB_GroupBy_Change
*/
DDCB_GroupBy_Change:
    /* Change the group by option
    */

    groupBy = "By" || VRGet( "DDCB_GroupBy", "SelectedString" )
    call VRMethod "WC_1", "SetOption", "GroupBy", groupBy

    /* Reset the group spin button
    */
 
    call ResetGroupSpin
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    /* We set up a stem-array with numbers from 1 to 100.
       This array is used to set the range used by the
       group number spin button.
     */
    do i = 1 to 100
        NumberStem.i = i
    end

    /* Initialize the groupBy option.
    */

    groupBy = VRMethod( "WC_1", "GetOption", "GroupBy" )
    parse var groupBy "By"groupBy

    call VRSet "DDCB_GroupBy", "Value", groupBy
    
    /* Reset the Group Spin button
    */

    call ResetGroupSpin
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* The product information is displayed with a multi-line
       messages dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 7
    message.1 = "Chart Groups Sample"
    message.2 = ""
    message.3 = "This sample application shows how groups"
    message.4 = "work in the chart. It would be a good idea"
    message.5 = "to look at the code for this example,"
    message.6 = "particularly in the section"
    message.7 = "SL_SliceCut_Change."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ResetGroupSpin
*/
ResetGroupSpin:
    /* Reset the group spin button to display the proper values
    */

    /* Insert group numbers into the spin button */

    NumberStem.0 = VRMethod( "WC_1", "GetNumGroups" )
    call VRMethod "SPIN_Group", "SetStringList", "NumberStem."

    /* Set the default values */

    groupNum = VRGet( "SPIN_Group", "Value" )
    sliceCut = VRMethod( "WC_1", "GetOption", "GroupSliceCut." || groupNum )
    call VRSet "SL_SliceCut", "TickIndex", sliceCut + 1
return

/*:VRX         SL_SliceCut_Change
*/
SL_SliceCut_Change:
    /* Update the chart slice from the slide bar
    */

    groupNumber = VRGet( "SPIN_Group", "Value" )
    sliceCut = VRGet( "SL_SliceCut", "TickIndex" ) - 1

    call VRMethod "WC_1", "SetOption", "GroupSliceCut." || groupNumber, sliceCut
return

/*:VRX         SPIN_Group_Change
*/
SPIN_Group_Change:
    /* Change the group in the spin button.
    */

    groupNum = VRGet( "SPIN_Group", "Value" )
    sliceCut = VRMethod( "WC_1", "GetOption", "GroupSliceCut." || groupNum )
    call VRSet "SL_SliceCut", "TickIndex", sliceCut + 1
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

