/*
** Module   :INSTALL.CMD
** Abstract :Installation script for FXWRAP.SYS
**
** Copyright (C) F/X Communications
**
** Log: Sat  17/10/1998 Created
**
*/
level=1

'@echo off'

say 'FXWrap Install Copyright (C) 1998  F/X Communications'
say

parse source os2 type invocation
lastslash = lastpos('\',invocation)
path = substr(invocation,1,lastslash-1)

/***************************************************************************
** Common part of installed/uninstaller
*/

/* Determine drive letter where OS/2 is installed */

drive=strip(left(value('COMSPEC',,'OS2ENVIRONMENT'),1))

do while drive='' | stream(drive':\config.sys','c','query exists')=''

    say 'Install is unable to automatically determine '
    say 'drive letter where OS/2 is installed'
    say

    /* unable to determine drive. Ask user */

    say 'Please enter drive letter for your OS/2 partition:'
    pull drive
    if length(drive)<>1 | stream(drive':\config.sys','c','query exists')=''
    then do
        say 'Invalid drive'
        drive=''
    end
end

/* Determine PROTOCOL.INI location */
config=drive':\config.sys'
protini=''

do while lines(config)>0
    str=translate(strip(linein(config)))

    if left(str,6)<>'DEVICE'
        then iterate

    if pos('PROTMAN.OS2',str) >0
    then do
        parse value str with 'DEVICE='protman prot_path

        /* If /I: is specified, then use value passed in /I */
        /* else use path of protman itself */

        prot_path=strip(prot_path)

        if prot_path = ''
        then do
            protini=left(protman, lastpos('\',protman)-1)
        end
        else do
            parse value prot_path with beg':\'protman
            protini=right(beg,1)':\'protman
        end
    end
end
call stream config, 'c', 'close'

do while protini=''
    say 'Install is unable to automatically determine '
    say 'path of PROTOCOL.INI'
    say

    /* unable to determine drive. Ask user */
    say 'Please enter path of PROTOCOL.INI:'
    pull protini
    if stream(protini'\protocol.ini','c','query exists')=''
    then do
        say 'Path is ivalid'
    end
end

/* check prerequisites */

if stream(protini'\PROTOCOL.!!!','c', 'query exists')<>''
then do
    say 'File PROTOCOL.!!! exists in directory 'protini
    say 'Probably caused by cancelled installation of FXWRAP'
    say 'Check contents of file, and please rename or delete it.'
    say 'Then restart installation of FXWRAP.'
    exit
end

if stream(drive':\CONFIG.!!!','c', 'query exists')<>''
then do
    say 'File CONFIG.!!! exists in 'translate(drive)':\'
    say 'Probably caused by cancelled installation of FXWRAP'
    say 'Check contents of file, and please rename or delete it.'
    say 'Then restart installation of FXWRAP.'
    exit
end

/* Last chance */

say 'Press'
say '<I> to install FXWRAP'
say '<U> to uninstall previously installed FXWRAP'
say 'any other key to exit'

pull answer

backup_copy=backup_name(protini'\PROTOCOL.')
backup_config=backup_name(drive':\CONFIG.')

if backup_copy='' | backup_config=''
then do
    say 'Unable to create backup copy of system files, aborting.'
    exit
end

if answer='U'
    then call uninstall;

if answer='I'
    then call install;
exit

/*--------------------------------------------------------------------------*/
/* Installation procedure                                                   */
/*--------------------------------------------------------------------------*/

Install:

if stream(path'\FXWRAP.SYS','c', 'query exists')=''
then do
    say 'File FXWRAP.SYS is NOT found in the INSTALL.CMD directory, aborting.'
    exit
end

config=drive':\config.sys'

do while lines(config)>0
    str=translate(strip(linein(config)))

    if left(str,6)<>'DEVICE'
        then iterate

    if pos('FXWRAP.SYS', str) >0
    then do
        say 'Install does not support installation of more than one'
        say 'instance of FXWRAP.SYS.'
        exit
    end
end
call stream config, 'c', 'close'


/* Parse PROTOCOL.INI and build bind tree */

config=protini'\PROTOCOL.INI'
nif_list=''
bind_list.=''
cur_nif=''
tcpip_nif=''

/* determine full list of NIF's */
/* determine full list of bindings for each NIF's*/

do while lines(config) > 0
    str=strip(linein(config))
    if str=''
        then iterate;

    if left(str,1)=';'
        then iterate;

    if left(str,1)='[' /*section name*/
    then do
        cur_nif=strip(substr(str,2,length(str)-2))

        if translate(cur_nif)='TCPIP_NIF'
            then tcpip_nif=cur_nif;

        nif_list=nif_list' 'cur_nif
        bind_list.cur_nif=''
        bind_list.cur_nif.bound=0
        iterate
    end

    if cur_nif=''
        then iterate;

    parse value str with variable'='var_value

    if translate(strip(variable))='BINDINGS'
    then do
        bind_list.cur_nif=var_value
        iterate
    end

    if cur_nif='IBMLXCFG'
    then do
        parse value str with nif_name'='file_name
        nif_name=strip(nif_name)
        file_name=strip(file_name)
        bind_list.nif_name.file=file_name
    end
end
call stream config, 'c', 'close'
nif_list=strip(nif_list)

/* Determine bottom level NIF's */

bottom_nifs=''

do i=1 to words(nif_list)
    call find_bindings word(nif_list,i)
end

do i=1 to words(nif_list)
    cur_nif=word(nif_list,i)

    if bind_list.cur_nif.bound = 1
    then do
        bottom_nifs=bottom_nifs' 'cur_nif
    end
end

bottom_nifs=strip(bottom_nifs)

/* */
j=1
sel_nif=-1

if pos('FXWRAP_NIF', translate(bind_list.tcpip_nif)) > 0
then do
    say 'Install does not support installation of more than one'
    say 'instance of FXWRAP.SYS.'
    exit
end

/* Show note about possible problems */

say
say '************************** WARNING !!! **************************'
say
say 'Installation of FXWRAP.SYS makes it impossible for MPTS.EXE to'
say 'correctly process PROTOCOL.INI. If you need to use MPTS to change'
say 'your network and protocol configuration, then uninstall FXWRAP,'
say 'make MPTS changes, and then reinstall FXWRAP. Simply use'
say 'INSTALL.CMD to install and uninstall FXWRAP.'
say
say '************************** WARNING !!! **************************'
say
say 'You have 'words(bottom_nifs)' LAN adapter(s) installed'
say
say 'Select the adapter attached to the external network'
say '(or 0 to cancel the installation):'
say

do i=1 to words(nif_list)
    cur_nif=word(nif_list,i)

    if bind_list.cur_nif.bound = 1
    then do
        lan_num=wordpos(cur_nif, translate(bind_list.tcpip_nif,' ',','))-1
        say j'. lan'lan_num':' strip(adapter_name(cur_nif))
        j=j+1
    end
end

say '0. Exit'

do while sel_nif='' | verify(sel_nif,'0123456789') <> 0 | sel_nif < 0 | sel_nif >= j
    say 'Choice:'
    pull sel_nif .
end

if sel_nif=0
    then exit;

j = 0

replace_nif=''

do i=1 to words(nif_list)
    cur_nif=word(nif_list,i)
    if bind_list.cur_nif.bound = 1
    then do
        j = j + 1
        if j = sel_nif
        then do
            replace_nif=cur_nif
            leave;
        end
    end
end

say 'Processing 'adapter_name(replace_nif)

infile =protini'\PROTOCOL.INI'
outfile=protini'\PROTOCOL.!!!'

do while lines(infile) > 0
    str2=linein(infile)
    str=strip(str2)

    if str='' | left(str,1)=';' | left(str,1)='['
    then do
        call lineout outfile, str2
        iterate
    end

    parse value str2 with var_name'='var_value

    if translate(strip(var_name))='BINDINGS'
    then do
        repl_pos=pos(translate(replace_nif),translate(var_value))
        if repl_pos > 0
        then do
            var_value=replace_bindings(var_value, replace_nif, 'FXWRAP_nif')
            call lineout outfile, '   'strip(var_name)'   = 'var_value
        end
        else
            call lineout outfile, str2;
    end
    else
        call lineout outfile, str2;
end

call lineout outfile,'[FXWRAP_nif]'
call lineout outfile,''
call lineout outfile,'   Drivername = FXWRAP1$'
call lineout outfile,'   Bindings   = 'replace_nif
call lineout outfile,''

call stream outfile, 'c', 'close'
call stream infile, 'c', 'close'

say 'Processing 'translate(drive)':\CONFIG.SYS'

tmpconfig=drive':\CONFIG.!!!'
infile   =drive':\CONFIG.SYS'
inserted=0

do while lines(infile) > 0
    str=linein(infile)
    call lineout tmpconfig, str

    if inserted=1
        then iterate;

    if pos('\IBMCOM\MACS\',translate(str)) > 0 & left(translate(strip(str)),6)='DEVICE'
    then do
        call lineout tmpconfig, 'DEVICE='protini'\MACS\FXWRAP.SYS'
        inserted=1
    end
end

if inserted=0
then do
    call lineout tmpconfig, 'DEVICE='protini'\MACS\FXWRAP.SYS'
end

call stream tmpconfig, 'c', 'close'
call stream infile, 'c', 'close'

/* replace PROTOCOL.INI */
/* replace CONFIG.SYS */
/* copy FXWRAP.SYS to all other MAC's */

'copy FXWRAP.SYS 'protini'\MACS >nul 2>nul'
if rc<>0
then do
    say 'Unable to copy FXWRAP.SYS to 'protini'\MACS'
    exit
end

'copy 'protini'\PROTOCOL.INI 'backup_copy '>nul 2>nul'

if rc<>0
then do
    say 'Unable to create backup copy of PROTOCOL.INI'
    exit
end

say protini'\PROTOCOL.INI saved as 'backup_copy;

'copy 'drive':\CONFIG.SYS 'backup_config '>nul 2>nul'

if rc<>0
then do
    say 'Unable to create backup copy of CONFIG.SYS'
    exit
end

say drive':\CONFIG.SYS saved as 'backup_config

'copy 'outfile protini'\PROTOCOL.INI >nul 2>nul'
if rc<>0
then do
    say 'Unable to replace 'protini'\PROTOCOL.INI'
    exit
end
'del 'outfile '> nul 2>nul'

'copy 'tmpconfig drive':\CONFIG.SYS >nul 2>nul'
if rc<>0
then do
    say 'Unable to replace 'drive':\CONFIG.SYS'
    exit
end
'del 'tmpconfig '> nul 2>nul'

say 'Installation completed successfully'
say 'You must reboot computer to activate FXWRAP.SYS device driver.'

return ''

/*--------------------------------------------------------------------------*/
/* Uninstallation procedure                                                 */
/*--------------------------------------------------------------------------*/

uninstall:
/* Parse PROTOCOL.INI and build bind tree */

config=protini'\PROTOCOL.INI'
nif_list=''
bind_list.=''
cur_nif=''

/* determine full list of NIF's */
/* determine full list of bindings for each NIF's*/

do while lines(config) > 0
    str=strip(linein(config))
    if str=''
        then iterate;

    if left(str,1)=';'
        then iterate;

    if left(str,1)='[' /*section name*/
    then do
        cur_nif=strip(substr(str,2,length(str)-2))
        nif_list=nif_list' 'cur_nif
        bind_list.cur_nif=''
        bind_list.cur_nif.bound=0
        iterate
    end

    if cur_nif=''
        then iterate;

    parse value str with variable'='var_value

    if translate(strip(variable))='BINDINGS'
    then do
        bind_list.cur_nif=var_value
        iterate
    end

    if cur_nif='IBMLXCFG'
    then do
        parse value str with nif_name'='file_name
        nif_name=strip(nif_name)
        file_name=strip(file_name)
        bind_list.nif_name.file=file_name
    end
end

call stream config, 'c', 'close'

nif_list=strip(nif_list)

/* Determine bottom level NIF's */

bottom_nifs=''

do i=1 to words(nif_list)
    call find_bindings word(nif_list,i)
end

do i=1 to words(nif_list)
    cur_nif=word(nif_list,i)
    /*say 'nif_list.'cur_nif'='bind_list.cur_nif*/
    if bind_list.cur_nif.bound = 1
    then do
        bottom_nifs=bottom_nifs' 'cur_nif
    end
end

bottom_nifs=strip(bottom_nifs)

fxwrap_nif=''
/* Find FXWRAP_nif and find their bindings */
do i=1 to words(bottom_nifs)
    cur_nif=word(bottom_nifs,i)
    if left(translate(cur_nif),6)='FXWRAP'
    then do
        /*say cur_nif',' bind_list.cur_nif*/
        fxwrap_nif=cur_nif
        leave
    end
end
if fxwrap_nif=''
then do
    say 'FXWRAP is NOT installed, aborting'
    exit
end

/*say cur_nif 'bound to' bind_list.cur_nif*/

say 'Processing 'fxwrap_nif

infile =protini'\PROTOCOL.INI'
outfile=protini'\PROTOCOL.!!!'

do while lines(infile) > 0
    str2=linein(infile)
    str=strip(str2)

    if str='' | left(str,1)=';' | left(str,1)='['
    then do
        if left(str,1)='['
        then do
            if translate(strip(substr(str,2,length(str)-2)))=translate(fxwrap_nif)
            then do
                do while lines(infile) > 0
                    str2 = linein(infile)
                    if left(strip(str2),1)='['
                    then do
                        call lineout outfile, str2;
                        leave
                    end
                end
            end
            else
                call lineout outfile, str2;
        end
        else
        	call lineout outfile, str2;
        iterate
    end

    parse value str2 with var_name'='var_value

    if translate(strip(var_name))='BINDINGS'
    then do
        repl_pos=pos(translate(fxwrap_nif),translate(var_value))
        if repl_pos > 0
        then do
            var_value=replace_bindings(var_value, fxwrap_nif, bind_list.fxwrap_nif)
            call lineout outfile, '   'strip(var_name)'   = 'var_value
        end
        else
            call lineout outfile, str2;
    end
    else
        call lineout outfile, str2;
end

call stream outfile, 'c', 'close'
call stream infile, 'c', 'close'

say 'Processing 'translate(drive)':\CONFIG.SYS'

tmpconfig=drive':\CONFIG.!!!'
infile   =drive':\CONFIG.SYS'
inserted=0

do while lines(infile) > 0
    str=linein(infile)
    /* Find FXWRAP.SYS */
    if left(translate(strip(str)),6)='DEVICE' & pos('FXWRAP.SYS',translate(str)) > 0
        then iterate;
    else
        call lineout tmpconfig, str;
end

call stream tmpconfig, 'c', 'close'
call stream infile, 'c', 'close'

/* replace PROTOCOL.INI */
/* replace CONFIG.SYS */
/* copy FXWRAP.SYS to all other MAC's */

'copy 'protini'\PROTOCOL.INI 'backup_copy '>nul 2>nul'

if rc<>0
then do
    say 'Unable to create backup copy of PROTOCOL.INI'
    exit
end

say protini'\PROTOCOL.INI saved as 'backup_copy;

'copy 'drive':\CONFIG.SYS 'backup_config '>nul 2>nul'

if rc<>0
then do
    say 'Unable to create backup copy of CONFIG.SYS'
    exit
end

say drive':\CONFIG.SYS saved as 'backup_config

'copy 'outfile protini'\PROTOCOL.INI >nul 2>nul'
if rc<>0
then do
    say 'Unable to replace 'protini'\PROTOCOL.INI'
    exit
end
'del 'outfile '> nul 2>nul'

'copy 'tmpconfig drive':\CONFIG.SYS >nul 2>nul'
if rc<>0
then do
    say 'Unable to replace 'drive':\CONFIG.SYS'
    exit
end

'del 'tmpconfig '> nul 2>nul'

say 'Uninstallation completed successfully'
say 'You must reboot computer to deactivate FXWRAP.SYS device driver.'

return ''

/*--------------------------------------------------------------------------*/
/* Utility procedure                                                        */
/*--------------------------------------------------------------------------*/

find_bindings: procedure expose bind_list. level
    cur_nif=arg(1)

    if bind_list.cur_nif<>''
    then do
        /*bindings can be separated by commas and by spaces */
        bind_list.cur_nif=space(translate(bind_list.cur_nif,' ', ','),1)

        do j=1 to words(strip(bind_list.cur_nif))
            nif=word(strip(bind_list.cur_nif),j)
            bind_list.nif.bound=1
            call find_bindings nif
        end
    end
return 0

adapter_name:
    fname=arg(1)
    adaptername=fname
    fname=bind_list.fname.file
    section=''

    if fname<>'' & stream(protini'\MACS\'fname,'c','query exists')<>''
    then do
        ad_nif=protini'\MACS\'fname

        do while lines(ad_nif)
            str=strip(linein(ad_nif))

            if str=''
                then iterate;

            if left(str,'1')='['
            then do
                if section<>''
                    then leave; /* parse only first section of .NIF*/
                section=strip(substr(str,2,length(str)-2))
                iterate
            end

            if section=''
                then iterate;

            parse value str with var_name'='var_value
            if translate(strip(var_name))='TITLE'
            then do
                adaptername=var_value
                leave
            end
        end
        call stream ad_nif, 'c', 'close'
    end
return adaptername

backup_name: procedure
    backup_copy=''
    basefile=arg(1)
    bkp=0

    do while backup_copy='' & bkp < 1000
        bkp_ext=right(bkp,3,'0')
        if stream(basefile||bkp_ext,'c','query exists')=''
        then do
            backup_copy=basefile||bkp_ext
        end
        bkp=bkp+1
    end
return backup_copy

/*
replace_bindings: procedure
    var_value=translate(strip(arg(1)),' ', ',')
    find_nif=strip(arg(2))
    repl_nif=strip(arg(3))
    out=''

    if left(strip(arg(1)),1)=','
        then var_value='~ 'var_value

    do i = 1 to words(var_value)

        if translate(word(var_value, i))=translate(find_nif)
        then do
            out=out||repl_nif;
        end
        else do
            out = out||word(var_value, i)
        end

        if i<>words(var_value)
            then out=out||' '
    end

    var_value=out

    if left(strip(arg(1)),1)=','
        then var_value=substr(var_value,2);

    var_value=translate(var_value,',', ' ')
return var_value
*/

replace_bindings: procedure
    var_value=strip(arg(1))
    find_nif=strip(arg(2))
    repl_nif=strip(arg(3))
    out=''

    do while var_value<>''
        prev=strip(var_value)
        parse value strip(var_value) with beg','var_value

        if translate(beg)=translate(find_nif)
        then do
            beg=repl_nif;
        end

        out=out||beg
        if var_value<>'' | prev=','
            then out=out','
    end

    var_value=out

return var_value

