/****************************************************************/
/*      Add a single-use account to the FtpServer database      */
/*                                                              */
/*      FtpServer itself will remove the account after it       */
/*                  has been used once                          */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      1 January 2002                            */
/*      Last revised: 8 June 2004                               */
/*                                                              */
/*  Usage:                                                      */
/*         onetime username password                            */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing FTPD.INI   */
/*         Edit the value of the PathString variable, in        */
/*         line 29 of this script, to reflect the directory     */
/*         you really want the user to use.                     */
/*                                                              */
/*         Remark: if the PathString is really complicated,     */
/*         you might want to develop a solution that uses       */
/*         LoadPRM rather than this script.                     */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PathString = '"/"="C:\Download"'

PARSE ARG username password
IF username = '' THEN
    DO
        SAY "Usage: onetime username password"
        EXIT 1
    END

/* Check the source directory, in case this command file is     */
/* run from a different directory.                              */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)
ini = INIFileFor(SrcDir, username)

/* Check for duplicated username. */

IF SysIni(ini, username, 'Category') \= 'ERROR:' THEN
    DO
        SAY "Username "username" already exists"
        SAY "Try a different name"
        EXIT 1
    END

/* Create the INI file entries for this new user. */

CALL SysIni ini, username, 'Category', '03'X
CALL SysIni ini, username, 'Notes', 'Single-use account'
CALL SysIni ini, username, 'Password', password
CALL SysIni ini, username, 'RealName', ''
CALL SysIni ini, username, 'SingleUse', '01'X
CALL SysIni ini, username, 'SpeedLimit', 'FFFFFFFF'X
CALL SysIni ini, username, 'UserLimit', '01000000'X
CALL SysIni ini, username, 'Volume', PathString

EXIT 0

/****************************************************************/
/*  Procedure to find the INI file that contains the data for   */
/*  one user.  In most installations this will turn out to be   */
/*  the file called FTPD.INI, but if the option to use multiple */
/*  INI files is activated then the file name is based on a     */
/*  hash coding of the username.                                */
/****************************************************************/

IniFileFor:  PROCEDURE

    PARSE UPPER ARG SrcDir, username
    file = SrcDir'\FTPD.INI'
    HashMax = SysIni(file, '$SYS', 'HashMax')
    IF HashMax = 'ERROR:' THEN HashMax = 0
    ELSE HashMax = C2D(REVERSE(HashMax))
    IF HashMax \= 0 THEN DO
        code = 0
        DO WHILE username <> ''
            ch = LEFT(username,1)
            username = RIGHT(username, LENGTH(username)-1)
            code = (16*code + C2D(ch)) // HashMax
        END
        code = TRANSLATE(FORMAT(code,4), '0', ' ')
        file = SrcDir'\FTPD'code'.INI'
    END
    RETURN file

