@echo off
rem 22-12-2001 JvW First version; Demo truncation for eCS install
rem 26-12-2001 JvW Added psave to allow prestore rollback; added UNDO parameter
rem 08-01-2002 JvW Try truncate on 1st 06/07/0b/0c type found in part 01 .. 03
rem 11-07-2002 JvW Updated to use V5 DFSDOS
rem 20-07-2002 JvW Removed confusing 'spacebar' hint for non-registred users
rem 05-11-2002 JvW Updated for executable naming DFSOS2, DFSWIN and DFSDOS
echo.

echo. >> dfstrunc.log
echo ========================= %0 ============================ >> dfstrunc.log
echo DFSee TRUNCATE script %0 called with parameters: %1 %2 %3 >> dfstrunc.log

set eflag=
if "%0"=="TRUNCTST" set eflag=-R
if "%0"=="trunctst" set eflag=-R

if "%OS2_SHELL%"=="" goto notos2
set dfsexe=dfsos2.exe
set cmdext=CMD
goto dfsee
:notos2
if "%OS%"==""        goto notnt
if "%OS%"=="DOS"     goto notnt
if "%OS%"=="MSDOS"   goto notnt
if "%OS%"=="DRDOS"   goto notnt
if "%OS%"=="IBMDOS"  goto notnt
if "%OS%"=="OPENDOS" goto notnt
set dfsexe=dfswin.exe
set cmdext=BAT
goto dfsee
:notnt
set dfsexe=dfsdos.exe
set cmdext=BAT
:dfsee

if "%1" == ""       goto usage
if "%1" == "?"      goto usage
if "%1" == "/?"     goto usage
if "%1" == "-?"     goto usage

echo Checking DFSee registration; Please wait ...
%dfsexe% -R -b -q query RValid
if not errorlevel 1 goto work
echo.
echo NOTE: Your DFSee version is not properly registred, this will cause
echo       some extra delays and reminder messages to be displayed  ...
echo.

:work
set fsize=%1
if "%2" == ""       goto defpart
set partid=%2
goto partset
:defpart
echo Check if another primary can be created on disk 1
echo Check if another primary can be created on disk 1                   >> dfstrunc.log
%dfsexe% -R -b -l:dfstrunc -q query DPrim  1
if errorlevel 4 goto nomoreprim
if not errorlevel 3 goto trypart1
%dfsexe% -R -b -l:dfstrunc -q query DTotal 1
if not errorlevel 4 goto trypart1
:nomoreprim
echo.
echo No room in partition table to create another primary partition!
echo No room in partition table to create another primary partition!     >> dfstrunc.log
goto end

echo find 06/07/0b/0c type in first three partitions on disk 1
echo find 06/07/0b/0c type in first three partitions on disk 1           >> dfstrunc.log
:trypart1
set partid=1
%dfsexe% -R -b -l:dfstrunc -q query PType  %partid%
if errorlevel 13 goto trypart2
if errorlevel 11 goto partset
if errorlevel  8 goto trypart2
if errorlevel  6 goto partset

:trypart2
set partid=2
%dfsexe% -R -b -l:dfstrunc -q query PType  %partid%
if errorlevel 13 goto trypart3
if errorlevel 11 goto partset
if errorlevel  8 goto trypart3
if errorlevel  6 goto partset

:trypart3
set partid=3
%dfsexe% -R -b -l:dfstrunc -q query PType  %partid%
if errorlevel 13 goto trypart4
if errorlevel 11 goto partset
if errorlevel  8 goto trypart4
if errorlevel  6 goto partset

:trypart4
echo.
echo No FAT, FAT32 or NTFS partition found in first 3 ...
echo No FAT, FAT32 or NTFS partition found in first 3 ...                >> dfstrunc.log
echo Truncation to make new primary is NOT possible!
goto end

:partset
echo Check partition number %partid% ...
echo Check partition number %partid% ...                                 >> dfstrunc.log
%dfsexe% -R -b -l:dfstrunc -q query PValid %partid%
if errorlevel 1 goto badpart

echo Find out on which disk %partid% is located ...
echo Find out on which disk %partid% is located ...                      >> dfstrunc.log
%dfsexe% -R -b -l:dfstrunc -q query PDisknr %partid%
if errorlevel 9 goto nodisk
if errorlevel 8 goto disk8
if errorlevel 7 goto disk7
if errorlevel 6 goto disk6
if errorlevel 5 goto disk5
if errorlevel 4 goto disk4
if errorlevel 3 goto disk3
if errorlevel 2 goto disk2
if errorlevel 1 goto disk1
goto nodisk
:disk1
set disknr=1
goto diskset
:disk2
set disknr=2
goto diskset
:disk3
set disknr=3
goto diskset
:disk4
set disknr=4
goto diskset
:disk5
set disknr=5
goto diskset
:disk6
set disknr=6
goto diskset
:disk7
set disknr=7
goto diskset
:disk8
set disknr=8
:diskset

if "%1" == "U"      goto undo
if "%1" == "u"      goto undo
if "%1" == "/U"     goto undo
if "%1" == "/u"     goto undo
if "%1" == "-u"     goto undo
if "%1" == "-U"     goto undo
if "%1" == "undo"   goto undo
if "%1" == "UNDO"   goto undo
if "%1" == "Undo"   goto undo

:truncate
echo Truncate partition, trying to make freespace                        >> dfstrunc.log
echo Truncate partition, trying to make freespace
echo Double-check disk-nr %disknr% availability ...
%dfsexe% -R -b -l:dfstrunc -q disk %disknr%#q
if errorlevel 1 goto baddisk
echo Save current partition information allowing rollback later (UNDO)
%dfsexe% -R -b -l:dfstrunc fdisk psave %disknr% dfstrunc info for UNDO truncate part %partid%
echo Show current partitioning of disk %disknr%:
%dfsexe% -R -b -l:dfstrunc map %disknr% +#q
echo Truncate partition %partid% to create %fsize% Mb of freespace; Please wait ...
%dfsexe% %eflag% -b -q -l:dfstrunc fdisk#part %partid%#trunc -f:%fsize%#q
echo.
if errorlevel 1 goto truncerr
%dfsexe% -R -b -l:dfstrunc map %disknr% +#q
echo.
echo View for disk %disknr%, after truncation of partition %partid% ...  >> dfstrunc.log
echo View for disk %disknr%, after truncation of partition %partid% ...
goto end

:undo
echo.
echo UNDO previous TRUNCATE partition %partid%, by %0 using DFSTRUNC.PD%disknr%
echo.
echo Check presence of the DFSTRUNC.PD%disknr% file ...
if not exist dfstrunc.pd%disknr% goto nosaved
echo Restore partition information from save dfstrunc.pd%disknr% file (UNDO)
%dfsexe% %eflag% -b -l:dfstrunc fdisk prestore %disknr% dfstrunc
echo.
%dfsexe% -R -b -l:dfstrunc map %disknr% +#q
echo.
echo View for disk %disknr%, after UNDO ... >> dfstrunc.log
echo View for disk %disknr%, after UNDO ...
goto end

:nosaved
echo.
echo There is NO dfstrunc.pd%disknr% file (anymore). UNDO is not possible.
echo.
goto end

:truncerr
echo Partition %partid% has NOT been truncated
goto end

:badpart
echo.
echo The specified partition number %partid% is not valid
echo.
goto end

:nodisk
echo.
echo The disk for partition %partid% is not supported or not present.
echo Only disks 1 through 8 can be used with %0
echo.
goto end

:baddisk
echo.
echo Disk number %disknr% does not seem to be present (or locked)
:locked
echo A disk in your system is not accesible, possibly locked.
echo This might be caused by another FDISK, LVM or DFSee program being active.
echo Please close all other FDISK related programs before running %0
echo.
goto end

:usage
echo %0   TRUNCATE a (FAT/NTFS/HPFS) partition, or undo previous truncate
echo.
echo Usage, to truncate:  %0  megabytes-needed  [ partition-id ]
echo.
echo.       Where the megabytes-needed will be taken from the partition-id
echo        specified (or 01 if not) that will be made SMALLER, while the
echo        rest will become FREESPACE to be used for other partitions.
echo        The partition-id is the left-most column in a DFSee PART list.
echo.
echo.       With no partition specified, a suitable FAT or NTFS is searched
echo.
echo    or, to rollback:  %0  undo              [ partition-id ]
echo.
echo.       When a partition-id was specified on the truncate, it MUST be
echo        specified on the undo as well, to find the right disk to undo!
echo        The UNDO will only work AFTER a truncation has been done, and
echo        as long as the recovery files DFSTRUNC.PD* are still present.
echo        Only the last truncation can be undone in this way.
echo.
if "%eflag%"=="" goto tipreal
echo %0 is operating in READONLY mode. No changes will be made to the disk.
echo For real truncation, rename %0 to DFSTRUNC.BAT (or DFSTRUNC.CMD)
echo.
goto end
:tipreal
echo For test purposes, rename %0 to TRUNCTST.BAT (or TRUNCTST.CMD)
echo this will make sure it operates in READONLY mode. Check the logfile
echo DFSTRUNC.LOG to check details about the tested truncation.
echo.
:end
