.*! html2ipf 0.4


:userdoc.

:title.fte Manual

:h1 id=0.About FTE
:lm margin=1.:i1.About FTE
:p.:lines align=center. fte
.br
Version :hp2.0.43b:ehp2.
.br
(c) Copyright 1995,1996 Marko Macek
.br
:elines.
:p.The latest version can be always downloaded from&colon.
.br
:hp2.http&colon.//ixtas.fri.uni-lj.si/~markom/fte:ehp2. 
:p.Please send comments/suggestions/bug reports to&colon.
.br
:hp2.Marko.Macek@snet.fri.uni-lj.si:ehp2. or :hp2.mark@hermes.si:ehp2. 
:p.See file HISTORY for recent changes. 
:p.See file TODO for possible future additions. 
:p.See file README for last minute notes. 
.br

:h1 id=1.Installation
:lm margin=1.:i1.Installation
:p.This section covers installation and configuration of editor. 
:h2 id=2.OS/2
:lm margin=1.:i1.OS/2
:p.
:p.The following files are included in the archive&colon. :dl compact tsize=10 break=all. 
:dt.:hp2.README:ehp2. 
:dd.Release notes, read first! 
:dt.:hp2.fte.exe:ehp2. 
:dd.Text-mode executable 
:dt.:hp2.ftepm.exe:ehp2. 
:dd.Presentation Manager executable 
:dt.:hp2.fte-def.cnf:ehp2. 
:dd.Default compiled configuration file. 
:dt.:hp2.fte.inf:ehp2., :hp2.fte.ipf:ehp2., :hp2.fte.html:ehp2., :hp2.fte.txt:ehp2. 
:dd.This file, in various formats. 
:dt.:hp2.config\*.fte:ehp2. 
:dd.Configuration files in source form. 
:dt.:hp2.clipserv.exe:ehp2. 
:dd.Clipboard server (required for PM clipboard support in text-mode
version). 
:dt.:hp2.cliputil.exe:ehp2. 
:dd.Utility to copy/paste to/from clipboard from command line. 
:dt.:hp2.HISTORY:ehp2. 
:dd.Revision history. 
:dt.:hp2.TODO:ehp2. 
:dd.Todo list. 
:dt.:hp2.file_id.diz:ehp2. 
:dd.Program description for BBS upload. :edl.
:p.The default configuration files are precompiled into :hp2.fte-def.cnf:ehp2.. This file should be copied to :hp2.fte.cnf:ehp2. for text-mode version, and to :hp2.ftepm.cnf:ehp2. for PM version. Or, you may want to compile your own configuration
from source using :hp1.cfte:ehp1. configuration file compiler. 
:p.For minimal installation of the text mode version, only :hp2.fte.exe:ehp2. and :hp2.fte.cnf:ehp2. are required. For PM clipboard support :hp2.clipserv.EXE:ehp2. is needed and must be running whenever you wish to use PM clipboard
from FTE. 
:p.To install PM version, :hp2.ftepm.exe:ehp2. and :hp2.ftepm.cnf:ehp2. are needed. 
:p.To recompile source files, :hp2.cfte.exe:ehp2. and :hp2.config\*.fte:ehp2. files are needed. 
:p.
:p.Place executable files somewhere on your :hp2.PATH:ehp2.. Compiled configuration files should be located in the same directory
as executable and have the same basename with extension :hp2..CNF:ehp2.. 
.br

:h2 id=3.Unix
:lm margin=1.:i1.Unix
:p.The following files are included in the archive&colon. :dl compact tsize=10 break=all. 
:dt.:hp2.README:ehp2. 
:dd.Readme file. 
:dt.:hp2.fte:ehp2. 
:dd.Linux console-only executable 
:dt.:hp2.Xfte:ehp2. 
:dd.X11 Xlib executable. 
:dt.:hp2.fte-def.cnf:ehp2. 
:dd.Default compiled configuration file 
:dt.:hp2.fte.html:ehp2. 
:dd.Reference manual 
:dt.:hp2.config\*.fte:ehp2. 
:dd.Configuration files in source form. 
:dt.:hp2.HISTORY:ehp2. 
:dd.History of changes. 
:dt.:hp2.TODO:ehp2. 
:dd.Todo list. 
:dt.:hp2.file_id.diz:ehp2. 
:dd.Program description for BBS upload. 
:dt.:hp2.fte-0.38.lsm:ehp2. 
:dd.LSM entry for FTE. :edl.
:p.The default configuration files are precompiled into :hp2.fte-def.cnf:ehp2.. This file should be copied to :hp2.~/.fterc:ehp2. to be automatically loaded by FTE. You may want to compile your own
configuration from source using :hp1.cfte:ehp1. configuration file compiler. 
:p.Suggested installation directories&colon. :xmp.
        /usr/local/bin/fte
        /usr/local/bin/Xfte
        /usr/local/bin/cfte
        /usr/local/lib/fte/etc/*.fte
        /usr/local/lib/fte/lib/fte.html
        /usr/local/lib/fte/lib/TODO
        /usr/local/lib/fte/lib/HISTORY
        /usr/local/lib/fte/lib/README
:exmp.
.br

:h1 id=4.Execution
:lm margin=1.:i1.Execution
:p.The FTE command line syntax is&colon. 
:p.:hp2.fte [[options] [files] ...]:ehp2. 
:p.Options&colon. :dl compact tsize=10 break=all. 
:dt.:hp2.-!:ehp2. 
:dd.Ignore any external configuration file. 
:dt.:hp2.-c<file>:ehp2. 
:dd.Use specified configuration file (compiled). 
:dt.:hp2.-l<line>[,<column>]:ehp2. 
:dd.Go to line (and column) in next file on command line 
:dt.:hp2.-m<MODE>:ehp2. 
:dd.Set mode for next files to <MODE> 
:dt.:hp2.-m:ehp2. 
:dd.Reset to default mode 
:dt.:hp2.-d<.dsk>:ehp2. 
:dd.Load/save desktop from file <.dsk>. If no argument, disable desktop
load/save. 
:dt.:hp2.-h<.his>:ehp2. 
:dd.Load/save history from file <.his>. If no argument, disable history
load/save. 
:dt.:hp2.--:ehp2. 
:dd.The rest of the arguments are not options, but filenames. 
:dt.:hp2.-+:ehp2. 
:dd.The next argument is not an option even if starting with a '-'. :edl.
:p.There should not be any delimiter between option and it's arguments. 
:p.Examples&colon. :dl compact tsize=10 break=all. 
:dt.:hp2.fte -mBIN fte.exe:ehp2. 
:dd.load fte.exe in BIN mode 
:dt.:hp2.fte -#100,30 win.c:ehp2. 
:dd.go to (100,30) in win.c 
:dt.:hp2.fte window.cpp:ehp2. 
:dd.load file window.cpp 
:dt.:hp2.fte -mBIN fte.exe -m fte.cpp:ehp2. 
:dd.load fte.exe in binary mode, window.cpp in default mode (C/C++) 
:dt.:hp2.fte -mBIN -+ -bla-:ehp2. 
:dd.load file -bla- in BIN mode 
:dt.:hp2.fte -- -1 -2 -3 -4 -5 -6:ehp2. 
:dd..load files -1, -2, -3, -4, -5, -6 :edl.
:p.Under OS/2 default history and desktop file names are :hp2.FTE.DSK:ehp2. and :hp2.FTE.HIS:ehp2. respectively. Under Unix they are named :hp2..fte-desktop:ehp2. and :hp2..fte-history:ehp2.. The global desktop and history files will be searched in program
directory under OS/2 and in user home directory under Unix. 
.br

:h1 id=5.Configuration Files
:lm margin=1.:i1.Configuration Files
:p.FTE configuration files are version specific, and must be recompiled
for each new version of the editor. 
:p.On startup, editor will attempt to load a configuration file with the
basename as the executable and extension :hp2..CNF:ehp2.. The configuration file is produced by compiling source files with :hp1.CFTE:ehp1.. 
:p.If the command line option :hp2.-!:ehp2. is used, editor will not attempt to load a configuration file and
will use default built-in settings. 
:h2 id=6.Compiling configuration files.
:lm margin=1.:i1.Compiling configuration files.
:p.
:p.Configuration files are compiled using :hp1.CFTE:ehp1. program. 
:p.:hp1.cfte:ehp1. should be invoked on :hp2.main.fte:ehp2., for example&colon. :xmp.
[C&colon.\FTE] cfte config\main.fte
$ cfte config/main.fte
:exmp.
:p.This will automatically compile all :hp2.*.fte:ehp2. files included from :hp2.main.fte:ehp2. and produce :hp2.fte-new.cnf:ehp2. if there are no errors in source files. 
:p.When configuration source files are sucessfully compiled, the
resulting file :hp2.fte-new.cnf:ehp2. should be copied to :hp2.fte.cnf:ehp2. and :hp2.ftepm.cnf:ehp2., or under Unix to :hp2.~/.fterc:ehp2. 
:h2 id=7.Source Configuration files
:lm margin=1.:i1.Source Configuration files
:p.
:p.Comments start with character :hp2.#:ehp2. and last until the end of line. 
:p.Strings can be specified using any of :hp2.' " /:ehp2. characters. 
:p.Single quoted strings perform no substitution. To enter :hp2.':ehp2. or :hp2.\:ehp2. into a string precede it with a backslash. 
:p.Double quoted strings perform the following substitutions&colon. :xmp. 
\t  ->  tab character
\r  ->  CR 
\n  ->  LF
\v  ->  vertical tab
\b  ->  ^H, backspace
\a  ->  ^G, bell
:exmp.
:p.Strings started by :hp2./:ehp2. character require no escaping. Mostly useful for specifying :link reftype=hd refid=336.regular expressions:elink. without double backslashes. 
.br

:h1 id=8.Global Configuration
:lm margin=1.:i1.Global Configuration
:p.
:h2 id=9.Global Settings
:lm margin=1.:i1.Global Settings
:p.The following settings can be used in the :hp2.GLOBAL:ehp2. section of the configuration file. 
:h3 id=10.ScreenSizeX
:lm margin=1.:i1.ScreenSizeX
:p.Number of columns visible on screen or window 
:h3 id=11.ScreenSizeY
:lm margin=1.:i1.ScreenSizeY
:p.Number of lines visible on screen or window 
:h3 id=12.CursorInsertStart
:lm margin=1.:i1.CursorInsertStart
:p.Starting percentage of cursor size (from top) when in insert mode. 
:h3 id=13.CursorInsertEnd
:lm margin=1.:i1.CursorInsertEnd
:p.Ending percentage of cursor size when in insert mode. 
:h3 id=14.CursorOverStart
:lm margin=1.:i1.CursorOverStart
:p.Starting percentage of cursor size when in overstrike mode 
:h3 id=15.CursorOverEnd
:lm margin=1.:i1.CursorOverEnd
:p.Ending percentage of cursor size when in overstrike mode. 
:h3 id=16.SysClipboard
:lm margin=1.:i1.SysClipboard
:p.When set to 1, editor will use external (PM) clipboard instead of
internal one. 
:h3 id=17.SelectPathname
:lm margin=1.:i1.SelectPathname
:p.If set to 1, pathname will be selected by default when prompting for a
file in :link reftype=hd refid=206.FileOpen:elink. function. If set to 0, pathname will not be selected, this allows you
to quickly type a new filename, without erasing an entire entryfield. 
:h3 id=18.OpenAfterClose
:lm margin=1.:i1.OpenAfterClose
:p.If set to 1, editor will prompt for another file when all files are
closed. 
:h3 id=19.ShowMenuBar
:lm margin=1.:i1.ShowMenuBar
:p.If set to 1, main menu bar will be visible. 
:h3 id=20.ShowVScroll
:lm margin=1.:i1.ShowVScroll
:p.If set to 1, scroll bar will be visible. 
:h3 id=21.DefaultModeName
:lm margin=1.:i1.DefaultModeName
:p.Default mode name for loading/editing files. If not set or invalid,
first mode in the configuration file will be used instead. By default
set to 'PLAIN'. 
:h3 id=22.CompletionFilter
:lm margin=1.:i1.CompletionFilter
:p.Files matching this regexp are ignored when doing filename completion.
:h3 id=23.WSStyleSearch
:lm margin=1.:i1.WSStyleSearch
:p.If set to 1, editor will use WordStar style prompts with separate
prompts for search, replace string and options instead of the default
search/replace/options style. 
:h3 id=24.CompileRx
:lm margin=1.:i1.CompileRx
:p.Defines :link reftype=hd refid=336.regular expressions:elink. and thers subpattern indices to match when searching for errors and
warnings in compilation output. First number is an index of the
subpattern that matches filename. The second must match the line
number, the third parameter is the regular expression to match to each
line of the compiler output. 
:h3 id=25.C_*
:lm margin=1.:i1.C_*
:p.Define the C mode smart indentation parameters 
:p.See section on :link reftype=hd refid=31.configuring C mode indentation:elink.. 
:h3 id=26.REXX_Indent
:lm margin=1.:i1.REXX_Indent
:p.Defines the REXX basic indentation level 
:h3 id=27.KeepHistory
:lm margin=1.:i1.KeepHistory
:p.If set to 1, last file position and imput prompt history will be
loaded on startup and saved on exit. Can be overriden with command
line option '-h'. 
:h3 id=28.LoadDesktopOnEntry
:lm margin=1.:i1.LoadDesktopOnEntry
:p.If set to 1, all files listed in FTE.DSK in current directory or
FTE.EXE directory will be loaded into FTE. The desktop file can be
overriden with command line option '-d'. 
:h3 id=29.SaveDesktopOnExit
:lm margin=1.:i1.SaveDesktopOnExit
:p.If set to 1, desktop will be automatically saved when :link reftype=hd refid=304.ExitEditor:elink. command is issued. 
:h2 id=30.Colors
:lm margin=1.:i1.Colors
:p.Colors are configured in COLOR.FTE file. 
:p.Syntax for color settings is&colon. 
:p.:hp2.color:ehp2. { { 'name', 'value' } ... } 
:p.Value is the PC character attribute first char is background color,
the second is foreground color. 
:p.Colors are as follows&colon. :xmp.
        0        Black
        1        Dark Blue
        2        Dark Green 
        3        Dark Cyan
        4        Dark Red
        5        Dark Magenta
        6        Orange
        7        Pale Gray
        8        Dark Gray
        9        Blue
        A        Green
        B        Cyan
        C        Red
        D        Magenta
        E        Yellow
        F        White
:exmp.
.br

:h2 id=31.CMode Smart Indentation
:lm margin=1.:i1.CMode Smart Indentation
:p.:hp2.Settings for CMode smart indentation:ehp2. 
:p.:dl compact tsize=10 break=all. 
:dt.:hp2.C_Indent:ehp2.
:dd.Basic C indentation level 
:dt.:hp2.C_BraceOfs:ehp2.
:dd.Brace '{' offset 
:dt.:hp2.C_CaseOfs:ehp2.
:dd.Offset of case and default statements 
:dt.:hp2.C_CaseDelta:ehp2.
:dd.Offsets of statements following case/default. 
:dt.:hp2.C_ClassOfs:ehp2.
:dd.Offset of public, private and protected 
:dt.:hp2.C_ClassDelta:ehp2.
:dd.Offset of statements following public, private, protected 
:dt.:hp2.C_ColonOfs:ehp2.
:dd.Offset of labels 
:dt.:hp2.C_CommentOfs:ehp2.
:dd.Offset of comments 
:dt.:hp2.C_CommentDelta:ehp2.
:dd.Offset of second line of comments :edl.
:p.Example 1&colon. :xmp.
class line {
public&colon.                   // C_ClassOfs = 0
    line();               // C_ClassDelta = 4
    ~line();
};

int main() {
    int x = 1;
    
    /*                    // C_CommentOfs = 0
     * check value        // C_CommentDelta = 1
     */
    
    puts("main");         // C_Indent = 4
    if (x)
    {                     // C_BraceOfs = 0
        switch (x) {
        case 1&colon.           // C_CaseOfs = 0
            puts("ok");   // C_CaseDelta = 4
            break;
        }
    }
end&colon.
    return 0;
}
:exmp.
:p.Example 2&colon. :xmp.
class line {
  public&colon.                     // C_ClassOfs = 2
    line();                   // C_ClassDelta = 2
    ~line();
};

int main() {
    int x = 1;
    
      /*                      // C_CommentOfs = 2
      ** check value          // C_CommentDelta = 0
      */
    
    puts("main");             // C_Indent = 4
    if (x)
    {                         // C_BraceOfs = 0
        switch (x) {
            case 1&colon.           // C_CaseOfs = 4
                puts("ok");   // C_CaseDelta = 4
                break;
        }
    }
end&colon.
    return 0;
}
:exmp.
.br

:h1 id=32.Mode Configuration
:lm margin=1.:i1.Mode Configuration
:p.
:p.fte allows each file extension to have a different editing mode. Mode
is a collection of editor settings such as keybindings, tab settings,
autoindent settings, syntax highlighting,... 
:p.Syntax of :hp2.mode:ehp2. command is 
:p.:xmp.
mode NAME { mode settings }
mode NAME&colon. PARENT { mode settings }
:exmp.
:p.Mode with name :hp1.NAME:ehp1.inherits settings from mode :hp1.PARENT:ehp1. if parent mode is specified at mode declaration. 
:p.When editor is searching for a mode to use for a file it will first
check if the mode has been overriden by a :link reftype=hd refid=207.FileOpenInMode:elink. command or a command line option (:hp2.-m:ehp2.). 
:p.Then it will check if the file name matches any of the :link reftype=hd refid=74.FileNameRx:elink. listed with mode declarations. 
:p.If the mode has still not been found, it will read the first line (max
80 chars) of the file, and attempt to match the :link reftype=hd refid=75.FirstLineRx:elink. with the first line. 
:p.If this fails, editor will use mode specified by :hp2.:link reftype=hd refid=21.DefaultModeName:elink.:ehp2. global setting to load a file. If that mode does not exist, first
mode defined in the configuration file will be used. 
.br

:h2 id=33.Mode Settings
:lm margin=1.:i1.Mode Settings
:p.
:p.The following settings can be specified for each mode&colon. 
:h3 id=34.ExpandTabs
:lm margin=1.:i1.ExpandTabs
:p.{0,1} 
:p.Should be set to 1 if tabs are to be expanded when displayed. Use :link reftype=hd refid=280.ToggleExpandTabs:elink. command to toggle during editing. 
:h3 id=35.TabSize
:lm margin=1.:i1.TabSize
:p.{1-32} 
:p.Tab size when tabs are shown expanded on display. 
:h3 id=36.AutoIndent
:lm margin=1.:i1.AutoIndent
:p.{0,1} 
:p.Should be set to 1 if autoindent is to be used. Use :link reftype=hd refid=278.ToggleAutoIndent:elink. command to toggle it on/off during editing. 
:h3 id=37.Insert
:lm margin=1.:i1.Insert
:p.{0,1} 
:p.If set to :hp2.1:ehp2., Insert mode is active by default. If set to :hp2.0:ehp2., Overwrite mode is activated. 
:p.Use :link reftype=hd refid=279.ToggleInsert:elink. command to toggle it on/off during editing. 
:h3 id=38.StripChar
:lm margin=1.:i1.StripChar
:p.{ASCII code/-1} 
:p.This characted will be stripped if it is found the end of any line
when the file is being loaded. If it is set to :hp2.-1:ehp2., no characted will be stripped. 
:p.Usually used to strip 13 (CR) characters from DOS text files. 
:h3 id=39.LineChar
:lm margin=1.:i1.LineChar
:p.{ASCII code/-1} 
:p.This character is used as a line separator when loading a file. If set
to :hp2.-1:ehp2., there is no line separator. (:hp2.WARNING&colon. File will be loaded as one line if LineChar is set to
-1:ehp2.). 
:p.Usually set to 10 (LF) as standard text file line separator. 
:h3 id=40.AddCR
:lm margin=1.:i1.AddCR
:p.{0,1} 
:p.If set to :hp2.1:ehp2., CR (13, \r) character will be added to end of line when saving. 
:h3 id=41.AddLF
:lm margin=1.:i1.AddLF
:p.{0,1} 
:p.If set to :hp2.1:ehp2., LF (10, \n) characted will be added to end if line when saving. 
:h3 id=42.ForceNewLine
:lm margin=1.:i1.ForceNewLine
:p.{0,1} 
:p.Normally, when saving, the last line is saved without any CR/LF
characters. This setting will override that behaviour. 
:h3 id=43.Hilit
:lm margin=1.:i1.Hilit
:p.{0,1} 
:p.If set to :hp2.1:ehp2., syntax highliting will be active. 
:h3 id=44.ShowTab
:lm margin=1.:i1.ShowTab
:p.{0,1} 
:p.If set to :hp2.1:ehp2., tabs will be visible as circles (EPM-like). 
:h3 id=45.IndentMode
:lm margin=1.:i1.IndentMode
:p.{PLAIN,C,REXX} 
:p.Activates the specified smart indent mode. (PLAIN mode specifies no
smart audoindenting, just normal autoindent). 
:h3 id=46.Colorizer
:lm margin=1.:i1.Colorizer
:p.Specifies a previously declared :link reftype=hd refid=46.colorize:elink. mode to use for syntax highlighting in this editing mode. 
:h3 id=47.EventMap
:lm margin=1.:i1.EventMap
:p.Specify the name of existing eventmap to use for current mode. 
:h3 id=48.UndoLimit
:lm margin=1.:i1.UndoLimit
:p.{Number} 
:p.Limit undo to this many recent commands (-1 = unlimited) 
:h3 id=49.UndoMoves
:lm margin=1.:i1.UndoMoves
:p.{0,1} 
:p.If set to 1, all cursor movements will be recorded on undo stack. 
:h3 id=50.KeepBackups
:lm margin=1.:i1.KeepBackups
:p.{0,1} 
:p.If set to :hp2.0:ehp2., backup files will be deleted after a successful save operation. 
:h3 id=51.MatchCase
:lm margin=1.:i1.MatchCase
:p.{0,1} 
:p.If set to :hp2.0:ehp2., searches will be case insensitive. This can be toggled via :link reftype=hd refid=285.ToggleMatchCase:elink. command when editor is running. 
:h3 id=52.BackSpKillTab
:lm margin=1.:i1.BackSpKillTab
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=148.BackSpace:elink. will kill entire tabs instead of converting them to spaces. 
:h3 id=53.DeleteKillTab
:lm margin=1.:i1.DeleteKillTab
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=149.Delete:elink. will kill entire tabs instead of converting them to spaces. 
:h3 id=54.BackSpUnindents
:lm margin=1.:i1.BackSpUnindents
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=148.BackSpace:elink. will unindent to previous indentation level if issued on beginning of
line. 
:h3 id=55.SpaceTabs
:lm margin=1.:i1.SpaceTabs
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=165.InsertTab:elink. command will insert spaces instead of tabs. 
:h3 id=56.IndentWithTabs
:lm margin=1.:i1.IndentWithTabs
:p.{0,1} 
:p.If set to 1, indentation will be done using tabs instead of spaces. 
:h3 id=57.WordWrap
:lm margin=1.:i1.WordWrap
:p.{0,1,2} 
:p.If set to 1, editor wrap current line when right margin is reached. If
set to 2, editor will wrap current paragraph continously. Paragraphs
as recognised by :link reftype=hd refid=170.WrapPara:elink. command must be separated by blank lines. 
:h3 id=58.LeftMargin
:lm margin=1.:i1.LeftMargin
:p.{1-xx} 
:p.Left margin for word wrap (:link reftype=hd refid=170.WrapPara:elink. command). 
:h3 id=59.RightMargin
:lm margin=1.:i1.RightMargin
:p.{1-xx} 
:p.Right margin for word wrap (:link reftype=hd refid=170.WrapPara:elink. command). 
:h3 id=60.Trim
:lm margin=1.:i1.Trim
:p.{0,1} 
:p.If set to 1, spaces on the end of line will be trimmed when editing. 
:h3 id=61.ShowMarkers
:lm margin=1.:i1.ShowMarkers
:p.{0,1} 
:p.If set to 1, end of line and end of file markers will be shown. 
:h3 id=62.CursorTroughTabs
:lm margin=1.:i1.CursorTroughTabs
:p.{0,1} 
:p.If set to 1, editor will allow cursor to be positioned inside tabs. 
:h3 id=63.DefFindOpt
:lm margin=1.:i1.DefFindOpt
:p.'options' 
:p.Default :link reftype=hd refid=335.search options:elink. for :link reftype=hd refid=320.Find:elink. command. 
:h3 id=64.DefFindReplaceOpt
:lm margin=1.:i1.DefFindReplaceOpt
:p.'options' 
:p.Default :link reftype=hd refid=335.search/replace:elink. options for :hp2.FindReplace:ehp2. command. 
:h3 id=65.SaveFolds
:lm margin=1.:i1.SaveFolds
:p.{0,1,2} 
:p.If 0, folds are not saved. If 1, folds are saved at beginning of line,
if 2 folds are saved at end of line. 
:p.Folds are saved as comments in source files, depending on active
editing mode. 
:p.See mode settings :link reftype=hd refid=66.CommentStart:elink. and :link reftype=hd refid=68.CommentEnd:elink. for configuration of fold comments. 
:h3 id=66.CommentStart
:lm margin=1.:i1.CommentStart
:p."comment-start-string" 
:p.String that starts comments (for saving folds) 
:h3 id=67.CommentEnd
:lm margin=1.:i1.CommentEnd
:p."comment-end-string" 
:p.String that ends comments 
:h3 id=68.AutoHilitParen
:lm margin=1.:i1.AutoHilitParen
:p.{0,1} 
:p.If set to :hp2.1:ehp2., editor will automatically highlight the matching bracket if it is
visible on screen. This is equivalent to executing :link reftype=hd refid=243.HilitMatchBracket:elink. command. 
:h3 id=69.Abbreviations
:lm margin=1.:i1.Abbreviations
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=80.abbreviation:elink. expansion will be active in this mode. 
:h3 id=70.BackSpKillBlock
:lm margin=1.:i1.BackSpKillBlock
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=148.BackSpace:elink. command will delete block if it is marked, otherwise it will delete
the previous character. 
:h3 id=71.DeleteKillBlock
:lm margin=1.:i1.DeleteKillBlock
:p.{0,1} 
:p.If set to 1, :link reftype=hd refid=149.Delete:elink. command will delete block if marked, instead of deleting the
character below cursor. 
:h3 id=72.PersistentBlocks
:lm margin=1.:i1.PersistentBlocks
:p.{0,1} 
:p.If set to 1, blocks will stay marked even if cursor is moved in the
file, if set to 0, block is unmarked as soon as the cursor is moved. 
:h3 id=73.InsertKillBlock
:lm margin=1.:i1.InsertKillBlock
:p.{0,1} 
:p.If set to 1, the marked block is deleted when a new character is
typed. 
:h3 id=74.FileNameRx
:lm margin=1.:i1.FileNameRx
:p."regexp" 
:p.Must be set to regexp that matches names of files that should be
edited in this mode. Has priority over :link reftype=hd refid=75.FirstLineRx:elink. 
:h3 id=75.FirstLineRx
:lm margin=1.:i1.FirstLineRx
:p."regexp" 
:p.Must be set to regex that matches the first line of files that should
be edited in this mode. This is checked only if no :link reftype=hd refid=74.FileNameRx:elink. matches the filename. 
.br

:h2 id=76.Loading files in various formats
:lm margin=1.:i1.Loading files in various formats
:p.
:p.Here are settings for loading files in various formats&colon. 
:p.:dl compact tsize=10 break=all. 
:dt.DOS/Win/OS2/NT text files (CR/LF delimited)&colon. 
:dd.:xmp.
          StripChar      13
          LineChar       10
          AddCR          1
          AddLF          1
:exmp.
.br

:dt.Unix text files (LF delimited)&colon. 
:dd.:xmp.
          StripChar      -1
          LineChar       10
          AddCR          0
          AddLF          1
:exmp.
:dt.MAC text files (CR delimited)&colon. 
:dd.:xmp.
          StripChar      -1
          LineChar       13
          AddCR          1
          AddLF          0
:exmp.
:dt.Binary files (fixed record length)&colon. 
:dd.:xmp.
          StripChar      -1
          LineChar       -1
          AddCR          0
          AddLF          0
          LoadMargin     64
          ForceNewLine   0
:exmp.:edl.
.br

:h2 id=77.Configuration of Tab options
:lm margin=1.:i1.Configuration of Tab options
:p.
.br

:h1 id=78.EventMap configuration
:lm margin=1.:i1.EventMap configuration
:p.eventmap section is used to bind editor commands to user events. 
:h2 id=79.Keybindings
:lm margin=1.:i1.Keybindings
:p.
:p.Keybindings are inherited from parent modes unless overriden. 
:p.Here are some examples of key specifiactions&colon. :dl compact tsize=10 break=all. 
:dt.[A]
:dd.Uppercase a 
:dt.[a]
:dd.Lowercase a 
:dt.[;]
:dd.Semicolon 
:dt.[A+A]
:dd.Alt+A 
:dt.[C+B]
:dd.Ctrl+B 
:dt.[A+C+F1]
:dd.Alt+Ctrl+F1 
:dt.[A+C+S+F1]
:dd.Alt+Ctrl+Shift+F1 
:dt.[A+Space]
:dd.Alt+Space 
:dt.[C+K_C+B]
:dd.Ctrl+K and then Ctrl+B (two keys) 
:dt.[C+A_C+B_C+C]
:dd.Ctrl+A Ctrl+B Ctrl+C must be pressed in sequence. 
:dt.[G+-]
:dd.Gray - 
:dt.[G++]
:dd.Gray + 
:dt.[C-S-X]
:dd.X, ignore the state of Ctrl and Shift keys. 
:dt.[C+\\]
:dd.Ctrl+Backslash 
:dt.[C+\[]
:dd.Ctrl+[ 
:dt.[C+G-Left]
:dd.Ctrl+Left, ignore difference between the two Left keys. 
:dt.[C+A-A]
:dd.Ctrl+A, ignore the state of Alt key. :edl.
:p.The following special keys are available (case sensitive)&colon. 
:p.:hp2.F1-F12 Home End PgUp PgDn Insert Delete Up Down Left Right Enter Esc
BackSp Space Tab Center:ehp2. 
:p.Keyname can be preceeded by modifiers :hp2.(A, C, G, S):ehp2.. If modifier is followed by a :hp2.+:ehp2. (plus), the modifier key must be pressed to match the key
specification. If the modifier key is followed by :hp2.-:ehp2. (minus), the state of the modifier key is ignored. 
:p.Multiple-key combinations can be specified by separating them with :hp2._:ehp2. (underline) 
:p.Keys are bound using the :hp2.key:ehp2. command&colon. 
:p.:hp2.key:ehp2. :hp2.[keyspec]:ehp2. { :link reftype=hd refid=90.editor commands:elink. } 
:p.ASCII characters >= 32 are bound to TypeChar by default. 
:p.Any number of commands can be bound to a key combination or menu item.
They are executed in sequence until one of them fails. 
:p.See :hp1.ui_fte.fte:ehp1. configuration file for examples and default configuration. 
:h2 id=80.Abbreviations
:lm margin=1.:i1.Abbreviations
:p.Abbreviations are used to automatically replace some text or run an
editor macro when some word is typed in. When a non-word character is
entered, the previous word is searched for in the list of
abbreviations. When it is found, it is either replaced with a new
string or a macro is executed. 
:p.Syntax&colon. :xmp.
abbrev 'old-word' 'new-string'

abbrev 'old-word' { Macro }
:exmp.
:p.Some examples of abbreviations&colon. :xmp.
    abbrev 'wcsw' 'WinCreateStdWindow';
    
    abbrev 'ifx' {
        KillWordPrev; InsertString 'if () {'; LineIndent; LineNew; 
        InsertString '}'; LineIndent; 
        MoveUp; MoveLineEnd; 3&colon.MoveLeft; 
        Fail; # do not insert typed character
    }
:exmp.
:p.The first one defines a replacement string, while the second one
defines an editor macro to be run. 
:p.For abbreviations to work, setting :link reftype=hd refid=71.Abbreviations:elink. must be set to 1 for active mode. 
:h2 id=81.EventMap Settings
:lm margin=1.:i1.EventMap Settings
:p.
:h3 id=82.MainMenu
:lm margin=1.:i1.MainMenu
:p."menu" 
:p.Main menu displayed when editing in this mode. 
:h3 id=83.LocalMenu
:lm margin=1.:i1.LocalMenu
:p."menu" 
:p.Local menu used when editing in this mode. 
.br

:h1 id=84.Colorizer Configuration
:lm margin=1.:i1.Colorizer Configuration
:p.Configuration of syntax highlighting modes. Syntax&colon. :xmp.
colorize <mode>[&colon.<parent>] { <settings> }
:exmp.
:h2 id=85.Settings
:lm margin=1.:i1.Settings
:p.
:h3 id=86.SyntaxParser
:lm margin=1.:i1.SyntaxParser
:p.{PLAIN,C,HTML,MAKE,REXX,DIFF,IPF,PERL,MERGE,Ada,...} 
:p.Activates the specified syntax parser for colorization mode. :hp2.PLAIN:ehp2. specifies no syntax parser, only keyword highlighting is available. 
:p.Currently only pre-programmed syntax parsers are available, new ones
can not be defined. 
:h2 id=87.Keywords
:lm margin=1.:i1.Keywords
:p.Syntax&colon. :xmp.
keyword <color-specifier> { list of keywords }
:exmp.Multiple keyword sets with different colors can be defined. 
:p.'-' can be used for color specifier do use the default keyword color
specified in global settings. 
:h2 id=88.Colors
:lm margin=1.:i1.Colors
:p.Syntax&colon. :xmp.
color { list-of color-name,color-spec pairs }
:exmp.Color settings are inherited from parent mode. 
:p.The following color-names are available, which ones will actually be
used depends on the SyntaxParser setting used&colon. :ul compact. 
:li.... :eul.
.br

:h1 id=89.Status Line
:lm margin=1.:i1.Status Line
:p.
:p.Status line displays the following status information&colon. 
:p.:hp2.position|flags|mode|curchar|mod? filename|winno:ehp2. 
:p.:hp2.position:ehp2. = line&colon.column 
:p.:hp2.flags:ehp2. :dl compact tsize=10 break=all. 
:dt.I
:dd.Insert 
:dt.A
:dd.Autoindent 
:dt.C
:dd.Matches are case sensitive 
:dt.SLC
:dd.Stream, Line, Column block-mode 
:dt.wW
:dd.Automatic word wrap active (w = line, W = paragraph). :edl.
:p.:hp2.mode:ehp2. = Mode name as specified in configuration file 
:p.:hp2.curchar:ehp2. = Decimal ASCII code of character under cursor, or EOL/EOF 
:p.:hp2.mod?:ehp2. = :hp2.*:ehp2. if file was modified, :hp2.%:ehp2. if file is read-only 
.br

:h1 id=90.Editor Commands
:lm margin=1.:i1.Editor Commands
:p.
:p.These commands can be bound to keys in configuration file&colon. 
.br

:h2 id=91.Cursor Movement
:lm margin=1.:i1.Cursor Movement
:p.
:h3 id=92.MoveLeft
:lm margin=1.:i1.MoveLeft
:p.Moves cursor left one character. Stops at first column. 
:h3 id=93.MoveRight
:lm margin=1.:i1.MoveRight
:p.Move cursor right one character. Does not stop at the end of line. 
:h3 id=94.MoveUp
:lm margin=1.:i1.MoveUp
:p.Moves cursor up one line. 
:h3 id=95.MoveDown
:lm margin=1.:i1.MoveDown
:p.Moves cursor down one line 
:h3 id=96.MovePrev
:lm margin=1.:i1.MovePrev
:p.Moves cursor to previous character. When the start of line is reached,
wraps to end of previous line. 
:h3 id=97.MoveNext
:lm margin=1.:i1.MoveNext
:p.Move cursor to next character. Then the end of line is reached, wraps
to the beginning of the next line. 
:h3 id=98.MoveWordLeft
:lm margin=1.:i1.MoveWordLeft
:p.Moves cursor one word left. Stops at the start of line. 
:h3 id=99.MoveWordRight
:lm margin=1.:i1.MoveWordRight
:p.Moves cursor one word right. Stops at the end of line. 
:h3 id=100.MoveWordPrev
:lm margin=1.:i1.MoveWordPrev
:p.Moves cursor to start of previous word. When the start of line is
reached, wraps to the end of previous line. 
:h3 id=101.MoveWordNext
:lm margin=1.:i1.MoveWordNext
:p.Moves cursor to start of next word. When the end of line is reached,
wraps to the start of next line. 
:h3 id=102.MoveLineStart
:lm margin=1.:i1.MoveLineStart
:p.Moves cursor to beginning of line 
:h3 id=103.MoveLineEnd
:lm margin=1.:i1.MoveLineEnd
:p.Moves cursor to end of line. 
:h3 id=104.MovePageUp
:lm margin=1.:i1.MovePageUp
:p.Move cursor to previous page. 
:h3 id=105.MovePageDown
:lm margin=1.:i1.MovePageDown
:p.Moves cursor to next page. 
:h3 id=106.MovePageLeft
:lm margin=1.:i1.MovePageLeft
:p.Moves cursor one page to the left. 
:h3 id=107.MovePageRight
:lm margin=1.:i1.MovePageRight
:p.Moves cursor one page to the right. 
:h3 id=108.MovePageStart
:lm margin=1.:i1.MovePageStart
:p.Moves cursor to the top of the page. 
:h3 id=109.MovePageEnd
:lm margin=1.:i1.MovePageEnd
:p.Moves cursor to the bottom of the page. 
:h3 id=110.MoveFileStart
:lm margin=1.:i1.MoveFileStart
:p.Moves cursor to the start of buffer. 
:h3 id=111.MoveFileEnd
:lm margin=1.:i1.MoveFileEnd
:p.Moves cursor to end of buffer. 
:h3 id=112.MoveBlockStart
:lm margin=1.:i1.MoveBlockStart
:p.Moves cursor to the start of block. 
:h3 id=113.MoveBlockEnd
:lm margin=1.:i1.MoveBlockEnd
:p.Moves cursor to the end of block. 
:h3 id=114.ScrollLeft
:lm margin=1.:i1.ScrollLeft
:p.Scroll screen left 8 characters 
:h3 id=115.ScrollRight
:lm margin=1.:i1.ScrollRight
:p.Scroll screen right 8 characters 
:h3 id=116.ScrollDown
:lm margin=1.:i1.ScrollDown
:p.Scroll screen down 1 line 
:h3 id=117.ScrollUp
:lm margin=1.:i1.ScrollUp
:p.Scroll screen up 1 line 
:h3 id=118.MoveFirstNonWhite
:lm margin=1.:i1.MoveFirstNonWhite
:p.Moves cursor to first non whitespace character on line. 
:h3 id=119.MoveLastNonWhite
:lm margin=1.:i1.MoveLastNonWhite
:p.Moves cursor after last non whitespace character on line. 
:h3 id=120.MovePrevEqualIndent
:lm margin=1.:i1.MovePrevEqualIndent
:p.Moves cursor to first line above the cursor with indentation equal to
current line. 
:h3 id=121.MoveNextEqualIndent
:lm margin=1.:i1.MoveNextEqualIndent
:p.Moves cursor to first line below the cursor with indentation equal to
current. 
:h3 id=122.MovePrevTab
:lm margin=1.:i1.MovePrevTab
:p.Moves cursor to previous tab stop. 
:h3 id=123.MoveNextTab
:lm margin=1.:i1.MoveNextTab
:p.Moves cursor to next tab stop. 
:h3 id=124.MovePrevPos
:lm margin=1.:i1.MovePrevPos
:p.Moves cursor to previous cursor position. 
:h3 id=125.SavePos
:lm margin=1.:i1.SavePos
:p.Saves current cursor position. 
:h3 id=126.MoveSavedPos
:lm margin=1.:i1.MoveSavedPos
:p.Moves cursor to saved position. 
:h3 id=127.MoveSavedPosCol
:lm margin=1.:i1.MoveSavedPosCol
:p.Moves cursor to saved position column without leaving the current
line. 
:h3 id=128.MoveSavedPosRow
:lm margin=1.:i1.MoveSavedPosRow
:p.Moves cursor to saved position line without leaving the current
column. 
:h3 id=129.MoveLineTop
:lm margin=1.:i1.MoveLineTop
:p.Reposition current line to top of window. 
:h3 id=130.MoveLineCenter
:lm margin=1.:i1.MoveLineCenter
:p.Reposition current line to center of window. 
:h3 id=131.MoveLineBottom
:lm margin=1.:i1.MoveLineBottom
:p.Reposition current line to bottom of window. 
:h3 id=132.MoveTabStart
:lm margin=1.:i1.MoveTabStart
:p.When inside of tab character, move cursor to start of tab. 
:h3 id=133.MoveTabEnd
:lm margin=1.:i1.MoveTabEnd
:p.When inside of tab character, move cursor to end of tab. 
:h3 id=134.MoveFoldTop
:lm margin=1.:i1.MoveFoldTop
:p.Move to the top of current fold. 
:h3 id=135.MoveFoldPrev
:lm margin=1.:i1.MoveFoldPrev
:p.Move to the top of previous fold. 
:h3 id=136.MoveFoldNext
:lm margin=1.:i1.MoveFoldNext
:p.Move to the top of next fold. 
.br

:h2 id=137.Text deleting
:lm margin=1.:i1.Text deleting
:p.Commands for deleting text in buffer. 
:h3 id=138.KillLine
:lm margin=1.:i1.KillLine
:p.Delete current line. If we are on the last line of file, only the line
contents is deleted. 
:h3 id=139.KillChar
:lm margin=1.:i1.KillChar
:p.Delete character under cursor. 
:h3 id=140.KillCharPrev
:lm margin=1.:i1.KillCharPrev
:p.Delete character before cursor. 
:h3 id=141.KillWord
:lm margin=1.:i1.KillWord
:p.Delete next word. 
:h3 id=142.KillWordPrev
:lm margin=1.:i1.KillWordPrev
:p.Delete previous word. 
:h3 id=143.KillToLineStart
:lm margin=1.:i1.KillToLineStart
:p.Delete text to line start. 
:h3 id=144.KillToLineEnd
:lm margin=1.:i1.KillToLineEnd
:p.Delete text to line end. 
:h3 id=145.KillBlock
:lm margin=1.:i1.KillBlock
:p.Kill text in block. 
:h3 id=146.KillBlockOrChar
:lm margin=1.:i1.KillBlockOrChar
:p.Kill block if marked, otherwise kill char under cursor. 
:h3 id=147.KillBlockOrCharPreV
:lm margin=1.:i1.KillBlockOrCharPreV
:p.Kill block if marked, otherwise kill char before cursor. 
:h3 id=148.BackSpace
:lm margin=1.:i1.BackSpace
:p.Delete character before cursor. 
:p.Can be configured with the following mode settings&colon. :ul compact. 
:li.WordWrap 
:li.BackSpUnindents 
:li.BackSpKillTab 
:li.Trim :eul.
:h3 id=149.Delete
:lm margin=1.:i1.Delete
:p.Delete character under cursor (configurable). 
:p.Can be configured with the following mode settings :ul compact. 
:li.DeleteKillTab 
:li.WordWrap 
:li.Trim :eul.
.br

:h2 id=150.Line commands
:lm margin=1.:i1.Line commands
:p.Text line operations. 
:h3 id=151.LineInsert
:lm margin=1.:i1.LineInsert
:p.Insert empty line before current line. 
:h3 id=152.LineAdd
:lm margin=1.:i1.LineAdd
:p.Add line after current. 
:h3 id=153.LineSplit
:lm margin=1.:i1.LineSplit
:p.Split line at current cursor position. 
:h3 id=154.LineJoin
:lm margin=1.:i1.LineJoin
:p.Join line with next one. 
:h3 id=155.LineNew
:lm margin=1.:i1.LineNew
:p.Add new line after current one, move to next line and indent
(indentation depends on currently active indentation mode). 
:h3 id=156.LineIndent
:lm margin=1.:i1.LineIndent
:p.Reindent current line. The behaviour depends on currenty active
indentation mode. 
:p.In PLAIN mode, reindent the line to the same level as previous line. 
:h3 id=157.LineTrim
:lm margin=1.:i1.LineTrim
:p.Trim spaces at the end of current line 
:h3 id=158.LineDuplicate
:lm margin=1.:i1.LineDuplicate
:p.Duplicate current line. 
.br

:h2 id=159.Text insertion
:lm margin=1.:i1.Text insertion
:p.Text insertion commands. 
:h3 id=160.InsertString
:lm margin=1.:i1.InsertString
:p.Insert string given as argument. 
:h3 id=161.InsertChar
:lm margin=1.:i1.InsertChar
:p.Insert character with ASCII code given as argument. Does not check for
possible abbreviations. 
:h3 id=162.InsertSpace
:lm margin=1.:i1.InsertSpace
:p.Insert Space character (ASCII 32) 
:h3 id=163.TypeChar
:lm margin=1.:i1.TypeChar
:p.Insert character with ASCII code given as argument. Checks for
possible abbreviations and performs the expansion. 
:h3 id=164.SelfInsert
:lm margin=1.:i1.SelfInsert
:p.Insert character defined by last key. 
:h3 id=165.InsertTab
:lm margin=1.:i1.InsertTab
:p.Insert Tab character (ASCII 9) 
:h3 id=166.InsertSpacesToTab
:lm margin=1.:i1.InsertSpacesToTab
:p.Insert Space characters to next tab stop, simulating a tab. 
:h3 id=167.InsPrevLineChar
:lm margin=1.:i1.InsPrevLineChar
:p.Insert character above current character. 
:h3 id=168.InsPrevLineToEol
:lm margin=1.:i1.InsPrevLineToEol
:p.Insert previous line from current column to end of line. 
:h3 id=169.CompleteWord
:lm margin=1.:i1.CompleteWord
:p.Complete word with previous occurance of the word in the file. 
:h3 id=170.WrapPara
:lm margin=1.:i1.WrapPara
:p.Word wrap paragraph (paragraphs are separated by blank lines). 
.br

:h2 id=171.Blocks
:lm margin=1.:i1.Blocks
:p.Block manipulation commands. 
:h3 id=172.BlockBegin
:lm margin=1.:i1.BlockBegin
:p.Set block beginning to current position. 
:h3 id=173.BlockEnd
:lm margin=1.:i1.BlockEnd
:p.Set block end to current position. 
:h3 id=174.BlockUnmark
:lm margin=1.:i1.BlockUnmark
:p.Unmark selected block. 
:h3 id=175.BlockCut
:lm margin=1.:i1.BlockCut
:p.Cut selected block to clipboard. 
:h3 id=176.BlockCutAppend
:lm margin=1.:i1.BlockCutAppend
:p.Cut selected block and append it to clipboard. 
:h3 id=177.BlockCopy
:lm margin=1.:i1.BlockCopy
:p.Copy selected block to clipboard. 
:h3 id=178.BlockCopyAppend
:lm margin=1.:i1.BlockCopyAppend
:p.Append selected block to clipboard. 
:h3 id=179.BlockPaste
:lm margin=1.:i1.BlockPaste
:p.Paste clipboard to current position. 
:h3 id=180.BlockPasteStream
:lm margin=1.:i1.BlockPasteStream
:p.Paste clipboard to current position as stream block. 
:h3 id=181.BlockPasteLine
:lm margin=1.:i1.BlockPasteLine
:p.Paste clipboard to current position as line block. 
:h3 id=182.BlockPasteColumn
:lm margin=1.:i1.BlockPasteColumn
:p.Paste clipboard to current position as column block. 
:h3 id=183.BlockKill
:lm margin=1.:i1.BlockKill
:p.Delete selected text. 
:h3 id=184.BlockIndent
:lm margin=1.:i1.BlockIndent
:p.Indent block by 1 character. 
:h3 id=185.BlockUnindent
:lm margin=1.:i1.BlockUnindent
:p.Unindent block by 1 character. 
:h3 id=186.BlockMarkStream
:lm margin=1.:i1.BlockMarkStream
:p.Start/stop marking stream block. 
:h3 id=187.BlockMarkLine
:lm margin=1.:i1.BlockMarkLine
:p.Start/stop marking line block. 
:h3 id=188.BlockMarkColumn
:lm margin=1.:i1.BlockMarkColumn
:p.Start/stop marking column block. 
:h3 id=189.BlockExtendBegin
:lm margin=1.:i1.BlockExtendBegin
:p.Start extending selected block. 
:h3 id=190.BlockExtendEnd
:lm margin=1.:i1.BlockExtendEnd
:p.Stop extending selected block. 
:h3 id=191.BlockReIndent
:lm margin=1.:i1.BlockReIndent
:p.Reindent entire block (C/REXX mode) 
:h3 id=192.BlockRead
:lm margin=1.:i1.BlockRead
:p.Read block from file. 
:h3 id=193.BlockWrite
:lm margin=1.:i1.BlockWrite
:p.Write marked block to file. 
:h3 id=194.BlockPrint
:lm margin=1.:i1.BlockPrint
:p.Print a block to configured device. 
:h3 id=195.BlockSelectLine
:lm margin=1.:i1.BlockSelectLine
:p.Select current line as block. 
:h3 id=196.BlockSelectWord
:lm margin=1.:i1.BlockSelectWord
:p.Select word under cursor as word. 
:h3 id=197.BlockSort
:lm margin=1.:i1.BlockSort
:p.Sorts the marked block in ascending order. 
:p.If mode setting MatchCase is set, characters will be compared case
sensitively. 
:p.When block is marked in :link reftype=hd refid=186.Stream:elink. or :link reftype=hd refid=187.Line:elink. mode, the entire lines in marked block will be compared. 
:p.When block is marked in :link reftype=hd refid=188.Column:elink. mode, only characters within marked columns will be compared. 
:h3 id=198.BlockSortReverse
:lm margin=1.:i1.BlockSortReverse
:p.Sorts the marked block in descending order. See :link reftype=hd refid=198.BlockSort:elink. for more information. 
.br

:h2 id=199.File commands
:lm margin=1.:i1.File commands
:p.
:h3 id=200.FileSave
:lm margin=1.:i1.FileSave
:p.Save current file. 
:h3 id=201.FileSaveAll
:lm margin=1.:i1.FileSaveAll
:p.Save all loaded files. 
:h3 id=202.FileSaveAs
:lm margin=1.:i1.FileSaveAs
:p.Save current file under a new name, changing the name of loaded file. 
:h3 id=203.FileWriteTo
:lm margin=1.:i1.FileWriteTo
:p.Save current file under a new name, without changing name of loaded
file. 
:h3 id=204.FileClose
:lm margin=1.:i1.FileClose
:p.Close current file. 
:h3 id=205.FileCloseAll
:lm margin=1.:i1.FileCloseAll
:p.Close all files. 
:h3 id=206.FileOpen
:lm margin=1.:i1.FileOpen
:p.Open a file given as argument. If no argument is given for command,
prompt user to enter a filename. 
:h3 id=207.FileOpenInMode
:lm margin=1.:i1.FileOpenInMode
:p.Load a file in a specified mode. 
:h3 id=208.FileReload
:lm margin=1.:i1.FileReload
:p.Reload current file. 
:h3 id=209.FileNext
:lm margin=1.:i1.FileNext
:p.Select next file in buffer ring. 
:h3 id=210.FilePrev
:lm margin=1.:i1.FilePrev
:p.Select previous file in buffer ring. 
:h3 id=211.FileLast
:lm margin=1.:i1.FileLast
:p.Select previously active file. Used to switch between two last used
files. 
.br

:h2 id=212.Window commands
:lm margin=1.:i1.Window commands
:p.Window commands. 
:h3 id=213.WinHSplit
:lm margin=1.:i1.WinHSplit
:p.Split window horizontally. 
:h3 id=214.WinNext
:lm margin=1.:i1.WinNext
:p.Activate next window. 
:h3 id=215.WinPrev
:lm margin=1.:i1.WinPrev
:p.Activate previous window. 
:h3 id=216.WinZoom
:lm margin=1.:i1.WinZoom
:p.Make current window the only one (close all others). 
:h3 id=217.WinRefresh
:lm margin=1.:i1.WinRefresh
:p.Repaint entire screen. 
:h3 id=218.WinResize
:lm margin=1.:i1.WinResize
:p.Resize window (takes integer argument, -x = smaller, +x = bigger). 
:h3 id=219.WinClose
:lm margin=1.:i1.WinClose
:p.Close current window. 
.br

:h2 id=220.Undo/Redo
:lm margin=1.:i1.Undo/Redo
:p.Undo commands. 
:h3 id=221.Undo
:lm margin=1.:i1.Undo
:p.Undo last operation. 
:h3 id=222.Redo
:lm margin=1.:i1.Redo
:p.Redo last undone operation. 
.br

:h2 id=223.Character translation
:lm margin=1.:i1.Character translation
:p.Character translation commands. 
:h3 id=224.CharCaseUp
:lm margin=1.:i1.CharCaseUp
:p.Convert current character to uppercase 
:h3 id=225.CharCaseDown
:lm margin=1.:i1.CharCaseDown
:p.Convert current character to lowercase 
:h3 id=226.CharCaseToggle
:lm margin=1.:i1.CharCaseToggle
:p.Toggle case of current characters 
:h3 id=227.CharTrans
:lm margin=1.:i1.CharTrans
:p.Translate current character as specified by two arguments. 
:p.Examples&colon. :xmp.
    CharTrans 'A-Za-z' 'a-zA-Z'
    CharTrans 'A-D' 'DCBA'
:exmp.
:h3 id=228.LineCaseUp
:lm margin=1.:i1.LineCaseUp
:p.Convert characters on current line to uppercase 
:h3 id=229.LineCaseDown
:lm margin=1.:i1.LineCaseDown
:p.Convert characters on current line to lowercase 
:h3 id=230.LineCaseToggle
:lm margin=1.:i1.LineCaseToggle
:p.Toggle case of characters on current line 
:h3 id=231.LineTrans
:lm margin=1.:i1.LineTrans
:p.Translate characters on current line as specified by two arguments. 
:h3 id=232.BlockCaseUp
:lm margin=1.:i1.BlockCaseUp
:p.Convert characters in selected block to uppercase 
:h3 id=233.BlockCaseDown
:lm margin=1.:i1.BlockCaseDown
:p.Convert characters in selected block to lowercase 
:h3 id=234.BlockCaseToggle
:lm margin=1.:i1.BlockCaseToggle
:p.Toggle case of characters in selected block 
:h3 id=235.BlockTrans
:lm margin=1.:i1.BlockTrans
:p.Translate characters in block as specified by two arguments. 
.br

:h2 id=236.Searching
:lm margin=1.:i1.Searching
:p.Search/Replace commands. 
:h3 id=237.Find
:lm margin=1.:i1.Find
:p.Search for text, w/options 
:h3 id=238.FindReplace
:lm margin=1.:i1.FindReplace
:p.Search and replace text w/options. 
:h3 id=239.FindRepeat
:lm margin=1.:i1.FindRepeat
:p.Repeat last search/replace operation 
:h3 id=240.FindRepeatReverse
:lm margin=1.:i1.FindRepeatReverse
:p.Repeat last search/replace operation in opposite direction 
:h3 id=241.FindRepeatOnce
:lm margin=1.:i1.FindRepeatOnce
:p.Repeat last search/replace operation only once. 
:h3 id=242.MatchBracket
:lm margin=1.:i1.MatchBracket
:p.Search for matching bracket 
:h3 id=243.HilitMatchBracket
:lm margin=1.:i1.HilitMatchBracket
:p.Show matching bracket highlited if visible in window. 
:h3 id=244.IncrementalSearch
:lm margin=1.:i1.IncrementalSearch
:p.Search incrementally for text. 
:h3 id=245.SearchWordPrev
:lm margin=1.:i1.SearchWordPrev
:p.Search for previous occurance of word under cursor. 
:h3 id=246.SearchWordNext
:lm margin=1.:i1.SearchWordNext
:p.Search for next occurance of word under cursor. 
:h3 id=247.Search
:lm margin=1.:i1.Search
:p.Search for text 
:h3 id=248.SearchB
:lm margin=1.:i1.SearchB
:p.Search for text backwards 
:h3 id=249.SearchRx
:lm margin=1.:i1.SearchRx
:p.Search for regexp 
:h3 id=250.SearchReplaceRx
:lm margin=1.:i1.SearchReplaceRx
:p.Search and replace using regexp 
:h3 id=251.SearchAgain
:lm margin=1.:i1.SearchAgain
:p.Search for text again 
:h3 id=252.SearchAgainB
:lm margin=1.:i1.SearchAgainB
:p.Search for text again backwards 
:h3 id=253.SearchReplace
:lm margin=1.:i1.SearchReplace
:p.Search for text and replace 
:h3 id=254.SearchReplaceB
:lm margin=1.:i1.SearchReplaceB
:p.Search and replace backwards 
.br

:h2 id=255.Folding
:lm margin=1.:i1.Folding
:p.Folding commands. 
:h3 id=256.FoldCreate
:lm margin=1.:i1.FoldCreate
:p.Create fold 
:h3 id=257.FoldCreateByRegexp
:lm margin=1.:i1.FoldCreateByRegexp
:p.Create folds at lines matching regexp. 
:h3 id=258.FoldDestroy
:lm margin=1.:i1.FoldDestroy
:p.Destroy fold at current line. 
:h3 id=259.FoldDestroyAll
:lm margin=1.:i1.FoldDestroyAll
:p.Destroy all folds in file. 
:h3 id=260.FoldOpen
:lm margin=1.:i1.FoldOpen
:p.Open fold at current line. 
:h3 id=261.FoldOpenAll
:lm margin=1.:i1.FoldOpenAll
:p.Open all folds in file. 
:h3 id=262.FoldOpenNested
:lm margin=1.:i1.FoldOpenNested
:p.Open current fold and all nested folds 
:h3 id=263.FoldClose
:lm margin=1.:i1.FoldClose
:p.Close current fold 
:h3 id=264.FoldCloseAll
:lm margin=1.:i1.FoldCloseAll
:p.Close all folds in file 
:h3 id=265.FoldToggleOpenClose
:lm margin=1.:i1.FoldToggleOpenClose
:p.Toggle open/close fold. 
:h3 id=266.FoldPromote
:lm margin=1.:i1.FoldPromote
:p.Make fold a higher level fold 
:h3 id=267.FoldDemote
:lm margin=1.:i1.FoldDemote
:p.Make fold a lower level fold 
.br

:h2 id=268.Compile commands
:lm margin=1.:i1.Compile commands
:p.Running external tools such as compilers. 
:h3 id=269.Compile
:lm margin=1.:i1.Compile
:p.Run compile command in background 
:h3 id=270.ViewMessages
:lm margin=1.:i1.ViewMessages
:p.View compiler output 
:h3 id=271.CompilePrevError
:lm margin=1.:i1.CompilePrevError
:p.Jump to previous compiler error 
:h3 id=272.CompileNextError
:lm margin=1.:i1.CompileNextError
:p.Jump to next compiler error 
.br

:h2 id=273.Bookmarks
:lm margin=1.:i1.Bookmarks
:p.
:h3 id=274.PlaceBookmark
:lm margin=1.:i1.PlaceBookmark
:p.Place a named bookmark at current buffer position 
:h3 id=275.GotoBookmark
:lm margin=1.:i1.GotoBookmark
:p.Goto a named bookmark in current buffer 
:h3 id=276.RemoveBookmark
:lm margin=1.:i1.RemoveBookmark
:p.Remove a named bookmark from current buffer 
.br

:h2 id=277.Settings
:lm margin=1.:i1.Settings
:p.Changing editing options. 
:h3 id=278.ToggleAutoIndent
:lm margin=1.:i1.ToggleAutoIndent
:p.Toggle automatic indentation 
:h3 id=279.ToggleInsert
:lm margin=1.:i1.ToggleInsert
:p.Toggle insert/overwrite mode 
:h3 id=280.ToggleExpandTabs
:lm margin=1.:i1.ToggleExpandTabs
:p.Toggle tab expansion on display. 
:h3 id=281.ToggleShowTabs
:lm margin=1.:i1.ToggleShowTabs
:p.Toggle tab visibility (as circles). 
:h3 id=282.ToggleUndo
:lm margin=1.:i1.ToggleUndo
:p.Toggle undo/redo information saving. 
:h3 id=283.ToggleReadOnly
:lm margin=1.:i1.ToggleReadOnly
:p.Toggle read only file. 
:h3 id=284.ToggleKeepBackups
:lm margin=1.:i1.ToggleKeepBackups
:p.Toggle backup files. 
:h3 id=285.ToggleMatchCase
:lm margin=1.:i1.ToggleMatchCase
:p.Toggle case sensitivity for searches 
:h3 id=286.ToggleBackSpKillTab
:lm margin=1.:i1.ToggleBackSpKillTab
:p.Enable/disable BackSp killing entire tabs. 
:h3 id=287.ToggleDeleteKillTab
:lm margin=1.:i1.ToggleDeleteKillTab
:p.Enable/disable Delete killing entire tabs. 
:h3 id=288.ToggleSpaceTabs
:lm margin=1.:i1.ToggleSpaceTabs
:p.Toggle insertion of spaces instead of tabs on Tab key. 
:h3 id=289.ToggleIndentWithTabs
:lm margin=1.:i1.ToggleIndentWithTabs
:p.Toggle indentation with tabs. 
:h3 id=290.ToggleBackSpUnindents
:lm margin=1.:i1.ToggleBackSpUnindents
:p.Toggle unindentation on previous indent level on BackSp. 
:h3 id=291.ToggleWordWrap
:lm margin=1.:i1.ToggleWordWrap
:p.Toggle automatic word wrap. 
:h3 id=292.ToggleTrim
:lm margin=1.:i1.ToggleTrim
:p.Toggle trimming of spaces at end of line. 
:h3 id=293.ToggleShowMarkers
:lm margin=1.:i1.ToggleShowMarkers
:p.Toggle EOL/EOF marker visibility. 
:h3 id=294.ToggleSysClipboard
:lm margin=1.:i1.ToggleSysClipboard
:p.Toggle usage of system clipboard. 
:h3 id=295.SetLeftMargin
:lm margin=1.:i1.SetLeftMargin
:p.Set left margin to current cursor column. 
:h3 id=296.SetRightMargin
:lm margin=1.:i1.SetRightMargin
:p.Set right margin to current cursor column. 
:h3 id=297.ChangeTabSize
:lm margin=1.:i1.ChangeTabSize
:p.Prompt for tab size. 
:h3 id=298.ChangeCIndent
:lm margin=1.:i1.ChangeCIndent
:p.Prompt for indentation level for CMode smart indentation. 
:h3 id=299.ChangeCBraceOfs
:lm margin=1.:i1.ChangeCBraceOfs
:p.Change brace offset for CMode smart indentation. 
:h3 id=300.ChangeREXXIndent
:lm margin=1.:i1.ChangeREXXIndent
:p.Prompt for indentation level for REXX smart indentation 
:h3 id=301.ChangeLeftMargin
:lm margin=1.:i1.ChangeLeftMargin
:p.Prompt for left margin for word wrap. 
:h3 id=302.ChangeRightMargin
:lm margin=1.:i1.ChangeRightMargin
:p.Prompt for right margin for word wrap. 
.br

:h2 id=303.Other
:lm margin=1.:i1.Other
:p.
:h3 id=304.ExitEditor
:lm margin=1.:i1.ExitEditor
:p.Close all files, save desktop and exit the editor. 
:h3 id=305.RunProgram
:lm margin=1.:i1.RunProgram
:p.Run external program in foreground. 
:h3 id=306.ViewBuffers
:lm margin=1.:i1.ViewBuffers
:p.View buffer list. 
:h3 id=307.ChangeMode
:lm margin=1.:i1.ChangeMode
:p.Activate another mode for current file. 
:h3 id=308.ShowEntryScreen
:lm margin=1.:i1.ShowEntryScreen
:p.Show saved shell screen if available. 
:h3 id=309.SwitchTo
:lm margin=1.:i1.SwitchTo
:p.Switch to buffer with a number. 
:h3 id=310.ChangeKeys
:lm margin=1.:i1.ChangeKeys
:p.Change current keymap to keymap of another mode. 
:h3 id=311.ChangeFlags
:lm margin=1.:i1.ChangeFlags
:p.Change current flags to flags of another mode. 
:h3 id=312.ShowMenu
:lm margin=1.:i1.ShowMenu
:p.Show and select from menu. 
:h3 id=313.MainMenu
:lm margin=1.:i1.MainMenu
:p.Activate menu bar. 
:h3 id=314.LocalMenu
:lm margin=1.:i1.LocalMenu
:p.Activate local popup menu. 
:h3 id=315.ASCIITable
:lm margin=1.:i1.ASCIITable
:p.Select and insert character from ASCII table. 
:h3 id=316.DesktopSave
:lm margin=1.:i1.DesktopSave
:p.Save current desktop to active desktop file. 
:h3 id=317.DesktopSaveAs
:lm margin=1.:i1.DesktopSaveAs
:p.Ask for a new desktop file and save current desktop into it. 
.br

:h1 id=318.Search and Replace
:lm margin=1.:i1.Search and Replace
:p.
:h2 id=319.Search/Replace Commands
:lm margin=1.:i1.Search/Replace Commands
:p.
:h3 id=320.Find
:lm margin=1.:i1.Find
:p.Search for text with :link reftype=hd refid=335.options:elink.. 
:h3 id=321.FindReplace
:lm margin=1.:i1.FindReplace
:p.Search and replace text w/options. 
:h3 id=322.FindRepeat
:lm margin=1.:i1.FindRepeat
:p.Repeat last search/replace operation 
:h3 id=323.FindRepeatReverse
:lm margin=1.:i1.FindRepeatReverse
:p.Repeat last search/replace operation in opposite direction 
:h3 id=324.FindRepeatOnce
:lm margin=1.:i1.FindRepeatOnce
:p.Repeat last search/replace operation only once. 
:h3 id=325.MatchBracket
:lm margin=1.:i1.MatchBracket
:p.Search for matching bracket 
:h3 id=326.IncrementalSearch
:lm margin=1.:i1.IncrementalSearch
:p.Search incrementally for text. 
:h3 id=327.Search
:lm margin=1.:i1.Search
:p.Search for text 
:h3 id=328.SearchB
:lm margin=1.:i1.SearchB
:p.Search for text backwards 
:h3 id=329.SearchRx
:lm margin=1.:i1.SearchRx
:p.Search for regexp 
:h3 id=330.SearchReplaceRx
:lm margin=1.:i1.SearchReplaceRx
:p.Search and replace using regexp 
:h3 id=331.SearchAgain
:lm margin=1.:i1.SearchAgain
:p.Search for text again 
:h3 id=332.SearchAgainB
:lm margin=1.:i1.SearchAgainB
:p.Search for text again backwards 
:h3 id=333.SearchReplace
:lm margin=1.:i1.SearchReplace
:p.Search for text and replace 
:h3 id=334.SearchReplaceB
:lm margin=1.:i1.SearchReplaceB
:p.Search and replace backwards 
:h2 id=335.Search and Replace Options
:lm margin=1.:i1.Search and Replace Options
:p.
:p.:dl compact tsize=10 break=all. 
:dt.:hp2.a:ehp2.
:dd.Search for all occurances 
:dt.:hp2.b:ehp2.
:dd.Search in block only 
:dt.:hp2.g:ehp2.
:dd.Search through entire file/block (globally). 
:dt.:hp2.i:ehp2.
:dd.Ignore case 
:dt.:hp2.r:ehp2.
:dd.Reverse search 
:dt.:hp2.x:ehp2.
:dd.Use :link reftype=hd refid=336.regular expression:elink. matching 
:dt.:hp2.d:ehp2.
:dd.Delete found line 
:dt.:hp2.j:ehp2.
:dd.Join found line 
:dt.:hp2.w:ehp2.
:dd.Search for entire words (only when 'x' not used). 
:dt.:hp2.n:ehp2.
:dd.No prompting :edl.
:p.Commands affected by :link reftype=hd refid=63.DefFindOpt:elink. mode setting&colon. :ul compact. 
:li.:hp2.Find:ehp2. :eul.
:p.Commands affected by :link reftype=hd refid=65.DefFindReplaceOpt:elink. mode setting&colon. :ul compact. 
:li.:hp2.FindReplace:ehp2. :eul.
:p.Commands affected by :hp2.MatchCase:ehp2. mode setting&colon. :ul compact. 
:li.:hp2.IncrementalSearch:ehp2. 
:li.:hp2.Search:ehp2. 
:li.:hp2.SearchB:ehp2. 
:li.:hp2.SearchRx:ehp2. 
:li.:hp2.SearchReplaceRx:ehp2. 
:li.:hp2.SearchReplace:ehp2. 
:li.:hp2.SearchReplaceB:ehp2. :eul.
:p.Commands affected by :hp2.WSStyleSearch:ehp2. mode setting&colon. :ul compact. 
:li.:hp2.Find:ehp2. 
:li.:hp2.FindReplace:ehp2. 
:li.:hp2.FindRepeat:ehp2. 
:li.:hp2.FindRepeatReverse:ehp2. 
:li.:hp2.FindRepeatOnce:ehp2. :eul.If :hp2.:link reftype=hd refid=29.WSStyleSearch:elink.:ehp2. is set to 1, search/replace string and options are entered at
separate prompts. Otherwise they must be separated by a '/' (slash)
and any slash or backslash in search/replace string must be escaped by
'\' (backslash), except when using regular expressions (double
escaping is not necessary). 
:p.For example (when WSStyleSearch is off)&colon. :xmp.
         foo/bar/agn    replace all foo with bar globally without prompting
:exmp.
.br

:h1 id=336.Regular Expressions
:lm margin=1.:i1.Regular Expressions
:p.
:p.Regular expressions are a way to specify text patterns when searching
for a text in a buffer. Regular expressions consist of normal
characters and special operator characters with a special meanings.
Operators allow you to anchor matches, match classes of characters,
match given pattern several times or match alternate patterns.
Operators can be also used to group patterns. 
:p.:hp2.Search Operators:ehp2. :dl compact tsize=10 break=all. 
:dt.:hp2.\:ehp2. 
:dd.Quotes next character. Character will lose it's special meaning. Can
also be used to match special characters. 
:dt.:hp2.\n:ehp2. 
:dd.Matches a 0x0A (LF) character. 
:dt.:hp2.\r:ehp2. 
:dd.Matches a 0x0D (CR) character. 
:dt.:hp2.\t:ehp2. 
:dd.Matches a 0x09 (TAB) character. 
:dt.:hp2.\e:ehp2. 
:dd.Matches an escape character (0x1B) 
:dt.:hp2.\s:ehp2. 
:dd.Matches whitespace (CR, LF, TAB, SPACE) characters. 
:dt.:hp2.\S:ehp2. 
:dd.Matches non-whitespace (the reverse of \s) 
:dt.:hp2.\w:ehp2. 
:dd.Matches word character [a-zA-Z0-9] 
:dt.:hp2.\W:ehp2. 
:dd.Matches non-word character 
:dt.:hp2.\d:ehp2. 
:dd.Matches a digit [0-9]. 
:dt.:hp2.\D:ehp2. 
:dd.Matches a non-digit. 
:dt.:hp2.\U:ehp2. 
:dd.Matches uppercase characters (A-Z) 
:dt.:hp2.\L:ehp2. 
:dd.Matches lowercase characters (a-z) 
:dt.:hp2.\x##:ehp2. 
:dd.Matches specified hex value (\x0A, \x0D, \x09, etc.) 
:dt.:hp2.\o###:ehp2. 
:dd.Matches specified octal value (\o000, \o015, etc.) 
:dt.:hp2.\N###:ehp2. 
:dd.Matches specified decimal value (\N000, \N013, \N009, etc.) 
:dt.:hp2.\C:ehp2. 
:dd.Starts case sensitive matching. 
:dt.:hp2.\c:ehp2. 
:dd.Starts case insensitive matching. 
:dt.:hp2.^:ehp2. 
:dd.Match a beginning of line. 
:dt.:hp2.$:ehp2. 
:dd.Match an end of line. 
:dt.:hp2..:ehp2. 
:dd.Match any character. 
:dt.:hp2.<:ehp2. 
:dd.Match beginning of word (word consists of [A-Za-z0-9]). 
:dt.:hp2.>:ehp2. 
:dd.Match end of word. 
:dt.:hp2.[ ]:ehp2. 
:dd.Specifies a class of characters ([abc123], [\]\x10], etc). 
:dt.:hp2.[ - ]:ehp2. 
:dd.Specified a range of characters ([0-9a-zA-Z_], [0-9], etc) 
:dt.:hp2.[^ ]:ehp2. 
:dd.Specifies complement class ([^a-z], [^\-], etc) 
:dt.:hp2.?:ehp2. 
:dd.Matches preceeding pattern optionally (a?bc, filename\.?, $?, etc) 
:dt.:hp2.|:ehp2. 
:dd.Matches preceeding or next pattern (a|b, c|d, abc|d). Only one
character will be used as pattern unless grouped together using {} or
(). 
:dt.:hp2.*:ehp2. 
:dd.Match zero or more occurances of preceeding pattern. Matching is
greedy and will match as much as possible. 
:dt.:hp2.+:ehp2. 
:dd.Match one or more occurances of preceeding pattern. Match is greedy. 
:dt.:hp2.@:ehp2. 
:dd.Match zero or more occurances of preceeding pattern. Matching is
non-greedy and will match as little as possible without causing the
rest of the pattern match to fail. 
:dt.:hp2.#:ehp2. 
:dd.Match one or more occurances of preceeding pattern. Matching is
non-greedy. 
:dt.:hp2.{ }:ehp2. 
:dd.Group patterns together to form complex pattern. ( {abc}, {abc}|{cde},
{abc}?, {word}?) 
:dt.:hp2.( ):ehp2. 
:dd.Group patterns together to form complex pattern. Also used to remember
the matched substring which can be used for substitution operation. Up
to 9 can be used. :edl.
:p.:hp2.Replace Operators&colon.:ehp2. :dl compact tsize=10 break=all. 
:dt.:hp2.\:ehp2. 
:dd.Causes the next character to lose it's special meaning. 
:dt.:hp2.\n:ehp2. 
:dd.Inserts a 0x0A (LF) character. 
:dt.:hp2.\r:ehp2. 
:dd.Inserts a 0x0D (CR) character. 
:dt.:hp2.\t:ehp2. 
:dd.Inserts a 0x09 (TAB) character. 
:dt.:hp2.\#:ehp2. 
:dd.Recalls stored substring from matched pattern ()'s. (\1, \2, \3, to
\9) 
:dt.:hp2.\0:ehp2. 
:dd.Recalls entire matched pattern. 
:dt.:hp2.\u:ehp2. 
:dd.Convert next character to uppercase 
:dt.:hp2.\l:ehp2. 
:dd.Convert next character to lowercase 
:dt.:hp2.\U:ehp2. 
:dd.Convert to uppercase till \E or \e 
:dt.:hp2.\L:ehp2. 
:dd.Convert to lowercase till \E or \e :edl.
.br

:h1 id=337.Performance Tips
:lm margin=1.:i1.Performance Tips
:p.If you want to achieve top performance (necessary for some text
editing tasks), here are some tips&colon. :ul compact. 
:li.Use PLAIN hilit mode 
:li.Disable Tab Expansion 
:li.Disable ShowMarkers 
:li.Disable Undo 
:li.Disable AutoHilitBracket 
:li.Disable Abbreviations. :eul.
:euserdoc.
