/* Sorteren *.PRN-bestand */

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadfuncs'
CALL SysLoadFuncs

PARSE ARG jaar
jaar=Strip(jaar)
IF jaar='' THEN DO
   jaar=Left(Date('S'),4)
   SAY 'Geen jaartal opgegeven,' jaar 'wordt standaard aangenomen.'
END
doel=jaar||'.TMP'
bron=jaar||'.PRN'
IF Stream(bron,'C','QUERY EXISTS')='' THEN DO
   SAY 'Fout: bestand' bron 'niet gevonden in' Directory()
   EXIT
END
IF Stream(doel,'C','QUERY EXISTS')<>'' THEN DO
   SAY 'Fout: bestand' doel 'bestaat al in' Directory()
   EXIT
END
CALL LineOut doel,LineIn(bron)
SAY 'Bestand' doel 'aangemaakt.'
SAY 'Bezig met inlezen van' bron||'...'
regel.=0
teller=0
totaal=0
vorige=''
DO WHILE Lines(bron)>0
   regel=Strip(LineIn(bron))
   IF regel<>'' THEN DO
      IF Left(regel,1)<>'<' THEN DO
         PARSE VAR regel symbool ',' . 
         aantal=(regel.symbool.0)+1
         regel.symbool.aantal=regel
         regel.symbool.0=aantal
         totaal=totaal+1
         IF symbool<>vorige THEN DO
            gevonden=0
            DO i=1 TO teller
               IF symbool==symbool.i THEN gevonden=i
            END i
            IF gevonden=0 THEN DO
               teller=teller+1
               symbool.teller=symbool
               vorige=symbool
            END
         END
      END
   END
END
CALL LineOut bron
symbool.0=teller
IF totaal<1 THEN DO
   SAY 'Fout:' totaal 'regels met gegevens gevonden in bestand' bron
   CALL LineOut doel
   CALL SysFileDelete doel
   EXIT
END
SAY totaal 'regels ingelezen.'
IF symbool.0<1 THEN DO
   SAY 'Fout:' regel.0 'symbolen gevonden in bestand' bron
   CALL LineOut doel
   CALL SysFileDelete doel
   EXIT
END
SAY symbool.0 'symbolen gevonden.'

SAY 'Sorteren symbolen...'
IF symbool.0>1 THEN DO  
   i=1
   DO WHILE i<symbool.0
      j=i+1
      IF symbool.i>symbool.j THEN DO
         hulp=symbool.i
         symbool.i=symbool.j
         symbool.j=hulp
         i=0
      END
      i=i+1
   END
END      

SAY 'Begin sortering:' Time()
DO i=1 TO symbool.0
   symbool=symbool.i
   SAY 'Bezig met:' symbool
   IF regel.symbool.0>1 THEN DO  
      j=1
      DO WHILE j<regel.symbool.0
         k=j+1
         IF regel.symbool.j>regel.symbool.k THEN DO
            hulp=regel.symbool.j
            regel.symbool.j=regel.symbool.k
            regel.symbool.k=hulp
            j=0
         END
         j=j+1
      END
   END      
   DO j=1 TO regel.symbool.0
      CALL LineOut doel,regel.symbool.j
   END j
END i
SAY 'Einde sortering ('||Time()||')'

CALL LineOut doel
SAY 'Bestand' doel 'aangemaakt.'

doel='2008.PRN'
temp='2008.TMP'

doel=jaar||'.TMP'
bron=jaar||'.PRN'

IF Stream(bron,'C','QUERY SIZE')<>Stream(doel,'C','QUERY SIZE') THEN DO
   SAY
   SAY 'Fout: bestand' bron 'is niet even groot als bestand' doel
   SAY
   EXIT
END
SAY 'Bestand' bron 'wordt verwijderd...'
CALL SysFileDelete bron
CALL CharOut bron,CharIn(doel,,Stream(doel,'C','QUERY SIZE'))
CALL CharOut bron
CALL CharOut doel
IF Stream(bron,'C','QUERY SIZE')<>Stream(doel,'C','QUERY SIZE') THEN DO
   SAY
   SAY 'Fout:' doel 'niet gekopieerd naar' bron
   SAY
   EXIT
END   
SAY 'Bestand' bron 'aangemaakt.'
SAY 'Bestand' doel 'wordt verwijderd...'
CALL SysFileDelete doel
SAY

EXIT
