#!/bin/ksh

export SHELL=/bin/ksh

basedir=`pwd | sed s/[A-Za-z]://g`

CC="gcc"
CXX="g++"
CFLAGS="-s -pipe -Zmt -O9 -fomit-frame-pointer -mcpu=pentium4 -march=pentium2 -ffast-math -funroll-loops"
CXXFLAGS="$CFLAGS"
#CPPFLAGS="-I$basedir/extra/include -I$basedir/libdart -I$basedir/libkva"
#LDFLAGS="-Zmt -L$basedir/extra/lib -L$basedir/libdart -L$basedir/libkva"
#LDFLAGS="-s $LFDLAGS"
#LIBS="-ldive"

freetypeconf="$basedir/extra/bin/freetype-config"
sdlconf="$basedir/extra/bin/sdl-config"
dvdnavconf="$basedir/extra/bin/dvdnav-config"

incdirs="$basedir/extra/include:$basedir/libdart:$basedir/libkva"
libdirs="$basedir/extra/lib:$basedir/libdart:$basedir/libkva"

export CC
export CFLAGS
export CXX
export CXXFLAGS
export CPPFLAGS
export LIBS
export LDFLAGS

./configure \
  --target=i686-OS/2 \
  --disable-vidix-internal \
  --disable-vidix-external \
  --enable-theora \
  --enable-runtime-cpudetection \
  --enable-cmov \
  --enable-fast-cmov \
  --disable-ssse3 \
  --disable-select \
  --enable-sdl \
  --with-sdl-config=$sdlconf \
  --disable-termcap \
  --disable-xanim \
  --with-freetype-config=$freetypeconf \
  --disable-libdvdcss-internal \
  --disable-dvdread-internal \
  --enable-dvdnav \
  --with-dvdnav-config=$dvdnavconf \
  --codecsdir=codecs \
  --language="en" \
  --with-extraincdir=$incdirs \
  --with-extralibdir=$libdirs \
  --extra-libs="-Zmt"
