{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Setup Scheduler
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_6;

{$O+}

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec, Fm_List;

Procedure SchedulerLoop;


Implementation


Procedure Display_Amount;
Begin
  if list_amount < 1 then
    begin
      writecolor(25,7,15,0,'^INS^-new ^ESC^-exit');
      writeat(2,1,11,0,replicate(14,''));
    end else
    begin
      WriteColor(25,7,15,0,'^F3^-In/Active ^INS^-new ^DEL^-delete ^ENTER^-edit ^ESC^-exit');
      Writeat(2,1,11,0,' '+int_to_str(list_amount)+' entries ');
    end;
End;

Procedure Display_Schedule;
Var tmp : String;
Begin
  If sc.inactive then writeat(45,10,15,backentry,'<Inactive>');

  If sc.freq <> Imm then
    Writeat(60,10,14,backentry,'Next: '+NextFrequency(sc.next)) else
      Writeat(60,10,14,backentry,expand(' ',19));
  Writeat(17,11,foreentry,backentry,expand(writefrequency(sc.freq,sc.day),40));

  Case Sc.Kind of
    Sc_Hatch  : Begin
                  Writeat(17,10,foreentry,backentry,'Hatch file  ');
                  If sc.aka = 0 then writeat(17,12,foreentry,backentry,expand('Aka matching',23)) else
                    Writeat(17,12,foreentry,backentry,expand(node2str(setup.address[sc.aka]),23));
                  Writeat(17,13,foreentry,backentry,expand(sc.mask,60));
                  Writeat(17,14,foreentry,backentry,expand(sc.tag,20));
                  Writeat(17,15,foreentry,backentry,expand(sc.magic,20));
                  Writeat(17,16,foreentry,backentry,expand(sc.line[1],62));
                  Writeat(17,17,foreentry,backentry,expand(sc.line[2],12));
                End;
    Sc_Report : Begin
                  Writeat(17,10,foreentry,backentry,'*C report   ');
                  If sc.aka = 0 then writeat(17,12,foreentry,backentry,expand('Aka matching',23)) else
                    Writeat(17,12,foreentry,backentry,expand(node2str(setup.address[sc.aka]),23));

                  If sc.msgto <> '' then
                    Begin
                      If Net in sc.status then
                        Writeat(17,14,foreentry,backentry,expand(sc.msgto+', '+node2str(sc.tonode),60))
                          else Writeat(17,14,foreentry,backentry,expand(sc.msgto,60));
                    End;

                  Writeattribs(17,15,79,sc.msgattr,net in sc.status); {attribs}
                  Writeat(17,16,foreentry,backentry,writeGroups(62,sc.grps));

                  If Net in sc.status then
                    tmp := ', Netmail' else tmp := ', Echomail';
                  If sc.msgbaseid <> #0 then
                    Begin
                      Case sc.msgbaseid of
                       'S' : begin
                               Writeat(17,18,foreentry,backentry,expand('Squish'+tmp,20));
                               Writeat(17,19,foreentry,backentry,expand(sc.msgbaseidstr,49));
                             end;
                       'H' : begin
                               Writeat(17,18,foreentry,backentry,expand('Hudson'+tmp,20));
                               Writeat(17,19,foreentry,backentry,expand(int_to_str(str_to_int(first(3,sc.msgbaseidstr))),4));
                               Writeat(40,19,foreentry,backentry,expand(last(length(sc.msgbaseidstr)-3,sc.msgbaseidstr),39));
                             end;
                       'F' : begin
                               Writeat(17,18,foreentry,backentry,expand('Fido'+tmp,20));
                               Writeat(17,19,foreentry,backentry,expand(sc.msgbaseidstr,49));
                             end;
                       'J' : begin
                               Writeat(17,18,foreentry,backentry,expand('Jam'+tmp,20));
                               Writeat(17,19,foreentry,backentry,expand(sc.msgbaseidstr,49));
                             end;
                       'E' : begin
                               Writeat(17,18,foreentry,backentry,expand('Ezycom'+tmp,20));
                               Writeat(17,19,foreentry,backentry,expand(int_to_str(str_to_int(first(4,sc.msgbaseidstr))),4));
                               Writeat(40,19,foreentry,backentry,expand(last(length(sc.msgbaseidstr)-4,sc.msgbaseidstr),39));
                             end;
                      End;
                    End;
                  Writeat(17,20,foreentry,backentry,int_to_str(sc.Maxsize));
                End;
    Sc_Exec   : Begin
                  Writeat(17,10,foreentry,backentry,'Exec program');
                  Writeat(17,12,foreentry,backentry,expand(sc.line[1],62));
                End;
    Sc_Post   : Begin
                  Writeat(17,10,foreentry,backentry,'Post message');
                  If sc.aka = 0 then writeat(17,12,foreentry,backentry,expand('Aka matching',23)) else
                    Writeat(17,12,foreentry,backentry,expand(node2str(setup.address[sc.aka]),23));

                  If sc.msgto <> '' then
                    Begin
                      If Net in sc.status then
                        Writeat(17,14,foreentry,backentry,expand(sc.msgto+', '+node2str(sc.tonode),60))
                          else Writeat(17,14,foreentry,backentry,expand(sc.msgto,60));
                    End;

                  Writeat(17,15,foreentry,backentry,sc.msgFrom);
                  Writeat(17,16,foreentry,backentry,sc.line[1] {subj} );
                  Writeattribs(17,17,79,sc.msgattr,net in sc.status); {attribs}
                  Writeat(17,18,foreentry,backentry,sc.line[2] {Messagetxt} );

                  If Net in sc.status then
                    tmp := ', Netmail' else tmp := ', Echomail';
                  If sc.msgbaseid <> #0 then
                    Begin
                      Case sc.msgbaseid of
                       'S' : begin
                               Writeat(17,20,foreentry,backentry,expand('Squish'+tmp,20));
                               Writeat(17,21,foreentry,backentry,expand(sc.msgbaseidstr,49));
                             end;
                       'H' : begin
                               Writeat(17,20,foreentry,backentry,expand('Hudson'+tmp,20));
                               Writeat(17,21,foreentry,backentry,expand(int_to_str(str_to_int(first(3,sc.msgbaseidstr))),4));
                               Writeat(40,21,foreentry,backentry,expand(last(length(sc.msgbaseidstr)-3,sc.msgbaseidstr),39));
                             end;
                       'F' : begin
                               Writeat(17,20,foreentry,backentry,expand('Fido'+tmp,20));
                               Writeat(17,21,foreentry,backentry,expand(sc.msgbaseidstr,49));
                             end;
                       'J' : begin
                               Writeat(17,20,foreentry,backentry,expand('Jam'+tmp,20));
                               Writeat(17,21,foreentry,backentry,expand(sc.msgbaseidstr,49));
                             end;
                       'E' : begin
                               Writeat(17,20,foreentry,backentry,expand('Ezycom'+tmp,20));
                               Writeat(17,21,foreentry,backentry,expand(int_to_str(str_to_int(first(4,sc.msgbaseidstr))),4));
                               Writeat(40,21,foreentry,backentry,expand(last(length(sc.msgbaseidstr)-4,sc.msgbaseidstr),39));
                             end;
                      End;
                    End;
                  Writeat(17,22,foreentry,backentry,int_to_Str(sc.maxsize));
                End;
  End;
End;

Procedure Write_Schedule( active:word );
Begin
  Case Sc.Kind of
    Sc_Hatch  : Begin
                  Writeat(2,10,7,0,' Type         ');
                  Writeat(2,11,7,0,' Frequency    ');
                  Writeat(2,12,7,0,' Aka          ');
                  Writeat(2,13,7,0,' Filename     ');
                  Writeat(2,14,7,0,' Area name    ');
                  Writeat(2,15,7,0,' Magic name   ');
                  Writeat(2,16,7,0,' Description  ');
                  Writeat(2,17,7,0,' Replace      ');

                  Case active of
                    1 : Begin
                          Writeat(2,10,kl4,kl5,' Type         ');
                          Writeat(1,25,7,0,expand('Which kind of schedule this is',79));
                        End;
                    2 : Begin
                          Writeat(2,11,kl4,kl5,' Frequency    ');
                          Writeat(1,25,7,0,expand('The frequency which triggers this exception',79));
                        End;
                    3 : Begin
                          Writeat(2,12,kl4,kl5,' Aka          ');
                          Writeat(1,25,7,0,expand('The aka to use',79));
                        End;
                    4 : Begin
                          Writeat(2,13,kl4,kl5,' Filename     ');
                          Writeat(1,25,7,0,expand('The file to hatch',79));
                        End;
                    5 : Begin
                          Writeat(2,14,kl4,kl5,' Area name    ');
                          Writeat(1,25,7,0,expand('The area in which the file must be hatched',79));
                        End;
                    6 : Begin
                          Writeat(2,15,kl4,kl5,' Magic name   ');
                          Writeat(1,25,7,0,expand('The magic name for the file',79));
                        End;
                    7 : Begin
                          Writeat(2,16,kl4,kl5,' Description  ');
                          Writeat(1,25,7,0,expand('The description to use for the file',79));
                        End;
                    8 : Begin
                          Writeat(2,17,kl4,kl5,' Replace      ');
                          Writeat(1,25,7,0,expand('The file to replace this file with',79));
                        End;
                  End;
                End;
    Sc_Report : Begin
                  Writeat(2,10,7,0,' Type         ');
                  Writeat(2,11,7,0,' Frequency    ');
                  Writeat(2,12,7,0,' Aka          ');
                  Writeat(2,14,7,0,' To           ');
                  Writeat(2,15,7,0,' Attributes   ');
                  Writeat(2,16,7,0,' Groups       ');
                  Writeat(2,18,7,0,' Msgbase      ');
                  Case sc.msgbaseid of
                    'S' : Writeat(2,19,7,0,' Msgbase Name ');
                    'H' : Writeat(2,19,7,0,' Board Number            Msgbase Path ');
                    'F' : Writeat(2,19,7,0,' Msgbase Path ');
                    'J' : Writeat(2,19,7,0,' Msgbase Name ');
                    'E' : Writeat(2,19,7,0,' Board Number            Msgbase Path ');
                  End;
                  Writeat(2,20,7,0,' MaxMsg Size  ');

                  Case active of
                    1 : Begin
                          Writeat(2,10,kl4,kl5,' Type         ');
                          Writeat(1,25,7,0,expand('Which kind of schedule this is',79));
                        End;
                    2 : Begin
                          Writeat(2,11,kl4,kl5,' Frequency    ');
                          Writeat(1,25,7,0,expand('The frequency which triggers this exception',79));
                        End;
                    3 : Begin
                          Writeat(2,12,kl4,kl5,' Aka          ');
                          Writeat(1,25,7,0,expand('The aka to use',79));
                        End;
                    4 : Begin
                          Writeat(2,14,kl4,kl5,' To           ');
                          Writeat(1,25,7,0,expand('The destination to use for the report',79));
                        End;
                    5 : Begin
                          Writeat(2,15,kl4,kl5,' Attributes   ');
                          Writeat(1,25,7,0,expand('The message attributes to use',79));
                        End;
                    6 : Begin
                          Writeat(2,16,kl4,kl5,' Groups       ');
                          Writeat(1,25,7,0,expand('The groups to use in the report',79));
                        End;
                    7 : Begin
                          Writeat(2,18,kl4,kl5,' Msgbase      ');
                        End;
                    8 : Begin
                          Case sc.msgbaseid of
                            'S' : Writeat(2,19,kl4,kl5,' Msgbase Name ');
                            'H' : Writeat(2,19,kl4,kl5,' Board Number ');
                            'F' : Writeat(2,19,kl4,kl5,' Msgbase Path ');
                            'J' : Writeat(2,19,kl4,kl5,' Msgbase Name ');
                            'E' : Writeat(2,19,kl4,kl5,' Board Number ');
                          End;
                        End;
                    9 : Begin
                          Writeat(2,20,kl4,kl5,' MaxMsg Size  ');
                          Writeat(1,25,7,0,expand('The maximum size of the message',79));
                        End;
                  End;
                End;
    Sc_Exec   : Begin
                  Writeat(2,10,7,0,' Type         ');
                  Writeat(2,11,7,0,' Frequency    ');
                  Writeat(2,12,7,0,' Command Line ');

                  Case active of
                    1 : Begin
                          Writeat(2,10,kl4,kl5,' Type         ');
                          Writeat(1,25,7,0,expand('Which kind of schedule this is',79));
                        End;
                    2 : Begin
                          Writeat(2,11,kl4,kl5,' Frequency    ');
                          Writeat(1,25,7,0,expand('The frequency which triggers this exception',79));
                        End;
                    3 : Begin
                          Writeat(2,12,kl4,kl5,' Command Line ');
                          Writeat(1,25,7,0,expand('The command line to execute',79));
                        End;
                  End;
                End;
    Sc_Post   : Begin
                  Writeat(2,10,7,0,' Type         ');
                  Writeat(2,11,7,0,' Frequency    ');
                  Writeat(2,12,7,0,' Aka          ');
                  Writeat(2,14,7,0,' To           ');
                  Writeat(2,15,7,0,' From         ');
                  Writeat(2,16,7,0,' Subject      ');
                  Writeat(2,17,7,0,' Attributes   ');
                  Writeat(2,18,7,0,' Message Text ');
                  Writeat(2,20,7,0,' Msgbase      ');
                  Case sc.msgbaseid of
                   'S' : Writeat(2,21,7,0,' Msgbase Name ');
                   'H' : Writeat(2,21,7,0,' Board Number            Msgbase Path ');
                   'F' : Writeat(2,21,7,0,' Msgbase Path ');
                   'J' : Writeat(2,21,7,0,' Msgbase Name ');
                   'E' : Writeat(2,21,7,0,' Board Number            Msgbase Path ');
                  End;
                  Writeat(2,22,7,0,' MaxMsg Size  ');

                  Case active of
                    1 : Begin
                          Writeat(2,10,kl4,kl5,' Type         ');
                          Writeat(1,25,7,0,expand('Which kind of schedule this is',79));
                        End;
                    2 : Begin
                          Writeat(2,11,kl4,kl5,' Frequency    ');
                          Writeat(1,25,7,0,expand('The frequency which triggers this exception',79));
                        End;
                    3 : Begin
                          Writeat(2,12,kl4,kl5,' Aka          ');
                          Writeat(1,25,7,0,expand('The aka to use',79));
                        End;
                    4 : Begin
                          Writeat(2,14,kl4,kl5,' To           ');
                          Writeat(1,25,7,0,expand('The TO address to use for this posting',79));
                        End;
                    5 : Begin
                          Writeat(2,15,kl4,kl5,' From         ');
                          Writeat(1,25,7,0,expand('The FROM address to use for this posting',79));
                        End;
                    6 : Begin
                          Writeat(2,16,kl4,kl5,' Subject      ');
                          Writeat(1,25,7,0,expand('The subject to use for this posting',79));
                        End;
                    7 : Begin
                          Writeat(2,17,kl4,kl5,' Attributes   ');
                          Writeat(1,25,7,0,expand('The message attributes to use',79));
                        End;
                    8 : Begin
                          Writeat(2,18,kl4,kl5,' Message Text ');
                          Writeat(1,25,7,0,expand('The message text to include in this posting',79));
                          If (setup.exteditor <> '') then writeat(64,25,14,0,'Press F2 to edit');
                        End;
                    9 : Begin
                          Writeat(2,20,kl4,kl5,' Msgbase      ');
                        End;
                   10 : Begin
                          Case sc.msgbaseid of
                            'S' : Writeat(2,21,kl4,kl5,' Msgbase Name ');
                            'H' : Writeat(2,21,kl4,kl5,' Board Number ');
                            'F' : Writeat(2,21,kl4,kl5,' Msgbase Path ');
                            'J' : Writeat(2,21,kl4,kl5,' Msgbase Name ');
                            'E' : Writeat(2,21,kl4,kl5,' Board Number ');
                          End;
                        End;
                   11 : Begin
                          Writeat(2,22,kl4,kl5,' MaxMsg Size  ');
                          Writeat(1,25,7,0,expand('The maximum size of the message',79));
                        End;
                  End;
                End;
  End;
End;


Procedure Schedule_read;
Var
  A   : Word;
  tmp1,tmp : string;
Begin
  Create_List;
  A := 0;
  Reset(scfile);
  While not eof(scfile) do
    Begin
      Inc(A);
      Read(Scfile,sc);

      Case sc.freq of
        Imm      : tmp := 'Immediately';
        Dayly    : tmp := 'Daily';
        Weekly   : tmp := 'Weekly '+int_to_str(sc.day);
        Weekly2  : tmp := '2-Weekly '+int_to_str(sc.day);
        Monthly  : tmp := 'Montly '+int_to_str(sc.day);
        Monthly2 : tmp := '2-Montly '+int_to_str(sc.day);
        Monthly3 : tmp := '3-Montly '+int_to_str(sc.day);
      End;
      tmp := expand(' '+tmp,11);

      if sc.inactive then tmp1 := '*' else tmp1 := ' ';

      Case Sc.Kind of
        Sc_Hatch  : Add_to_List(expand(tmp1+int_to_Str(a),4)+' Hatch file    '+tmp+
                       ' '+sc.mask+' '+^P+' '+sc.tag);
        Sc_Report : Add_to_List(expand(tmp1+int_to_str(a),4)+' *C Report     '+tmp+
                       ' '+sc.msgto+' '+^P+' '+WriteGroups(40,sc.grps));
        Sc_Exec   : Add_to_List(expand(tmp1+int_to_str(a),4)+' Exec program  '+tmp+
                       ' '+sc.line[1]);
        Sc_Post   : Add_to_List(expand(tmp1+int_to_str(a),4)+' Post message  '+tmp+
                       ' '+sc.line[2]+' '+^P+' '+sc.msgto);
      End;
    End;
End;


Function Select_Kind (a:scheduletype) : ScheduleType;
Var
  sel : byte;
  ch  : char;

   Procedure WriteKind;
   Begin
     Writeat(31,12,7,0,' Hatch file   ');
     Writeat(31,13,7,0,' *C report    ');
     Writeat(31,14,7,0,' Exec program ');
     Writeat(31,15,7,0,' Post message ');
     Case sel of
      1 : Begin
            Writeat(31,12,kl4,kl5,' Hatch file   ');
            Writeat(1,25,7,0,expand('Hatch a file with regular interval',79));
          End;
      2 : Begin
            Writeat(31,13,kl4,kl5,' *C report    ');
            Writeat(1,25,7,0,expand('Send a connection list with regular interval',79));
          End;
      3 : Begin
            Writeat(31,14,kl4,kl5,' Exec program ');
            Writeat(1,25,7,0,expand('Execute a program or batchfile with regular interval',79));
          End;
      4 : Begin
            Writeat(31,15,kl4,kl5,' Post message ');
            Writeat(1,25,7,0,expand('Write a message with regular interval',79));
          End;
     End;
   End;

Begin
  With mwin[4] do
    Begin
      x1 := 30;
      x2 := 10;
      y1 := 45;
      y2 := 17;
      st := ' Type ';
    End;
  Create_Window(4);
  Case a of
    sc_hatch  : sel := 1;
    sc_report : sel := 2;
    sc_exec   : sel := 3;
    sc_post   : sel := 4;
  End;
  Ch := #0;
  While not (Ch in [#27,#13]) do
    Begin
      WriteKind;
      Ch := Readkey;
      If Ch = #0 then
        Begin
          Ch := Readkey;
          If Ch = #80 then
            begin if sel < 4 then inc(sel) else sel := 1; end else
          If Ch = #72 then
            begin if sel > 1 then dec(sel) else sel := 4; end;
        End else
      If Ch = #9 then Infoscreen else
      If Ch = #26 then DosShell;
    End;
  Remove_Window(4);
  If Ch = #27 then Select_Kind := A else
    Begin
      Case sel of
       1 : Select_Kind := Sc_hatch;
       2 : select_Kind := sc_report;
       3 : select_kind := sc_exec;
       4 : select_kind := sc_post;
      End;
    End;
End;

Procedure Schedule_InsHook(new:boolean; rec:word);
Var
  Tmp,
  Tmp1   : String;
  Ch     : Char;
  Active : Word;
  ScBak  : ScheduleRec;
  bol    : Boolean;
  res    : word;

  Function Select_the_area (tmp:string) : String;
  Var
    X      : Word;
    Exbak2 : ScheduleRec;
  Begin
    if tmp <> '' then
      begin
        x := 0;
        repeat
          inc(x);
        until (upper(afxt^[x].tag) = upper(tmp)) or (x > areaidx);
        if x > areaidx then x := 1;
      end else x := 1;
    exbak2 := sc;
    remove_list;
    x := Select_Area(4,x);
    schedule_read;
    sc := exbak2;
    if x <> 0 then select_the_area := afxt^[x].tag
      else select_the_area := '';
  End;

Begin
  ScBak := Sc;

  With mwin[3] do
    Begin
      x1 := 1;
      x2 := 8;
      y1 := 80;
      y2 := 24;
      st := ' Entry '+int_to_str(rec)+' ';
    End;
  Create_window(3);

  Ch := #0;
  Active := 1;
  if new then
    begin
      fillchar(sc,sizeof(sc),#0);
      sc.freq := dayly;
      sc.next := nextdate(0,sc.freq,sc.day);
    end;

  While Ch <> #27 do
    Begin
      Write_Schedule(active);
      Display_Schedule;
      Ch := Readkey;
      Case Ch of
        #9  : infoscreen;
        #26 : dosshell;
        #13 : Begin
                Case Active of
                  1 : Begin
                        Sc.Kind := Select_Kind(sc.kind);
                        FillScreen(2,9,79,23,7,0,' ');
                      End;
                  2 : Begin
                        Select_Frequency(4,false,sc.Freq,sc.Day,sc.next);
                        sc.next := nextdate(0,sc.freq,sc.day);
                      End;
                End;
                Case sc.kind of
                  Sc_Hatch  : Begin
                                Case Active of
                                  3 : sc.aka := Select_Address(4,sc.aka,true);
                                  4 : begin {txtfile}
                                        tmp := sc.mask;
                                        read_string(17,13,60,60,tmp,c_all);
                                        sc.mask := tmp;
                                      end;
                                  5 : begin {areatag}
                                        tmp := sc.tag;
                                        read_string(17,14,20,20,tmp,c_all);
                                        if (sc.tag = tmp) or (tmp = '') then
                                          begin
                                            sc.tag := select_the_area(tmp);
                                          end else sc.tag := tmp;
                                      end;
                                  6 : begin {magic}
                                        tmp := sc.magic;
                                        read_string(17,15,20,20,tmp,c_all);
                                        sc.magic := tmp;
                                      end;
                                  7 : begin {description}
                                        tmp := sc.line[1];
                                        read_string(17,16,62,76,tmp,c_all);
                                        sc.line[1] := tmp;
                                      end;
                                  8 : begin
                                        tmp := sc.line[2];
                                        read_string(17,17,20,12,tmp,c_all);
                                        sc.line[2] := tmp;
                                      end;
                                End;
                              End;
                  Sc_Report : Begin
                                Case Active of
                                  3 : sc.aka := Select_Address(4,sc.aka,true);
                                  4 : begin {to}
                                       tmp := sc.msgto;
                                       read_String(17,14,50,35,tmp,c_all);
                                       sc.msgto := tmp;
                                       if net in sc.status then
                                         begin
                                           writeat(17,14,foreentry,backentry,tmp+',');
                                           tmp := node2str(sc.tonode);
                                           read_string(19+length(sc.msgto),14,18,23,tmp,c_all);
                                           str2node(tmp,sc.tonode,setup.address[1],bol);
                                           if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                                         end;
                                      end;
                                  5 : Select_Attribs(4,sc.msgattr,net in sc.status); {attribs}
                                  6 : Select_Groups(4,sc.grps,false);
                                  7 : begin {msgbase}
                                        tmp := sc.msgbaseidstr;
                                        select_messagebase(4,sc.msgbaseid,sc.status,tmp,tmp,false);
                                        sc.msgbaseidstr := tmp;
                                      end;
                                  8 : begin
                                        case sc.msgbaseid of
                                          'S' : Begin
                                                  Tmp := sc.msgbaseidstr;
                                                  read_string(17,19,49,49,tmp,c_all);
                                                  sc.msgbaseidstr := tmp;
                                                End;
                                          'H' : Begin
                                                  Tmp := first(3,sc.msgbaseidstr);
                                                  read_String(17,19,3,3,tmp,c_numbers);
                                                  Tmp1 := last(length(sc.msgbaseidstr)-3,sc.msgbaseidstr);
                                                  read_string(40,19,39,39,tmp1,c_all);
                                                  checkpath(tmp1);
                                                  while length(tmp) < 3 do tmp := '0' + tmp;
                                                  sc.msgbaseidstr := tmp + tmp1;
                                                End;
                                          'F' : Begin
                                                  Tmp := sc.msgbaseidstr;
                                                  read_string(17,19,49,49,tmp,c_all);
                                                  checkpath(tmp);
                                                  sc.msgbaseidstr := tmp;
                                                End;
                                          'J' : Begin
                                                  Tmp := sc.msgbaseidstr;
                                                  read_string(17,19,49,49,tmp,c_all);
                                                  sc.msgbaseidstr := tmp;
                                                End;
                                          'E' : Begin
                                                  Tmp := first(4,sc.msgbaseidstr);
                                                  read_String(17,19,4,4,tmp,c_numbers);
                                                  Tmp1 := last(length(sc.msgbaseidstr)-4,sc.msgbaseidstr);
                                                  read_string(40,19,39,39,tmp1,c_all);
                                                  checkpath(tmp1);
                                                  while length(tmp) < 4 do tmp := '0' + tmp;
                                                  sc.msgbaseidstr := tmp + tmp1;
                                                End;
                                        end;
                                      end;
                                  9 : begin
                                        tmp := int_to_str(sc.maxsize);
                                        read_string(17,20,5,3,tmp,c_all);
                                        sc.maxsize := str_to_int(tmp);
                                        if sc.maxsize > 16 then sc.maxsize := 16;
                                      end;
                                End;
                              End;
                  Sc_Exec   : Begin
                                Case Active of
                                  3 : begin {commandline}
                                        tmp := sc.line[1];
                                        read_string(17,12,62,76,tmp,c_all);
                                        sc.line[1] := tmp;
                                      end;
                                End;
                              End;
                  Sc_Post   : Begin
                                Case Active of
                                  3 : sc.aka := Select_Address(4,sc.aka,true);
                                  4 : begin { to + tonode }
                                       tmp := sc.msgto;
                                       read_String(17,14,50,35,tmp,c_all);
                                       sc.msgto := tmp;
                                       if net in sc.status then
                                         begin
                                           writeat(17,14,foreentry,backentry,tmp+',');
                                           tmp := node2str(sc.tonode);
                                           read_string(19+length(sc.msgto),14,18,23,tmp,c_all);
                                           str2node(tmp,sc.tonode,setup.address[1],bol);
                                           if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                                         end;
                                      end;
                                  5 : begin { from }
                                        tmp := sc.msgfrom;
                                        read_string(17,15,50,35,tmp,c_all);
                                        sc.msgfrom := tmp;
                                      end;
                                  6 : begin {subject}
                                        tmp := sc.line[1];
                                        read_string(17,16,62,76,tmp,c_all);
                                        sc.line[1] := tmp;
                                      end;
                                  7 : Select_Attribs(4,sc.msgattr,net in sc.status); {attribs}
                                  8 : begin {msgtxt}
                                        tmp := sc.line[2];
                                        read_string(17,18,62,76,tmp,c_all);
                                        sc.line[2] := upper(tmp);
                                        if sc.line[2] <> '' then
                                          begin
                                            if not exist(tmp) then
                                              begin
                                                if askwindow(sc.line[2],'does not exist!','Create (Y/N) ?',['y','Y','n','N'])
                                                in ['y','Y'] then create_file(tmp);
                                              end;
                                          end;
                                      end;
                                  9 : begin
                                        tmp := sc.msgbaseidstr;
                                        select_messagebase(4,sc.msgbaseid,sc.status,tmp,tmp,false);
                                        sc.msgbaseidstr := tmp;
                                      end;
                                 10 : begin
                                        case sc.msgbaseid of
                                          'S' : Begin
                                                  Tmp := sc.msgbaseidstr;
                                                  read_string(17,21,49,49,tmp,c_all);
                                                  sc.msgbaseidstr := tmp;
                                                End;
                                          'H' : Begin
                                                  Tmp := first(3,sc.msgbaseidstr);
                                                  read_String(17,21,3,3,tmp,c_numbers);
                                                  Tmp1 := last(length(sc.msgbaseidstr)-3,sc.msgbaseidstr);
                                                  read_string(40,21,39,39,tmp1,c_all);
                                                  checkpath(tmp1);
                                                  while length(tmp) < 3 do tmp := '0' + tmp;
                                                  sc.msgbaseidstr := tmp + tmp1;
                                                End;
                                          'F' : Begin
                                                  Tmp := sc.msgbaseidstr;
                                                  read_string(17,21,49,49,tmp,c_all);
                                                  checkpath(tmp);
                                                  sc.msgbaseidstr := tmp;
                                                End;
                                          'J' : Begin
                                                  Tmp := sc.msgbaseidstr;
                                                  read_string(17,21,49,49,tmp,c_all);
                                                  sc.msgbaseidstr := tmp;
                                                End;
                                          'E' : Begin
                                                  Tmp := first(4,sc.msgbaseidstr);
                                                  read_String(17,21,4,4,tmp,c_numbers);
                                                  Tmp1 := last(length(sc.msgbaseidstr)-4,sc.msgbaseidstr);
                                                  read_string(40,21,39,39,tmp1,c_all);
                                                  checkpath(tmp1);
                                                  while length(tmp) < 4 do tmp := '0' + tmp;
                                                  sc.msgbaseidstr := tmp + tmp1;
                                                End;
                                        end;
                                      end;
                                 11 : begin
                                        tmp := int_to_str(sc.maxsize);
                                        read_string(17,22,5,3,tmp,c_all);
                                        sc.maxsize := str_to_int(tmp);
                                        if sc.maxsize > 16 then sc.maxsize := 16;
                                      end;
                                End;
                              End;
                End;
              End;
        #0  : Begin
                Ch := Readkey;
                Case Ch of
                  #72 : {up}   if active > 1 then dec(active) else
                               begin
                                 case sc.kind of
                                  sc_hatch  : active := 8;
                                  sc_report : active := 9;
                                  sc_exec   : active := 3;
                                  sc_post   : active := 11;
                                 end;
                               end;
                  #80 : {down} begin
                                 case sc.kind of
                                  sc_hatch  : if active < 8 then inc(Active) else active := 1;
                                  sc_report : if active < 9 then inc(active) else active := 1;
                                  sc_exec   : if active < 3 then inc(active) else active := 1;
                                  sc_post   : if active < 11 then inc(active) else active := 1;
                                 end;
                               end;
                  #60 : {f2}   begin
                                 if sc.kind = sc_post then
                                   begin
                                     if active = 8 then
                                       begin
                                        cursor_on;
                                        savescreen;
                                        if sc.line[2] <> '' then
                                          res := fmExec(setup.exteditor,sc.line[2], setup.SwapMethode, $ffff, false, false);
                                        restorescreen;
                                        cursor_off;
                                       end;
                                   end;
                               end;
                End;
              End;
      End;
    End;

  If not samerec(sc,scbak,sizeof(scbak)) then
    Begin
      If AskWindow('Changes have been made','Save changes?','(Y/N)',['y','Y','n','N']) in ['y','Y'] then
        Begin
          Seek(scfile,rec-1);
          Write(scfile,sc); {save rec}

          remove_list;
          schedule_read;
          display_amount;
        End;
    End;

  Remove_Window(3);
End;


{$F+} Procedure Schedule_Ins; {$F-}
Begin
  Schedule_InsHook(true,filesize(scfile)+1);
  Display_Amount;
End;


{$F+} Procedure Schedule_F3(rec:word); {$F-}
Begin
  Remove_List;

  reset(scfile);
  seek(scfile,rec-1);
  read(scfile,sc);
  sc.inactive := not sc.inactive;
  seek(scfile,rec-1);
  write(scfile,sc);

  Schedule_Read;
  Display_Amount;
End;


{$F+} Function Schedule_Del(rec:word) : Boolean; {$F-}
Var
  Scbakfile : File of ScheduleRec;
  x         : Word;
  tmp : string;
Begin
  tmp := Extractwords(1,1,Get_From_List(rec));
  if first(1,tmp) = '*' then tmp := last(length(tmp)-1,tmp);
  rec := str_to_int(tmp);
  If Askwindow('Delete entry '+int_to_str(rec),'are you sure?','(Y/N)',['y','Y','n','N']) in ['n','N'] then
    begin
      schedule_del := false;
      exit;
    end;

  Remove_List;

  Assign(Scbakfile,systempath+'SCHEDULE.NEW');
  Rewrite(Scbakfile);
  Reset(Scfile);
  X := 0;
  While not eof(Scfile) do
    Begin
      Inc(x);
      Read(scfile,sc);
      If rec <> x then Write(scbakfile,sc);
    End;
  Close(Scfile);
  Erase(scfile);
  Close(scbakfile);
  Rename(scbakfile,systempath+'SCHEDULE.FM');
  {del rec from scfile}
  Assign(scfile,systempath+'SCHEDULE.FM');
  Reset(scfile);

  Schedule_Read;
  Schedule_Del := True;
  Display_Amount;
End;


Procedure SchedulerLoop;
Var
  Ch     : Char;
  Tmp    : String;
  Active : Byte;
Begin
  Assign(Scfile,Systempath + 'SCHEDULE.FM');
  {$I-} Reset(Scfile); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'SCHEDULE.FM not found','Create new?','(Y/N)',['y','Y','n','N',#27]) in ['y','Y'] then
        Begin
          Rewrite(Scfile);
        End Else
        Begin
          Exit;
        End;
    End;

  With mwin[2] do
    Begin
      x1 := 1;
      x2 := 1;
      y1 := 80;
      y2 := 24;
      st := ' Scheduler ';
    End;
  Create_Window(2);

  Ins_Hook := Schedule_Ins;
  Del_Hook := Schedule_Del;
  F3_Hook := Schedule_F3;
  Schedule_Read;

  Active := 1;
  Repeat
    Display_Amount;
    Tmp := Show_List (2,true,false {Jump},0 {JumpWord},active);
    If Tmp <> '' then
      Begin
        if first(1,tmp) = '*' then
          begin
            strip('B',' ',tmp);
            tmp := last(length(tmp)-1,tmp);
            active := str_to_int(extractwords(1,1,tmp));
          end else
            active := str_to_int(extractwords(1,1,tmp));
        seek(scfile,active-1);
        read(scfile,sc);
        Schedule_Inshook(false,active);
      End;
  Until Tmp = '';

  Remove_List;
  Remove_Window(2);
  Close(Scfile);
End;


END.
