{*****************************************************************************
 *
 * Purpose ...............: Setup Areas
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_3;

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec;

Procedure AreaLoop;

Implementation


{ area manager }

Procedure SortAreaIndex;
Var
  I, j      : word;

  Procedure Swp (Var X,Y : AreaIndexType);
  Var T : AreaIndexType;
  Begin
    T := X;    X := Y;    Y := T;
  End;

  Function Bigger(X,Y : AreaIndexType) : Boolean;
  Begin
    if setup.sortarea then
      bigger := x.tag < y.tag else
        begin
          if x.grp = y.grp then
            bigger := x.tag < y.tag else
              bigger := x.grp < y.grp;
        end;
  End;

Begin
  writecolor(25,7,15,0,'Sorting area''s...');
  if areaidx > 1 then
    begin
       for J := areaidx downto 2 do
         for I := 2 to j do
           if bigger(afxt^[i],afxt^[i-1]) then swp(afxt^[i],afxt^[i-1]);
    end;
End;



{$F+} Procedure GlobalHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'The group ID');
    2 : Writeat(1,25,7,0,'The tpl format to use for the listfile');
    3 : Writeat(1,25,7,0,'The batchfile to execute on file arrival');
    4 : Writeat(1,25,7,0,'The message file to attach to the file while forwarding');
    5 : Writeat(1,25,7,0,'The message slot(s) in which the files should be announced');
    6 : Writeat(1,25,7,0,'The re-archive functions');
    7 : Writeat(1,25,7,0,'The cleanup functions');
    8 : Writeat(1,25,7,0,'The replacement mode');
    9 : Writeat(1,25,7,0,'The costsharings options');
   10 : Writeat(1,25,7,0,'The status bits');
   11 : Writeat(1,25,7,0,'The aka to use in seen-by lines');
   12 : Writeat(1,25,7,0,'The list of nodes who are connected');
  End;
End;


Procedure GlobelArea;
Var
  ban : byte;
  arc    : Archivertype;
  pak    : Packertype;
  stat1,
  stat2  : Statustype;
  N1, N2 : ExportType;
  Bol,
  Bal    : Booleanset;

  Areaexbak : word;
  Ar     : Array[1..12] of String[12];
  X, Ge,
  X1, X2 : Word;
  X3, X4 : Byte;
  x5,x6  : boolean;
  Ch     : Char;
  Tmp    : String;
  Count,
  Tel    : Word;
  Cor    : Boolean;
  doit : boolean;

  Function Globalconnection : Byte;
  Var Br : Array[1..4] of String[12];
      Gr : Byte;
  Begin
    With mwin[4] do
     Begin
       x1 := 35; x2 := 8;
       y1 := 50; y2 := 15;
       st := ' Connections ';
     End;
    create_window(4);
    br[1] := 'Add node';
    br[2] := 'Remove node';
    br[3] := 'Change node';
    br[4] := 'Replace node';
    choosehook := dummy;
    decwin(4);
    globalconnection := select_window(4,4,12,@br,1,false);
    incwin(4);
    remove_window(4);
  End;

Begin
  With Mwin[3] do
   Begin
     x1 := 32;
     x2 := 6;
     y1 := 47;
     y2 := 21;
     st := ' Global ';
   End;
  Create_Window(3);

  ar[1] := 'Group';
  ar[2] := 'Format Tpl';
  ar[3] := 'Batchfile';
  ar[4] := 'Message file';
  ar[5] := 'Announces';
  ar[6] := 'Re-archive';
  ar[7] := 'Cleanup';
  ar[8] := 'Replace';
  ar[9] := 'Costsharing';
  ar[10]:= 'Status';
  ar[11]:= 'Seen-by';
  ar[12]:= 'Connections';

  ge := 1;
  while ge <> 0 do
    begin
      choosehook := globalhelp;
      decwin(3);
      ge := select_window(3,12,12,@ar,ge,false);
      incwin(3);
      if ge <> 0 then
        begin
          for x := 1 to 255 do bol[x] := false;
          for x := 1 to 255 do bal[x] := false;
          writeat(1,25,7,0,expand(' ',79));

          doit := false;
          tmp := '';
          fillchar(n1,sizeof(n1),#0);

          case ge of
           1 : Begin
                 writeat(1,25,7,0,'Select the group to use');
                 x1 := Select_Group(4,1);
                 doit := true;
               End;
           2 : Begin
                 writeat(1,25,7,0,'Select the tpl format to use');
                 tmp := select_tpl(4,area.format,false);
               End;
           3 : Begin
                 writeat(1,25,7,0,'Batchfile:');
                 read_string(12,25,12,12,tmp,c_all);
                 if tmp = '' then
                   begin
                     if askwindow('','Remove batchfile?','',['y','Y','n','N',#27]) in ['y','Y'] then
                       doit := true;
                   end;
               End;
           4 : Begin
                 writeat(1,25,7,0,'Message file:');
                 read_string(15,25,63,80,tmp,c_all);
                 if tmp = '' then
                   begin
                     if askwindow('','Remove message file?','',['y','Y','n','N',#27]) in ['y','Y'] then
                       doit := true;
                   end;
               End;
           5 : Begin
                 Writeat(1,25,7,0,'Select the message announcements to use');
                 Select_messages(4,bal,false);;
                 doit := true;
               End;
           6 : Begin
                 arc := zip;
                 pak := [];
                 ban := 0;
                 Writeat(1,25,7,0,'Select the re-archive options to use');
                 Select_Rearchiving(4,pak,arc,ban);
                 doit := true;
               End;
           7 : Begin
                 x1 := 0; x2 := 0;
                 Writeat(1,25,7,0,'Select the cleanup options to use');
                 Select_Cleanup(4,x1,x2);
                 doit := true;
               End;
           8 : Begin
                 x1 := 0;
                 Repeat
                    case x1 of
                     0 : Tmp := 'No replace';
                     1 : Tmp := 'Replace   ';
                     2 : Tmp := 'Move file ';
                    end;
                   writecolor(25,7,15,0,'Replace function: ^'+tmp);
                    ch := readkey;
                   if (ch = #13) or (ch = #32) then inc(x1);
                    if x1 = 3 then x1 := 0;
                  until ch = #27;
               End;
           9 : Begin
                 writeat(1,25,7,0,'Select the costsharings options to use');
                 x1 := 0; x2 := 0;
                  select_costsharing(4,x1,x3,cor,x4,x5,x6);
                 doit := true;
             End;
          10 : Begin
                 stat1 := [];
                  stat2 := [];
                 writeat(1,25,7,0,'Select the status bits to use');
                  change_globalareastatus(4,stat1,stat2);
                  if (stat1 <> []) or (stat2 <> []) then doit := true;
               End;
          11 : begin
                 writeat(1,25,7,0,'Select the aka to use in the seen-by lines');
                 x1 := select_address(4,1,true);
                 if x1 = 0 then tmp := '"Aka matching"' else tmp := node2str(setup.address[x1]);
               end;
          12 : begin
                 x1 := globalconnection;
                 case x1 of
                   1 : begin
                         writeat(1,25,7,0,'Select the node to add');
                         select_node_systemlist(4,n1,true,1);
                         tmp := #0;
                       end;
                   2 : begin
                         writeat(1,25,7,0,'Node to remove:');
                         read_string(17,25,23,23,tmp,c_all);
                         str2node(tmp,n1.a,setup.address[1],cor);
                         if not cor then askwindow('','Invalid nodenumber entered','',[#32,#27,#13]);
                       end;
                   3 : begin
                         tmp := #0;
                         writeat(1,25,7,0,'Select the node to change');
                         select_node_systemlist(4,n1, true,1);
                       end;
                   4 : begin
                         writeat(1,25,7,0,'Node to replace:');
                         read_string(18,25,23,23,tmp,c_all);
                         str2node(tmp,n1.a,setup.address[1],cor);
                         if not cor then askwindow('','Invalid nodenumber entered','',[#32,#27,#13]);

                         writeat(1,25,7,0,'Select the node to replace with');
                         fillchar(n2,sizeof(n2),0);
                         select_node_systemlist(4,n2,true,1);
                       end;
                 end;
               end;
          End;

          if (tmp <> '') or doit then
            begin
              Writeat(1,25,7,0,'Select the groups which affect this global change');
              Select_Groups(4,bol,false);

              Writeat(1,25,7,0,expand('',79));
              Case ge of
               1 : Writeat(1,25,7,0,'Change group ID in selected groups to '+int_to_str(x1)+' ? (Y/N)');
               2 : Writeat(1,25,7,0,'Change Tpl format in selected groups to '+tmp+' ? (Y/N)');
               3 : Writeat(1,25,7,0,'Change batchfile in selected groups to '+upper(tmp)+' ? (Y/N)');
               4 : Writeat(1,25,7,0,'Change message file in selected groups to '+upper(tmp)+' ? (Y/N)');
               5 : Writeat(1,25,7,0,'Change the announce messages to '+WriteGroups(39,bal)+' ? (Y/N)');
               6 : Writeat(1,25,7,0,'Change the re-archiver option in the selected groups ? (Y/N)');
               7 : Writeat(1,25,7,0,'Change the cleanup option in the selected groups ? (Y/N)');
               8 : Writeat(1,25,7,0,'Change the replace function in selected groups to "'+strip('B',' ',tmp)+'" ? (Y/N)');
               9 : Writeat(1,25,7,0,'Change the costsharing function in selected groups ? (Y/N)');
              10 : Writeat(1,25,7,0,'Change the selected status bits in selected groups ? (Y/N)');
              11 : Writeat(1,25,7,0,'Change the aka to use in selected groups to '+tmp+' ? (Y/N)');
              12 : Begin
                     Case X1 of
                       1 : Writeat(1,25,7,0,'Add node '+node2str(n1.a)+' to selected groups ? (Y/N)');
                       2 : Writeat(1,25,7,0,'Remove node '+node2str(n1.a)+' from selected groups ? (Y/N)');
                       3 : Writeat(1,25,7,0,'Change node '+node2str(n1.a)+' in selected groups ? (Y/N)');
                       4 : Writeat(1,25,7,0,'Replace node '+node2str(n1.a)+' with '+node2str(n2.a)
                              +' in selected groups ? (Y/N)');
                     End;
                   End;
              End;

              Tel := 0;
              Ch := #0;
              While not (ch in [#27,'y','Y','n','N']) do ch := readkey;
              { vragen if sure y/n }
              If ch in ['y','Y'] then
                Begin
                  For x := 1 to AreaIdx do
                    Begin
                      If bol[Afxt^[x].grp] then
                        Begin
                          writeat(1,25,7,0,expand(afxt^[x].tag,79));
                          seek(af,afxt^[x].arearec);
                          blockread(af,area,sizeof(area),count);
                          areaexbak := area.exportnr;

                          case ge of
                            1 : begin
                                  area.grp := x1;
                                  afxt^[x].grp := x1;
                                end;
                            2 : area.format := tmp;
                            3 : area.batchfile := upper(tmp);
                            4 : area.msgfile := upper(tmp);
                            5 : move(bal,area.msgid,sizeof(bal));
                            6 : begin
                                  area.rearchive := pak;
                                  area.usearchiver := arc;
                                  area.usebanner := ban;
                                end;
                            7 : begin
                                  area.keepdays := x1;
                                  area.keepamount := x2;
                                end;
                            8 : area.replacemode := x1;
                            9 : begin
                                  area.costperblock := x1;
                                  area.block := x3;
                                  area.alllinks := cor;
                                  area.addpercent := x4;
                                  area.inclhost := x5;
                                  area.incluplink := x6;
                                end;
                           10 : begin
                                  area.status := area.status + stat1;
                                  area.status := area.status - stat2;
                                end;
                           11 : area.aka := x1;
                           12 : begin
                                  fillchar(sfxt^,sizeof(sfxt^),0);
                                  BlockRead(Af,Sfxt^,(area.exportnr*sizeof(exporttype)),count);
                                  case x1 of
                                   1 : begin
                                         if not is_dup(area.exportnr,n1.a) then
                                           begin
                                             inc(area.exportnr);
                                             sfxt^[area.exportnr] := n1;
                                           end else dec(tel)
                                       end;
                                   2 : begin
                                         cor := false; x2 := 0;
                                         while (x2 < area.exportnr) and not cor do
                                           begin
                                             inc(x2);
                                             cor := samerec(sfxt^[x2].a,n1.a,sizeof(n1.a));
                                           end;
                                         if cor then
                                           begin
                                             for x2 := x2 to area.exportnr-1 do
                                              sfxt^[x2] := sfxt^[x2+1];
                                             dec(area.exportnr);
                                           end else dec(tel);
                                       end;
                                   3 : begin
                                         cor := false; x2 := 0;
                                         while (x2 < area.exportnr) and not cor do
                                           begin
                                             inc(x2);
                                             cor := samerec(sfxt^[x2].a,n1.a,sizeof(n1.a));
                                           end;
                                         if cor then sfxt^[x2] := n1;
                                       end;
                                   4 : begin
                                         cor := false; x2 := 0;
                                         while (x2 < area.exportnr) and not cor do
                                           begin
                                             inc(x2);
                                             cor := samerec(sfxt^[x2].a,n1.a,sizeof(n1.a));
                                           end;
                                         if cor then
                                           if not is_dup(area.exportnr,n2.a) then
                                             sfxt^[x2] := n2;
                                       end;
                                  end;
                                end;
                          end;
                          inc(tel);

                          if ge = 12 then
                            if area.exportnr <> areaexbak then
                              afxt^[x].arearec := filesize(af);

                          seek(af,afxt^[x].arearec);
                          blockwrite(af,area,sizeof(area),count);
                          If ge = 12 then
                            begin
                              sortsystemlist(area.exportnr);
                              blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype),count);
                            end;
                        End;
                    End;
                  Askwindow('',int_to_str(tel)+' areas changed','',[#13,#32,#27]);
                End;
            End;
        End;
    End;
  Remove_Window(3);
End;


Function GetBbsAreaNaam(recnummer:longint) : String;
Var
  Found    : Boolean;
  Tel, Max : Longint;
Begin
  If Exist(systempath+'filearea.fm') then
    Begin
      Assign (bf, systempath+'filearea.fm');
      Reset (bf,1);
      Max   := (Filesize(bF) div sizeof(bbsarea))-2;
      If Recnummer-1 <= Max then
        Begin
          Dec(Recnummer);
          Seek(bF, (Recnummer * SizeOf(Bbsarea)) + sizeof(Bbsarea) + 20);
          BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
          GetBbsAreaNaam := BbsArea.name;
        End Else
          GetBbsAreaNaam := '';
      Close(bf);
   End Else
    GetBbsAreaNaam := '';
End;


Function GetBbsArea(directory:string) : Word; {0 if not found, anders rec nummer}
Var
  Found    : Boolean;
  Tel, Max : Longint;
Begin
  FillChar(BbsArea,Sizeof(bbsarea),#0);
  If Exist(systempath+'filearea.fm') then
    Begin
      Assign (bf, systempath+'filearea.fm');
      Reset (bf,1);
      Max   := (Filesize(bF) div sizeof(bbsarea)) -2;
      Tel := 0;
      Found := False;
      If last(1,directory) <> '\' then directory := directory + '\';
      While not found and (tel <= Max) do
        Begin
          Seek(bF, (Tel * SizeOf(Bbsarea)) + sizeof(bbsarea) + 20);
          BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
          If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';
          If Upper(Directory) = Upper(Bbsarea.path) then
            Found := True;
          Inc(Tel);
        End;
      Close(bf);
      If found then GetBbsArea := Tel Else GeTbbsArea := 0;
   End Else
    GetBbsArea := 0;
End;


Function Area_Ok (newrecord:boolean) : Boolean;
Var
  Found : Boolean;
  tmp,tmp1 : string;
  X     : Integer;
Begin
  If area.tag = '' then
    Begin
      Area_Ok := False;
      AskWindow('You have to','enter a tag name','(F9 to abort)',[#13,#27,#32]);
    End Else
    Begin
      Found := False;
      For X := 1 to AreaIdx do
        begin
          tmp := afxt^[x].tag;
          if length(tmp) > 16 then tmp := first(16,tmp);
          tmp1 := area.tag;
          if length(tmp1) > 16 then tmp1 := first(16,tmp1);
          If upper(tmp) = upper(tmp1) then Found := true;
        end;
      If Found and newrecord then
        Begin
          AskWindow('Areatag',tmp1,'already exist',[#13,#27,#32]);
          Area_Ok := False;
        End Else Area_Ok := True;
    End;
End;


Procedure AreaHelp( x : byte );
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case X of
    1 : Writeat(1,25,7,0,'The tag of this area. Must be the same as in the *.TIC-files you receive/send');
    2 : Writeat(1,25,7,0,'The description of this area. This is shown in %list reports etc..');
    3 : Writeat(1,25,7,0,'The group ID and group description');
    4 : Begin
          Writeat(1,25,7,0,'The *.TPL template to describe the files in this area');
          If (setup.exteditor <> '') and (area.format <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
    5 : Writeat(1,25,7,0,'The directory in which FileMgr should put the files it receives');
    6 : Writeat(1,25,7,0,'The listfile (FILES.BBS) or BBS area for this area');
    7 : Begin
          writeat(1,25,7,0,'The batchfile that must be executed during processing');
          If (setup.exteditor <> '') and (area.batchfile <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
    8 : Begin
          writeat(1,25,7,0,'The full path to a text file to include in netmail file attach');
          If (setup.exteditor <> '') and (area.msgfile <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
    9 : Writeat(1,25,7,0,'The ID''s of the messages that should be used to announce files in this area');
   10 : Writeat(1,25,7,0,'If FileMgr should re-archive incoming files');

   11 : Writeat(1,25,7,0,'If FileMgr should delete files based on date or number {NOT FUNCTIONAL YET}');

   12 : Writeat(1,25,7,0,'If Filemgr should delete, ignore or move ''to be replaced'' files');
   13 : Writeat(1,25,7,0,'Costsharing options for this area');
   14 : Writeat(1,25,7,0,'The statusbits of this area');
   15 : Writeat(1,25,7,0,'Which AKA should be used when forwarding files in this area');
   16 : Writeat(1,25,7,0,'Which systems are connected to this area');
  End;
End;


Procedure AreaWrite(x:byte);
Begin
  writeat(2, 3,7,0,' Area tag     ');
  writeat(2, 4,7,0,' Description  ');
  writeat(2, 5,7,0,' Group ID     ');
  if (setup.filebase = 0) or (area.areanr = 0) then
    writeat(2, 6,7,0,' Format .TPL  ') else
    writeat(2, 6,7,0,replicate(14,' '));
  writeat(2, 7,7,0,' Directory    ');
  if (setup.filebase <> 0) then
    writeat(2, 8,7,0,' Filebase     ') Else
    writeat(2, 8,7,0,' List file    ');
  writeat(2, 9,7,0,' Batchfile    ');
  writeat(2,10,7,0,' Message file ');
  writeat(2,11,7,0,' Announces    ');
  writeat(2,12,7,0,' Re-archive   ');
  writeat(2,13,7,0,' Cleanup      ');
  writeat(2,14,7,0,' Replace mode ');
  writeat(2,15,7,0,' Costsharing  ');
  writeat(2,16,7,0,' Status       ');

  Writeat(17,16,7,0,'CRC');
  Writeat(33,16,7,0,'Dupcheck');
  Writeat(48,16,7,0,'FuzzyDup');
  Writeat(63,16,7,0,'Tiny');

  Writeat(17,17,7,0,'Secure');
  Writeat(33,17,7,0,'Backup');
  Writeat(48,17,7,0,'Hide');
  Writeat(63,17,7,0,'VirusScan');

  Writeat(17,18,7,0,'ImportDiz');
  Writeat(33,18,7,0,'LongDesc');
  Writeat(48,18,7,0,'AnnNew');
  Writeat(63,18,7,0,'HatchNew');

  Writeat(17,19,7,0,'Test file');
  Writeat(33,19,7,0,'Notified');
  Writeat(48,19,7,0,'Discon.');

  writeat(2,20,7,0,' Seen-by      ');
  writeat(2,21,7,0,' Connections  ');

  case x of
    1 : writeat(2, 3,kl4,kl5,' Area tag     ');
    2 : writeat(2, 4,kl4,kl5,' Description  ');
    3 : writeat(2, 5,kl4,kl5,' Group ID     ');
    4 : begin
          if (setup.filebase = 0) or (area.areanr = 0) then
            writeat(2, 6,kl4,kl5,' Format .TPL  ') else
              writeat(2, 6,kl4,kl5,'              ');
        end;
    5 : writeat(2, 7,kl4,kl5,' Directory    ');
    6 : begin
          if (setup.filebase <> 0) then
            writeat(2, 8,kl4,kl5,' Filebase     ') else
              writeat(2, 8,kl4,kl5,' List file    ');
        end;
    7 : writeat(2, 9,kl4,kl5,' Batchfile    ');
    8 : writeat(2,10,kl4,kl5,' Message file ');
    9 : writeat(2,11,kl4,kl5,' Announces    ');
   10 : writeat(2,12,kl4,kl5,' Re-archive   ');
   11 : writeat(2,13,kl4,kl5,' Cleanup      ');
   12 : writeat(2,14,kl4,kl5,' Replace mode ');
   13 : writeat(2,15,kl4,kl5,' Costsharing  ');
   14 : writeat(2,16,kl4,kl5,' Status       ');
   15 : writeat(2,20,kl4,kl5,' Seen-by      ');
   16 : writeat(2,21,kl4,kl5,' Connections  ');
  end;
End;



Procedure Edit_SystemList;
Var
  Ch    : Char;
  X, Z  : Word;
  Top   : word;

  Procedure WriteList(activ:word);
  Var y   : byte;
      tmp : string;
  Begin
    For Y := 6 to 21 do
      If top+y-6 <= area.exportnr then
        begin
          tmp := node_bits_Status(sfxt^[top+y-6].s);
          if top+y-6 = activ then
            writeat(29,y,kl4,kl5,                '  '+expand(int_to_str(top+y-6),4)+' '+tmp+'   '
              +expand(node2str(sfxt^[top+y-6].a),16)+' ') else
            Writeat(29,y,foreentry,backentry,'  '+expand(int_to_str(top+y-6),4)+' '+tmp+'   '
              +expand(node2str(sfxt^[top+y-6].A),16)+' ');
        end else
            Writeat(29,y,foreentry,backentry,expand(' ',31));
  End;

Begin
  With mwin[3] do
    Begin
      x1 := 28;
      x2 := 3;
      y1 := 60;
      y2 := 22;
      st := ' Connections ';
    End;
  Create_Window(3);

  Writeat(29,4,7,0,'  #    Status Node');

  top := 1;
  x := 1;
  Ch := #0;

  While Ch <> #27 do
   Begin
     Writeat(28,5,11,0,''+replicate(31,'')+'');
     Writelist(top+x-1);

     ch := readkey;
     Case ch of
       #0  : Begin
               ch := readkey;
               Case ch of
                #80 : {down}     begin
                                   if x < 16 then
                                     begin
                                       if area.exportnr > x then
                                         inc(X);
                                     end else
                                       if top+16 <= area.exportnr then
                                         inc(top);
                                 end;
                #72 : {up}       begin
                                   if x > 1 then dec(X) else
                                     if top > 1 then
                                       dec(top);
                                 end;
                #81 : {pagedown} begin
                                   if x = 16 then
                                     begin
                                       if top+34 <= area.exportnr then
                                         inc(top,16) else
                                           begin
                                             repeat
                                               inc(x);
                                               if x = 17 then begin dec(x); inc(top); end;
                                             until top+x-1 = area.exportnr;
                                           end;
                                     end else
                                     begin
                                       X := 16;
                                       while top+x-1 > area.exportnr do
                                         begin
                                           dec(x);
                                         end;
                                     end;
                                 end;
                #73 : {pageup}   begin
                                   if x = 1 then
                                     begin
                                       if top < 17 then top := 1 else
                                         dec(top,16);
                                     end else X := 1;
                                 end;
                #71 : {home}     begin X := 1; top := 1; end;
                #79 : {end}      begin
                                   while top+x-1 < area.exportnr do
                                     begin
                                       inc(x);
                                       if x = 17 then begin dec(x); inc(top); end;
                                     end;
                                 end;
                #83 : Begin {del}
                        If area.exportnr > 0 then
                          Begin
                            If askwindow('Delete node '+node2str(sfxt^[top+x-1].a)+',','Are you sure?','(Y/N)',
                            ['y','Y','n','N',#27]) in ['y','Y'] then
                              Begin
                                Z := top+x-1;
                                Repeat
                                  sfxt^[z] := sfxt^[z+1];
                                  inc(z);
                                Until z >= area.exportnr;
                                Dec(area.exportnr);
                                if top+x-1 > area.exportnr then
                                  if top > 1 then dec(top) else dec(x);
                              End;
                          End;
                      End;
                #82 : Begin {ins}
                        if area.exportnr < 256 then
                          begin
                            Writeat(28,5,1,0,''+replicate(31,'')+'');
                            Inc(area.exportnr);
                            Fillchar(sfxt^[area.exportnr],sizeof(exporttype),0);
                            sfxt^[area.exportnr].s := [export];
                            select_node_systemlist(4,sfxt^[area.exportnr],area.msgfile = '',area.aka);
                            If (sfxt^[area.exportnr].a.zone <> 0) then
                              begin
                                if not is_dup(area.exportnr-1,sfxt^[area.exportnr].a) then
                                  begin
                                    while top+x-1 < area.exportnr do
                                      begin
                                        inc(x);
                                        if x = 17 then begin dec(x); inc(top); end;
                                      end;
                                    sortsystemlist(area.exportnr);
                                  end else
                                  begin
                                    dec(area.exportnr);
                                    askwindow('','Node '+node2str(sfxt^[area.exportnr+1].a)+' already exists!',
                                      '',[#27,#32,#13]);
                                    fillchar(sfxt^[area.exportnr+1],sizeof(exporttype),0);
                                  end;
                              end else dec(area.exportnr);
                         end else askwindow('','Maximum of 256 links reached','',[#13,#32,#27]);
                      End;
               End;
             End;
       #9  : infoscreen;
       #26 : dosshell;
       #13 : Begin
               if area.exportnr >= top+x-1 then
                 begin
                   Writeat(28,5,1,0,''+replicate(31,'')+'');
                   select_node_systemlist(4,sfxt^[top+x-1],area.msgfile = '',area.aka);
                 end;
             End;
     End;
   End;
  Remove_Window(3);
End;



Procedure DisplaySystemList (X,Y,Size : Byte);
Var
  I, sX      : Byte;
  Tmp        : String[15];
  Bak        : NodeType;
  c1, c2, c3 : byte;
Begin
  i := y;
  repeat
    writeat(x,i,7,0,replicate(80-x,' '));
    inc(i);
  until i > 23;

  sX := X;
  BAK.Zone  := 0;
  BAK.Net   := 0;
  BAK.Node  := 0;
  BAK.Point := 0;

  if not mono then
    begin
      c1 := 0; c2 := 0; c3 := 0;
      for I := 1 to size do  {kijken of er meer dan 2 kleuren nodig zijn}
        begin
          if (export in sfxt^[i].s) and (import in sfxt^[i].s) then inc(c3) else
          if export in sfxt^[i].s then inc(c2) else
          if import in sfxt^[i].s then inc(c1);
        end;

      if c3 <> 0 then
        begin
          if c2 = 0 then c3 := 15 else
           if c1 = 0 then c3 := 15 else c3 := 14;
        end;

      if c1 <> 0 then
        begin
          if c3 = 0 then c1 := 15 else
            if c2 = 0 then c1 := 7 else
              begin
                c1 := 15;
                c3 := 14;
              end;
        end;

    end else
    begin
      c3 := 7;
      c1 := 15;
    end;

  for I := 1 to SIZE
  do begin
    TMP := Node2Str(sfxt^[I].A);

    if sfxt^[I].A.Zone = BAK.Zone
    then Delete (TMP,1,Pos(':',TMP));
    if sfxt^[I].A.Net  = BAK.Net
    then Delete (TMP,1,Pos('/',TMP));
    if sfxt^[I].A.Node = BAK.Node
    then Delete (TMP,1,Pos('.',TMP)-1);

    BAK := sfxt^[I].A;

    if X + Length(TMP) > 78
    then begin
      Inc (Y);
      if y > 23 then
        Begin
          writeat(x,y-1,12,0,chr(26));
          exit;
        End;
      X := sX;
    end;

    if (export in sfxt^[i].s) and (import in sfxt^[i].s) then writeat(x,y,c3,0,tmp+' ') else
    if export in sfxt^[i].s then writeat(x,y,foreentry,0,tmp+' ') else
    if import in sfxt^[i].s then writeat(x,y,c1,0,tmp+' ')
      else writeat(x,y, 12,0, tmp+' ');  { no send or receive status: in red }

    X := X + Length(TMP) + 1;
  end;
end;



Procedure DisplayArea;
Var tmp : string;
Begin
  writeat(17, 3,3,0,expand(area.tag,30));
  writeat(17, 4,3,0,expand(area.name,50));

  if area.grp = 0 then writeat(17,5,3,0,expand('0 - Unknown group',26)) else
    writeat(17, 5,3,0,expand(int_to_str(area.grp)+' - '+gfx[area.grp].groupname,26));

  if (setup.filebase = 0) or (area.areanr = 0) then
    writeat(17, 6,3,0,expand(area.format,12)) else
      writeat(17, 6,3,0,replicate(12,' '));

  writeat(17, 7,3,0,expand(area.directory,63));

  if (setup.filebase = 0) or (area.areanr = 0) then
    writeat(17, 8,3,0,expand(area.listspec,63)) else
      writeat(17,8,3,0,expand('('+int_to_str(bbsarea.nr)+') '+bbsarea.name,63));

  writeat(17, 9,3,0,expand(area.batchfile,12));
  writeat(17,10,3,0,expand(area.msgfile,63));

  Writeat(17,11,foreentry,backentry,expand(WriteGroups(63,area.msgid),63));

  If not (convert in area.Rearchive) then
    Writeat(17,12,foreentry,backentry,expand('No',11)) else
      begin
        if setup.extarchiver = '' then
          Writeat(17,12,foreentry,backentry,'Yes, to '+zipstr[area.usearchiver]) else
            Writeat(17,12,foreentry,backentry,'Yes');
      end;

  If (area.Keepdays = 0) and (area.Keepamount = 0) then
    Writeat(17,13,foreentry,backentry,expand('No',63)) else
      If (area.Keepdays <> 0) and (area.Keepamount <> 0) then
        Writeat(17,13,foreentry,backentry,expand('Max '
        +int_to_str(area.keepamount)+' files, '+int_to_str(area.keepdays)+' days',63)) else
          If area.Keepamount <> 0 then
            Writeat(17,13,foreentry,backentry,expand('Max '+int_to_str(area.keepamount)+' files',63)) else
              Writeat(17,13,foreentry,backentry,expand('Max '+int_to_str(area.keepdays)+' days',63));

  if area.replacemode = 0 then writeat(17,14,foreentry,backentry,'No replace') else
  if area.replacemode = 1 then writeat(17,14,foreentry,backentry,'Replace   ') else
  if area.replacemode = 2 then writeat(17,14,foreentry,backentry,'Move file ');

  if area.costperblock = 0 then
    begin
      if area.incluplink then writeat(17,15,foreentry,backentry,expand('Only uplink costs',63)) else
        writeat(17,15,foreentry,backentry,expand('Disabled',63));
    end else
    begin
      case area.block of
        0 : tmp := '100 kb';
        1 : tmp := '1024 kb';
        2 : tmp := 'file';
      end;
      if area.addpercent <> 0 then tmp := tmp + ' (+'+int_to_Str(area.addpercent)+'%)';
      if area.incluplink then tmp := tmp + ' (+ uplink charges)';
      writeat(17,15,foreentry,backentry,expand(int_to_str(area.costperblock)+' cents per '+tmp,63));
    end;

  writeat(27,16,foreentry,backentry,yesno(crc in area.status));
  writeat(42,16,foreentry,backentry,yesno(dupcheck in area.status));
  writeat(57,16,foreentry,backentry,yesno(fuzzydup in area.status));
  writeat(73,16,foreentry,backentry,yesno(tiny in area.status));

  writeat(27,17,foreentry,backentry,yesno(secure in area.status));
  writeat(42,17,foreentry,backentry,yesno(backup in area.status));
  writeat(57,17,foreentry,backentry,yesno(hide in area.status));
  writeat(73,17,foreentry,backentry,yesno(virus in area.status));

  writeat(27,18,foreentry,backentry,yesno(importdiz in area.status));
  writeat(42,18,foreentry,backentry,yesno(longdesc in area.status));
  writeat(57,18,foreentry,backentry,yesno(annnew in area.status));
  writeat(73,18,foreentry,backentry,yesno(hatchnew in area.status));

  writeat(27,19,foreentry,backentry,yesno(test in area.status));
  writeat(42,19,foreentry,backentry,yesno(noti in area.status));
  writeat(57,19,foreentry,backentry,yesno(disc in area.status));

  if area.AKA > 0
    then Writeat(17,20,foreentry,backentry, expand(Node2Str(SETUP.Address[area.AKA]),63))
      else Writeat(17,20,foreentry,backentry,expand('AKA matching   ',63));

  displaysystemlist(17,21,area.exportnr);
End;


procedure editarealist(welke:byte);
Var res : word;
Begin
  If setup.exteditor <> '' then
    begin
      cursor_on;
      savescreen;
      case welke of
       4 : begin
             if (area.format <> '') and (setup.tplpath <> '') then
               res := fmExec(setup.exteditor,setup.tplpath+area.format, setup.SwapMethode, $ffff, false, false);
           end;
       7 : begin
             if (area.batchfile <> '') then
               res := fmExec(setup.exteditor,systempath+area.batchfile, setup.SwapMethode, $ffff, false, false);
           end;
       8 : begin
             if (area.msgfile <> '') then
               res := fmExec(setup.exteditor,area.msgfile, setup.SwapMethode, $ffff, false, false);
           end;
      end;
      restorescreen;
      cursor_off;
    end;
End;



Function AreaEdit(newrecord:boolean;active:word) : Boolean;  {true if changed}
Var
  abak  : areatype;
  Ch    : Char;
  X     : Byte;
  Tmp   : String;
  k1,k2 : string;
  count : word;
  abort : boolean;
  found : boolean;
Begin
  x := 1;
  ch := #0;
  abort := false;
  while ch <> #27 do
    begin
      areawrite(x);
      areahelp(x);
      displayarea;
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                 #67 : {f9}       begin ch := #27; abort := true; end;
                 #68 : {f10}      if area_ok(newrecord) then ch := #27;
                 #80 : {down}     if x < 16 then inc(X) else x := 1;
                 #72 : {up}       if x > 1 then dec(X) else x := 16;
                 #81 : {pagedown} X := 16;
                 #73 : {pageup}   X := 1;
                 #71 : {home}     X := 1;
                 #79 : {end}      X := 16;
                 #60 : editarealist(x); {f2}
                end;
              end;
        #9  : infoscreen;
        #26 : dosshell;
        #13 : begin
                case x of
                  1 : begin
                        tmp := area.tag;
                        read_string(17,3,20,20,tmp,c_all);
                        tmp := replace(' ','_',tmp);
                        found := false;

                        if not newrecord and (tmp <> area.tag) then
                          begin
                            For count := 1 to AreaIdx do
                              begin
                                k1 := afxt^[count].tag;
                                if length(k1) > 16 then k1 := first(16,k1);
                                k2 := tmp;
                                if length(k2) > 16 then k2 := first(16,k2);
                                If (upper(k1) = upper(k2)) and
                                   (count <> active) then Found := true;
                              end;
                            If Found then
                              Begin
                                AskWindow('Areatag',k2,'already exist',[#13,#27,#32]);
                              End else area.tag := upper(tmp);
                          end else  area.tag := upper(tmp);

                        if (area.exportnr = 0) and (area.tag <> '') and newrecord then
                          begin
                            if askwindow(' Insert connections from an ','existing area?','(Y/N)',['y','Y','n','N',#27])
                            in ['y','Y'] then
                              begin
                                count := select_area(3,1);
                                if count <> 0 then
                                  begin
                                    seek(af,afxt^[count].arearec);
                                    blockread(af,abak,sizeof(abak),count);
                                    if count = sizeof(abak) then
                                      begin
                                        BlockRead(Af, Sfxt^, (abak.exportnr*sizeof(exporttype)), count);
                                        if count <> abak.exportnr*sizeof(exporttype) then
                                          askwindow('','Error reading feedlist: AREAFILE.FM','',[#13,#27,#32]) else
                                            area.exportnr := abak.exportnr;
                                      end else
                                        askwindow('','Error reading AREAFILE.FM','',[#13,#27,#32]);
                                  end;
                              end;
                          end;
                      end;
                  2 : begin
                        tmp := area.name;
                        read_string(17,4,50,50,tmp,c_all);
                        area.name := tmp;
                      end;
                  3 : begin
                        if area.grp = 0 then area.grp := 1;
                        tmp := int_to_str(select_group(3,area.grp));
                        if (str_to_int(tmp) <> 0) then
                          begin
                            area.grp := str_to_int(tmp);
                            if askwindow(' Copy the default settings from ','group '+int_to_str(area.grp)+' to this area?',
                            '(Y/N)',['y','Y','n','N',#27]) in ['y','Y'] then
                              begin
                                if gfx[area.grp].recnr <> 0 then
                                  begin
                                    assign(gf,systempath+'groups.fm');
                                    {$I-} reset(gf); {$I+}
                                    If ioresult <> 0 then
                                      askwindow('','Cannot open '+systempath+'GROUPS.FM','',[#13,#27,#32]) else
                                        begin
                                          seek(gf,gfx[area.grp].recnr-1);
                                          read(gf,group);
                                          close(gf);

                                          area.Format       := group.format;
                                          area.Directory    := group.directory;
                                          area.ListSpec     := group.listspec;
                                          area.Rearchive    := group.rearchive;
                                          area.UseArchiver  := group.usearchiver;
                                          area.BatchFile    := group.batchfile;
                                          area.Aka          := group.aka;
                                          area.Status       := group.status;
                                          area.ReplaceMode  := group.replacemode;
                                          area.Msgid        := group.msgid;
                                          area.MsgFile      := group.msgfile;
                                          area.KeepDays     := group.keepdays;
                                          area.KeepAmount   := group.keepamount;
                                          area.CostPerBlock := group.costperblock;
                                          area.Block        := group.block;
                                          area.AllLinks     := group.alllinks;
                                          area.AddPercent   := group.addpercent;
                                          area.inclhost     := group.inclhost;
                                          area.incluplink   := group.incluplink;
                                          area.usebanner    := group.usebanner;
                                        end;
                                  end;
                              end;
                          end;
                      end;
                  4 : begin
                        tmp := select_tpl(3,area.format,true);
                        if tmp <> '' then area.format := tmp else
                          begin
                            tmp := area.format;
                            read_String(17,6,12,12,tmp,c_all);
                            area.format := tmp;
                          end;
                      end;
                  5 : begin
                        tmp := area.directory;
                        read_string(17,7,63,80,tmp,c_all);
                        checkpath(tmp);
                        if (upper(area.directory) <> upper(tmp)) and (tmp <> '') then
                          Begin
                            area.directory := upper(tmp);
                            if askwindow(' Update list file with ','new directory?','(Y/N)',['y','Y','n','N',#27])
                            in ['y','Y'] then
                              Begin
                                Case Setup.filebase of
                                  0 : Begin
                                        Area.listspec := area.directory;
                                        If last(1,area.listspec) <> '\' then area.listspec := area.listspec + '\';
                                        Area.listspec := area.listspec + 'FILES.BBS';
                                      End;
                                  1 : Begin
                                        If not exist(systempath+'filearea.fm') then
                                          Begin
                                            AskWindow ('FILEAREA.FM not found!', 'Please run FMCONV to create this file.',
                                            '[Enter] to continue', [#13,#27]);
                                            Area.Listspec := area.directory;
                                            If last(1,area.listspec) <> '\' then area.listspec := area.listspec + '\';
                                            Area.listspec := area.listspec + 'FILES.BBS';
                                            Area.Areanr := 0;
                                          End Else
                                          Begin
                                            Area.Areanr := GetBbsArea(area.Directory);
                                            If Area.areanr = 0 then
                                              Begin
                                                AskWindow ('Directory not found',
                                                  'using FILES.BBS file as listfile',
                                                '[Enter] to continue', [#13,#27]);
                                                Area.listspec := area.directory;
                                                If last(1,area.listspec) <> '\' then area.listspec := area.listspec + '\';
                                                Area.listspec := area.listspec + 'FILES.BBS';
                                                Area.areanr := 0;
                                              End;
                                          End;
                                      End;
                                End; {case}
                              End;
                          End Else
                        If tmp = '' then
                          Begin
                            If Askwindow('Without a path this','area is passthru','(Y/N)',['y','Y','n','N'])
                              in ['y','Y'] then
                                Begin
                                  area.directory := '';
                                  area.status := area.status + [backup];
                                  area.listspec := '';
                                  area.areanr := 0;
                                End;
                          End;
                      End;
                  6 : Begin
                        case setup.filebase of
                          0 : begin
                                tmp := area.listspec;
                                read_string(17,8,63,80,tmp,c_all);
                                area.listspec := tmp;
                              end;
                          1 : begin
                                If exist(systempath+'filearea.fm') then
                                  Begin
                                    writeat(1,25,7,0,expand('Select the filebase or press [space] for files.bbs type',79));
                                    area.areanr := Select_FileAreas(3,true,area.areanr);
                                    If area.areanr = 0 then
                                      begin
                                        tmp := area.listspec;
                                        read_string(17,8,63,80,tmp,c_all);
                                        area.listspec := tmp;
                                      end else
                                      begin
                                        tmp := getbbsareanaam(area.areanr);
                                        if area.directory = '' then
                                          area.directory :=  bbsarea.path;
                                      end;
                                  End Else
                                  Begin
                                    AskWindow ('FILEAREA.FM not found!', 'Please run FMCONV to create this file.',
                                    '[Enter] to continue', [#13,#27]);
                                    area.areanr := 0;
                                  End;
                              end;
                        end; {case}
                      end;
                  7 : begin
                        tmp := area.batchfile;
                        read_string(17,9,12,12,tmp,c_all);
                        area.batchfile := upper(tmp);
                        if (area.batchfile <> '') and not exist(systempath+area.batchfile) then
                          begin
                            if askwindow(upper(systempath)+area.batchfile,'does not exist!','Create (Y/N) ?',['y','Y','n','N'])
                              in ['y','Y'] then create_file(systempath+area.batchfile);
                          end;
                      end;
                  8 : begin
                        tmp := area.msgfile;
                        read_string(17,10,63,80,tmp,c_all);
                        area.msgfile := tmp;
                      end;
                  9 : Select_messages(3,area.msgid,false);
                  10: Select_Rearchiving(3,area.rearchive,area.Usearchiver,area.usebanner);
                  11: Select_Cleanup(3,area.Keepdays, area.KeepAmount);
                  12: begin
                        inc(area.replacemode);
                        if area.replacemode = 3 then area.replacemode := 0;
                      end;
                  13: Select_CostSharing(3,area.CostPerBlock,area.Block,area.AllLinks,area.AddPercent,
                          area.inclhost,area.incluplink);
                  14: Select_AreaStatus(3, true, area.status);
                  15: begin
                        choosehook := dummy;
                        area.aka := Select_Address(3,area.aka,true);
                      end;
                  16: Edit_SystemList; {connection list}
                end;
              end;
        #27 : if not area_ok(newrecord) then ch := #0;
      end;
      if (setup.filebase <> 0) and (area.areanr > 0) then if x = 4 then {voor tpl, hoeft niet bij filebase}
        begin
          if ch = #80 then x := 5 else
            if ch = #72 then x := 3;
        end;
    End;
  AreaWrite(0);
  Areaedit := abort;
End;


Procedure AreaLoop;

Var
  ont     : word;
  Ch      : Char;
  AreaBak : AreaType;
  Count   : word;
  Active  : Word;
  Tmp     : String;
  ge      : word;
Type
  SbakFx = Array[1..512] of ExportType;
Var
  Sbakfxt : ^Sbakfx;
Begin
  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      AskWindow('','Not enough memory left','',[#13,#27,#32]);
      Exit;
    End Else New(Sfxt);

  If MaxAvail < Sizeof(Sbakfxt^) then
    Begin
      Askwindow('','Not enough memory left','',[#13,#27,#32]);
      Dispose(Sfxt);
      Exit;
    End Else New(Sbakfxt);

  with mwin[2] do
    begin
      x1 := 1;
      x2 := 1;
      y1 := 80;
      y2 := 24;
      st := ' Area Manager ';
    end;
  Create_window(2);

  Areawrite(0);
  SortAreaIndex;


  If areaidx > 0 then active := 1 else active := 0;

  ch := #0;
  While ch <> #27 do
    Begin
      if areaidx < 1 then
        begin
          writecolor(25,7,15,0,'^INS^-new ^ESC^-exit');
          writeat(2,1,11,0,replicate(14,''));
        end else
        begin
          WriteColor(25,7,15,0,'^F2^-global ^F3^-copy ^F4^-search ^F5^-browse ^F6^-flow ^INS^-new ^DEL^-delete');
          writeat(2,1,11,0,' '+int_to_str(active)+' of '+int_to_str(areaidx)+' ');

          seek(af,afxt^[active].arearec);
          blockread(af,area,sizeof(area),count);
          if (count = sizeof(area)) then
            begin
              if area.exportnr > 6000 then
                begin
                  area.exportnr := 0;
                  seek(af,filesize(af));
                  afxt^[active].arearec := filesize(af);
                  blockwrite(af,area,sizeof(area));
                  write(^g);
                  seek(af,afxt^[active].arearec);
                  blockread(af,area,sizeof(area));
                end;

              fillchar(sfxt^,sizeof(sfxt^),0);
              BlockRead(Af, Sfxt^, (area.exportnr*sizeof(exporttype)), count);
              if count = area.exportnr*sizeof(exporttype) then
                begin
                  if (setup.filebase <> 0) and (area.areanr <> 0) then
                    GetBbsAreaNaam(area.areanr);
                  displayarea;
                end else
                  askwindow('','Error reading feedlist: AREAFILE.FM','',[#13,#27,#32]);
            end else
            begin
              askwindow('','Error reading AREAFILE.FM','',[#13,#27,#32]);
              remove_window(2);
              Dispose(Sfxt);
              Dispose(Sbakfxt);
              Exit;
            end;
        end;

      AreaWrite(0);

      Ch := readkey;
      Case ch of
       #0  : begin
               Ch := Readkey;
               Case Ch of
                 #60 : {f2} globelarea;
                 #62 : begin {f4}
                         Writeat(1,25,7,0,replicate(80,' '));
                         Tmp := '';
                         ont := active;
                         Writeat(1,25,7,0,'Enter search string: ');
                         Read_String(22,25,40,40,tmp,c_all);
                         If Tmp <> '' then
                           Begin
                             Ge := active+1;
                             While (pos(upper(tmp),upper(afxt^[ge].tag)) = 0) and (ge < areaidx) do Inc(ge);
                             If pos(upper(tmp),upper(afxt^[ge].tag)) = 0 then ge := 1;
                             While (pos(upper(tmp),upper(afxt^[ge].tag)) = 0) and (ge < ont) do inc(ge);
                             If pos(upper(tmp),upper(afxt^[ge].tag)) = 0 then
                               Begin
                                 AskWindow('',tmp+' not found!','',[#13,#27,#32]);
                                 active := ont;
                               End Else Active := ge;
                           End;
                       End;
                 #63 : Begin {f5}
                         count := select_area(3,active);
                         if count <> 0 then active := count;
                       End;
                 #64 : Begin
                         ShowFlow(area.flow, area.lastmonth);
                         seek(af,afxt^[active].arearec);
                         blockwrite(af,area,sizeof(area),count);
                         if count <> sizeof(area) then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);
                       End;
                 #75 : begin {left}
                         if active > 1 then dec(active) else write(#7);
                       end;
                 #77 : begin {rght}
                         if active < areaidx then inc(active) else write(#7);
                       end;
                 #71 : {home} if areaidx > 0 then active := 1;
                 #79 : {end}  active := areaidx;
                 #61 : begin {f3}
                         if areaidx < 2500 then
                           begin
                             writeat(2,1,11,0,' '+int_to_str(areaidx+1)+' of '+int_to_str(areaidx)+' ');
                             areabak := area;
                             Move(Sfxt^,sBakfxt^,sizeof(sbakfxt^));

                             if not areaedit(true,active) and not (samerec(area,areabak,sizeof(area)) and
                                samerec(sfxt,sbakfxt,sizeof(sbakfxt))) then
                               begin
                                 if askwindow('','Save changes ? (Y/N)','',['y','Y','n','N'])  in ['y','Y'] then
                                   begin
                                     inc(areaidx);
                                     afxt^[areaidx].arearec := filesize(af);
                                     afxt^[areaidx].tag     := area.tag;
                                     afxt^[areaidx].grp     := area.grp;

                                     for count := 1 to 12 do
                                       begin
                                         area.flow[count].bytes := -1;
                                         area.flow[count].files := -1;
                                       end;

                                     seek(af,filesize(af));
                                     blockwrite(af,area,sizeof(area),count);
                                     if count <> sizeof(area) then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);

                                     blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype),count);
                                     if count <> area.exportnr*sizeof(exporttype)
                                       then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);

                                     sortareaindex;
                                     active := 1;
                                     while (afxt^[active].tag <> area.tag) and (active < areaidx) do inc(active);
                                   end;
                               end;
                           end;
                       end;
                 #82 : begin {ins}
                         if areaidx < 2000 then
                           begin
                             fillchar(area,sizeof(area),#0);
                             fillchar(sfxt^,sizeof(sfxt^),0);

                             writeat(2,1,11,0,' '+int_to_str(areaidx+1)+' of '+int_to_str(areaidx)+' ');

                             area.exportnr := 0;
                             area.Format := 'FILESBBS.TPL';
                             area.AKA    := 1;
                             area.Status := [fuzzydup, CRC, Secure, DupCheck, longdesc];
                             area.listspec  := 'FILES.BBS';
                             area.replacemode := 1;
                             area.newarea := true;
                             for count := 1 to 12 do
                               begin
                                 area.flow[count].bytes := -1;
                                 area.flow[count].files := -1;
                               end;

                             areabak := area;

                             Move(Sfxt^,sBakfxt^,sizeof(sbakfxt^));

                             if not areaedit(true,active) and not (samerec(area,areabak,sizeof(area)) and
                                samerec(sfxt,sbakfxt,sizeof(sbakfxt))) then
                               begin
                                 if askwindow('','Save changes ? (Y/N)','',['y','Y','n','N'])  in ['y','Y'] then
                                   begin
                                     inc(areaidx);
                                     afxt^[areaidx].arearec := filesize(af);
                                     afxt^[areaidx].tag     := area.tag;
                                     afxt^[areaidx].grp     := area.grp;

                                     seek(af,filesize(af));
                                     blockwrite(af,area,sizeof(area),count);
                                     if count <> sizeof(area) then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);

                                     blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype),count);
                                     if count <> area.exportnr*sizeof(exporttype)
                                       then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);

                                     sortareaindex;
                                     active := 1;
                                     while (afxt^[active].tag <> area.tag) and (active < areaidx) do inc(active);
                                   end;
                               end;
                           end else askwindow('','Maximum area entries reached','',[#13,#27,#32]);
                       end;
                 #83 : begin {del}
                         if active > 0 then
                           begin
                             if askwindow('Remove area '+afxt^[active].tag,'Are you sure?','(Y/N)',['y','n','Y','N',#27,#13])
                               in ['y','Y'] then
                                 begin
                                   seek(af,afxt^[active].arearec);
                                   blockread(af,area,sizeof(area),count);
                                   seek(af,afxt^[active].arearec);
                                   area.tag := '';
                                   blockwrite(af,area,sizeof(area));

                                   for count := active to areaidx-1 do
                                     afxt^[count] := afxt^[count+1];
                                   dec(areaidx);
                                   if active > areaidx then active := areaidx;
                                 end;
                           end;
                       end;

               End;
             End;
       #4  : {ctrl-d} begin
                        if askwindow('Remove all connected nodes','from '+afxt^[active].tag,'Are you sure? (Y/N)',
                          ['y','Y','n','N']) in ['Y','y'] then
                            begin
                              seek(af,filesize(af));
                              afxt^[active].arearec := filesize(af);
                              area.exportnr := 0;
                              blockwrite(af,area,sizeof(area));
                            end;
                      end;
       #9  : Infoscreen;
       #26 : dosshell;
       #13 : If areaidx <> 0 then
               Begin
                 Areabak := area;
                 Move(Sfxt^,sBakfxt^,sizeof(sbakfxt^));

                 if not areaedit(false,active) and not (samerec(area,areabak,sizeof(area)) and
                    samerec(sfxt^,sbakfxt^,sizeof(sbakfxt^))) then
                   Begin
                     if askwindow('','Save changes ? (Y/N)','',['y','Y','n','N'])  in ['y','Y'] then
                       Begin
                         if area.exportnr <> areabak.exportnr then
                           afxt^[active].arearec := filesize(af);
                         seek(af,afxt^[active].arearec);

                         blockwrite(af,area,sizeof(area),count);
                         if count <> sizeof(area) then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);

                         blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype),count);
                         if count <> area.exportnr*sizeof(exporttype)
                           then askwindow('','Cannot add to AREAFILE.FM','',[#13,#27,#32]);

                         if (afxt^[active].tag <> area.tag) or
                            (afxt^[active].grp <> area.grp) then
                           begin
                             afxt^[active].tag     := area.tag;
                             afxt^[active].grp     := area.grp;
                             sortareaindex;

                             active := 1;
                             while (afxt^[active].tag <> area.tag) and (active < areaidx) do inc(active);
                           end;
                       End;
                   End;
               End Else Write(#7);
      End;
    End;

  Remove_window(2);
  Dispose(Sbakfxt);
  Dispose(Sfxt);
End;


END.
