{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Setup Groups
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_2;

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec;

Procedure GroupLoop;

Implementation

Procedure F3_Update(grp:byte);
Var
  Ar       : Array[1..12] of String[12];
  Ge       : Byte;
  Tel,
  Count, X : Word;
Begin
  With Mwin[3] do
   Begin
     x1 := 32;
     x2 := 5;
     y1 := 47;
     y2 := 20;
     st := ' Update ';
   End;
  Create_Window(3);

  ar[1] := 'Format Tpl';
  ar[2] := 'Directory';
  ar[3] := 'List file';
  ar[4] := 'Batchfile';
  ar[5] := 'Message file';
  ar[6] := 'Messages';
  ar[7] := 'Re-archive';
  ar[8] := 'Cleanup';
  ar[9] := 'Replace';
  ar[10]:= 'Costsharing';
  ar[11]:= 'Status';
  ar[12]:= 'Seen-by';


  ge := 1;
  while ge <> 0 do
    begin
      Tel := 0;
      Writeat(1,25,7,0,expand('Select the option to update the areafile with',79));
      choosehook := dummy;
      decwin(3);
      ge := select_window(3,12,12,@ar,ge,false);
      incwin(3);
      if ge <> 0 then
        begin
          if askwindow('Update '+upper(ar[ge])+' option',' in all areas with group '+int_to_str(grp)+' ','(Y/N)',
          ['y','Y','n','N',#27]) in ['y','Y'] then
            begin

              For x := 1 to AreaIdx do
                Begin
                  If Afxt^[x].grp = grp then
                    Begin
                      Writeat(1,25,7,0,expand(afxt^[x].tag,79));
                      seek(af,afxt^[x].arearec);
                      blockread(af,area,sizeof(area),count);

                      case ge of
                       1 : area.format := group.format;
                       2 : area.Directory := group.directory;
                       3 : area.Listspec := group.listspec;
                       4 : area.Batchfile := group.batchfile;
                       5 : area.msgfile := group.msgfile;
                       6 : move(group.msgid,area.Msgid,sizeof(group.msgid));
                       7 : begin
                             area.Rearchive := group.rearchive;
                             area.UseArchiver := group.usearchiver;
                           end;
                       8 : begin
                             area.KeepDays := group.keepdays;
                             area.KeepAmount := group.keepamount;
                           end;
                       9 : area.Replacemode := group.replacemode;
                      10 : begin
                             area.CostPerBlock := group.costperblock;
                             area.Block := group.block;
                             area.AllLinks := group.alllinks;
                             area.AddPercent := group.addpercent;
                             AREA.INCluplink := group.incluplink;
                             area.inclhost := group.inclhost;
                           end;
                      11 : area.Status := group.status;
                      12 : area.aka := group.aka;
                      end;

                      inc(tel);
                      seek(af,afxt^[x].arearec);
                      blockwrite(af,area,sizeof(area),count);
                    End;
                End;
              Askwindow('',int_to_str(tel)+' areas updated','',[#13,#32,#27]);
            end;
        end;
    end;
  Remove_Window(3);
end;


Procedure GroupHelp ( Welke : Byte );
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
   1 : writeat(1,25,7,0,'The identification number of this group');
   2 : writeat(1,25,7,0,'The name of this group');
   3 : Begin
         writeat(1,25,7,0,'The Tpl format this group uses as default');
         If (setup.exteditor <> '') and (group.format <> '') then writeat(64,25,14,0,'Press F2 to edit');
       End;
   4 : writeat(1,25,7,0,'The default destination directory for this group');
   5 : writeat(1,25,7,0,'The listfile this group uses as default');
   6 : begin
         writeat(1,25,7,0,'The batchfile that must be executed during processing');
         If (setup.exteditor <> '') and (group.batchfile <> '') then writeat(64,25,14,0,'Press F2 to edit');
       end;
   7 : writeat(1,25,7,0,'The default description to use when description is missing');
   8 : begin
         writeat(1,25,7,0,'The full path to a text file to include in netmail file attach');
         If (setup.exteditor <> '') and (group.msgfile <> '') then writeat(64,25,14,0,'Press F2 to edit');
       end;
   9 : writeat(1,25,7,0,'The message groups to include in announcements');
  10 : writeat(1,25,7,0,'If FileMgr should re-archive every incoming file in this group');
  11 : writeat(1,25,7,0,'If FileMgr should delete files based on date or number');
  12 : writeat(1,25,7,0,'If FileMgr should delete, ignore or copy ''to be replaced'' files');
  13 : Writeat(1,25,7,0,'Costsharing options for this group');
  14 : writeat(1,25,7,0,'The status to use as default for this group');
  15 : writeat(1,25,7,0,'The Aka to use when forwarding files');
  End;
End;


Procedure DisplayGroup(ge:integer);
Var Tmp : String;
Begin
  Writeat(17,3,foreentry,backentry,expand(int_to_str(ge),3));
  Writeat(17,4,foreentry,backentry,expand(group.groupname,50));

  Writeat(17,8,foreentry,backentry,expand(group.format,12));
  Writeat(17,9,foreentry,backentry,expand(group.directory,63));
  Writeat(17,10,foreentry,backentry,expand(group.listspec,63));
  Writeat(17,11,foreentry,backentry,expand(group.batchfile,63));
  Writeat(17,12,foreentry,backentry,expand(group.defaultdesc,60));
  Writeat(17,13,foreentry,backentry,expand(group.msgfile,63));
  Writeat(17,14,foreentry,backentry,expand(WriteGroups(63,group.msgid),63));

  If not (convert in group.Rearchive) then
    Writeat(17,15,foreentry,backentry,expand('No',11)) else
      Begin
        If setup.extarchiver = '' then
          Writeat(17,15,foreentry,backentry,'Yes, to '+zipstr[group.usearchiver]) else
            Writeat(17,15,foreentry,backentry,'Yes');
      End;

  If (group.Keepdays = 0) and (group.Keepamount = 0) then
    Writeat(17,16,foreentry,backentry,expand('No',63)) else
      If (group.Keepdays <> 0) and (group.Keepamount <> 0) then
        Writeat(17,16,foreentry,backentry,expand('Max '
        +int_to_str(group.keepamount)+' files, '+int_to_str(group.keepdays)+' days',63)) else
          If group.Keepamount <> 0 then
            Writeat(17,16,foreentry,backentry,expand('Max '+int_to_str(group.keepamount)+' files',63)) else
              Writeat(17,16,foreentry,backentry,expand('Max '+int_to_str(group.keepdays)+' days',63));

  if group.replacemode = 0 then writeat(17,17,foreentry,backentry,'No replace') else
  if group.replacemode = 1 then writeat(17,17,foreentry,backentry,'Replace   ') else
  if group.replacemode = 2 then writeat(17,17,foreentry,backentry,'Move file ');

  if group.costperblock = 0 then
    begin
      if group.incluplink then writeat(17,18,foreentry,backentry,expand('Only uplink costs',63)) else
        writeat(17,18,foreentry,backentry,expand('Disabled',60));
    end else
    begin
      case group.block of
        0 : tmp := '100 kb';
        1 : tmp := '1024 kb';
        2 : tmp := 'file';
      end;
      if group.addpercent <> 0 then tmp := tmp + ' (+'+int_to_Str(group.addpercent)+'%)';
      if group.incluplink then tmp := tmp + ' (+ uplink charges)';
      writeat(17,18,foreentry,backentry,expand(int_to_str(group.costperblock)+' cents per '+tmp,63));
    end;

  writeat(27,19,foreentry,backentry,yesno(crc in group.status));
  writeat(27,20,foreentry,backentry,yesno(secure in group.status));
  writeat(27,21,foreentry,backentry,yesno(importdiz in group.status));

  writeat(42,19,foreentry,backentry,yesno(dupcheck in group.status));
  writeat(42,20,foreentry,backentry,yesno(backup in group.status));
  writeat(42,21,foreentry,backentry,yesno(longdesc in group.status));

  writeat(57,19,foreentry,backentry,yesno(fuzzydup in group.status));
  writeat(57,20,foreentry,backentry,yesno(hide in group.status));
  writeat(57,21,foreentry,backentry,yesno(annnew in group.status));

  writeat(73,19,foreentry,backentry,yesno(tiny in group.status));
  writeat(73,20,foreentry,backentry,yesno(virus in group.status));
  writeat(73,21,foreentry,backentry,yesno(hatchnew in group.status));

 If group.Aka > 0 then
   Writeat(17,22,foreentry,backentry,Expand(Node2Str(SETUP.Address[group.AKA]),63)) else
     Writeat(17,22,foreentry,backentry,expand('Aka matching',63));
End;


Procedure WriteGroup(active:integer);
Begin
  writeat(2,3, 7,0,' Group number ');
  writeat(2,4, 7,0,' Description  ');

  writeat(2,8, 7,0,' Format .TPL  ');
  writeat(2,9, 7,0,' Directory    ');
  writeat(2,10,7,0,' List file    ');
  writeat(2,11,7,0,' Batchfile    ');
  writeat(2,12,7,0,' Description  ');
  writeat(2,13,7,0,' Message file ');
  writeat(2,14,7,0,' Message(s)   ');
  writeat(2,15,7,0,' Re-archive   ');
  writeat(2,16,7,0,' Cleanup      ');
  writeat(2,17,7,0,' Replace mode ');
  writeat(2,18,7,0,' Costsharing  ');
  writeat(2,19,7,0,' Status       ');

  Writeat(17,19,7,0,'CRC');
  Writeat(33,19,7,0,'Dupcheck');
  Writeat(48,19,7,0,'FuzzyDup');
  Writeat(63,19,7,0,'Tiny');

  Writeat(17,20,7,0,'Secure');
  Writeat(33,20,7,0,'Backup');
  Writeat(48,20,7,0,'Hide');
  Writeat(63,20,7,0,'VirusScan');

  Writeat(17,21,7,0,'ImportDiz');
  Writeat(33,21,7,0,'LongDesc');
  Writeat(48,21,7,0,'AnnNew');
  Writeat(63,21,7,0,'HatchNew');

  writeat(2,22,7,0,' Seen-by      ');

  case active of
   1 : writeat(2,3,kl4,kl5,' Group number ');
   2 : writeat(2,4,kl4,kl5,' Description  ');
   3 : writeat(2,8,kl4,kl5,' Format .TPL  ');
   4 : writeat(2,9,kl4,kl5,' Directory    ');
   5 : writeat(2,10,kl4,kl5,' List file    ');
   6 : writeat(2,11,kl4,kl5,' Batchfile    ');
   7 : writeat(2,12,kl4,kl5,' Description  ');
   8 : writeat(2,13,kl4,kl5,' Message file ');
   9 : writeat(2,14,kl4,kl5,' Message(s)   ');
  10 : writeat(2,15,kl4,kl5,' Re-archive   ');
  11 : writeat(2,16,kl4,kl5,' Cleanup      ');
  12 : writeat(2,17,kl4,kl5,' Replace mode ');
  13 : writeat(2,18,kl4,kl5,' Costsharing  ');
  14 : writeat(2,19,kl4,kl5,' Status       ');
  15 : writeat(2,22,kl4,kl5,' Seen-by      ');
  End;
End;


procedure editgrouplist(welke:byte);
Var res : word;
Begin
  If setup.exteditor <> '' then
    begin
      cursor_on;
      savescreen;
      case welke of
       3 : begin
             if (group.format <> '') and (setup.tplpath <> '') then
               res := fmExec(setup.exteditor,setup.tplpath+group.format, setup.SwapMethode, $ffff, false, false);
           end;
       6 : begin
             if (group.batchfile <> '') then
               res := fmExec(setup.exteditor,systempath+group.batchfile, setup.SwapMethode, $ffff, false, false);
           end;
       8 : begin
             if (group.msgfile <> '') then
               res := fmExec(setup.exteditor,group.msgfile, setup.SwapMethode, $ffff, false, false);
           end;
      end;
      restorescreen;
      cursor_off;
    end;
End;

Procedure EditGroup(var rec:integer);
Var
  ge, x : integer;
  ch    : char;
  tmp   : string;
  grp   : grouptype;
  bol   : booleanset;
Begin
  for ge := 1 to 256 do bol[x] := false;
  bol[rec] := true;
  ge := 1;
  move(group,grp,sizeof(group));

  Repeat
    grouphelp(ge);
    writegroup(ge);
    displaygroup(rec);
    ch := readkey;
    case ch of
     #0 : begin
            ch := readkey;
            case ch of
              #72 : {up} if ge > 1 then dec(ge) else ge := 15;
              #80 : {down} if ge < 15 then inc(ge) else ge := 1;
              #67 : {f9}   begin ch := #27; move(grp,group,sizeof(group)); end;
              #68 : {f10}  ch := #27;
              #60 : editgrouplist(ge); {f2}
            end;
          end;
     #9 : infoscreen;
     #26: dosshell;
     #13: begin
            case ge of
             1 : if samerec(group,grp,sizeof(group)) then
                 begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   select_groups(3,bol,true);
                   writeat(1,6,11,0,''+replicate(78,'')+'');

                   rec := 0;
                   repeat
                     inc(rec);
                   until (rec > 255) or bol[rec];

                   if gfx[rec].recnr <> 0 then
                     begin
                       seek(gf,gfx[rec].recnr-1);
                       read(gf,group);
                     end else
                     begin
                       fillchar(group,sizeof(group),#0);
                       group.groupnr     := rec;
                       group.format      := 'FILESBBS.TPL';
                       group.listspec    := 'FILES.BBS';
                       group.replacemode := 1;
                       group.status      := [fuzzydup,crc,secure,longdesc,dupcheck];
                       group.defaultdesc := '[No Description, Inform Sysop]';
                       group.aka         := 1;
                     end;
                   move(group,grp,sizeof(group));
                   displaygroup(rec);
                 end;
             2 : begin
                   tmp := group.groupname;
                   read_string(17,4,40,40,tmp,c_all);
                   group.groupname := tmp;
                   gfx[rec].groupname := tmp;
                 end;
             3 : begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   tmp := Select_Tpl(3,group.format,true);
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                   if tmp <> '' then group.format := tmp else
                     begin
                       tmp := group.format;
                       read_string(17,8,12,12,tmp,c_all);
                       group.format := tmp;
                     end;
                 end;
             4 : begin {directory}
                   tmp := group.directory;
                   read_string(17,9,63,80,tmp,c_all);
                   checkpath(tmp);
                   if (upper(tmp) <> upper(group.directory)) and (tmp <> '') then
                     begin
                       group.directory := upper(tmp);
                       if askwindow(' Update list file with ','new directory?','(Y/N)',['y','Y','n','N',#27])
                       in ['y','Y'] then
                         begin
                           group.listspec := group.directory;
                           if last(1,group.listspec) <> '\' then group.listspec := group.listspec +'\';
                           group.listspec := group.listspec + 'FILES.BBS';
                         end;
                     end;
                 end;
             5 : begin {list file}
                   tmp := group.listspec;
                   read_string(17,10,63,80,tmp,c_all);
                   group.listspec := tmp;
                 end;
             6 : begin {batch file}
                   tmp := group.batchfile;
                   read_string(17,11,63,80,tmp,c_all);
                   group.batchfile := upper(tmp);
                   if (group.batchfile <> '') and not exist(systempath+group.batchfile) then
                     begin
                       if askwindow(upper(systempath)+group.batchfile,'does not exist!','Create (Y/N) ?',['y','Y','n','N'])
                         in ['y','Y'] then create_file(systempath+group.batchfile);
                     end;
                 end;
             7 : begin {description}
                   tmp := group.defaultdesc;
                   read_string(17,12,63,60,tmp,c_all);
                   group.defaultdesc := tmp;
                 end;
             8 : begin {msgfile}
                   tmp := group.msgfile;
                   read_string(17,13,63,60,tmp,c_all);
                   group.msgfile := tmp;
                 end;
             9 : begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   select_messages(3,group.msgid,false);  {msgs}
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                 end;
            10 : begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   select_rearchiving(3,group.rearchive,group.usearchiver,group.usebanner); {rearchive}
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                 end;
            11 : begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   select_cleanup(3,group.keepdays,group.keepamount); {cleanup}
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                 end;
            12 : begin
                   inc(group.replacemode);
                   if group.replacemode = 3 then group.replacemode := 0;
                 end; {replace}
            13 : begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   Select_CostSharing(3,group.CostPerBlock,group.Block,group.AllLinks,
                     group.AddPercent,group.inclhost,group.incluplink);
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                 end; {costsharing}
            14 : begin
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   select_areastatus(3,false,group.status); {status}
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                 end;
            15 : begin
                   choosehook := dummy;
                   writeat(1,6,1,0,''+replicate(78,'')+'');
                   group.aka := Select_Address(3,group.aka,true); {aka}
                   writeat(1,6,11,0,''+replicate(78,'')+'');
                 end;
            end;
          end;
    end;
  Until ch = #27;

  If not Samerec(group,grp,sizeof(group)) then
    Begin
      If Askwindow('','Save changes? (Y/N)','',['y','Y','n','N']) in ['Y','y'] then
        Begin
          If gfx[rec].recnr = 0 then gfx[rec].recnr := filesize(gf)+1;
          if filesize(gf) > 0 then Seek(gf,gfx[rec].recnr-1);
          Write(gf, group);
        End;
    End;
End;


Function Remove_Areas_from_Group( ge:byte ) : Word;
Var x, amount,
    count      : word;
Begin
  Amount := 0;
  x := 1;
  Repeat
    If afxt^[x].grp = ge then
      Begin
        Inc(amount);
        If x < areaidx then
          Begin
            For count := x to areaidx-1 do
              afxt^[count] := afxt^[count+1];
            Dec(areaidx);
          End Else dec(areaidx);
        X := 0;
      End;
    Inc(x);
  Until X > Areaidx;
  Remove_Areas_From_Group := Amount;
End;


Procedure GroupLoop;
Var
  Ge, x : Integer;
  Ch    : Char;
  Tmp   : String;
  Grp   : Grouptype;
  Found : Boolean;
  Bol   : BooleanSet;
Begin
  for x := 1 to 256 do bol[x] := false;

  assign(gf,systempath+'groups.fm');
  {$I-} reset(gf); {$I+}
  If ioresult <> 0 then
    begin
      askwindow('','Cannot open '+systempath+'GROUPS.FM','',[#13,#27,#32]);
      exit;
    end;

  with mwin[2] do
    begin
      x1 := 1;
      x2 := 1;
      y1 := 80;
      y2 := 24;
      st := ' Group Manager ';
    end;
  create_window(2);
  writeat(1,6,11,0,''+replicate(78,'')+'');

  ge := 1;
  ch := #0;

  repeat
    writegroup(0);

    if filesize(gf) < 1 then
      begin
        writecolor(25,7,15,0,'^INS^-new ^ESC^-exit');
        writeat(2,1,11,0,replicate(14,''));
      end else
      begin
        WriteColor(25,7,15,0,'^F3^-update ^F4^-search ^F5^-browse ^F6^-flow ^INS^-new ^DEL^-delete ^ENTER^-edit ^ESC^-exit');
        writeat(2,1,11,0,' '+int_to_str(ge)+' of 255 ');

        if gfx[ge].recnr <> 0 then
          begin
            seek(gf,gfx[ge].recnr-1);
            read(gf,group);
          end else
            fillchar(group,sizeof(group),#0);
        displaygroup(ge);
      end;

    ch := readkey;

    if ch = #13 then
      begin
        If gfx[ge].recnr = 0 then
          begin
            group.groupnr     := ge;
            group.format      := 'FILESBBS.TPL';
            group.listspec    := 'FILES.BBS';
            group.replacemode := 1;
            group.status      := [fuzzydup,crc,secure,longdesc,dupcheck];
            group.defaultdesc := '[No Description, Inform Sysop]';
            group.aka         := 1;
            for x := 1 to 12 do
              begin
                group.flow[x].bytes := -1;
                group.flow[x].files := -1;
              end;
          end;
        editgroup(ge);
      end;
    if ch = #9 then infoscreen;
    if ch = #26 then dosshell;

    case ch of
      #0 : Begin
             Ch := readkey;
             If ch = #82 then {ins}
               Begin
                 for x := 1 to 256 do bol[x] := false;

                 Ge := 1;                    {zoeken naar eerste lege record}
                 While (ge < 256) and (gfx[ge].recnr <> 0) do inc(ge);

                 If ge = 256 then
                   Begin
                     Askwindow('','All 255 groups are full!','',[#27,#32,#13]);
                   End Else
                   Begin
                     bol[ge] := true;

                     Writeat(1,6,1,0,''+replicate(78,'')+'');
                     Select_Groups(3,bol,true);
                     Writeat(1,6,11,0,''+replicate(78,'')+'');

                     ge := 0;
                     repeat
                       inc(ge)
                     until (ge > 255) or bol[ge];

                     If ge < 256 then
                       Begin
                         If gfx[ge].recnr <> 0 then
                           Begin
                             seek(gf,ge-1);
                             read(gf,group);
                           End Else
                           Begin
                             Seek(gf,filesize(gf));
                             fillchar(group,sizeof(group),#0);
                             group.groupnr     := ge;
                             group.format      := 'FILESBBS.TPL';
                             group.listspec    := 'FILES.BBS';
                             group.replacemode := 1;
                             group.status      := [fuzzydup,crc,secure,longdesc,dupcheck];
                             group.defaultdesc := '[No Description, Inform Sysop]';
                             group.aka         := 1;
                             for x := 1 to 12 do
                               begin
                                 group.flow[x].bytes := -1;
                                 group.flow[x].files := -1;
                               end;
                           End;
                         displaygroup(ge);
                         editgroup(ge);
                       End;
                   End;
               End;

             if filesize(gf) > 0 then
               begin
                 case ch of
                   #83 : Begin {del}
                           If gfx[ge].recnr <> 0 then
                             Begin
                               If Askwindow('Remove group '+int_to_str(ge),'Are you sure?','(Y/N)',['y','Y','n','N',#13,#27])
                               in ['Y','y'] then
                                 Begin
                                   seek(gf,gfx[ge].recnr-1);
                                   fillchar(group, sizeof(group), #0);
                                   for x := 1 to 12 do
                                     begin
                                       group.flow[x].bytes := -1;
                                       group.flow[x].files := -1;
                                     end;
                                   write(gf,group);
                                   gfx[ge].recnr := 0;
                                   gfx[ge].groupname := '';

                                   displaygroup(ge);

                                   If Askwindow('Remove all areas from','group '+int_to_str(ge)+' also?','(Y/N)',
                                   ['y','Y','n','N',#13,#27]) in ['Y','y'] then
                                     Begin
                                       Askwindow('',int_to_str(Remove_Areas_From_Group(ge))+' areas removed','',[#32,#27,#13]);
                                     End;
                                 End;
                             End;
                         End;
                   #61 : begin {f3}
                           Writeat(1,6,1,0,''+replicate(78,'')+'');
                           f3_update(ge);
                           Writeat(1,6,11,0,''+replicate(78,'')+'');
                         end;
                   #62 : begin {f4}
                           Writeat(1,25,7,0,replicate(80,' '));
                           Tmp := '';
                           Writeat(1,25,7,0,'Enter search string: ');
                           Read_String(22,25,40,40,tmp,c_all);

                           If Tmp <> '' then
                             Begin
                               Ge := 0;
                               While (pos(upper(tmp),upper(gfx[ge].groupname)) = 0) and (ge < 256) do
                                 Inc(ge);
                               If ge = 256 then
                                 Begin
                                   AskWindow('',tmp+' not found!','',[#13,#27,#32]);
                                   Ge := 1;
                                 End Else
                                   Displaygroup(ge);

                               WriteColor(25,7,15,0,'^F3^-update ^F4^-search ^F5^-browse ^F6^-flow ^INS^-new '+
                                 '^DEL^-delete ^ENTER^-edit ^ESC^-exit');
                             End;
                         End;
                   #63 : begin {f5}
                           Writeat(1,6,1,0,''+replicate(78,'')+'');
                           ge := select_group(3,ge);
                           Writeat(1,6,11,0,''+replicate(78,'')+'');
                         end;
                   #64 : begin
                           ShowFlow(group.flow, group.lastmonth);
                           Seek(gf,gfx[ge].recnr-1);
                           Write(gf, group);
                         end;
                   #79 : ge := 255; {end}
                   #71 : ge := 1;   {home}
                   #77 : begin {left}
                           if ge+1 < 256 then
                             begin
                               if ge+1 > filesize(gf) then
                                 inc(ge) else
                                   begin
                                     seek(gf,ge);
                                     read(gf,group);
                                     inc(ge);
                                   end;
                             end else write(#7);
                         end;
                   #75 : begin {right}
                           if ge-1 > 0 then
                             begin
                               if ge-1 > filesize(gf) then
                                 dec(ge) else
                                   begin
                                     seek(gf,ge-2);
                                     read(gf,group);
                                     dec(ge)
                                   end;
                             end else write(#7);
                         end;
                 end; {case}
               end;
           end; { #0 }
    end; {case}

  until ch = #27;

  remove_Window(2);
  close(gf);
End;


END.
