 {
 $Id$
 }
{*****************************************************************************
 *
 * Purpose ...............: Setup Top end main system loop
 *
 * 08/02/08 VBC - update date in copyright chg fido addr
 * 04/03/08 vbc - spelling errors
 * 19/03/08 vbc - remove registration from menus
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_1;

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec;

Procedure SystemLoop;

Implementation


{  ------------ SYSTEM ADDRESS LOOP -------------}


Procedure AdressLoop;
Var
  Ch  : Char;
  Ge  : Integer;
  Tmp : String;
  Bol : Boolean;

  Procedure WriteAddress(ge:integer);
  Var x : integer;
  Begin
    for x := 1 to 10 do writeat(23,9+x,foreentry,backentry,first(18,node2str(setup.address[x])));
    for x := 11 to 20 do writeat(56,9+x-10,foreentry,backentry,first(18,node2str(setup.address[x])));

    Writeat(8,10,7,0,' Main Address ');
    Writeat(8,11,7,0,' AKA #1       ');
    Writeat(8,12,7,0,' AKA #2       ');
    Writeat(8,13,7,0,' AKA #3       ');
    Writeat(8,14,7,0,' AKA #4       ');
    Writeat(8,15,7,0,' AKA #5       ');
    Writeat(8,16,7,0,' AKA #6       ');
    Writeat(8,17,7,0,' AKA #7       ');
    Writeat(8,18,7,0,' AKA #8       ');
    Writeat(8,19,7,0,' AKA #9       ');

    Writeat(41,10,7,0,' AKA #10      ');
    Writeat(41,11,7,0,' AKA #11      ');
    Writeat(41,12,7,0,' AKA #12      ');
    Writeat(41,13,7,0,' AKA #13      ');
    Writeat(41,14,7,0,' AKA #14      ');
    Writeat(41,15,7,0,' AKA #15      ');
    Writeat(41,16,7,0,' AKA #16      ');
    Writeat(41,17,7,0,' AKA #17      ');
    Writeat(41,18,7,0,' AKA #18      ');
    Writeat(41,19,7,0,' AKA #19      ');

    Case ge of
      1 : Writeat(8,10,kl4,kl5,' Main Address ');
      2 : Writeat(8,11,kl4,kl5,' AKA #1       ');
      3 : Writeat(8,12,kl4,kl5,' AKA #2       ');
      4 : Writeat(8,13,kl4,kl5,' AKA #3       ');
      5 : Writeat(8,14,kl4,kl5,' AKA #4       ');
      6 : Writeat(8,15,kl4,kl5,' AKA #5       ');
      7 : Writeat(8,16,kl4,kl5,' AKA #6       ');
      8 : Writeat(8,17,kl4,kl5,' AKA #7       ');
      9 : Writeat(8,18,kl4,kl5,' AKA #8       ');
      10: Writeat(8,19,kl4,kl5,' AKA #9       ');

      11: Writeat(41,10,kl4,kl5,' AKA #10      ');
      12: Writeat(41,11,kl4,kl5,' AKA #11      ');
      13: Writeat(41,12,kl4,kl5,' AKA #12      ');
      14: Writeat(41,13,kl4,kl5,' AKA #13      ');
      15: Writeat(41,14,kl4,kl5,' AKA #14      ');
      16: Writeat(41,15,kl4,kl5,' AKA #15      ');
      17: Writeat(41,16,kl4,kl5,' AKA #16      ');
      18: Writeat(41,17,kl4,kl5,' AKA #17      ');
      19: Writeat(41,18,kl4,kl5,' AKA #18      ');
      20: Writeat(41,19,kl4,kl5,' AKA #19      ');
    End;
  End;

Begin
  with mwin[3] do
    begin
      x1 := 6;
      x2 := 8;
      y1 := 74;
      y2 := 21;
      st := ' Addresses ';
    end;
  create_window(3);

  ge := 1;
  ch := #0;
  repeat
    writeaddress(ge);
    choosehook := dummy;
    ch := readkey;
    case ch of
     #0  : begin
             ch := readkey;
             case ch of
               #72 : if ge > 1 then dec(ge) else ge := 20; {up}
               #80 : if ge < 20 then inc(ge) else ge := 1; {dn}
               #75, #77 : {rgt/lft} if ge < 11 then inc(ge,10) else dec(ge,10);
               #73, #71 : ge := 1;
               #81, #79 : ge := 20;
             end;
           end;
     #9  : infoscreen;
     #13 : begin
             tmp := node2str(setup.address[ge]);

             if ge < 11 then
               read_string(23,9+ge,18,23,tmp,c_all) else
                 read_string(56,9+ge-10,18,23,tmp,c_all);

             str2node(tmp,setup.address[ge],setup.address[1],bol);
             if not bol then askwindow('','Invalid nodenumber entered','',[#32,#27,#13]);
           end;
     #26 : dosshell;
    end;
  writeat(60,2,1,7,replicate(19,' '));
  writeat(79-length(node2str(setup.address[1])),2,1,7,node2str(setup.address[1]));
  until ch = #27;
  remove_window(3);
End;


{  ------------ AKA LOOP ------------------------}


Procedure AkaLoop;
Var
  Ar    : Array[1..20] of String[2];
  X, Ge : Integer;
  Tmp   : String;
Begin
  with mwin[3] do
    begin
      x1 := 25;
      x2 := 2;
      y1 := 65;
      y2 := 24;
      st := ' AKA Matching ';
    end;
  create_window(3);
  writeat(27,3,7,0,'    Zone   Net    Active AKA');

  ar[1] := '1';
  ar[2] := '2';
  ar[3] := '3';
  ar[4] := '4';
  ar[5] := '5';
  ar[6] := '6';
  ar[7] := '7';
  ar[8] := '8';
  ar[9] := '9';
  ar[10]:= '10';
  ar[11]:= '11';
  ar[12]:= '12';
  ar[13]:= '13';
  ar[14]:= '14';
  ar[15]:= '15';
  ar[16]:= '16';
  ar[17]:= '17';
  ar[18]:= '18';
  ar[19]:= '19';
  ar[20]:= '20';

  ge := 1;
  while ge <> 0 do
    begin

      for x := 1 to 20 do
        begin
          if setup.zonetoaka[x].zone <> 0 then
            begin
              writeat(31,3+x,foreentry,backentry,expand(int_to_str(setup.zonetoaka[x].zone),7));
              writeat(38,3+x,foreentry,backentry,expand(int_to_str(setup.zonetoaka[x].net),7));
              writeat(45,3+x,foreentry,backentry,expand(node2str(setup.address[setup.zonetoaka[x].aka]),20))
            end else writeat(31,3+x,foreentry,backentry,replicate(34,' '));
        end;

      choosehook := dummy;
      inc(mwin[3].x2);
      ge := select_window(3,20,2,@ar,ge,false);
      dec(mwin[3].x2);
      if ge <> 0 then
        begin
          tmp := int_to_str(setup.zonetoaka[ge].zone);
          read_string(31,3+ge,5,5,tmp,c_all);
          setup.zonetoaka[ge].zone := str_to_int(tmp);

          if setup.zonetoaka[ge].zone <> 0 then
            begin
              tmp := int_to_str(setup.zonetoaka[ge].net);
              read_string(38,3+ge,5,5,tmp,c_all);
              setup.zonetoaka[ge].net := str_to_int(tmp);

              setup.zonetoaka[ge].aka := select_address(4,setup.zonetoaka[ge].aka,false);
            end;
        end;
    end;
  remove_window(3);
End;


{  ------------ SYSTEM INFO LOOP ----------------}


Procedure SysInfoLoop;
Var
  Ch  : Char;
  X   : Byte;
  Tmp : String;
  Bbs : String[20];

  Procedure WriteSysInfo;
  Begin
    Writeat(36,10,foreentry,backentry,expand(setup.sysopname,39));
    Writeat(36,11,foreentry,backentry,expand(setup.systemname,39));
{   Writeat(36,12,foreentry,backentry,expand(setup.regkey,12));   }

    Case setup.mailer of
      1 : Writeat(36,14,foreentry,backentry,'Frontdoor      ');
      2 : Writeat(36,14,foreentry,backentry,'BinkleyTerm    ');
      3 : Writeat(36,14,foreentry,backentry,'D''bridge       ');
      4 : Writeat(36,14,foreentry,backentry,'Portal of Power');
      5 : Writeat(36,14,foreentry,backentry,'Intermail      ');
    End;

    Writeat(36,15,foreentry,backentry, bbs );

    Case setup.filebase of
      0 : Writeat(36,16,foreentry,backentry,'Files.bbs       ');
      1 : Writeat(36,16,foreentry,backentry,'RemoteAccess 2.x');
    End;

    WriteAt(16,10,7,0,' Sysop''s name      ');
    Writeat(16,11,7,0,' System name       ');
 {  Writeat(16,12,7,0,' Registration code ');    }
    Writeat(16,14,7,0,' Mailer type       ');
    Writeat(16,15,7,0,' BBS type          ');
    Writeat(16,16,7,0,' Filebase type     ');
    Case X of
      1 : WriteAt(16,10,kl4,kl5,' Sysop''s name      ');
      2 : Writeat(16,11,kl4,kl5,' System name       ');
{     3 : Writeat(16,12,kl4,kl5,' Registration code ');  }
      3 : Writeat(16,14,kl4,kl5,' Mailer type       ');
      4 : Writeat(16,15,kl4,kl5,' BBS type          ');
      5 : Writeat(16,16,kl4,kl5,' Filebase type     ');
    End;
  End;

  Procedure SysInfoHelp ( Welke : Byte );
  Begin
    Writeat(1,25,7,0,replicate(80,' '));
    Case Welke of
      1 : Writeat(1,25,7,0,'The name of the person who is running this system. Usually YOUR name :-)');
      2 : Writeat(1,25,7,0,'The name of your mailsystem, BBS');
{     3 : Writeat(1,25,7,0,'Your FileMgr registration code');    }
      3 : Writeat(1,25,7,0,'The mailer you are running');
      4 : Writeat(1,25,7,0,'The kind of bbs you are running (fmconv)');
      5 : Writeat(1,25,7,0,'The type of filebase you use on your bbs');
    End;
  End;

Begin
  with mwin[3] do
    begin
      x1 := 15;
      x2 := 8;
      y1 := 75;
      y2 := 18;
      st := ' SiteInfo ';
    end;
  create_window(3);

  bbs := getbbssystem;

  x := 1;
  ch := #0;
  while ch <> #27 do   { Escape }
    begin
      writesysinfo;
      sysinfohelp(x);
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                 #80 : {down}     if x < 6 then inc(X) else x := 1;
                 #72 : {up}       if x > 1 then dec(X) else x := 6;
                 #81 : {pagedown} X := 6;
                 #73 : {pageup}   X := 1;
                 #71 : {home}     X := 1;
                 #79 : {end}      X := 6;
                end;
              end;
        #9  : infoscreen;        { Tab  }
        #26 : dosshell;
        #13 : begin              { Enter }
                case x of
                  1 : begin
                        tmp := setup.sysopname;
                        read_string(36,10,39,40,tmp,c_all);
                        setup.sysopname := tmp;
                      end;
                  2 : begin
                        tmp := setup.systemname;
                        read_string(36,11,39,40,tmp,c_all);
                        setup.systemname := tmp;
                      end;
       {          3 : begin
                        tmp := setup.regkey;
                        read_string(36,12,39,12,tmp,c_all);
                        setup.regkey := upper(tmp);
                      end;
        }         3 : begin
                        inc(setup.mailer);
                        if setup.mailer = 6 then setup.mailer := 1;
                      end;
                  4 : begin
                        askwindow('','Run FMCONV.EXE to set your bbs type','',[#32,#13,#27]);
                      end;
                  5 : begin
                        inc(setup.filebase);
                        if setup.filebase = 2 then setup.filebase := 0;
                      end;
                end;
              end;
      end;
    end;
  remove_window(3);
  setup.regkey := '';
End;


{  ------------ PATH LOOP -----------------------}


{$F+} Procedure PathHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Path to your inbound file directory');
    2 : Writeat(1,25,7,0,'Path to your secure inbound file directory');
    3 : Writeat(1,25,7,0,'To store (tic)files for your downlinks. MUST BE FILEMGR ONLY!');
    4 : Writeat(1,25,7,0,'Path to your netmail (*.msg) messagebase');
    5 : Writeat(1,25,7,0,'Directory for bad, incomplete or infected files');
    6 : Writeat(1,25,7,0,'Path and name of your AREAS.BBS style file');
    7 : Begin
          Writeat(1,25,7,0,'Path to your announcement template files');
          If (setup.exteditor <> '') and (Setup.tplpath <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
    8 : Writeat(1,25,7,0,'Path and name of the logfile FileMgr should use.');
    9 : Writeat(1,25,7,0,'Path and name of the areamanger logfile (if blank filemgr log will be used)');
   10 : Writeat(1,25,7,0,'Path to store temporary files (for unpacking/virusscan)');
   11 : Begin
          Writeat(1,25,7,0,'Path and name of your ''quote of the day'' file.');
          If (setup.exteditor <> '') and (setup.quotefile <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
   12 : Begin
          Writeat(1,25,7,0,'Magicname list #1 (format: <magicname> <filespec>');
          If (setup.exteditor <> '') and (setup.aliasfile[1] <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
   13 : Begin
          Writeat(1,25,7,0,'Magicname list #2 (format: <magicname> <description>');
          If (setup.exteditor <> '') and (setup.aliasfile[2] <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
   14 : Writeat(1,25,7,0,'Path to your D''Bridge queue/BinkleyTerm outbound path');
   15 : Writeat(1,25,7,0,'Path for ''to be replaced'' files');
   16 : Writeat(1,25,7,0,'Path for mailer and FileMgr''s semaphores (multinode)');
   17 : Writeat(1,25,7,0,'Path and name to your external text editor');
  End;
End;

{$F+} procedure editmagic(active:byte); {$F-}
Var
  res : word;
  tmp : string;
Begin
  if setup.exteditor <> '' then
    begin
      case active of
        7 : Begin
              if setup.tplpath <> '' then
                Begin
                  writeat(1,25,7,0,expand('Select the tpl to edit',80));
                  incwin(3);
                  tmp := Select_Tpl(4,'',true);
                  cursor_on;
                  savescreen;
                  if tmp <> '' then
                    res := fmExec(setup.exteditor,setup.tplpath+tmp, setup.SwapMethode, $ffff, false, false);
                  restorescreen;
                  cursor_off;
                  decwin(3);
                end;
            End;
       11 : if setup.quotefile <> '' then
              begin
                cursor_on;
                savescreen;
                res := fmExec(setup.exteditor,setup.quotefile, setup.SwapMethode, $ffff, false, false);
                restorescreen;
                cursor_off;
              end;
       12 : if setup.aliasfile[1] <> '' then
              begin
                cursor_on;
                savescreen;
                res := fmExec(setup.exteditor,setup.aliasfile[1], setup.SwapMethode, $ffff, false, false);
                restorescreen;
                cursor_off;
              end;
       13 : if setup.aliasfile[2] <> '' then
              begin
                cursor_on;
                savescreen;
                res := fmExec(setup.exteditor,setup.aliasfile[2], setup.SwapMethode, $ffff, false, false);
                restorescreen;
                cursor_off;
              end;
      end;
    end;
End;

Procedure PathLoop;
Var
  Ar  : Array[1..17] of String[16];
  Ge  : Integer;
  Tmp : String;

  Procedure WritePaths;
  Begin
    Writeat(30,6, foreentry,backentry,first(40,setup.inboundpath));
    Writeat(30,7, foreentry,backentry,first(40,setup.securepath));
    Writeat(30,8, foreentry,backentry,first(40,setup.outboundpath));
    Writeat(30,9, foreentry,backentry,first(40,setup.netmailpath));
    Writeat(30,10,foreentry,backentry,first(40,setup.badfilepath));
    Writeat(30,11,foreentry,backentry,first(40,setup.areapath));
    Writeat(30,12,foreentry,backentry,first(40,setup.tplpath));
    Writeat(30,13,foreentry,backentry,first(40,setup.logfile));
    Writeat(30,14,foreentry,backentry,first(40,setup.arealog));
    Writeat(30,15,foreentry,backentry,first(40,setup.temppath));
    Writeat(30,16,foreentry,backentry,first(40,setup.quotefile));
    Writeat(30,17,foreentry,backentry,first(40,setup.aliasfile[1]));
    Writeat(30,18,foreentry,backentry,first(40,setup.aliasfile[2]));
    Writeat(30,19,foreentry,backentry,first(40,setup.quepath));
    Writeat(30,20,foreentry,backentry,first(40,setup.retirepath));
    Writeat(30,21,foreentry,backentry,first(40,setup.semaphorepath));
    Writeat(30,22,foreentry,backentry,first(40,setup.exteditor));
  End;

Begin
  with mwin[3] do
    begin
      x1 := 10;
      x2 := 4;
      y1 := 70;
      y2 := 24;
      st := ' Paths & Filenames ';
    end;
  create_window(3);

  ar[1] := 'Inbound files   ';
  ar[2] := 'Secure inbound  ';
  ar[3] := 'Outbound files  ';
  ar[4] := 'Netmail         ';
  ar[5] := 'Bad files       ';
  ar[6] := 'Areas.bbs       ';
  ar[7] := 'Template path   ';
  ar[8] := 'Logfile name    ';
  ar[9] := 'Areamgr logfile ';
  ar[10]:= 'Temporary path  ';
  ar[11]:= 'Quote file      ';
  ar[12]:= 'Magicname list 1';
  ar[13]:= 'Magicname list 2';
  ar[14]:= 'Queue path      ';
  ar[15]:= 'Retirement path ';
  ar[16]:= 'Semaphore path  ';
  ar[17]:= 'External editor ';

  f2hook := editmagic;

  ge := 1;
  while ge <> 0 do
    begin
      writepaths;
      choosehook := pathhelp;
      decwin(3);
      ge := select_window(3,17,16,@ar,ge,false);
      incwin(3);
      case ge of
        1 : begin
              tmp := setup.inboundpath;
              read_string(30,6,40,80,tmp,c_all);
              checkpath(tmp);
              setup.inboundpath := upper(tmp);
            end;
        2 : begin
              tmp := setup.securepath;
              read_string(30,7,40,80,tmp,c_all);
              checkpath(tmp);
              setup.securepath := upper(tmp);
            end;
        3 : begin
              tmp := setup.outboundpath;
              read_string(30,8,40,80,tmp,c_all);
              checkpath(tmp);
              setup.outboundpath := upper(tmp);
              if setup.outboundpath = setup.quepath then
                askwindow('Outboundpath and','queue path may not be','the same!',[#13,#27,#32]);
            end;
        4 : begin
              tmp := setup.netmailpath;
              read_string(30,9,40,80,tmp,c_all);
              checkpath(tmp);
              setup.netmailpath := upper(tmp);
            end;
        5 : begin
              tmp := setup.badfilepath;
              read_string(30,10,40,80,tmp,c_all);
              checkpath(tmp);
              setup.badfilepath := upper(tmp);
            end;
        6 : begin
              tmp := setup.areapath;
              read_string(30,11,40,80,tmp,c_all);
              setup.areapath := upper(tmp);
            end;
        7 : begin
              tmp := setup.tplpath;
              read_string(30,12,40,80,tmp,c_all);
              checkpath(tmp);
              setup.tplpath := upper(tmp);
            end;
        8 : begin
              tmp := setup.logfile;
              read_string(30,13,40,80,tmp,c_all);
              setup.logfile := upper(tmp);
            end;
        9 : begin
              tmp := setup.arealog;
              read_string(30,14,40,80,tmp,c_all);
              setup.arealog := upper(tmp);
            end;
        10: begin
              tmp := setup.temppath;
              read_string(30,15,40,80,tmp,c_all);
              checkpath(tmp);
              setup.temppath := upper(tmp);
            end;
       11 : begin
              tmp := setup.quotefile;
              read_string(30,16,40,80,tmp,c_all);
              setup.quotefile := upper(tmp);
            end;
       12 : begin
              tmp := setup.aliasfile[1];
              read_string(30,17,40,80,tmp,c_all);
              setup.aliasfile[1] := upper(tmp);
              if (setup.aliasfile[1] <> '') and not exist(tmp) then
                begin
                  if askwindow(tmp,'does not exist!','Create (Y/n) ?',['y','Y','n','N',#13,#27]) in ['y','Y',#13] then
                    create_file(tmp);
                end;
            end;
       13 : begin
              tmp := setup.aliasfile[2];
              read_string(30,18,40,80,tmp,c_all);
              setup.aliasfile[2] := upper(tmp);
              if (setup.aliasfile[2] <> '') and not exist(tmp) then
                begin
                  if askwindow(tmp,'does not exist!','Create (Y/n) ?',['y','Y','n','N',#13,#27]) in ['y','Y',#13] then
                    create_file(tmp);
                end;
            end;
       14 : begin
              tmp := setup.quepath;
              read_string(30,19,40,80,tmp,c_all);
              checkpath(tmp);
              setup.quepath := upper(tmp);
              if setup.outboundpath = setup.quepath then
                askwindow('Outboundpath and','queue path may not be','the same!',[#13,#27,#32]);
            end;
       15 : begin
              tmp := setup.retirepath;
              read_String(30,20,40,80,tmp,c_all);
              checkpath(tmp);
              setup.retirepath := upper(tmp);
            end;
       16 : begin
              tmp := setup.semaphorepath;
              read_String(30,21,40,80,tmp,c_all);
              checkpath(tmp);
              setup.semaphorepath := upper(tmp);
            end;
       17 : begin
              tmp := setup.exteditor;
              read_String(30,22,40,80,tmp,c_all);
              if tmp <> '' then
                if not exist(tmp) then askwindow('Editor','does not exist!','Press [ENTER] to continue',[#13,#27,#32]);
              setup.exteditor := upper(tmp);
            end;
      end;

      if (setup.mailer in [2,3,4]) and (setup.quepath = '') and (ge = 0) then
        begin
          askwindow('','Queuepath may not be empty!','',[#13,#27,#32]);
          ge := 14;
        end;

    end;
  f2hook := dummy1;
  remove_window(3);
End;


{  ------------ EXTERNAL PROGS LOOP --------------}


Procedure ArchiverLoop;
Var
  Ch  : Char;
  X   : Byte;
  Tmp : String;

  Procedure ArchInfoHelp;
  Begin
    Writeat(1,25,7,0,replicate(80,' '));
    If x in [1..10] then
      Writeat(1,25,7,0,'Name and parameters for your .    archiver (%1=archivename, %2=input list).');
    Case X of
     1 : Writeat(31,25,7,0,'ZIP');
     2 : Writeat(31,25,7,0,'ARJ');
     3 : Writeat(31,25,7,0,'LZH');
     4 : Writeat(31,25,7,0,'ARC');
     5 : Writeat(31,25,7,0,'PAK');
     6 : Writeat(31,25,7,0,'ZOO');
     7 : Writeat(31,25,7,0,'SQZ');
     8 : Writeat(31,25,7,0,'RAR');
     9 : Writeat(31,25,7,0,'HYP');
    10 : Writeat(31,25,7,0,'DWC');
    11 : Writeat(1,25,7,0,'Name and parameters of your unpack program or shell');
    12 : Writeat(1,25,7,0,'Name and parameters of your external archiver convert prg (empty = internal)');
    13 : Writeat(1,25,7,0,'Name and parameters of your external archiver test util');
    End;
  End;

  procedure editpak(x:byte);
  var
    ch  : char;
    tmp : string;
    tel : byte;

    procedure displayit;
    begin
      writeat(40,11,foreentry,backentry,expand(setup.packername[x],12));
      writeat(40,12,foreentry,backentry,expand(setup.packswitch[x],20));
      writeat(40,13,foreentry,backentry,expand(setup.bannerswitch[x],20));
      writeat(40,15,foreentry,backentry,expand(setup.unpackername[x],12));
      writeat(40,16,foreentry,backentry,expand(setup.unpackswitch[x],20));
    end;

    procedure writeit(xx:byte);
    begin
      writeat(21,11,7,0,' Packer name    : ');
      writeat(21,12,7,0,'  > Switches   : ');
      writeat(21,13,7,0,'  > Add banner : ');
      writeat(21,15,7,0,' Unpack name    : ');
      writeat(21,16,7,0,'  > Switches   : ');
      case xx of
       1 : writeat(21,11,kl4,kl5,' Packer name    : ');
       2 : writeat(21,12,kl4,kl5,'  > Switches   : ');
       3 : writeat(21,13,kl4,kl5,'  > Add banner : ');
       4 : writeat(21,15,kl4,kl5,' Unpack name    : ');
       5 : writeat(21,16,kl4,kl5,'  > Switches   : ');
      end;
    end;

  begin
    with mwin[5] do
      begin
        x1 := 20;
        x2 := 9;
        y1 := 60;
        y2 := 18;
        st := ' Archiver '+int_to_str(x)+' ';
      end;
    create_window(5);
    tel := 1;
    repeat
      writeit(tel);
      displayit;
      ch := readkey;
      case ch of
        #13 : begin
                case tel of
                  1 : begin
                        tmp := setup.packername[x];
                        read_string(40,11,12,12,tmp,c_all);
                        setup.packername[x] := tmp;
                      end;
                  2 : begin
                        tmp := setup.packswitch[x];
                        read_string(40,12,20,44,tmp,c_all);
                        setup.packswitch[x] := tmp;
                      end;
                  3 : begin
                        tmp := setup.bannerswitch[x];
                        read_string(40,13,20,44,tmp,c_all);
                        setup.bannerswitch[x] := tmp;
                      end;
                  4 : begin
                        tmp := setup.unpackername[x];
                        read_string(40,15,20,44,tmp,c_all);
                        setup.unpackername[x] := tmp;
                      end;
                  5 : begin
                        tmp := setup.unpackswitch[x];
                        read_string(40,16,20,44,tmp,c_all);
                        setup.unpackswitch[x] := tmp;
                      end;
                end;
              end;
        #0  : begin
                ch := readkey;
                case ch of
                  #72 : if tel > 1 then dec(tel) else tel := 5;
                  #80 : if tel < 5 then inc(tel) else tel := 1;
                end;
              end;
        #26 : dosshell;
      end;
    until ch = #27;
    remove_window(5);
  end;

  Procedure WriteArchInfo;
  var i : word;
  Begin
    for i := 1 to 10 do
      begin
        Writeat(21,7+i,foreentry,backentry,expand(setup.packername[i]+' '+setup.packswitch[i],26));
        Writeat(47,7+i,foreentry,backentry,expand(setup.unpackername[i]+' '+setup.unpackswitch[i],26));
      end;

    Writeat(21,19,foreentry,backentry,setup.packername[11]);
    Writeat(21,20,foreentry,backentry,first(51,setup.extarchiver));
    Writeat(21,21,foreentry,backentry,first(51,setup.testfile));

    WriteAt(11,8 ,7,0,' ZIP     ');
    Writeat(11,9 ,7,0,' ARJ     ');
    Writeat(11,10,7,0,' LZH     ');
    Writeat(11,11,7,0,' ARC     ');
    Writeat(11,12,7,0,' PAK     ');
    Writeat(11,13,7,0,' ZOO     ');
    Writeat(11,14,7,0,' Squeeze ');
    Writeat(11,15,7,0,' RAR     ');
    Writeat(11,16,7,0,' Hyper   ');
    Writeat(11,17,7,0,' DWC     ');
    Writeat(11,19,7,0,' Unpack  ');
    Writeat(11,20,7,0,' Convert ');
    Writeat(11,21,7,0,' Test    ');
    Case X of
      1 : WriteAt(11,8 ,kl4,kl5,' ZIP     ');
      2 : Writeat(11,9 ,kl4,kl5,' ARJ     ');
      3 : Writeat(11,10,kl4,kl5,' LZH     ');
      4 : Writeat(11,11,kl4,kl5,' ARC     ');
      5 : Writeat(11,12,kl4,kl5,' PAK     ');
      6 : Writeat(11,13,kl4,kl5,' ZOO     ');
      7 : Writeat(11,14,kl4,kl5,' Squeeze ');
      8 : Writeat(11,15,kl4,kl5,' RAR     ');
      9 : Writeat(11,16,kl4,kl5,' Hyper   ');
      10: Writeat(11,17,kl4,kl5,' DWC     ');
      11: Writeat(11,19,kl4,kl5,' Unpack  ');
      12: Writeat(11,20,kl4,kl5,' Convert ');
      13: Writeat(11,21,kl4,kl5,' Test    ');
    End;
  End;

Begin
  with mwin[4] do
    begin
      x1 := 10;
      x2 := 6;
      y1 := 73;
      y2 := 23;
      st := ' Archivers ';
    end;
  create_window(4);

  x := 1;
  ch := #0;
  while ch <> #27 do
    begin
      writearchinfo;
      archinfohelp;
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                 #80 : {down}     if x < 13 then inc(X) else x := 1;
                 #72 : {up}       if x > 1 then dec(X) else x := 13;
                 #81 : {pagedown} X := 13;
                 #73 : {pageup}   X := 1;
                 #71 : {home}     X := 1;
                 #79 : {end}      X := 13;
                end;
              end;
        #9  : infoscreen;
        #26 : dosshell;
        #13 : begin
                if x = 13 then
                  begin
                    tmp := setup.testfile;
                    read_String(21,21,51,80,tmp,c_all);
                    setup.testfile := tmp;
                  end else
                if x = 12 then
                  begin
                    tmp := setup.extarchiver;
                    read_string(21,20,51,80,tmp,c_all);
                    setup.extarchiver := tmp;
                  end else
                if x = 11 then
                  begin
                    tmp := setup.packername[11];
                    read_string(21,19,25,25,tmp,c_all);
                    setup.packername[11] := tmp;
                  end else
                  begin
                    editpak(x);
                  end;
              end;
      end;
    end;
  remove_window(4);
End;


{$F+} Procedure VirusHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Complete path and name to your virusscanner');
    2 : Writeat(1,25,7,0,'The parameters for the scanner to use');
    3 : Writeat(1,25,7,0,'The maximum errorlevel that means no virusses found');
    4 : Writeat(1,25,7,0,'Only when these files are present FileMgr will start the virusscanner');
  End;
End;


Procedure VirusLoop;
Var
  Ar  : Array[1..4] of String[14];
  Ge  : Integer;
  Tmp : String;

  Procedure WriteVirus;
  Begin
    Writeat(33,14,foreentry,backentry,expand(setup.viruspath,37));
    Writeat(33,15,foreentry,backentry,first(37,setup.virusparm));
    Writeat(33,16,foreentry,backentry,expand(int_to_str(setup.viruserr),5));
    If setup.virusfiles = 0 then
     Writeat(33,17,foreentry,backentry,'Exe, Com & Ovl files') else
       Writeat(33,17,foreentry,backentry,expand('*.*',20));
  End;

Begin
  with mwin[4] do
    begin
      x1 := 15;
      x2 := 12;
      y1 := 70;
      y2 := 19;
      st := ' VirusScanner ';
    end;
  create_window(4);

  ar[1] := 'Scanner Path  ';
  ar[2] := 'Parameters    ';
  ar[3] := 'Max Errorlevel';
  ar[4] := 'Files to Scan ';

  ge := 1;
  while ge <> 0 do
    begin
      writevirus;
      choosehook := virushelp;
      decwin(4);
      ge := select_window(4,4,14,@ar,ge,false);
      incwin(4);
      case ge of
        1 : begin
              tmp := setup.viruspath;
              read_string(33,14,37,80,tmp,c_all);
              setup.viruspath := tmp;
            end;
        2 : begin
              tmp := setup.virusparm;
              read_string(33,15,37,50,tmp,c_all);
              setup.virusparm := tmp;
            end;
        3 : begin
              tmp := int_to_str(setup.viruserr);
              read_string(33,16,37,3,tmp,c_numbers);
              setup.viruserr := str_to_int(tmp);
            end;
        4 : If setup.virusfiles = 0 then setup.virusfiles := 1 else setup.virusfiles := 0;
      end;
    end;
  remove_window(4);
End;


{$F+} Procedure ExOptionsHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Swapping method to use');
    2 : Writeat(1,25,7,0,'If number of bytes swapped to disk/ems/xms must be visible');
    3 : Writeat(1,25,7,0,'If output of archivers during packing should be visible');
    4 : Writeat(1,25,7,0,'If output of archivers during unpacking should be visible');
    5 : Writeat(1,25,7,0,'If the output of the viruscanner during scanning should be visible');
  End;
End;


Procedure ExOptionsLoop;
Var
  Ar : Array[1..5] of String[17];
  Ge : Integer;

  Procedure WriteExOptions;
  Begin
    Case setup.swapmethode of
      583 : Writeat(43,13,foreentry,backentry,'Ems/Xms/Disk');
      599 : Writeat(43,13,foreentry,backentry,'Xms/Ems/Disk');
      581 : Writeat(43,13,foreentry,backentry,'Ems/Disk    ');
      582 : Writeat(43,13,foreentry,backentry,'Xms/Disk    ');
      580 : Writeat(43,13,foreentry,backentry,'Disk        ');
    End;
    If setup.showswapping then
      Writeat(43,14,foreentry,backentry,'Yes') else writeat(43,14,foreentry,backentry,'No ');
    If setup.showpack then
      Writeat(43,15,foreentry,backentry,'Yes') else writeat(43,15,foreentry,backentry,'No ');
    If setup.showunpack then
      Writeat(43,16,foreentry,backentry,'Yes') else writeat(43,16,foreentry,backentry,'No ');
    If setup.showvirus then
      Writeat(43,17,foreentry,backentry,'Yes') else writeat(43,17,foreentry,backentry,'No ');
  End;

Begin
  with mwin[4] do
    begin
      x1 := 22;
      x2 := 11;
      y1 := 60;
      y2 := 19;
      st := ' Options ';
    end;
  create_window(4);

  ar[1] := 'Swapping method  ';
  ar[2] := 'Show swapping    ';
  ar[3] := 'Packing visible  ';
  ar[4] := 'Unpacking visible';
  ar[5] := 'Virusscan visible';

  ge := 1;
  while ge <> 0 do
    begin
      writeexoptions;
      choosehook := exoptionshelp;
      decwin(4);
      ge := select_window(4,5,17,@ar,ge,false);
      incwin(4);
      case ge of
        1 : Case setup.swapmethode of
              583 : setup.swapmethode := 599;
              599 : setup.swapmethode := 581;
              581 : setup.swapmethode := 582;
              582 : setup.swapmethode := 580;
              580 : setup.swapmethode := 583;
            End;
        2 : Setup.Showswapping := not setup.showswapping;
        3 : Setup.showpack := not setup.showpack;
        4 : Setup.ShowUnpack := not setup.showunpack;
        5 : Setup.ShowVirus := not setup.showvirus;
      end;
    end;
  remove_window(4);
End;


{$F+} Procedure ExternalHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Archivers and parameters');
    2 : Writeat(1,25,7,0,'Virusscanner, parameters and options');
    3 : Writeat(1,25,7,0,'General options for these external programs');
    4 : Writeat(1,25,7,0,'Banner definition files for rearchive function');
  End;
End;

{$F+} procedure banneredit(ch:byte); {$F-}
var res : word;
begin
  if setup.exteditor <> '' then
    begin
      if strip('B',' ',setup.bannerarray[ch]) <> '' then
        Begin
          cursor_on;
          savescreen;
          res := fmExec(setup.exteditor,setup.bannerarray[ch], setup.SwapMethode, $ffff, false, false);
          restorescreen;
          cursor_off;
        end;
    end;
end;

Procedure Bannerloop;
Var
  Ar  : Array[1..15] of String[3];
  Ge  : Integer;

  Procedure editbanner(ge:word);
  var tmp : string;
  begin
    tmp := setup.bannerarray[ge];
    read_String(22,6+ge,42,60,tmp,c_all);
    if tmp <> '' then
      if not exist(tmp) then
        askwindow('Banner file',tmp,'not found!',[#13,#27,#32]);
    setup.bannerarray[ge] := tmp;
  end;

  procedure writeit;
  var x : byte;
  begin
    for x := 1 to 15 do
     writeat(22,6+x,foreentry,backentry,expand(setup.bannerarray[x],42));
  end;

Begin
  with mwin[4] do
    begin
      x1 := 15;
      x2 := 5;
      y1 := 65;
      y2 := 23;
      st := ' Banner files ';
    end;
  create_window(4);

  ar[1] := '#1';
  ar[2] := '#2';
  ar[3] := '#3';
  ar[4] := '#4';
  ar[5] := '#5';
  ar[6] := '#6';
  ar[7] := '#7';
  ar[8] := '#8';
  ar[9] := '#9';
  ar[10] := '#10';
  ar[11] := '#11';
  ar[12] := '#12';
  ar[13] := '#13';
  ar[14] := '#14';
  ar[15] := '#15';

  f2hook := banneredit;
  If (setup.exteditor <> '') then writeat(64,25,14,0,'Press F2 to edit');
  ge := 1;
  while ge <> 0 do
    begin
      writeit;
      choosehook := dummy;
      decwin(4);
      ge := select_window(4,15,3,@ar,ge,false);
      incwin(4);
      if ge <> 0 then editbanner(ge);
    end;
  f2hook := dummy1;
  remove_window(4);
End;



Procedure ExternalLoop;
Var
  Ar : Array[1..4] of String[12];
  Ge : Integer;
Begin
  with mwin[3] do
    begin
      x1 := 31;
      x2 := 8;
      y1 := 46;
      y2 := 15;
      st := ' Externals ';
    end;
  create_window(3);

  ar[1] := 'Archivers';
  ar[2] := 'VirusScanner';
  ar[3] := 'Options';
  ar[4] := 'Banners';

  ge := 1;
  while ge <> 0 do
    begin
      choosehook := externalhelp;
      decwin(3);
      ge := select_window(3,4,12,@ar,ge,false);
      incwin(3);
      case ge of
        1 : ArchiverLoop;
        2 : VirusLoop;
        3 : ExOptionsLoop;
        4 : Bannerloop;
      end;
    end;
  remove_window(3);
End;



{  ------------ BEHAVIOUR LOOP --------------}

{$F+} Procedure BehaviourHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Report sysop of incoming files with incorrect crc''s');
    2 : Writeat(1,25,7,0,'Report sysop of incoming files containing a virus');
    3 : Writeat(1,25,7,0,'Report sysop of incoming files from an illegal feed');
    4 : Writeat(1,25,7,0,'Report sysop of incoming files in unknown areas');
    5 : Writeat(1,25,7,0,'Report sysop of other bad incoming files (moved to the bad dir)');
    6 : Writeat(1,25,7,0,'Report sysop of automatically created new areas');
    7 : Writeat(1,25,7,0,'Report sysop of requested areas from your uplink');
    8 : Writeat(1,25,7,0,'Report sysop of disconnected areas');
    9 : Writeat(1,25,7,0,'Report sysop of empty passthru areas');
  End;
End;

Procedure WriteBehaviour;
Begin
  Writeat(55,9 ,3,0,yesno(setup.noti_bad));
  Writeat(55,10,3,0,yesno(setup.noti_virus));
  Writeat(55,11,3,0,yesno(setup.noti_ill));
  Writeat(55,12,3,0,yesno(setup.noti_unk));
  Writeat(55,13,3,0,yesno(setup.noti_other));
  Writeat(55,14,3,0,yesno(setup.noti_newly));
  Writeat(55,15,3,0,yesno(setup.noti_req));
  Writeat(55,16,3,0,yesno(setup.noti_disco));
  Writeat(55,17,3,0,yesno(setup.noti_empty));
End;

Procedure BehaviourLoop;
Var
  Ar : Array[1..9] of String[20];
  Ge : Integer;
Begin
  with mwin[3] do
    begin
      x1 := 31;
      x2 := 7;
      y1 := 59;
      y2 := 19;
      st := ' Behaviour ';
    end;
  create_window(3);

  ar[1] := 'Bad files';
  ar[2] := 'Virus files';
  ar[3] := 'Illegal files';
  ar[4] := 'Unknown files';
  ar[5] := 'Other bad files';
  ar[6] := 'Newly created areas';
  ar[7] := 'Requested areas';
  ar[8] := 'Disconnected areas';
  ar[9] := 'Empty passthru areas';

  ge := 1;
  while ge <> 0 do
    begin
      choosehook := behaviourhelp;
      writebehaviour;
      decwin(3);
      ge := select_window(3,9,20,@ar,ge,false);
      incwin(3);
      case ge of
       1 : setup.noti_bad := not setup.noti_bad;
       2 : setup.noti_virus := not setup.noti_virus;
       3 : setup.noti_ill := not setup.noti_ill;
       4 : begin
             setup.noti_unk := not setup.noti_unk;
             if setup.noti_unk then setup.ignunknown := 0;
           end;
       5 : setup.noti_other := not setup.noti_other;
       6 : setup.noti_newly := not setup.noti_newly;
       7 : setup.noti_req := not setup.noti_req;
       8 : setup.noti_disco := not setup.noti_disco;
       9 : setup.noti_empty := not setup.noti_empty;
      end;
    end;
  remove_window(3);
End;


{  ------------ MISCELLANEOUS LOOP --------------}


Procedure MiscLoop;
Var
  Ch  : Char;
  X   : Byte;
  Tmp : String;

  Procedure MiscHelp;
  Begin
    Writeat(1,25,7,0,replicate(80,' '));
    Case X of
      1 : Writeat(1,25,7,0,'Days to keep files ready for pickup. Inform your downlink(s) about this');
      2 : Writeat(1,25,7,0,'Should FileMgr set the date/time stamp of received files to the current date');
      3 : Writeat(1,25,7,0,'Should FileMgr replace outdated files with newer ones?');
      4 : Writeat(1,25,7,0,'Should FileMgr kill received requests?');
      5 : Writeat(1,25,7,0,'Should FileMgr ignore files in unknown areas? (leave alone/move to bad/delete)');
      6 : Writeat(1,25,7,0,'Should FileMgr ignore files with a bad CRC? (leave alone/move to bad/delete)');
      7 : Writeat(1,25,7,0,'Should FileMgr force ^AINTL lines when dest.zone = orig.zone?');
      8 : Writeat(1,25,7,0,'Update your mailers magicname list(s)?');
      9 : Writeat(1,25,7,0,'Number of weeks FileMgr should keep the history up-to-date.');
     10 : Writeat(1,25,7,0,'Maximum size of the historyfile (in Kb)');
     11 : Writeat(1,25,7,0,'The way you want your areas sorted in the areamanager.');
     12 : Writeat(1,25,7,0,'The number of HOURS to add to your local time in order to get UTC');

     13 : Writeat(1,25,7,0,'Password, used in *.TIC files to unknown nodes.');
     14 : Writeat(1,25,7,0,'Should FileMgr ignore extended ascii chars in file_id.diz files?');
     15 : Writeat(1,25,7,0,'In which column the description starts, normally 14 (only files.bbs filebase)');
     16 : Writeat(1,25,7,0,'Use AREADESC keyword in tic files for new areas');
     17 : Writeat(1,25,7,0,'Should FileMgr declare files as duplicate on an overall, group or area basis');
     18 : Writeat(1,25,7,0,'The maximum size of netmail messages (manager and scheduler)');
     19 : Writeat(1,25,7,0,'Try to update old *.ZIC packets, or only create new ones (not with DBridge)');
     20 : Writeat(1,25,7,0,'Maximum number of characters to use when importing file_id.diz files');
     21 : Writeat(1,25,7,0,'Should FileMgr reformat automatically and ignore linefeeds in descriptions');
     22 : Writeat(1,25,7,0,'If the logfile should give compact or expanded information');
     23 : Writeat(1,25,7,0,'How much diskspace must at least be available before FileMgr can start (in Kb)');
    End;
  End;

  Procedure WriteMiscData;
  Begin
    Writeat(28,9,foreentry,backentry,expand(int_to_str(setup.days2keep),3));
    If setup.touch then writeat(28,10,foreentry,backentry,'Yes') else writeat(28,10,foreentry,backentry,'No ');
    If setup.replace then writeat(28,11,foreentry,backentry,'Yes') else writeat(28,11,foreentry,backentry,'No ');
    If setup.killrcvd then writeat(28,12,foreentry,backentry,'Yes') else writeat(28,12,foreentry,backentry,'No ');

    case setup.ignunknown of
     0 : writeat(28,13,foreentry,backentry,'No    ');
     1 : writeat(28,13,foreentry,backentry,'Yes   ');
     2 : writeat(28,13,foreentry,backentry,'Delete');
    end;

    case setup.ignbadcrc of
     0 : writeat(28,14,foreentry,backentry,'No    ');
     1 : writeat(28,14,foreentry,backentry,'Yes   ');
     2 : writeat(28,14,foreentry,backentry,'Delete');
    end;

    If setup.forceintl then writeat(28,15,foreentry,backentry,'Yes ') else writeat(28,15,foreentry,backentry,'No ');
    If setup.updalias then writeat(28,16,foreentry,backentry,'Yes ') else writeat(28,16,foreentry,backentry,'No ');
    Writeat(28,17,foreentry,backentry,int_to_str(setup.historyweeks));
    Writeat(28,18,foreentry,backentry,int_to_str(setup.historykb));
    If setup.sortarea then writeat(28,19,foreentry,backentry,'Tag  ') else writeat(28,19,foreentry,backentry,'Group');
    Writeat(28,20,foreentry,backentry,expand(int_to_str(setup.timezone),5));

    Writeat(65,9,foreentry,backentry,first(13,setup.defaultpwd));
    If setup.extendeddiz then writeat(65,10,foreentry,backentry,'Yes') else writeat(65,10,foreentry,backentry,'No ');
    Writeat(65,11,foreentry,backentry,int_to_str(setup.descstart));
    If setup.useareadesc then Writeat(65,12,foreentry,backentry,'Yes') else writeat(65,12,foreentry,backentry,'No ');
    case setup.dupchecking of
      0 : writeat(65,13,foreentry,backentry,'Area   ');
      1 : writeat(65,13,foreentry,backentry,'Group  ');
      2 : writeat(65,13,foreentry,backentry,'Overall');
    end;
    writeat(65,14,foreentry,backentry,expand(int_to_str(setup.maxmsgsize),3));
    If setup.updateold then writeat(65,15,foreentry,backentry,'Yes') else writeat(65,15,foreentry,backentry,'No ');
    writeat(65,16,foreentry,backentry,expand(int_to_str(setup.maxfileid),4));
    if setup.wrapdesc then writeat(65,17,foreentry,backentry,'Yes') else writeat(65,17,foreentry,backentry,'No ');
    if setup.expandedlog then writeat(65,18,foreentry,backentry,'Expanded') else writeat(65,18,foreentry,backentry,'Compact ');
    writeat(65,19,foreentry,backentry,expand(int_to_str(setup.space),5));
  End;

  Procedure WriteMiscInfo;
  Begin
    WriteAt( 3, 9,7,0,' Days to keep files     ');
    Writeat( 3,10,7,0,' Touch files            ');
    Writeat( 3,11,7,0,' Replace outdated files ');
    Writeat( 3,12,7,0,' Kill received requests ');
    Writeat( 3,13,7,0,' Ignore unknown areas   ');
    Writeat( 3,14,7,0,' Ignore bad CRC files   ');
    Writeat( 3,15,7,0,' Force ^AINTL kludge    ');
    Writeat( 3,16,7,0,' Update magic list      ');
    Writeat( 3,17,7,0,' Weeks to keep history  ');
    Writeat( 3,18,7,0,' Max. size of history   ');
    Writeat( 3,19,7,0,' Area sorting method    ');
    Writeat( 3,20,7,0,' UTC difference         ');

    Writeat(40, 9,7,0,' Default password       ');
    Writeat(40,10,7,0,' Ignore extended ascii  ');
    Writeat(40,11,7,0,' Description start      ');
    Writeat(40,12,7,0,' Use AREADESC keyword   ');
    Writeat(40,13,7,0,' Duplicate checking     ');
    Writeat(40,14,7,0,' Max netmail msg size   ');
    Writeat(40,15,7,0,' Update old *.ZIC files ');
    Writeat(40,16,7,0,' Max chars file_id.diz  ');
    Writeat(40,17,7,0,' Reformat descriptions  ');
    Writeat(40,18,7,0,' Logfile information    ');
    Writeat(40,19,7,0,' Minimum harddisk space ');

    Case X of
      1 : WriteAt( 3, 9,kl4,kl5,' Days to keep files     ');
      2 : Writeat( 3,10,kl4,kl5,' Touch files            ');
      3 : Writeat( 3,11,kl4,kl5,' Replace outdated files ');
      4 : Writeat( 3,12,kl4,kl5,' Kill received requests ');
      5 : Writeat( 3,13,kl4,kl5,' Ignore unknown areas   ');
      6 : Writeat( 3,14,kl4,kl5,' Ignore bad CRC files   ');
      7 : Writeat( 3,15,kl4,kl5,' Force ^AINTL kludge    ');
      8 : Writeat( 3,16,kl4,kl5,' Update magic list      ');
      9 : Writeat( 3,17,kl4,kl5,' Weeks to keep history  ');
     10 : Writeat( 3,18,kl4,kl5,' Max. size of history   ');
     11 : Writeat( 3,19,kl4,kl5,' Area sorting method    ');
     12 : Writeat( 3,20,kl4,kl5,' UTC difference         ');

     13 : Writeat(40, 9,kl4,kl5,' Default password       ');
     14 : Writeat(40,10,kl4,kl5,' Ignore extended ascii  ');
     15 : Writeat(40,11,kl4,kl5,' Description start      ');
     16 : Writeat(40,12,kl4,kl5,' Use AREADESC keyword   ');
     17 : Writeat(40,13,kl4,kl5,' Duplicate checking     ');
     18 : Writeat(40,14,kl4,kl5,' Max netmail msg size   ');
     19 : Writeat(40,15,kl4,kl5,' Update old *.ZIC files ');
     20 : Writeat(40,16,kl4,kl5,' Max chars file_id.diz  ');
     21 : Writeat(40,17,kl4,kl5,' Reformat descriptions  ');
     22 : Writeat(40,18,kl4,kl5,' Logfile information    ');
     23 : Writeat(40,19,kl4,kl5,' Minimum harddisk space ');
    End;
  End;

Begin
  with mwin[3] do
    begin
      x1 := 2;
      x2 := 7;
      y1 := 79;
      y2 := 22;
      st := ' Miscellaneous ';
    end;
  create_window(3);

  x := 1;
  ch := #0;
  while ch <> #27 do
    begin
      writemiscdata;
      writemiscinfo;
      mischelp;
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                 #80 : {down}     if x < 23 then inc(X) else x := 1;
                 #72 : {up}       if x > 1 then dec(X) else x := 23;
                 #81 : {pagedown} X := 23;
                 #73 : {pageup}   X := 1;
                 #71 : {home}     X := 1;
                 #79 : {end}      X := 23;
                end;
              end;
        #9  : infoscreen;
        #26 : dosshell;
        #13 : begin
                case x of
                  1 : begin
                        tmp := int_to_str(setup.days2keep);
                        read_string(28,9,3,3,tmp,c_all);
                        setup.days2keep := str_to_int(tmp);
                      end;
                  2 : setup.touch := not setup.touch;
                  3 : setup.replace := not setup.replace;
                  4 : setup.killrcvd := not setup.killrcvd;
                  5 : begin
                        inc(setup.ignunknown);
                        if setup.ignunknown > 2 then setup.ignunknown := 0;
                      end;
                  6 : begin
                        inc(setup.ignbadcrc);
                        if setup.ignbadcrc > 2 then setup.ignbadcrc := 0;
                      end;
                  7 : setup.forceintl := not setup.forceintl;
                  8 : setup.updalias := not setup.updalias;
                  9 : begin
                        tmp := int_to_str(setup.historyweeks);
                        read_string(28,17,12,3,tmp,c_all);
                        setup.historyweeks := str_to_int(tmp);
                      end;
                 10 : begin
                        tmp := int_to_str(setup.historykb);
                        read_string(28,18,12,3,tmp,c_all);
                        setup.historykb := str_to_int(tmp);
                      end;
                 11 : setup.sortarea := not setup.sortarea;
                 12 : begin
                        tmp := int_to_str(setup.timezone);
                        read_string(28,20,13,5,tmp,c_all);
                        setup.timezone := str_to_int(tmp);
                      end;
                 13 : begin
                        tmp := setup.defaultpwd;
                        read_string(65,9,13,15,tmp,c_all);
                        setup.defaultpwd := tmp;
                      end;
                 14 : setup.extendeddiz := not setup.extendeddiz;
                 15 : begin
                        tmp := int_to_str(setup.descstart);
                        read_string(65,11,13,3,tmp,c_all);
                        setup.descstart := str_to_int(tmp);
                      end;
                 16 : setup.useareadesc := not setup.useareadesc;
                 17 : begin
                        inc(setup.dupchecking);
                        if setup.dupchecking > 2 then setup.dupchecking := 0;
                      end;
                 18 : begin
                        tmp := int_to_str(setup.maxmsgsize);
                        read_string(65,14,13,3,tmp,c_all);
                        setup.maxmsgsize := str_to_int(tmp);
                        if setup.maxmsgsize > 16 then setup.maxmsgsize := 16;
                      end;
                 19 : setup.updateold := not setup.updateold;
                 20 : begin
                        tmp := int_to_str(setup.maxfileid);
                        read_string(65,16,13,4,tmp,c_all);
                        setup.maxfileid := str_to_int(tmp);
                        if setup.maxfileid > 2048 then setup.maxfileid := 2048;
                      end;
                 21 : begin
                        setup.wrapdesc := not setup.wrapdesc;
                        if not setup.wrapdesc then setup.extendeddiz := false;
                      end;
                 22 : setup.expandedlog := not setup.expandedlog;
                 23 : begin
                        tmp := int_to_str(setup.space);
                        read_string(65,19,5,5,tmp,c_numbers);
                        setup.space := str_to_int(tmp);
                      end;
                end;
              end;
      end;
    end;
  remove_window(3);
End;


{  ------------ ORIGIN LOOP ---------------------}

Procedure OriginLoop;
Var
  Ar  : Array[1..14] of String[3];
  Ge  : Integer;
  Tmp : String;

  Procedure WriteOrigin;
  Var X : Byte;
  Begin
    For X := 1 to 14 do
      WriteAt(14,7+x,foreentry,backentry,setup.origline[x]);
  End;

Begin
  with mwin[3] do
    begin
      x1 := 7;
      x2 := 6;
      y1 := 74;
      y2 := 23;
      st := ' OriginLines ';
    end;
  create_window(3);

  ar[1] := '#1 ';
  ar[2] := '#2 ';
  ar[3] := '#3 ';
  ar[4] := '#4 ';
  ar[5] := '#5 ';
  ar[6] := '#6 ';
  ar[7] := '#7 ';
  ar[8] := '#8 ';
  ar[9] := '#9 ';
  ar[10]:= '#10';
  ar[11]:= '#11';
  ar[12]:= '#12';
  ar[13]:= '#13';
  AR[14]:= '#14';

  ge := 1;
  while ge <> 0 do
    begin
      writeorigin;
      choosehook := dummy;
      decwin(3);
      ge := select_window(3,14,3,@ar,ge,false);
      incwin(3);
      if ge <> 0 then
        begin
          tmp := setup.origline[ge];
          read_string(14,7+ge,60,60,tmp,c_all);
          setup.origline[ge] := tmp;
        end;
    end;
  remove_window(3);
End;


{  ------------ ALIAS LOOP ----------------------}


Procedure AliasLoop;
Var
  Ar  : Array[1..13] of String[3];
  Ge  : Integer;
  Tmp : String;

  Procedure WriteAlias;
  Var X : Byte;
  Begin
    For X := 1 to 13 do
      Writeat(35,7+x,foreentry,backentry,setup.alias[x]);
  End;

Begin
  with mwin[3] do
    begin
      x1 := 28;
      x2 := 6;
      y1 := 56;
      y2 := 22;
      st := ' Aliases ';
    end;
  create_window(3);

  ar[1] := '#1 ';
  ar[2] := '#2 ';
  ar[3] := '#3 ';
  ar[4] := '#4 ';
  ar[5] := '#5 ';
  ar[6] := '#6 ';
  ar[7] := '#7 ';
  ar[8] := '#8 ';
  ar[9] := '#9 ';
  ar[10]:= '#10';
  ar[11]:= '#11';
  ar[12]:= '#12';
  ar[13]:= '#13';

  ge := 1;
  while ge <> 0 do
    begin
      writealias;
      choosehook := dummy;
      decwin(3);
      ge := select_window(3,13,3,@ar,ge,false);
      incwin(3);
      if ge <> 0 then
        begin
          tmp := setup.alias[ge];
          read_string(35,7+ge,20,20,tmp,c_all);
          setup.alias[ge] := tmp;
        end;
    end;
  remove_window(3);
End;


{  ------------ LOGFILE LOOP --------------------}


Procedure LogfileLoop;
Var
  Ar : Array[1..11] of String[21];
  Ge : Integer;

  Procedure Writelog;
  Begin
    If LFatal in setup.logstatus then
      Writeat(53,9,foreentry,backentry,'Yes') else Writeat(53,9,foreentry,backentry,'No ');
    If LOther in setup.logstatus then
      Writeat(53,10,foreentry,backentry,'Yes') else Writeat(53,10,foreentry,backentry,'No ');
    If LAccounting in setup.logstatus then
      Writeat(53,11,foreentry,backentry,'Yes') else Writeat(53,11,foreentry,backentry,'No ');
    If Lsending in setup.logstatus then
      Writeat(53,12,foreentry,backentry,'Yes') else Writeat(53,12,foreentry,backentry,'No ');
    If LForwarding in setup.logstatus then
      Writeat(53,13,foreentry,backentry,'Yes') else Writeat(53,13,foreentry,backentry,'No ');
    If LBrief in setup.logstatus then
      Writeat(53,14,foreentry,backentry,'Yes') else Writeat(53,14,foreentry,backentry,'No ');
    If LTrivial in setup.logstatus then
      Writeat(53,15,foreentry,backentry,'Yes') else Writeat(53,15,foreentry,backentry,'No ');
    If Linfo in setup.logstatus then
      Writeat(53,16,foreentry,backentry,'Yes') else Writeat(53,16,foreentry,backentry,'No ');
    If Lsession in setup.logstatus then
      Writeat(53,17,foreentry,backentry,'Yes') else Writeat(53,17,foreentry,backentry,'No ');
    If LProcess in setup.logstatus then
      Writeat(53,18,foreentry,backentry,'Yes') else Writeat(53,18,foreentry,backentry,'No ');
  End;

Begin
  with mwin[3] do
    begin
      x1 := 27;
      x2 := 7;
      y1 := 57;
      y2 := 21;
      st := ' Logfile ';
    end;
  create_window(3);

  ar[1] := '! Fatal errors       ';
  ar[2] := '? Other errors       ';
  ar[3] := '$ Accounting info    ';
  ar[4] := '* Processing of files';
  ar[5] := ': Forwarding of files';
  ar[6] := '= Sending of files   ';
  ar[7] := '+ Brief messages     ';
  ar[8] := '- Trivial messages   ';
  ar[9] := '% Info messages      ';
  ar[10]:= '~ Session information';
  ar[11]:= '  All of the above   ';

  ge := 1;
  while ge <> 0 do
    begin
      writelog;
      choosehook := dummy;
      decwin(3);
      ge := select_window(3,11,21,@ar,ge,false);
      incwin(3);
      case ge of
        1 : begin
              If LFatal in setup.logstatus then
                setup.logstatus := setup.logstatus - [LFatal] else
                  setup.logstatus := setup.logstatus + [LFatal];
            end;
        2 : begin
              If LOther in setup.logstatus then
                setup.logstatus := setup.logstatus - [LOther] else
                  setup.logstatus := setup.logstatus + [LOther];
            end;
        3 : begin
              If LAccounting in setup.logstatus then
                setup.logstatus := setup.logstatus - [Laccounting] else
                  setup.logstatus := setup.logstatus + [Laccounting];
            end;
        4 : begin
              If Lsending in setup.logstatus then
                setup.logstatus := setup.logstatus - [lsending] else
                  setup.logstatus := setup.logstatus + [lsending];
            end;
        5 : begin
              If LForwarding in setup.logstatus then
                setup.logstatus := setup.logstatus - [LForwarding] else
                  setup.logstatus := setup.logstatus + [LForwarding];
            end;
        6 : begin
              If LBrief in setup.logstatus then
                setup.logstatus := setup.logstatus - [LBrief] else
                  setup.logstatus := setup.logstatus + [LBrief];
            end;
        7 : begin
              If LTrivial in setup.logstatus then
                setup.logstatus := setup.logstatus - [LTrivial] else
                  setup.logstatus := setup.logstatus + [LTrivial];
            end;
        8 : begin
              If Linfo in setup.logstatus then
                setup.logstatus := setup.logstatus - [linfo] else
                  setup.logstatus := setup.logstatus + [linfo];
            end;
        9 : begin
              If LSession in setup.logstatus then
                setup.logstatus := setup.logstatus - [LSession] else
                  setup.logstatus := setup.logstatus + [LSession];
            end;
        10: begin
              If LProcess in setup.logstatus then
                setup.logstatus := setup.logstatus - [LProcess] else
                  setup.logstatus := setup.logstatus + [LProcess];
            end;
        11: begin
              setup.Logstatus  := [LFatal..LProcess];
            end;
      end;
    end;
  remove_window(3);
End;


{  ------------ UPLINK LOOP ---------------------}

var uplinknr : byte;


{$F+} Procedure Uplink2Help ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Network address of this uplink');
    2 : Writeat(1,25,7,0,'Program that FileMgr should address arearequests to');
    3 : Writeat(1,25,7,0,'Password that FileMgr should specify on the subjectline');
    4 : Writeat(1,25,7,0,'Should FileMgr add a ''+'' prefix to request areas?');
    5 : Writeat(1,25,7,0,'Groups that uplinks is ''feeding''');
    6 : Begin
          Writeat(1,25,7,0,'ASCII file containing file-areas from your uplink');
          If (setup.exteditor <> '') then writeat(64,25,14,0,'Press F2 to edit');
        End;
    7 : Writeat(1,25,7,0,'Which of your AKA''s should be used when writing messages to this uplink');
  End;
End;

{$F+} procedure uplinklistedit(welke:byte); {$F-}
var res : word;
begin
   if (welke = 6) and (setup.exteditor <> '') then
     begin
       if setup.uplink[uplinknr].areafile <> '' then
         begin
           cursor_on;
           savescreen;
           res := fmExec(setup.exteditor,setup.uplink[uplinknr].areafile, setup.SwapMethode, $ffff, false, false);
           restorescreen;
           cursor_off;
         end;
     end;
end;

Procedure Uplink2Loop;
Const
  upref = $02;
Var
  Ar      : Array[1..7] of String[14];
  Ge, Y   : Integer;
  Tmp     : String;
  Prefix  : Boolean;
  Bol     : Boolean;

  Procedure WriteUploop;
  Begin
    Writeat(31,13,foreentry,backentry,expand(node2str(setup.uplink[uplinknr].address),39));
    Writeat(31,14,foreentry,backentry,expand(setup.uplink[uplinknr].mgrname,39));
    Writeat(31,15,foreentry,backentry,expand(setup.uplink[uplinknr].password,39));
    If prefix then Writeat(31,16,foreentry,backentry,'Yes') else
      Writeat(31,16,foreentry,backentry,'No ');
    Writeat(31,17,foreentry,backentry,expand(writeGroups(39,setup.uplink[uplinknr].groups),39));
    Writeat(31,18,foreentry,backentry,expand(setup.uplink[uplinknr].areafile,39));
    Writeat(31,19,foreentry,backentry,expand(node2str(setup.address[setup.uplink[uplinknr].aka]),39));
  End;

Begin
  if setup.uplink[uplinknr].address.zone = 0 then
    begin
      setup.uplink[uplinknr].mgrname := 'FILEMGR';
      setup.uplink[uplinknr].status  := upref;
      setup.uplink[uplinknr].aka     := 1;
    end;
  prefix := setup.uplink[uplinknr].status and upref = upref;

  with mwin[4] do
    begin
      x1 := 13;
      x2 := 11;
      y1 := 70;
      y2 := 21;
      st := ' Uplink '+int_to_str(uplinknr)+' ';
    end;
  create_window(4);

  ar[1] := 'Address       ';
  ar[2] := 'Mgr program   ';
  ar[3] := ' Password    ';
  ar[4] := ' Use + prefix';
  ar[5] := 'Groups        ';
  ar[6] := 'Area listfile ';
  ar[7] := 'Origin Address';

  f2hook := uplinklistedit;
  ge := 1;
  while ge <> 0 do
    begin
      writeuploop;
      choosehook := uplink2help;
      decwin(4);
      ge := select_window(4,7,14,@ar,ge,false);
      incwin(4);
      case ge of
        1 : begin
              tmp := node2str(setup.uplink[uplinknr].address);
              read_string(31,13,39,23,tmp,c_all);
              str2node(tmp,setup.uplink[uplinknr].address,setup.address[1],bol);
              if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
            end;
        2 : begin
              tmp := setup.uplink[uplinknr].mgrname;
              read_String(31,14,39,15,tmp,c_all);
              setup.uplink[uplinknr].mgrname := tmp;
            end;
        3 : begin
              tmp := setup.uplink[uplinknr].password;
              read_String(31,15,39,15,tmp,c_all);
              setup.uplink[uplinknr].password := tmp;
            end;
        4 : prefix := not prefix;
        5 : select_groups(5,setup.uplink[uplinknr].groups,false);
        6 : begin
              tmp := setup.uplink[uplinknr].areafile;
              read_string(31,18,39,80,tmp,c_all);
              setup.uplink[uplinknr].areafile := tmp;
            end;
        7 : begin
              choosehook := dummy;
              setup.uplink[uplinknr].aka := Select_Address(5,setup.uplink[uplinknr].aka,false);
            end;
      end;
    end;
  f2hook := dummy1;
  setup.uplink[uplinknr].status := byte(prefix) * upref;
  remove_window(4);
End;


Procedure UplinkLoop;
Var
  Ge : Integer;
  Ch : Char;

  Procedure WriteUplink(ge:integer);
  Var X : Byte;
  Begin
    For x := 1 to 10 do
      begin
        writeat(16,8+x,foreentry,backentry,expand(' ',23));
        Writeat(16,8+x,foreentry,backentry,first(23,node2str(Setup.Uplink[x].address)));
      end;
    For x := 11 to 20 do
      begin
        writeat(45,8+x-10,foreentry,backentry,expand(' ',23));
        Writeat(45,8+x-10,foreentry,backentry,first(23,node2str(Setup.Uplink[x].address)));
      end;

    For X := 1 to 10 do
      Writeat(11,8+x,7,0,' '+expand(int_to_str(x),3));
    For X := 11 to 20 do
      Writeat(40,8+x-10,7,0,' '+expand(int_to_str(x),3));

    If ge < 11 then
      Writeat(11,8+ge,kl4,kl5,' '+expand(int_to_str(ge),3)) else
        Writeat(40,8+ge-10,kl4,kl5,' '+expand(int_to_Str(ge),3));
  End;

Begin
  with mwin[3] do
    begin
      x1 := 10;
      x2 := 7;
      y1 := 69;
      y2 := 20;
      st := ' Uplinks ';
    end;
  create_window(3);

  ge := 1;
  ch := #0;
  repeat
    writeuplink(ge);
    choosehook := dummy;
    ch := readkey;
    case ch of
      #0 : begin
             ch := readkey;
             case ch of
               #72 : if ge > 1 then dec(ge) else ge := 20; {up}
               #80 : if ge < 20 then inc(ge) else ge := 1; {dn}
               #75, #77 : {rgt/lft} if ge < 11 then inc(ge,10) else dec(ge,10);
               #73, #71 : ge := 1;
               #81, #79 : ge := 20;
               #83 {del} : fillchar(setup.uplink[ge],sizeof(setup.uplink[ge]),#0);
             end;
           end;
      #9 : infoscreen;
      #26: dosshell;
      #13: begin
             uplinknr := ge;
             uplink2loop;
           end;
    end;
  until ch = #27;
  remove_window(3);
End;



{  ------------ LANGUAGE LOOP ---------------}

{$F+} Procedure LanguageHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Day language definitions for announcements');
    2 : Writeat(1,25,7,0,'Month language definitions for announcements');
    3 : Writeat(1,25,7,0,'Miscellaneous language definitions for announcements');
    4 : Writeat(1,25,7,0,'Edit the external tpl files');
    5 : Writeat(1,25,7,0,'Setup and edit the optional tpl message files');
  End;
End;

Procedure DayLanguage;
Var
  Ar  : Array[1..7] of String[9];
  Ge  : Integer;

  Procedure editday(ge:word);
  var tmp : string;
  begin
    tmp := setup.dayarray[ge];
    read_String(38,9+ge,15,15,tmp,c_all);
    setup.dayarray[ge] := tmp;
  end;

  procedure writeit;
  var x : byte;
  begin
    for x := 1 to 7 do
     writeat(38,9+x,foreentry,backentry,setup.dayarray[x]);
  end;

Begin
  with mwin[4] do
    begin
      x1 := 25;
      x2 := 8;
      y1 := 54;
      y2 := 18;
      st := ' Day definitions ';
    end;
  create_window(4);

  ar[1] := 'Sunday';
  ar[2] := 'Monday';
  ar[3] := 'Tuesday';
  ar[4] := 'Wednesday';
  ar[5] := 'Thursday';
  ar[6] := 'Friday';
  ar[7] := 'Saturday';

  ge := 1;
  while ge <> 0 do
    begin
      writeit;
      choosehook := dummy;
      decwin(4);
      ge := select_window(4,7,9,@ar,ge,false);
      incwin(4);
      if ge <> 0 then editday(ge);
    end;
  remove_window(4);
End;


Procedure MonthLanguage;
Var
  Ar  : Array[1..12] of String[9];
  Ge  : Integer;

  Procedure editmonth(ge:word);
  var tmp : string;
  begin
    tmp := setup.montharray[ge];
    read_String(38,8+ge,15,15,tmp,c_all);
    setup.montharray[ge] := tmp;
  end;

  procedure writeit;
  var x : byte;
  begin
    for x := 1 to 12 do
     writeat(38,8+x,foreentry,backentry,setup.montharray[x]);
  end;

Begin
  with mwin[4] do
    begin
      x1 := 25;
      x2 := 7;
      y1 := 54;
      y2 := 22;
      st := ' Month definitions ';
    end;
  create_window(4);

  ar[1] := 'January';
  ar[2] := 'February';
  ar[3] := 'March';
  ar[4] := 'April';
  ar[5] := 'May';
  ar[6] := 'June';
  ar[7] := 'July';
  ar[8] := 'August';
  ar[9] := 'September';
  ar[10] := 'October';
  ar[11] := 'November';
  ar[12] := 'December';

  ge := 1;
  while ge <> 0 do
    begin
      writeit;
      choosehook := dummy;
      decwin(4);
      ge := select_window(4,12,9,@ar,ge,false);
      incwin(4);
      if ge <> 0 then editmonth(ge);
    end;
  remove_window(4);
End;

Procedure MiscLanguage;
Var
  Ar  : Array[1..3] of String[10];
  Ge  : Integer;
  Tmp : String;

  procedure writemisc;
  var x : byte;
  begin
    writeat(34,11,foreentry,backentry,setup.partstr);
    writeat(34,12,foreentry,backentry,first(30,setup.cont1str));
    writeat(34,13,foreentry,backentry,first(30,setup.cont2str));
  end;

Begin
  with mwin[4] do
    begin
      x1 := 20;
      x2 := 9;
      y1 := 65;
      y2 := 15;
      st := ' Miscellaneous definitions ';
    end;
  create_window(4);

  ar[1] := 'Part';
  ar[2] := 'Continued in next message';
  ar[3] := 'Continued from last message';

  ge := 1;
  while ge <> 0 do
    begin
      writemisc;
      choosehook := dummy;
      decwin(4);
      ge := select_window(4,3,10,@ar,ge,false);
      incwin(4);
      if ge <> 0 then
        begin
          case ge of
            1 : begin
                  tmp := setup.partstr;
                  read_String(34,11,10,10,tmp,c_all);
                  setup.partstr := tmp;
                end;
            2 : begin
                  tmp := setup.cont1str;
                  read_String(34,12,30,50,tmp,c_all);
                  setup.cont1str := tmp;
                end;
            3 : begin
                  tmp := setup.cont2str;
                  read_String(34,13,30,50,tmp,c_all);
                  setup.cont2str := tmp;
                end;
          end;
        end;
    end;
  remove_window(4);
End;



{$F+} procedure optionaltplhelp(ge:byte); {$F-}
begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case ge of
    1 : Writeat(1,25,7,0,'The msg that will be sent when a node requests help');
    2 : Writeat(1,25,7,0,'The msg that will be placed under every cso bill');
    3 : Writeat(1,25,7,0,'The msg that will be sent when a node runs out of credits');
    4 : Writeat(1,25,7,0,'The msg that will be send when a node reaches credit warn level');
  End;
  If (setup.exteditor <> '') then writeat(64,25,14,0,'Press F2 to edit');
end;

{$F+} procedure extopttpl(welke:byte); {$F-}
var tmp : string;
    res : byte;
begin
  case welke of
   1 : tmp := setup.helptplmsg;
   2 : tmp := setup.csobillmsg;
   3 : tmp := setup.ooctplmsg;
   4 : tmp := setup.aooctplmsg;
  end;
  if (setup.exteditor <> '') and exist(tmp) then
    begin
      cursor_on;
      savescreen;
      res := fmExec(setup.exteditor,tmp, setup.SwapMethode, $ffff, false, false);
      restorescreen;
      cursor_off;
    end;
end;

Procedure Optional;
Var
  Ar  : Array[1..4] of String[14];
  Ge  : Integer;

  Procedure editmsg(ge:word);
  var tmp : string;
  begin
    case ge of
     1 : tmp := setup.helptplmsg;
     2 : tmp := setup.csobillmsg;
     3 : tmp := setup.ooctplmsg;
     4 : tmp := setup.aooctplmsg;
    end;
    read_String(30,11+ge,40,80,tmp,c_all);
    if (tmp <> '') and not exist(tmp) then
      begin
        if askwindow(upper(tmp),'does not exist','Create (Y/N) ?',['y','Y','n','N']) in ['y','Y'] then
          create_file(tmp);
      end;
    case ge of
      1 : setup.helptplmsg := tmp;
      2 : setup.csobillmsg := tmp;
      3 : setup.ooctplmsg := tmp;
      4 : setup.aooctplmsg := tmp;
    end;
  end;

  procedure writeit;
  begin
    writeat(30,12,foreentry,backentry,first(40,setup.helptplmsg));
    writeat(30,13,foreentry,backentry,first(40,setup.csobillmsg));
    writeat(30,14,foreentry,backentry,first(40,setup.ooctplmsg));
    writeat(30,15,foreentry,backentry,first(40,setup.aooctplmsg));
  end;

Begin
  with mwin[4] do
    begin
      x1 := 12;
      x2 := 10;
      y1 := 71;
      y2 := 17;
      st := ' Optional tpl''s ';
    end;
  create_window(4);

  ar[1] := 'Help msg';
  ar[2] := 'Cso bill';
  ar[3] := 'Out of credits';
  ar[4] := 'Warning msg';

  f2hook := extopttpl;
  ge := 1;
  while ge <> 0 do
    begin
      writeit;
      choosehook := optionaltplhelp;
      decwin(4);
      ge := select_window(4,4,14,@ar,ge,false);
      incwin(4);
      if ge <> 0 then editmsg(ge);
    end;
  remove_window(4);
  f2hook := dummy1;
End;


Procedure LanguageLoop;
Var
  Ar  : Array[1..5] of String[13];
  Ge  : Integer;
  Tmp : String;
  Res : word;
Begin
  with mwin[3] do
    begin
      x1 := 37;
      x2 := 10;
      y1 := 53;
      y2 := 18;
      st := ' Tpl ';
    end;
  create_window(3);
  ge := 1;
  while ge <> 0 do
    begin
      ar[1] := 'Days';
      ar[2] := 'Months';
      ar[3] := 'Miscellaneous';
      ar[4] := 'Edit tpl''s';
      ar[5] := 'Optional';
      choosehook := languagehelp;
      decwin(3);
      ge := select_window(3,5,13,@ar,ge,false);
      incwin(3);
      case ge of
        1 : daylanguage;
        2 : monthlanguage;
        3 : misclanguage;
        4 : begin
              if setup.exteditor <> '' then
                begin
                  if setup.tplpath <> '' then
                    Begin
                      writeat(1,25,7,0,expand('Select the tpl file to edit',80));
                      tmp := Select_Tpl(4,'',false);
                      if tmp <> '' then
                        begin
                          cursor_on;
                          savescreen;
                          res := fmExec(setup.exteditor,setup.tplpath+tmp, setup.SwapMethode, $ffff, false, false);
                          restorescreen;
                          cursor_off;
                        end;
                    end;
                end else askwindow('External editor','not installed','Press [ENTER] to continue',[#13,#27,#32]);
            end;
        5 : Optional;
      end;
    end;
  remove_window(3);
End;


{ ------------- SECURITY ------------------------}

Procedure Security;
Var Tmp,
    Tmp1 : String;
    x   : byte;
Begin
  If setup.password <> '' then
    Begin
      If not (Askwindow('','Remove existing password? (Y/N)','',['y','Y','n','N',#27])
      in ['y','Y']) then Exit;
    End;

  With Mwin[3] do
    Begin
      x1 := 30;
      x2 := 10;
      y1 := 50;
      y2 := 14;
      st := ' Password ';
    End;
  Create_Window(3);
  Writeat(1,25,7,0,'Password required before entering FMSETUP');
  Tmp := '';
  Read_password(32,12,17,22,tmp,c_all);

  If tmp <> '' then
    Begin
      With Mwin[4] do
        Begin
          x1 := 32;
          x2 := 12;
          y1 := 52;
          y2 := 16;
          St := ' Password ';
        End;
      Create_window(4);
      Writeat(1,25,7,0,'Please enter password again for security ');
      Tmp1 := '';
      Read_password(34,14,17,22,tmp1,c_all);

      If Tmp = Tmp1 then
        Begin
          for x := 1 to length(tmp) do tmp[x] := chr(ord(tmp[x])-30);
          setup.password := tmp;
        End Else
          Askwindow('','Passwords do not match!','',[#13,#27,#32]);

      Remove_window(4);
    End Else
     Setup.password := Tmp;
  Remove_window(3);
End;



{  ------------ SEMAPHORE LOOP ---------------}


{$F+} Procedure SemaphoreHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'The semaphore mode to use (none = disabled)');
    2 : Writeat(1,25,7,0,'Seconds to wait on other task before aborting');
    3 : Writeat(1,25,7,0,'Maximum time before semaphore is declared old (in minuts)');
    4 : Writeat(1,25,7,0,'The file to create or touch when a mailer rescan should be performed');
  End;
End;


Procedure SemaphoreLoop;
Var
  Ar  : Array[1..4] of String[15];
  Ge  : Integer;
  Tmp : String;

  Procedure Writeit;
  Begin
    case setup.semamode of
      0 : writeat(29,12,foreentry,backentry,'None           ');
      1 : writeat(29,12,foreentry,backentry,'BinkleyTerm    ');
      2 : writeat(29,12,foreentry,backentry,'Frontdoor      ');
      3 : writeat(29,12,foreentry,backentry,'Intermail      ');
      4 : writeat(29,12,foreentry,backentry,'Portal of Power');
    end;
    writeat(29,13,foreentry,backentry,expand(int_to_str(setup.secstowait),5));
    writeat(29,14,foreentry,backentry,expand(int_to_str(setup.maxwaittime),5));
    writeat(29,15,foreentry,backentry,expand(setup.rescanfile,40));
  End;

Begin
  with mwin[3] do
    begin
      x1 := 10;
      x2 := 10;
      y1 := 70;
      y2 := 17;
      st := ' Semaphores ';
    end;
  create_window(3);

  ar[1] := 'Semaphore mode';
  ar[2] := 'Seconds to wait';
  ar[3] := 'Max wait time';
  ar[4] := 'Mailer rescan';

  ge := 1;
  while ge <> 0 do
    begin
      writeit;
      decwin(3);
      choosehook := semaphorehelp;
      ge := select_window(3,4,15,@ar,ge,false);
      incwin(3);
      case ge of
        1 : begin
              inc(setup.semamode);
              if setup.semamode = 5 then setup.semamode := 0;

              if setup.semaphorepath <> '' then
                begin
                  case setup.semamode of
                    1 : setup.rescanfile := '';
                    2 : setup.rescanfile := setup.semaphorepath+'FDRESCAN.NOW';
                    3 : setup.rescanfile := setup.semaphorepath+'IMRESCAN.NOW';
                    4 : setup.rescanfile := '';
                  end;
                end;
            end;
        2 : begin
              tmp := int_to_str(setup.secstowait);
              read_string(29,13,5,5,tmp,c_all);
              setup.secstowait := str_to_int(tmp);
            end;
        3 : begin
              tmp := int_to_str(setup.maxwaittime);
              read_string(29,14,5,5,tmp,c_all);
              setup.maxwaittime := str_to_int(tmp);
            end;
        4 : begin
              tmp := setup.rescanfile;
              read_string(29,15,40,80,tmp,c_all);
              setup.rescanfile := upper(tmp);
              if (tmp <> '') and not exist(setup.rescanfile) then
                if askwindow(setup.rescanfile,'does not exist!','Create (Y/N) ?',['y','Y','n','N']) in ['y','Y'] then
                  create_file(setup.rescanfile);
            end;
      end;
    end;
  remove_window(3);
  if setup.semamode = 0 then
    begin
      delete_file(systempath+'FMBUSY.NOW');
      delete_file(setup.semaphorepath+'FMBUSY.NOW');
    end;
End;




{  ------------ MAIN SYSTEEM LOOP ---------------}


{$F+} Procedure SystemHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'System addresses');
    2 : Writeat(1,25,7,0,'Match a specified AKA to a zone');
    3 : Writeat(1,25,7,0,'bbs and mailer settings');
    4 : Writeat(1,25,7,0,'Directories and filenames');
    5 : Writeat(1,25,7,0,'External programs, parameters and options');
    6 : writeat(1,25,7,0,'Special behaviour options of FileMgr');
    7 : Writeat(1,25,7,0,'General FileMgr parameters');
    8 : Writeat(1,25,7,0,'Originlines, used for announcements');
    9 : Writeat(1,25,7,0,'Names to be recognized by FileMgr');
   10 : Writeat(1,25,7,0,'Specific logfile options');
   11 : Writeat(1,25,7,0,'Information about your uplinks');
   12 : Writeat(1,25,7,0,'Template language definitions');
   13 : Writeat(1,25,7,0,'Multinode sempahore settings');
   14 : Writeat(1,25,7,0,'Security access to FMSETUP');
  End;
End;


Procedure SystemLoop;
Var
  Ar : Array[1..14] of String[17];
  Ge : Integer;
Begin
  with mwin[2] do
    begin
      x1 := 35;
      x2 := 5;
      y1 := 55;
      y2 := 22;
      st := ' System Data ';
    end;
  create_window(2);

  ar[1] := 'Addresses';
  ar[2] := 'AKA matching';
  ar[3] := 'Site info';
  ar[4] := 'Paths & filenames';
  ar[5] := 'External programs';
  ar[6] := 'Behaviour';
  ar[7] := 'Miscellaneous';
  ar[8] := 'Originlines';
  ar[9] := 'Aliases';
  ar[10]:= 'Logfile';
  ar[11]:= 'Uplinks';
  ar[12]:= 'Tpl language';
  ar[13]:= 'Semaphores';
  ar[14]:= 'Security';

  ge := 1;
  while ge <> 0 do
    begin
      decwin(2);
      choosehook := systemhelp;
      ge := select_window(2,14,17,@ar,ge,false);
      incwin(2);
      case ge of
        1 : AdressLoop;
        2 : AkaLoop;
        3 : SysInfoLoop;
        4 : PathLoop;
        5 : ExternalLoop;
        6 : Behaviourloop;
        7 : MiscLoop;
        8 : OriginLoop;
        9 : AliasLoop;
       10 : LogfileLoop;
       11 : UplinkLoop;
       12 : LanguageLoop;
       13 : SemaphoreLoop;
       14 : Security;
      end;
    end;
  remove_window(2);
End;

End.
