{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: FileMgr Program
 *
 * vbc - 09/02/08 - see fm_noti.pas for version no. details
 *                      fm_struct       ditto
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Program FileMgr;
{  stack, Heap Min, Heap Max }
{$M 65000,120000,650000}

Uses
  S_String, F_File,

  MkMsgSqu, MkMsgHud, MkMsgJam, MkMsgEzy, MkMsgAbs, MkMsgPkt, MkMsgTxt,
  MkMisc, MkFile, MkGlobt, MkDos, MkOpen,

  Compsys,
  Ibm_arc, Ibm_arj, Ibm_dwc, Ibm_hyp, Ibm_lha, Ibm_pkz, Ibm_rar, Ibm_sqz, Ibm_zoo,

  Crosslib,
  Fm_Struct, Fm_MTask, Fm_Init, Fm_New, Fm_File, Fm_Sched, Fm_Hatch, Fm_List,
  Fm_Ann, Fm_Scan, Fm_Noti, Fm_Man, Fm_Bbs, Fm_Log, Nw_Forw, Fm_Bill,

{ Fm_Key, } {  removed from all processing }

  Fm_Basic, Fm_Rear, Fm_Clean, Fm_Ovr;

{$O MkMsgSqu}
{$O MkMsgHud}
{$O MkMsgJam}
{$O MkMsgEzy}
{$O MkMsgAbs}
{$O MkMsgPkt}
{$O MkMsgTxt}

{$O MkMisc}
{$O MkfFile}
(* {$O MkFile} *)
{$O MkGlobt}
{$O MkDos}
{$O MkOpen}

{$O CROSSLIB}
{$O FM_BASIC}
{$O FM_MTASK}
{$O FM_INIT}
{$O FM_NEW}
{$O FM_SCHED}
{$O FM_HATCH}
{$O FM_ANN}
{$O FM_NOTI}
{$O FM_REAR}
{$O FM_BBS}
{$O FM_LOG}
{$O FM_BILL}
{$O FM_CLEAN}
{$O FM_PROC2}

Begin
  InitProgram;                                           {fm_init}
  OpenInit;

  For Run := 1 to ParamCount do
    Begin
      ParamWord := Upper(ParamStr(Run));
      If Paramword = 'SCAN'     then Scan else                 { fm_scan  }
      If Paramword = 'HATCH'    then Hatch else                { fm_hatch }
      If Paramword = 'MGR'      then Manager else              { fm_man   }
      If Paramword = 'ANNOUNCE' then Announcement else         { fm_ann   }
      If Paramword = 'NOTIFY'   then
        NotifyReport (parNode, not validnode, part, pnod) else { fm_noti }
      If Paramword = 'SCHEDULE' then Schedule else             { fm_sched }
      If Paramword = 'FILEFIND' then FileFind else             { fm_file  }
      If Paramword = 'NEWSCAN'  then NewScan else              { fm_new   }
      If Paramword = 'COST'     then Costs else                { fm_basic }
      If Paramword = 'CLEAN'    then
        CleanForwardFiles('Removing sent files...') else       { fm_forw  }
      if run = 1 then
        Begin
          Writeln(#7+'Invalid parameter '+paramword);
          Writeln;
          ParameterHelp;  { give help if invalid params  }
        End;
    End;

  If exist(systempath+'*.FM_') then ForwardFiles;              { fm_forw  }
  If exist(systempath+'FM_$A_MA.INT') and not nomaint
    then Area_Maint;                                           { fm_clean }
  If exist(systempath+'*.BIL') and not nobill then Bill;       { fm_bill  }

  If rescan then Rescanmailer;                                 { fm_forw  }
  CloseInit;                                                   { fm_init  }
End.

