{
 $Id$
}
{$S-,R-,V-}  Unit F_Fast;   (* F+ directive weggehaald ivm os/2 *)
{ Turn off Range check (R), stack overflow (s), Var string check (V)  }
 {*****************************************************************************
 *
 * Purpose ...............: Fast Screen write unit
 *                          Contains asm
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


  { v1.2 : added writecenter procedure }


INTERFACE

Uses
  Dos, S_String;

{-----------------------------------------------------------------------------}

Var
  Mono         : boolean;                  {if true monochrome screen detected}
  SnowProne    : boolean;
  BaseOfScreen : Word;                           {Base address of video memory}
  VSeg         : word;                          {Base address of active screen}
  VOfs         : word;                          {Base address of active screen}
  Vmod         : byte;                                     {current video mode}

Procedure Attrib(X1,Y1,X2,Y2,F,B:Byte);
                                               {changes color attrib at coords}

Procedure WriteAT(X,Y,F,B:integer; St:String);
                                                 {writes string fast to screen}

Procedure WriteCenter(Y,F,B:integer; St:String);
                                         {writes string centered to the screen}

Procedure PlainWrite(Col,Row:byte; St:String);
                                      {writes string without changes attribute}

Procedure FBox(X1,Y1,X2,Y2,F,B,boxtype:integer);
                                 {Draws a box and clears text within Box frame}

Procedure FillScreen(X1,Y1,X2,Y2:byte; F,B:byte; C:char);
                                         {fills screen with specific character}

{Procedure Init_Copyright;}
                                  {initializes the nice 'Copyright (c)' string}
{Function  Copyright : string;}
                                          {returns nice 'Copyright (c)' string}

Procedure Cursor_Half;
Procedure Cursor_Off;
Procedure Cursor_On;


Function Get_Video_Mode:byte;        {returns 7 if monoscreen else colorscreen}


{-----------------------------------------------------------------------------}

IMPLEMENTATION


  {$L F_FAST}

  {$F+}

  Procedure FastWrite(Col,Row,Attr:byte; St:String); external;
  Procedure Plainwrite(Col,Row:byte;St:string); external;
  Procedure Attribute(Col,Row,Attr:byte; Number:Word); external;
  {$F-}



  Procedure Cursor_On;
  Var
    regs : Registers;
  Begin
    Regs.Ah:=$01;
    Regs.Ch:=$06;
    Regs.Cl:=$07;
    Intr($10,Regs);
  End;

  Procedure Cursor_Off;
  Var
    regs : Registers;
  Begin
    Regs.Ah:=$01;
    Regs.Ch:=$16;
    Regs.Cl:=$0;
    Intr($10,Regs);
  End;

  Procedure Cursor_Half;
  Var
    regs : Registers;
  Begin
    Regs.Ah:=$01;
    Regs.Ch:=$04;
    Regs.Cl:=$07;
    Intr($10,Regs);
  End;


  Function Attr(F,B:byte):byte;
  {---------------------------}
  {converts foreground(F) and background(B) colors to combined Attribute byte}
  begin
      Attr := (B Shl 4) or F;
  end;


  Procedure Attrib(X1,Y1,X2,Y2,F,B : Byte );
  {----------------------------------------}
  Var
    I,X,A : byte;
  Begin
    A := Attr(F,B);
    X := Succ(X2-X1);
    For I := Y1 to Y2 do
      Attribute(X1,I,A,X);
  End;


  Procedure WriteAT(X,Y,F,B:integer;St:String);
  {-------------------------------------------}
  begin
      Fastwrite(X,Y,attr(F,B),St);
  end;

  Procedure WriteCenter(Y,F,B:integer;St:String);
  {---------------------------------------------}
  begin
      Fastwrite(40-( length(st) div 2 ),y,attr(f,b),st);
  end;


  Procedure ClearText(x1,y1,x2,y2,F,B:integer);
  var
    Y : integer;
    attrib : byte;
  begin
      If x2 > 80 then x2 := 80;
      Attrib := attr(F,B);
      For Y := y1 to y2 do Fastwrite(X1,Y,attrib,replicate(X2-X1+1,' '));
  end;


  Procedure FillScreen(X1,Y1,X2,Y2:byte; F,B:byte; C:char);
  var
     I : integer;
     S : string;
  begin
      Attrib(X1,Y1,X2,Y2,F,B);
      S := Replicate(Succ(X2-x1),C);
      For I := Y1 to Y2 do PlainWrite(X1,I,S);
  end;


  Procedure Box(X1,Y1,X2,Y2,F,B,boxtype:integer);
  {Draws a box on the screen}
  var
    I         :integer;
    corner1,corner2,corner3,corner4,
    horizline,
    vertline  : char;
    attrib    : byte;
  begin
      case boxtype of
      0:begin
            corner1:=' ';
            corner2:=' ';
            corner3:=' ';
            corner4:=' ';
            horizline:=' ';
            vertline:=' ';
        end;
      1:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
      2:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
      3:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
      4:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
    else
       corner1:=chr(ord(Boxtype));
       corner2:=chr(ord(Boxtype));
       corner3:=chr(ord(Boxtype));
       corner4:=chr(ord(Boxtype));
       horizline:=chr(ord(Boxtype));
       vertline:=chr(ord(Boxtype));
    end;{case}
    attrib := attr(F,B);
    FastWrite(X1,Y1,attrib,corner1);
    FastWrite(X1+1,Y1,attrib,replicate(X2-X1-1,horizline));
    FastWrite(X2,Y1,attrib,corner2);
    For I := Y1+1 to Y2-1 do
    begin
        FastWrite(X1,I,attrib,vertline);
        FastWrite(X2,I,attrib,vertline);
    end;
    FastWrite(X1,Y2,attrib,corner3);
    FastWrite(X1+1,Y2,attrib,replicate(X2-X1-1,horizline));
    FastWrite(X2,Y2,attrib,corner4);
  end; {Proc Box}


  Procedure FBox(X1,Y1,X2,Y2,F,B,boxtype:integer);
  {----------------------------------------------}
  {Draws a box and clears text within Box frame}
  begin
      Box(X1,Y1,X2,Y2,F,B,boxtype);
      ClearText(succ(X1),succ(Y1),pred(X2),pred(Y2),F,B);
  end;


  procedure HorizLine(X1,X2,Y,F,B,lineType : byte);
  var
    I : integer;
    Horizline : char;
    attrib : byte;
  begin
      case LineType of                     {5.00a}
      0       : HorizLine := ' ';
      2,4,7,9 : Horizline := '';
      1,3,6,8 : HorizLine := '';
      else HorizLine := Chr(LineType);
      end; {case}
      Attrib := attr(F,B);
      If X2 > X1 then
         FastWrite(X1,Y,attrib,replicate(X2-X1+1,Horizline))
      else
         FastWrite(X1,Y,attrib,replicate(X1-X2+1,Horizline));
  end;   {horizline}


  Procedure VertLine(X,Y1,Y2,F,B,lineType : byte);
  var
    I : integer;
    vertline : char;
    attrib : byte;
  begin
      case LineType of                {5.00a}
      0       : VertLine := ' ';
      2,4,7,9 : Vertline := '';
      1,3,6,8 : VertLine := '';
      else VertLine := Chr(LineType);
      end; {case}
      Attrib := attr(F,B);
      If Y2 > Y1 then
         For I := Y1 to Y2 do Fastwrite(X,I,Attrib,Vertline)
      else
         For I := Y2 to Y1 do Fastwrite(X,I,Attrib,Vertline);
  end;   {vertline}


  Function Get_Video_Mode:byte;
  var
     Regs : registers;
  begin
      with Regs do
      begin
          Ax := $0F00;
          Intr($10,Regs);
          Get_Video_Mode := Al;
      end;
  end;


procedure init_copyright;
Const
  Copyr: Array[0..15] of Byte = ( $00, $00, $3C, $42, $99, $A5, $A1, $A1,
                                  $A5, $99, $42, $3C, $00, $00, $00, $00 );
Var
  Regs : Registers;
Begin
  Regs.ah := $0F;
  Intr($10,regs);
  Vmod := regs.al;

  If Vmod in [2,3] then         {You MUST be in video mode 2 or 3}
    begin                       {2=vga mono, 3=vga color}
      regs.ax := $1100;         {function of int 10h}
      regs.bh := 16;            {number of bytes per char pattrn, VGA = 16 !}
      regs.bl := 0;             {forgot :-) }
      regs.cx := 1;             {number of patterns to store}
      regs.es := seg(CopyR);
      regs.bp := ofs(CopyR);
      regs.dx := 2;             {character offset in map block, #2=2 etc}
      intr($10,regs);
   end;
end;


function copyright : string;
{--------------------------}
Begin
  If Vmod in [2,3] then                      {You MUST be in video mode 2 or 3}
    Copyright := 'Copyright '+#2 else
      Copyright := 'Copyright (c)';
end;



Procedure F_Init;
Begin
   if Get_Video_Mode = 7 then
    begin
       BaseOfScreen := $B000;  {Mono}
       Mono := True;
    end else
    begin
       BaseOfScreen := $B800; {Color}
       Mono := False;
    end;
    VSeg := BaseOfScreen;
    Vofs := 0;
end;


{---------------------}


BEGIN
  F_Init;
END.

