PAGE  80,132
TITLE WRDPOSR  Position of the Nth word from the RIGHT, Ver 6.20

; WRDPOSR.ASM - WrdPosR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the index of the Nth word from the RIGHT delimited by
; spaces.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdPosR

S            EQU     DWORD PTR SS:[bx+6]
Nth          EQU     BYTE  PTR SS:[bx+4]

; WrdPosR - Index the Nth word from the RIGHT in a string.
; function WrdPosR (S: string; Nth: byte): byte;

WrdPosR      PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
; -- Evalute Nth --
       add   dl,Nth           ; Get Nth, Nth=0?
       jz    Exit             ;   yes, return null
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   cl,es:[di]       ; Get length
       jcxz  Exit             ; Exit if null string
; -- Set up constants --
       add   di,cx            ; To S[L]
       mov   al,' '           ; Get Space char to scan
       std                    ; Set DF to decrement
       EVEN                   ; Align for speed
L1:    repe  scasb            ; Scan for non-space
       je    Exit             ; All spaces
       repne scasb            ; Scan for space
       jne   Last             ; Last char, do test
       dec   dx               ; Word found, dec count
       jnz   L1               ; Loop if Nth word not reached
       inc   cx               ; To Wrd[0]
       inc   cx               ; To Wrd[1]
       jmp   SHORT Exit       ; Word found.
; -- Make test at S[0], CX=0 and DX>0 --
Last:  cmp   dl,2             ; DX=1?
       adc   cl,ch            ;   yes, set CL=1
Exit:  xchg  ax,cx            ; Set AL=value in CL
       ret   6                ; Clear all parameters

WrdPosR      ENDP

CODE   ENDS

       END
