PAGE  80,132
TITLE WRDPARSE  Generic parsing and token routines, Ver 6.20

; WRDPARSE.ASM - WrdParse, WrdToken
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

; WrdParse extracts the next delimited word RIGHT from the given Index.
; Nulls are significant; i.e., two delimiters in sequence is considered a null
; parse.

; WrdToken extracts the next delimited word RIGHT from the given Index.
; Nulls are ignored; i.e., two delimiters in sequence are overlooked.

; Routine has fully scanned when resulting Index is set to zero.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdToken, WrdParse
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR [bp+18]
S            EQU     DWORD PTR [bp+14]
Delims       EQU     DWORD PTR [bp+10]
Index        EQU     DWORD PTR [bp+6]

; AH: starting index  AL: Char to scan
; BX: starting offset
; CH: 0               CL: Count
; DH: Delim length    DL: Remaining S length


; WrdParse - Parse delimited word RIGHT from given Index.  Terminate at
; first delimiter found and extract word.
; procedure WrdParse (VAR Dest: string; S,Delims: string; VAR: Index: byte);

WrdParse     PROC FAR
       stc                    ; Set CF to mark Parse procedure
       jmp   SHORT Start      ; Jump into routine


; WrdToken - Parse delimited word RIGHT from given Index.  Continue until
; token found.
; procedure WrdToken (VAR Dest: string; S,Delims: string; VAR: Index: byte);

WrdToken     PROC FAR
       clc                    ; Clear CF to mark Token procedure
Start: lahf                   ; Save Flag Status
       mov   bx,ax            ; Save in BX
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       xor   ax,ax            ; Set AX=0
; -- Point to string to be delimited --
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Set CX
       jcxz  Exit2            ; Exit if null string (Sets '' and 0)
; -- Evaluate Index --
       les   di,Index         ; Point to Index
       mov   al,es:[di]       ; Get index value
; -- Adjust Index (Leave 0 index alone) --
       cmp   ah,al            ; Index>0?
       sbb   al,ah            ;   yes, decrement
; -- Index-1 within string length? --
       sub   cl,al            ; Length<=Index-1?
       jbe   Null             ;   yes, exit with null (Sets '' and 0)
       add   si,ax            ; First char to scan in S
       inc   ax               ; Set to Index
       mov   ah,al            ; Save starting index in AH
       mov   dx,cx            ; Save scan count in DL (DH=0)
; -- Evaluate delimiters --
       les   di,Delims        ; Point to delimiter string
       add   dh,es:[di]       ; Get Delims length, Delims = ''?
       jz    Rest             ;   yes, return rest of string
       inc   di               ; To Delims[1]
       cmp   dh,1             ; One delimiter?
       je    One              ;   yes, special case
       mov   cl,dh            ; Reset Delims length
; -- Check the procedure in use --
       xchg  ax,bx            ; Get flags into AH
       sahf                   ; Reset flags
       mov   ax,bx            ; Replace AX
       mov   bx,si            ; Save S[index] offset
       jc    L1               ; Jump if parse routine
; -- Search for token --
       EVEN                   ; Align for speed
L0:    lodsb                  ; Get first char
       repne scasb            ; Scan delimiters
       jne   Tok              ; Found token
       add   di,cx            ; As if full scan of delimiters
       mov   cl,dh            ; Reset Delims length
       sub   di,cx            ; To Delims[1]
       inc   bx               ; Increment S starting offset
       inc   ah               ; Increment starting index
       dec   dl               ; S length -1
       jnz   L0               ; Try again
       jmp   SHORT Null       ; Nothing but delimiters left
; -- Search for delimiter --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get string char
       repne scasb            ; Scan for delimiter
       je    Found            ; Found delimiter
Tok:   mov   cl,dh            ; Reset Delims length
       sub   di,cx            ; To Delims[1]
       dec   dl               ; S length -1
       jnz   L1               ; Try again
; -- Delimiter not found; Return rest of string; set index=0
NoDel: mov   ah,ch            ; Set AH=0
       inc   si               ; Act like delimiter
; -- Calculate length --
Found: mov   cx,si            ; Get current SI
       sub   cx,bx            ; Calc position
       cmp   ch,dl            ; Past last char?
       jz    AtEnd            ;   yes, leave new index=0
       add   ah,cl            ; Calc new index
AtEnd: dec   cx               ; Account for delimiter
; -- Reset pointers --
       mov   si,bx            ; To S[index]
Exit:  mov   al,cl            ; Set length in AL
Exit2: les   di,Dest          ; Set up destination
       stosb                  ; Save length
       call  RepMovsB         ; Do fast move of bytes
; -- Set new index --
       les   di,index         ; Get Index
       mov   al,ah            ; Place new Index in AL
       stosb                  ; Save next Index
       pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   16               ; Clear all parameters

; -- Return Null string and new Index=0 --
Null:  mov   cl,ch            ; Set CX=0
; -- Return rest of string and new Index=0 --
Rest:  mov   ah,ch            ; Set AH=0
       jmp   SHORT Exit       ; Finish up routine

; -- One character delimiter --
One:   mov   al,es:[di]       ; Get the delimiter
       mov   di,ds            ; Copy DS ...
       mov   es,di            ;   ... into ES
       mov   di,si            ; Copy SI into DI
; -- Check the procedure in use --
       xchg  ax,bx            ; Get flags into AH
       sahf                   ; Reset flags
       mov   ax,bx            ; Replace AX
       mov   bx,si            ; Save S[index] offset
       jc    Parse            ; Jump if parse routine
; -- Search for token --
       repe  scasb            ; Search for token
       je    Rest             ; Not found, (Return '' and index=0)
       xchg  cl,dl            ; Swap counts
       sub   cl,dl            ; Delimiter count
       dec   cx               ; Account for token
       add   bx,cx            ; New initial offset
       add   ah,cl            ; New initial index
       mov   cl,dl            ; Reset chars to scan
; -- Search for delimiter --
Parse: repne scasb            ; Search for delimiter
       mov   dl,cl            ; Copy remaining scan count
       mov   si,di            ; Copy offset as Source
       jne   NoDel            ; Not found
       inc   dx               ; Another word to find
       jmp   SHORT Found      ; Found it

WrdToken     ENDP

WrdParse     ENDP

CODE   ENDS

       END
