PAGE  80,132
TITLE WRDLX  Parse word from the LEFT starting at a given index, Ver 6.20

; WRDLX.ASM - WrdLX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine parses the word at a given index from a string delimited
; by spaces.  The routine searches starting at indeX, from LEFT to right to
; find the beginning of the first word found.

; This was made a procedure in lieu of a function for speed.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdLX
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+10]
S            EQU     DWORD PTR SS:[bx+6]
indeX        EQU     BYTE  PTR SS:[bx+4]

; WrdLX - Parse a word from the LEFT starting at given indeX.
; procedure WrdLX (VAR Dest: string; S: string; indeX: byte);

;   INDEX    START      MARKER  CHARS TO SCAN
;   -----    ---------  ------  -------------
;    0,1     S[1]       S[1]    L-(X-1)=L
;    2       S[X-1]     S[1]    L-(X-2)=L
;    X       S[X-1]     S[1]    L-(X-2)
;
;   ABORT SCAN IF X>L

WrdLX        PROC FAR

       mov   bx,sp            ; Set up stack base
       xor   ax,ax            ; Set AX=0
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   al,es:[di]       ; Get length
       mov   cx,ax            ; Set CX
       jcxz  Exit             ; Exit if null string
; -- Evalute Index --
       mov   al,indeX         ; Get indeX
; -- Convert 0 index to 1 --
       cmp   ah,al            ; Index=0?
       sbb   al,-1            ;   yes, increment
; -- Back up index 1 char --
       mov   dx,ax            ; Save a copy in DX
       cmp   al,2             ; Index>1?
       adc   al,-1            ;   yes, decrement index
; -- Index within string length? --
       sub   cx,ax            ; Length<Index?
       jb    Null             ;   yes, exit with null
       inc   cx               ; add 1
; -- Test first char --
       add   di,ax            ; First char to scan
       mov   al,' '           ; Get Space char to scan
       cld                    ; Set DF to increment
       dec   dx               ; Index=1?
       je    aWord            ;   yes, hunt straight for word
; -- Search right to end of partial word --
       repne scasb            ; Scan for space.
       jne   Exit             ; All non-spaces.
; -- Search for a word --
aWord: repe  scasb            ; Scan for non-space.
       je    Exit             ; All spaces
       mov   si,di            ; Save marker at Wrd[2]
       dec   si               ; Set marker at Wrd[1]
; -- Search for end of the word found --
       jcxz  SHORT Leng       ; At end of string?
       repne scasb            ; Scan for end of word.
       jne   Leng             ;   no space
       dec   di               ; Set on space
; -- Set word length --
Leng:  mov   cx,di            ; Get final offset
       sub   cx,si            ; Word length in CX
; -- Reset pointers --
       mov   dx,es            ; Save ES  (not needed if CX=0)
Exit:  mov   ax,cx            ; Set length in AX
       les   di,Dest          ; Set up destination
       stosb                  ; Save length
       mov   bx,ds            ; Save Pascal's DS
       mov   ds,dx            ; Set source seg
       call  RepMovsB         ; Do fast move of bytes (Skip if CX=0)
       mov   ds,bx            ; Restore Pascal's DS
       ret   10               ; Clear all parameters

; -- Manually set CX=0 and then exit --
Null:  xor   cx,cx            ; Set count 0
       jmp   SHORT Exit       ; Store result

WrdLX        ENDP

CODE   ENDS

       END
