PAGE  80,132
TITLE STRSPN  Finds first char NOT in a group of chars, Ver 6.20

; STRSPN.ASM - StrSpn
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

; Returns the length of a substring that are all members of the chars in
; Members scanning RIGHT from the given index.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrSpn

S            EQU     DWORD PTR [bp+12]
Members      EQU     DWORD PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]

; AH:                 AL: Char to scan
; BX: starting offset
; CH: 0               CL: Count
; DH: Member length   DL: Remaining S length

; function StrSpn (S,Members: string; Index: byte): byte;

StrSpn       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       xor   ax,ax            ; Set AX=0
; -- Point to string to be spanned --
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Set CX
       jcxz  Exit             ; Exit if null string
; -- Adjust Index (Leave 0 index alone) --
       mov   al,Index         ; Get index value
       cmp   ah,al            ; Index>0?
       sbb   al,ah            ;   yes, decrement
; -- Index-1 within string length? --
       add   si,ax            ; First char to scan in S
       mov   bx,si            ; Save starting offset
       sub   cx,ax            ; Length<=Index-1?
       jbe   Span             ;   yes, exit with 0
       mov   dx,cx            ; Save scan count in DL (DH=0)
; -- Evaluate Members --
       les   di,Members       ; Point to Members string
       add   dh,es:[di]       ; Get Members length, Members = ''?
       jz    Span             ;   yes, return 0
       inc   di               ; To Members[1]
       inc   bx               ; Account for the trailing non-member
       cmp   dh,1             ; One Member?
       je    One              ;   yes, special case
       mov   cl,dh            ; Reset Members length
; -- Search for Members --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get string char
       repne scasb            ; Scan for member
       jne   Span             ; Span found
       add   di,cx            ; As if all were scanned
       mov   cl,dh            ; Reset Members length
       sub   di,cx            ; Reset to Members[1]
       dec   dl               ; S length -1
       jnz   L1               ; Try again
       inc   si               ; Add imaginary non-member
; -- Calculate span --
Span:  mov   ax,si            ; Get current SI
Span2: sub   ax,bx            ; Calc position
; -- Reset pointers --
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters

; -- One character Member --
One:   mov   al,es:[di]       ; Get the Member char
       mov   di,ds            ; Copy DS ...
       mov   es,di            ;   ... into ES
       mov   di,si            ; Copy SI into DI
; -- Search for Non-Member --
       repe  scasb            ; Search for Member
       mov   ax,di            ; Get offset
       jne   Span2            ; Non-member found
       inc   ax               ; Add imaginary non-member
       jmp   SHORT Span2      ; Exit routine

StrSpn       ENDP

CODE   ENDS

       END
