PAGE  80,132
TITLE STRSORT  String Sort Routine, Ver 6.20

; STRSORT.ASM - StrSort
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Operates on a string by sorting it in ascending order.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrSort

; StrSort - Operates on a string by sorting it in ascending order.
;
; Two algorithms are used for this routine for speed.  For strings up
; to 22 chars long, the classic Quick Sort is used.  After 22 chars, the
; Tally Sort is used which is up to 10 times faster than Quick Sort,
; because the Tally Sort does it in only two passes.

; procedure StrSort (VAR S: string);


; -------------------------- Quick Sort Algorithm -----------------------

Lower1       EQU     WORD  PTR [bp+6]
Upper1       EQU     WORD  PTR [bp+4]

; AH:          AL: MidChar
; BX: Local lower
; CX: Upper1 offset
; DX; Lower1 offset
; SI  Local upper

Qsort        PROC NEAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
;      mov   si,Upper1        ; Starting upper offset  ; ** ASSUMED ***
;      mov   bx,Lower1        ; Starting lower offset  ; ** ASSUMED ***
       mov   cx,si            ; Save Upper1
       mov   dx,bx            ; Save Lower1
       add   si,dx            ; L+U
       rcr   si,1             ; [L+U]/2
       lodsb                  ; Grab middle char
       mov   ah,al            ; Save copy in AH
       mov   si,cx            ; Reset local upper
L0:    mov   di,si            ; Start with upper
       std                    ; Set DF to decrement
       EVEN                   ; Align for speed
; -- Skip upper chars already in order --
L1:    scasb                  ; T<S[up]?
       jb    L1               ;   yes, scan again
       inc   di               ;   no, point to it (new upper)
       mov   si,di            ; Save in SI
       mov   di,bx            ; Get lower offset
       cld                    ; Set DF to increment
; -- Skip lower chars already in order --
       EVEN                   ; Align for speed
L2:    scasb                  ; T>S[lo]?
       ja    L2               ;   yes, scan again
       dec   di               ;   no, point to it
       cmp   di,si            ; L>U?
       ja    Swapd            ;   yes, no more this iteration
; -- Swap in ascending order --
       mov   al,[di]          ; Get lower char
       xchg  al,[si]          ; Swap with upper char
       stosb                  ; Save new upper char
       dec   si               ; U-1
       mov   bx,di            ; Save new lower offset
       mov   al,ah            ; Restore midchar
       jmp   SHORT L0         ; keep going
; -- Save L in Stack; Lower1 no longer needed --
Swapd: mov   Lower1,di        ; Save L
; -- Swap lower half --
       cmp   dx,si            ; Lower1>=U?
       jae   Half             ;   yes, do upper half
       mov   bx,dx            ; Set Lower1 in BX
       push  dx               ; Push Lower1
       push  si               ; Push U as new Upper1
       call  Qsort            ; Recursive sort
; -- Swap upper half --
Half:  mov   bx,Lower1        ; Really L
       mov   si,Upper1        ; Get Upper1
       cmp   bx,si            ; L>=Upper1?
       jae   Done             ;   yes, all done
       push  bx               ; Push L
       push  si               ; Upper1
       call  Qsort            ; Recursive sort
; -- Exit routine --
Done:  pop   bp               ; Restore Pascal's BP
       ret   4                ; Clear all parameters
Qsort        ENDP


; -------------------------- Tally Sort Algorithm -----------------------

Table        EQU     BYTE  PTR [bp-256]
Tally        EQU     BYTE  PTR es:[bx+di]

Tsort:
; -- Clear table --
       mov   dx,ax            ; Save length in DL
       mov   bx,ss            ; Move SS into ...
       mov   es,bx            ;  ... ES
       lea   di,Table         ; Point to table
       mov   bx,di            ; Copy in BX for later
       mov   al,ah            ; Set AX=0
       mov   cx,128           ; Set CX=128
       rep   stosw            ; Clear table
; -- Make tally --
       mov   cx,dx            ; Get length again
       EVEN                   ; Align for speed
L3:    lodsb                  ; Get char
       mov   di,ax            ; Set offset
       inc   Tally            ; Tally occurrence
       loop  L3               ; Continue for all chars
; -- Reverse pointers to assemble sorted string --
       mov   di,ds            ; Save string seg in DI
       mov   ax,es            ; Get table seg
       mov   ds,ax            ;   ... place in DS
       mov   es,di            ; Get string seg in ES
       sub   si,dx            ; Point to S[1]
       mov   di,si            ; Make dest
; -- Search for tally --
       mov   si,cx            ; Set SI=0
       dec   si               ; Start at -1
       EVEN                   ; Align for speed
L4:    inc   si               ; next char
       add   cl,[bx+si]       ; Get tally
       jz    L4               ; Loop if zero
; -- Assemble string --
       mov   ax,si            ; AX=Char#
       sub   dx,cx            ; Chars left
       rep   stosb            ; Assemble string
       jnz   L4               ; Continue if more chars
       jmp   SHORT Exit       ; Exit when done


; -------------------------- StrSort Procedure --------------------------

S            EQU     DWORD PTR [bp+6]

StrSort      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       sub   sp,256           ; Allow space for table
       push  ds               ; Save Pascal's DS
; -- Get string length --
       lds   si,S             ; Point to string
       xor   ax,ax            ; Set AX=0
       cld                    ; Set DF to increment
       lodsb                  ; Set length
       cmp   al,1             ; L<=1?
       jbe   Exit             ;  yes, quit
; -- Use Quick Sort or Tally Sort? --
       cmp   al,22            ; L>=22?
       jae   Tsort            ;  yes, use Tally Sort
; -- Set upper and lower parameters for Quick Sort --
       mov   bx,ds            ; Move DS into ...
       mov   es,bx            ;  ... ES
       push  si               ; Offset for S[1]
       mov   bx,si            ; Save as Lower1
       add   si,ax            ; Adjust to S[L+1]
       dec   si               ; Adjust to S[L]
       push  si               ; Offset for S[L] (Upper1)
       call  Qsort            ; Do quick sort
; -- Exit routine --
Exit:  pop   ds               ; Restore Pascal's DS
       mov   sp,bp            ; Clear local variable
       pop   bp               ; Restore Pascal's BP
       ret   4                ; Clear all parameters
StrSort      ENDP


CODE   ENDS

       END
