PAGE  80,132
TITLE STRREPL  Find and Replace of Substring Routine, Ver 6.20

; STRREPL.ASM - StrRepl, StrReplI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds and replaces a substring from a given index for Qty
; number of replacements for both match and ignore case.


DATA    SEGMENT WORD PUBLIC
        EXTRN   ReplOverFlow: BYTE
        EXTRN   ReplIndex:    BYTE
        EXTRN   ReplToDo:     BYTE
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE, DS:DATA
        PUBLIC  StrRepl,StrReplI
        EXTRN   RepMovsBRev: NEAR
        EXTRN   RepMovsB:    NEAR
        EXTRN   CopyStr:     NEAR

; -- Passed Parameters --
S            EQU     DWORD PTR [bp+20]
Find         EQU     DWORD PTR [bp+16]
Repl         EQU     DWORD PTR [bp+12]
Index        EQU     BYTE  PTR [bp+10]
Qty          EQU     BYTE  PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]

; -- Local variables --
LocalVar     EQU     208h
OvfIndex     EQU     BYTE  PTR [bp-2]
Repls        EQU     BYTE  PTR [bp-4]
ToDo         EQU     BYTE  PTR [bp-6]
NoCase       EQU     BYTE  PTR [bp-8]
Sstk         EQU     BYTE  PTR [bp-108h]
FindStk      EQU     BYTE  PTR [bp-LocalVar]

; -- Stacked variables --
Repl1Disp    EQU     20Ch
PascalDS     EQU     WORD  PTR [bp-20Ah]
Repl1Ofs     EQU     BYTE  PTR [bp-Repl1Disp]


; StrRepl - Finds and replaces a substring from a given Index for Qty
; number of replacements and is stopped before being longer than MaxLen chars.
; A report of the procedure is saved in global data as follows:
;   ReplOverFlow  - True if last replacement would have caused an overflow in
;               length and was therefore incomplete for this string.
;   ReplIndex - Index at overflow stop.  Since the replacement couldn't be
;               made without overflowing the string, this is the last Find's
;               index at termination.
;   ReplToDo  - Number of replacements left to do whether overflow or not.
; StrReplI is the the same as StrRepl except that it ignores case.  From 522 to
; 777 extra stack bytes are used for both of these routines.
;
; procedure StrRepl  (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: byte);
; procedure StrReplI (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: byte);

StrReplI     PROC  FAR
       stc                    ; To indicate StrReplI procedure
       jmp   SHORT Start      ;

StrRepl      PROC  FAR
       clc                    ; To indicate StrReplI procedure
Start: mov   ax,0             ; Set AX=0
       rcl   al,1             ; Copy in CF
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       sub   sp,LocalVar      ; Allow for local vars
       push  ds               ; Save Pascal's DS
       mov   NoCase,al        ; Save casing flag
; -- Test for ignore case --
       shr   ax,1             ; Ignore case?
       jnc   C0               ;   no, match case

; -- To ignore case, convert strings to stack in same case --
; -- Copy S String --
       lds   si,S             ; Point to S source
       lea   di,Sstk          ; EA of Sstk
       mov   dx,ss            ; Copy SS to ...
       mov   es,dx            ;   ES
       cld                    ; Set DF to increment
       call  CopyStr          ; Copy S to Sstk
; -- Copy Find String --
       lds   si,Find          ; Point to Find source
       lea   di,FindStk       ; EA of FindStk
       call  CopyStr          ; Copy Find to FindStk
       lea   si,FindStk       ; EA of FindStk
       mov   ax,cx            ; Set AX=0
       jmp   SHORT C0b        ; Leave Find in stack

; -- Check Find length --
C0:    lds   si,Find          ; Point to Find string
       cld                    ; Set DF to increment
C0b:   lodsb                  ; Get length of Find
       test  al,al            ; Length=0?
       jz    Exit1            ;   yes, then exit
       mov   es,dx            ; Move SS into ES
       mov   dx,ax            ; Save a copy in DX

; -- Test for ignore case --
       cmp   NoCase,ah        ; Match case?
       je    C0c              ;   yes
       lea   di,Sstk          ;   no, point to stack string (ES=SS)
       jmp   SHORT C0d        ;

; -- Check S length --
C0c:   les   di,S             ; Point to original string
C0d:   mov   al,es:[di]       ; Get S length
       dec   dx               ; Skip first char          (DH=0)
       sub   al,dl            ; Positions remaining in AL
       jbe   Exit1            ; Exit if Find[0]>S[0]
       mov   cx,ax            ; Also copy in CX
; -- Calc S offset to start at --
       mov   al,Index         ; Get Position
       cmp   ah,al            ; Index>0? (CF=1?)
       sbb   al,ah            ;   yes, decrement
       sub   cx,ax            ; Chars to scan
       jbe   Exit1            ; None to search
       inc   ax               ; 1-based index
       add   di,ax            ; Offset to first char to scan
; -- Check number of occurrences --
       add   ah,Qty           ; Get and test quantity to replace
       jz    Exit3            ;   yes, none to replace

; ------------------------------------------------------------------------
;    SCAN FOR ALL FINDS
; ------------------------------------------------------------------------

; AH: Qty        AL: First char
; BX: Last CX
; CH: 0          CL: Compare length
; DH: 0          DL: Find[0]-1

; -- Scan for All Finds --
       lodsb                  ; Get first char to find in AL
       EVEN                   ; Align for speed
L1:    repne scasb            ; Try to match first char
       jne   C1               ; None found
       mov   bx,cx            ; Save count remaining
       mov   cl,dl            ; Set Find scan length
       repe  cmpsb            ; Strings equal?
       je    L2               ;   Match found!
       ; -- Restore char count and adjust SI --
       xchg  cx,bx            ; Restore chars remaining
       jcxz  C1               ; Nothing left to scan
       sub   bx,dx            ; Chars compared (neg)
       add   si,bx            ; Restore at Find[2]
       add   di,bx            ; Restore S offset
       jmp   SHORT L1         ; Continue to next pos
       ; -- A match was found! --
L2:    push  di               ; Save a copy of the offset
       dec   ah               ; Decrement the number to find
       jz    C1               ; If last one, quit looking.
       mov   cx,bx            ; Restore chars remaining
       sub   cl,dl            ; Jump past last find
       jbe   C1               ; Nothing left to scan (CL<=0)
       sub   si,dx            ; Restore at Find[2]
       jmp   SHORT L1         ; Continue to next pos

; ------------------------------------------------------------------------
;    EXIT
; ------------------------------------------------------------------------
; -- Generate report and exit routine --
Exit1: mov   ah,Qty           ; Get Qty since nothing was replaced
       jmp   SHORT Exit3      ;
Exit2: mov   ah,ToDo          ; Get replacements to do
Exit3: xor   al,al            ; Set AL=0 (FALSE)
Exit4: mov   bl,al            ; Set BL=0
Exit5: pop   ds               ; Restore Pascal's DS
       mov   ReplOverFlow,al  ; Set TRUE/FALSE
       mov   ReplIndex,bl     ; Set to Index
       mov   ReplToDo,ah      ; Save Qty remaining
       mov   sp,bp            ; Point at BP
       pop   bp               ; Restore Pascal's BP
       ret   18               ; Return to call

; ------------------------------------------------------------------------
;    TEST FINDS
; ------------------------------------------------------------------------
; -- Calculate any finds --
C1:    mov   al,Qty           ; Get Qty to find again
       sub   al,ah            ; Calc qty found
       je    Exit4            ;   none found

; -- Test for ignore case --
       cmp   NoCase,ch        ; Match case?
       je    C1a              ;   yes
       xchg  ax,bx            ; Save count in BX
       les   di,S             ; At S[0]
       lea   ax,Sstk          ;   no, point to stack string (DS=SS)
       sub   ax,di            ; Calc difference in offsets
       mov   si,sp            ; Point at top of stack
; -- Adjust offsets for true S string -
       mov   cl,bl            ; Set count
       EVEN                   ; Align for speed
LOfs:  sub   [si],ax          ; Adjust offset
       inc   si               ;
       inc   si               ; Next offset
       loop  Lofs             ;
       xchg  ax,bx            ; Restore count in AX

; -- Save count --
C1a:   inc   dx               ; DL=Find[0]                 (DL=Find[0])
       mov   Repls,al         ; Save number of replacements to do
       mov   ToDo,ah          ; Save number that will not be done
; -- Get Repl length difference --
       lds   si,Repl          ; At Repl[0]
       mov   bl,[si]          ; Get Repl[0]
       sub   bl,dl            ; Calculate Repl[0]-Find[0]
       je    Same             ;   for Repl[0] = Find[0]
; -- Point at S[0] and jump for Repl and Find Delta --
       lds   si,S             ; At S[0]
       mov   cl,[si]          ; Get length
       jl    Less             ;   for Repl[0] < Find[0]
       jmp   SHORT More       ;   for Repl[0] > Find[0]

; ------------------------------------------------------------------------
;    ROUTINE FOR REPL = FIND
; ------------------------------------------------------------------------
; -- Replace first find --
Same:  pop   di               ; Get offset of last find
       sub   di,dx            ; Point to first char
       mov   ax,di            ; Save as new Repl location
       inc   si               ; At Repl[1]
       mov   cx,dx            ; Set length
       call  RepMovsB         ; Do fast move of bytes
       mov   bx,es            ; Move ES into ...
       mov   ds,bx            ;   DS
; -- Replace rest of the finds --
       EVEN                   ; Align for speed
L3:    dec   Repls            ; Test # of replacements
       jz    Exit2            ; Quit
       pop   di               ; Get offset of last find
       sub   di,dx            ; Point to first char
       mov   si,ax            ; At Repl[1]
       mov   cx,dx            ; Reset Repl length
       call  RepMovsB         ; Do fast move of bytes
       jmp   SHORT L3         ;

;-------------------------------------------------------------------------
;    ROUTINE FOR REPL < FIND
; ------------------------------------------------------------------------
; -- Adjust length of string --
Less:
       mul   bl               ; AX=Delta string length (negative)
       mov   ah,dh            ; Zero-extend AL
       add   [si],al          ; Set new length
       add   si,cx            ; At S[L]
       inc   si               ; At S[L+1]
       add   si,dx            ; A full Repl[0] past EOS
       push  si               ; Simulate a find
; -- Replace first find --
       ; -- Copy in new Repl --
       lea   bx,Repl1Ofs      ; Use BX as stack base
       mov   di,ss:[bx]       ; Get offset of first find (Find[L+1])
       sub   di,dx            ; Point to first char
       lds   si,Repl          ; At Repl[0]
       mov   al,[si]          ; Get length
       inc   si               ; At Repl[1]
       mov   dh,al            ; Save in DH                 (DH=Repl[0])
       mov   cx,ax            ; Set string length
       mov   ax,di            ; Save this as new Repl location
       call  RepMovsB         ; Do fast move of bytes
       mov   si,es            ; Move ES into ...
       mov   ds,si            ;   DS
       ; -- Copy unaltered text --
       mov   cl,dl            ; CX=Find[0]
       add   cx,ax            ; At Find[L+1]
       mov   si,cx            ; Make it the source
       jmp   SHORT L5         ;
; -- Replace rest of the finds --
       EVEN                   ; Align for speed
L4:    dec   Repls            ; Test # of replacements
       jz    L6               ; Quit
       ; -- Copy in new Repl --
       mov   si,ax            ; At Repl[1]
       mov   cl,dh            ; Set Repl length
       call  RepMovsB         ; Do fast move of bytes
       ; -- Copy unaltered text --
       mov   si,ss:[bx]       ; Get offset of same find (Find[L+1])
L5:    dec   bx               ; next byte
       dec   bx               ; next byte
       mov   cx,ss:[bx]       ; Get offset at next find (Find[L+1])
       sub   cx,si            ; Calc chars to next find (Find[L+1])
       sub   cl,dl            ; Subtract out the Find
       call  RepMovsB         ; Do fast move of bytes
       jmp   SHORT L4         ;
L6:    lea   sp,PascalDS      ; Drop stack down to PascalDS
       jmp   Exit2            ; Set ReplOverFlow and ReplIndex =0

; ------------------------------------------------------------------------
;    ROUTINE FOR REPL > FIND
; ------------------------------------------------------------------------
; -- Test for OverFlow condition --
More:  mul   bl               ; AX=Delta string length;  BL=Delta F/R length
       add   al,cl            ; New length in AL
       cmp   al,MaxLen        ; NewLen<=MaxLen?
       mov   OvfIndex,ch      ; Assume overflow index =0
       jbe   R1               ;   yes, all set up
; -- Resolve OVERFLOW condition --
       mov   al,MaxLen        ; Get maximum length
       sub   al,cl            ; Calc room available
       ja    C2               ;   no room
       mov   al,ah            ; Set MaxRepls=0
       jmp   SHORT C3         ;
C2:    div   bl               ; Calc maximum number of Repls in AL
C3:    mov   Repls,al         ; Save new count
       xchg  ax,bx            ; Save new count in BL
       mul   bl               ; AX=MaxDelta string length
       mov   bh,al            ; Save MaxDelta in BH
       mov   al,Qty           ; Get Qty
       sub   al,bl            ; Reset ToDo to limit
       mov   ToDo,al          ; Save ReplToDo
; -- Adjust stack and set overflow index --
       mov   al,bl            ; Get Repls in AL
       mov   di,ax            ; Set as offset
       shl   di,1             ; Words->Bytes
       neg   di               ; Set negative
       lea   sp,[bp+di-Repl1Disp]  ; Move SP at overflow offset
       pop   ax               ; Get the offset
       sub   ax,si            ; Calc index of Find[L+1]
       sub   al,dl            ; Subtract out find
       add   al,bh            ; Add in MaxDelta
       mov   OvfIndex,al      ; Save overflow index
       mov   al,bh            ; AL=MaxDelta
; -- Test if any Repls possible --
       cmp   al,ah            ; Repls>0   (AH=0)
       jz    C5               ;   no, just quit
       add   al,cl            ; New length in AL
; -- Replace first find --
       ; -- Copy unaltered text --
       ; -- Point to end of original and new strings --
R1:    mov   [si],al          ; Set new length
       mov   di,si            ; At S[0]
       add   si,cx            ; At S[L]
       add   di,ax            ; Snew[L]
       pop   bx               ; Get offset of last find
       dec   bx               ; Point to last char
       mov   cx,si            ; Get current S offset
       sub   cx,bx            ; Difference b/w offsets
       std                    ; Reverse direction
       call  RepMovsBRev      ; Do fast move of bytes
       ; -- Save this repl DI as a copy of the new Repl SI
       ; -- Copy in new Repl --
       mov   ax,di            ; Save as new Repl location
       push  si               ; Save offset
       lds   si,Repl          ; At Repl[0]
       mov   cl,[si]          ; Get length
       add   si,cx            ; At Repl[L]
       mov   dh,cl            ; Save in DH                 (DH=Repl[0])
       call  RepMovsBRev      ; Do fast move of bytes
       mov   si,es            ; Move ES into ...
       mov   ds,si            ;   DS
       pop   si               ; Restore offset
; -- Replace rest of the finds --
       EVEN                   ; Align for speed
L7:    dec   Repls            ; Test # of replacements
       jz    C4               ; Quit
       ; -- Copy unaltered text --
       mov   cl,dl            ; Reset Find length
       sub   si,cx            ; Point to letter before Find in S
       pop   bx               ; Get offset of last find
       dec   bx               ; Point to last char
       mov   cx,si            ; Get current offset
       sub   cx,bx            ; Difference b/w offsets
       call  RepMovsBRev      ; Do fast move of bytes
       ; -- Copy in new Repl --
       mov   bx,si            ; Save SI
       mov   si,ax            ; At Repl[L]
       mov   cl,dh            ; Reset Repl length
       call  RepMovsBRev      ; Do fast move of bytes
       mov   si,bx            ; Restore SI
       jmp   SHORT L7         ;
; -- Set up report --
C4:    xor   al,al            ; Set AL=FALSE
C5:    mov   bl,OvfIndex      ; Get overflow index
       cmp   al,bl            ; Index>0? (CF=1?)
       adc   al,al            ;   yes, increment to TRUE
       mov   ah,ToDo          ; Get replacements to do
       jmp   Exit5            ;

StrRepl      ENDP
StrReplI     ENDP

CODE   ENDS

       END

