PAGE  80,132
TITLE STRPOSLI  String Count and Position Routines - Ignore case, Ver 6.20

; STRPOSLI.ASM - StrPosLI, StrQtyI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrPosLI, StrQtyI
        EXTRN   StrPosL: NEAR, StrQty:  NEAR, ToStack: NEAR

; StrPosLI - Position of Nth occurrence of Find ignoring case.
; This routine finds the position of Nth occurrence a given substring.
; function StrPosLI (S,Find: string; Nth: byte): byte;

StrPosLI     PROC FAR
       mov   di,2             ; Set stack offset 2
       call  ToStack          ; Copy and convert strings
       push  ss               ; S2 seg
       push  ax               ; S2 offset
       push  ss               ; Find2 seg
       push  bx               ; Find2 offset
       push  cx               ; Push Nth
       push  cs               ; Save Cseg
       call  StrPosL          ; Call StrPosL
       add   sp,200h          ; Drop stack
       ret   10               ; Clear all parameters
StrPosLI     ENDP


; StrQtyI - Total quantity of Finds in a string ignoring case.
; This routine counts the occurrences a given Find string.
; function StrQtyI (S,Find: string): byte;

StrQtyI      PROC FAR
       xor   di,di            ; Set stack offset 0
       call  ToStack          ; Copy and convert strings
       push  ss               ; S2 seg
       push  ax               ; S2 offset
       push  ss               ; Find2 seg
       push  bx               ; Find2 offset
       push  cs               ; Save Cseg
       call  StrQty           ; Call StrQty
       add   sp,200h          ; Drop stack
       ret   8                ; Clear all parameters
StrQtyI      ENDP


CODE   ENDS

       END
