PAGE  80,132
TITLE STROVRL  String Overwrite Routine, Ver 6.20

; STROVRL.ASM - StrOvrL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This procedure overwrites a string at a given index left-justified.
;   . The length is adjusted if the substring would make it longer.
;   . Any gap between the two strings is filled with spaces.
; Caution: Just like Move and FillChar, this procedure does not check
; for end of string termination for the destination variable.  However,
; resulting strings are truncated at 255.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrOvrL
        EXTRN   RepMovsB: NEAR
        EXTRN   RepStosB: NEAR

Dest         EQU     DWORD PTR [bp+12]
S            EQU     DWORD PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]
Space        EQU     ' '

; StrOvrL - Overwrites the contents of a string at a given index and extends
; the length if needed and fills any gap with spaces.  Overwrite string is
; Left justfied at index.
; procedure StrOvrL (VAR Dest: string; S: string; DestIndex: byte);

StrOvrL       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Get overwrite string length --
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; Point to overwrite string
       cld                    ; Set DF to increment
       lodsb                  ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       jcxz  Exit             ; Quit if null string
; -- Get Dest string length --
       les   di,Dest          ; Point to dest string
       mov   bx,di            ; Save offset in BX
       mov   al,es:[di]       ; Get length
       mov   dh,al            ; Save in DH
; -- Get index --
       mov   al,Index         ; Get index
       cmp   ah,al            ; indeX>0?
       sbb   al,ah            ;   yes, decrement
       add   di,ax            ; Point to dest
       inc   di               ;
       mov   dl,al            ; Copy Index to DL
; -- Calc max move length --
       add   al,cl            ; Past last position?
       jnc   OK               ;   no, <=255
       sub   cl,al            ;   yes, truncate overwrite string
       dec   cx               ; 0-based
; -- Test for gap --
OK:    sub   dl,dh            ; Index<=length?
       jb    Move             ;   yes, then just do move
; -- Fill with spaces --
       mov   al,Space         ; Set to space
       xchg  cl,dl            ; Get fill length
       sub   di,cx            ; Adjust DI
       call  RepStosB         ; Fast fill of spaces
       mov   cl,dl            ; Get overwrite length
; -- Move overwrite string --
Move:  call  RepMovsB         ; Do fast copy of bytes
       xchg  bx,di            ; Reset to S[0]
       sub   bx,di            ; New position in BX
       dec   bx               ; Calc length
       cmp   dh,bl            ; Old length>= new length
       ja    Exit             ;   yes, old length fine
       xchg  ax,bx            ;   no, store new length
       stosb                  ; Save length
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrOvrL       ENDP

CODE   ENDS

       END
