PAGE  80,132
TITLE STROVRC  String Overwrite Routine, Center-justified, Ver 6.20

; STROVRC.ASM - StrOvrC
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This procedure overwrites a string at a given index with the source
; Center-justified on the destination.
;   . The length is adjusted if the substring would make it longer.
;   . Any gap between the two strings is filled with spaces.
; Caution: Just like Move and FillChar, this procedure does not check
; for end of string termination for the destination variable.  Strings
; are truncated if they extend before index 1 or beyond index 225.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrOvrC
        EXTRN   RepMovsBrev: NEAR
        EXTRN   RepStosBrev: NEAR

Dest         EQU     DWORD PTR [bp+12]
S            EQU     DWORD PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]
Space        EQU     ' '

; StrOvrC - Overwrites the contents of a string at a given index and extends
; the length if needed and fills any gap with spaces. S is Center-justified
; at DestIndex.
; procedure StrOvrC (VAR Dest: string; S: string; DestIndex: byte);

StrOvrC      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get overwrite string length --
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; Point to overwrite string
       mov   al,[si]          ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       jcxz  Exit             ; Quit if null string
       add   si,ax            ; Point at last char
       dec   ax               ; (For left-preferred centering)
       shr   al,1             ; Offset to right of DestIndex
       mov   bh,al            ; Save in BH
; -- Get Dest string length --
       les   di,Dest          ; Point to dest string
       mov   al,es:[di]       ; Get length
       mov   bl,al            ; Save in BL
; -- Get and adjust index --
       mov   al,Index         ; Get index
       cmp   ah,al            ; Index=0? (CF=0?)
       sbb   al,-1            ;   yes, increment
       add   al,bh            ; NewIndex = DestIndex + Right Offset
       jnc   @@0              ; Jump if no need to truncate
       inc   ax               ; 1-based (Value never > 128)
       sub   cl,al            ; Cut chars to copy
       sub   si,ax            ; Move S pointer left
       mov   al,255           ; Set maxlen
; -- Set new Dest length --
@@0:   cmp   al,bl            ; NewIndex<DestLen?
       jb    @@1              ;   yes, length OK
       mov   es:[di],al       ;   no, set new length
@@1:   add   di,ax            ; Point to dest index
; -- Room for full string? --
       sub   al,cl            ; NewIndex>Slen? (AL=remaining room)
       ja    @@2              ;   yes, enough room
       add   cl,al            ;   no, truncate & set length to Index
       mov   al,ah            ; Set AX=0
; -- Move overwrite string --
@@2:   std                    ; Set DF to decrement
       call  RepMovsBrev      ; Do fast copy of bytes in reverse
; -- Test for gap --
       sub   al,bl            ; remaining room<=Dest length?
       jbe   Exit             ;   yes, no gap
; -- Fill with spaces --
       mov   cl,al            ; Set gap length
       mov   al,Space         ; Set to space
       call  RepStosBrev      ; Fast fill of spaces in reverse
Exit:  mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrOvrC      ENDP

CODE   ENDS

       END
