PAGE  80,132
TITLE STRCAP  String Capitalization Routine, Ver 6.20

; STRCAP.ASM - StrCap
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine creates ASCIIZ strings from Pascal type strings.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrCap

S            EQU     DWORD PTR SS:[bx+4]

; StrCap - Operates on a string to capitalize words separated by spaces.
; The first letter of a word is capitalized while all others are forced to
; lower case to form proper names.  The code has been designed assuming
; operations upon strings that are mostly lower case.

; As an interesting programming coincidence, the value for SPACE ($20)is
; the same value for converting case which is 'a'-'A'.  The SPACE constant
; in the code therefore has a dual purpose.

; procedure StrCap (VAR S: string);

StrCap       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   di,ds            ; Save Pascal's DS
; -- Get address of string --
       lds   si,S             ; Point to source string
       xor   ax,ax            ; Set AX=0.
       cld                    ; Set DF to increment
       lodsb                  ; Load S[0] in AL
       xchg  ax,cx            ; Set CX=length
       jcxz  Exit             ; Quit if null string
; -- Set up constants for greater speed --
       mov   ah,' '           ; Set AH=' ' (also = 'a'-'A')
       mov   bx,'ZA'          ; Set BH='Z' and BL='A'
L0:    mov   dl,1             ; Set flag for first letter
; -- Convert string --
L1:    lodsb                  ; Get char in AL
       cmp   al,ah            ; AL=space?
       je    Space            ;   yes, skip and set flag
                              ;   (change this code to JBE if
                              ;    you also want to include
                              ;    control chars as spaces.)
; -- Test for first letter --
       shr   dl,1             ; Flag set?
       jc    GoCap            ;   yes, go capitalize
; -- Convert to lower case --
       cmp   al,bh            ; Char>Z?
       ja    Next             ;   yes, already lower case
       cmp   al,bl            ; Char<A?
       jb    Next             ;   no, not in range
       or    al,ah            ; Convert case
Store: mov   [si-1],al        ; Store new char
Next:  loop  L1               ; Get next char
Exit:  mov   ds,di            ; Restore Pascal's DS
       ret   4                ; Clear all parameters

; -- Skip spaces --
       EVEN                   ; Align for speed
Space: loop  L0               ; Do more chars
       jmp   SHORT Exit       ; Quit

; -- Capitalize first letter --
GoCap: cmp   al,'a'           ; Char<a?
       jb    Next             ;   yes, already upper case
       cmp   al,'z'           ; Char>z?
       ja    Next             ;   no, not in range
       xor   al,ah            ; Convert case
       jmp   SHORT Store      ; Go store char
StrCap       ENDP

CODE   ENDS

       END


