PAGE  80,132
TITLE STRBIN  Decimal to Binary String Routine, Ver 6.20

; STRBIN.ASM - StrBin
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts numbers to binary strings.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrBin

Result       EQU     DWORD PTR [bp+0Ch]
Num          EQU     DWORD PTR [bp+8]
Field        EQU     BYTE  PTR [bp+6]


; StrBin - Converts numbers to binary strings.  If the field is larger than
; the resulting string, the field is balanced with leading zeros.  If no
; leading zeros are desired, set Field to 0.  Maximum field is 32.
; function StrBin (Num: longint; Field: byte): string;

StrBin       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       les   bx,Num           ; Get Lo word in BX
       mov   dx,es            ; Get Hi word in DX
       les   di,Result        ; Point to dest string
       mov   si,di            ; Save length offset
       mov   ah,Field         ; Set AH to Field
       inc   di               ; Start at first char
       cld                    ; Set DF to increment
       mov   cx,32            ; Count all 32 bits
       EVEN                   ; Align for speed
L1:    mov   al,'1'           ; Set AL to one
       shl   bx,1             ; Shift bits
       rcl   dx,1             ; Test 0 bit
       jc    Set              ; Bit set?
       dec   ax               ;   no, set to '0'
       cmp   cl,ah            ; Count<=Field?
       ja    NoChar           ;   no, no char yet
Set:   stosb                  ; Save char
       mov   ah,cl            ; Reset field
NoChar:loop  L1               ;
       test  ah,ah            ; Final length=0?
       jnz   NZ               ;   no, bits were found
       stosb                  ; Save '0' char
NZ:    xchg  ax,di            ; Get final DI
       dec   ax               ; Last char offset
       sub   ax,si            ; Calc length (AL)
       mov   di,si            ; Point to length byte
       stosb                  ; Save length
       pop   bp               ; Restore Pascal's BP
       ret   6                ; Clear all parameters
StrBin       ENDP

CODE   ENDS

       END
