PAGE  80,132
TITLE REPSTOSB  Fast Store Algorithm for bytes, Ver 6.20

; REPSTOSB.ASM - RepStosB
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Algorithm fills bytes by a word at a time.  Self-aligning for
; alignment sensitive computers like the 8088, 8086, and 80386.
; Uses 27 bytes.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  RepStosB

; RepStosB - fills and array of bytes by the fastest possible method.
; Used as a local routine for other STRS routines.  Assumes:
;   - AL has character
;   - Dest is loaded
;   - CX has the byte count
;   - DF is set to increment
;!! - AH is destroyed in process !!

RepStosB     PROC NEAR
       cmp   cx,10            ; At least 10 bytes?
       jae   Wrds             ;  yes, move words
       rep   stosb            ; Store bytes
       ret                    ; Return to call
; -- To speed up transfers align the DI offset --
       EVEN                   ; Align for speed
Wrds:  mov   ah,al            ; Copy to AH as well
       test  di,1             ; DI even?
       jz    Evn              ;   yes, start with words
       stosb                  ;   no, store odd byte
       dec   cx               ; Decrement the count
; -- Now transfer by words --
       EVEN                   ; Align for speed
Evn:   shr   cx,1             ; Bytes -> words
       rep   stosw            ; Fill words
       adc   cl,cl            ; Add in odd byte
       rep   stosb            ; Store remaining byte
       ret                    ; Return to call
RepStosB     ENDP

CODE   ENDS

       END
