PAGE  80,132
TITLE POS  Standard Pascal POS Routine, Ver 6.20

; POS.ASM - Pos
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds a substring position in a string.
; The null string handling conforms to Borland's interpretation:
;   i := Pos ('','');   { i will =0 }
;   j := Pos ('','x');  { j will =1 }
;   k := Pos ('x','');  { k will =0 }


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  Pos

Find    EQU     DWORD PTR ss:[bx+10]
S       EQU     DWORD PTR ss:[bx+ 6]

; function Pos (Find: string; S: string): byte;

Pos    PROC NEAR
       push  ds               ; Save Pascal's DS
       mov   bx,sp            ; Set up stack base
       xor   ax,ax            ; Set AX=0
; -- Get S length --
       les   di,S             ; Point to source string
       mov   al,es:[di]       ; Get S length
       mov   cx,ax            ; Set count
       jcxz  @@6              ; Quit if null
       inc   di               ; Point to S[1]
; -- Test Find length --
       lds   si,Find          ; Point to Find string
       cld                    ; Set DF to increment
       lodsb                  ; Get Find length
       mov   dx,ax            ; Save in DX       (DX=Find[0]-1)
       dec   dx               ; Find[0]-1, Find=''?
       js    @@2              ;   yes, exit (Set to Pos=1)
; -- Get first Find char --
       lodsb                  ;   (Get first Find char)
       jz    @@3              ;   if DX=0, scan for single char
       sub   cx,dx            ; Chars to scan in CL
       jbe   @@4              ; Exit if Find[0]-1>=S[0]
       mov   ah,cl            ; Save initial count
; -- Scan for Find --
       EVEN                   ; Align for speed
@@1:   repne scasb            ; Try to match first char
       jne   @@4              ; None found
       mov   bx,cx            ; Save count remaining
       mov   cx,dx            ; Set Find scan length
       repe  cmpsb            ; Strings equal?
       xchg  cx,bx            ;   (Swap counts)
       je    @@5              ;   yes, a match found
                              ;   no, scan again
; -- Readjust for no match --
       jcxz  @@4              ; Nothing left to scan
       sub   bx,dx            ; Number of chars compared (neg)
       add   si,bx            ; Reset SI
       add   di,bx            ; Reset DI
       jmp   SHORT @@1        ; Continue to next pos

@@2:   inc   ax               ; Set AX=1
       jmp   SHORT @@6        ; Exit

; -- Special scan for just one char --
@@3:   mov   ah,cl            ; Save initial count
       repne scasb            ; Scan
       je    @@5              ; Found char
; -- Report results --
@@4:   mov   ah,cl            ; Set AH=CL to get result 0
@@5:   mov   al,ah            ; Get original count in AL
       sub   al,cl            ; Subtract chars scanned
       mov   ah,dh            ; Set AH=0
@@6:   pop   ds               ; Restore Pascal's DS
       retf  8                ; Return to call
Pos    ENDP

CODE   ENDS

       END
