PAGE  80,132
TITLE CHRPOSRI Right Character Position Routine - Ignore case, Ver 6.20

; CHRPOSRI.ASM - ChrPosRI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of the Nth occurrence of a given character
; from the RIGHT ignoring case.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPosRI
        EXTRN   ChrSrchI: NEAR

S            EQU     DWORD PTR ss:[bx+8]
Find         EQU     BYTE  PTR ss:[bx+6]
Nth          EQU     BYTE  PTR ss:[bx+4]


; ChrPosRI - Position of Nth occurrence of Find from the RIGHT ignoring case.
; function ChrPosRI (S: string; Find: char; Nth: byte): byte;

ChrPosRI     PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Get and evaluate Nth --
       xor   ax,ax            ; Set AX=0
       add   al,Nth           ; Get count and test
       jz    Exit1            ; Exit if no count
       mov   dx,ax            ; Save count in DX
; -- Get and evaluate S --
       push  ds               ; Save Pascal's DS
       lds   si,S             ; Point to dest string
       mov   al,[si]          ; Get length
       mov   cx,ax            ; Set length
       jcxz  Exit0            ; Quit if null string
       std                    ; Set DF to decrement
       add   si,ax            ; Start at last char
; -- Search for Find --
       call  ChrSrchI         ; Search for Find
       xchg  ax,cx            ; Place 0-based position in AL
       jne   Exit0            ; Nth not found (ZF=0 and AL=0)
; -- Calculate position --
       inc   ax               ; Increment position
Exit0: pop   ds               ; Restore Pascal's DS
Exit1: ret   8                ; Clear all parameters
ChrPosRI     ENDP

CODE   ENDS

       END
