PAGE  80,132
TITLE CHRFILL  String Fill Procedure, Ver 6.20

; CHRFILL.ASM - ChrFill
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine quickly fills a string with duplicate copies of a character.
; As in all fill-type procedures, make sure your destination is large enough.
; Up to twice as fast as system.fillchar.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrFill
        EXTRN   RepStosB: NEAR

S            EQU     DWORD PTR ss:[bx+8]
Fill         EQU     BYTE  PTR ss:[bx+6]
Count        EQU     BYTE  PTR ss:[bx+4]

; ChrFill - Fills a string with duplicate characters.
; procedure ChrFill (VAR S: string; Fill: string; Count: byte);

ChrFill      PROC FAR
       mov   bx,sp            ; Set up stack base
       les   di,S             ; Point to S
; -- Check Count>0 --
       xor   ax,ax            ; Zero extend AL
       mov   al,Count         ; Get Count
       cld                    ; Set DF to increment
       stosb                  ; Save length
       mov   cx,ax            ; Save in CX
; -- Fill string --
       mov   al,Fill          ; Get fill char
       call  RepStosB         ; Do fast fill of bytes
       ret   8                ; Clear all parameters
ChrFill      ENDP

CODE   ENDS

       END
