PAGE  80,132
TITLE CHRDELL  Delete Leading Chars Routine, Ver 6.20

; CHRDELL.ASM - ChrDelL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine operates on a string to delete all leading occurrences of a
; given character.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrDelL
        EXTRN   RepMovsB: NEAR

S            EQU     DWORD PTR ss:[bx+6]
Find         EQU     BYTE  PTR ss:[bx+4]


; ChrDelL - Deletes Left (or leading) characters.
; procedure ChrDelL (S: string; Find: char);

ChrDelL      PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get string length --
       lds   si,S             ; Point to source string
       xor   cx,cx            ; Set CX=0
       add   cl,[si]          ; Get and evaluate length
       jz    Exit             ; Quit if null string
       cld                    ; Set DF to increment
; -- Copy address as destination --
       mov   di,ds            ; Move DS into ...
       mov   es,di            ;  ... ES
       mov   di,si            ; At S[0]
       inc   di               ; At S[1]
       mov   al,Find          ; Get Find to delete
; -- Scan for leading chars --
       mov   bx,cx            ; Save length in BX, too
       inc   cx               ; Account for first scan
       repe  scasb            ; Find char that's not equal with AL
       cmp   bx,cx            ; Any leading chars?
       jz    Exit             ;   no, so exit
; -- Set new length and shift string --
       mov   ax,cx            ; Copy count in AL
       xchg  si,di            ; Point DI at S[0], SI at S[?+1]
       stosb                  ; Set new count
       dec   si               ; Align on the different char
       call  RepMovsB         ; Do fast move of bytes
Exit:  mov   ds,dx            ; Restore Pascal's DS
       ret   6                ; Clear all parameters
ChrDelL      ENDP

CODE   ENDS

       END
