{
 $Id$
}
{$S-,R-,V-,D-,F+}   UNIT S_Screen;


 {*****************************************************************************
 *
 * Purpose ...............: Screen Save Unit
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Run Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +                        - Screen Save Unit -                              +
  +    Version 1.4                                                           +
  +    DD. 8 maart 1995                                                      +
  +                                                                          +
  +    (c) Ron Huiskes / InterSoft 1991-2008                                 +
  +        All Rights Reserved                                               +
  +                                                                          +
  +    This unit is copyright material by Ron Huiskes and InterSoft,         +
  +                                                                          +
  +    Author    : Ron Huiskes                                               +
  +    FidoNet   : 2:281/506                                                 +
  +                                                                          +
  +    SnailMail : P.o. Box 528                                              +
  +                2280 AM Rijswijk zh                                       +
  +                The Netherlands                                           +
  +                                                                          +
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  { version 1.3 : added SHADOW boolean, if enabled shadow will be used with
                  mkwin procedure.
    version 1.4 : enhanced savescreen/restorescreen procedures so that max 2
                  complete screens can be saved at the same time. }


INTERFACE

USES Crt, F_Fast;

{-----------------------------------------------------------------------------}

PROCEDURE  SaveScreen;                                {saves the entire screen}
PROCEDURE  RestoreScreen;                    {restores a previous saved screen}

PROCEDURE  Mkwin(x1,y1,x2,y2,F,B,boxtype:integer);   {creates window on screen}
PROCEDURE  Rmwin;                    {removes the temporary window from screen}

FUNCTION   GetScreenChar(X,Y:byte):char;       {gets char at specific position}
FUNCTION   GetScreenAttr(X,Y:byte):byte;     {gets attrib at specific position}

Var
  Shadow : Boolean;

{-----------------------------------------------------------------------------}

CONST
   Max_Windows = 8;                                 {Change this as necessary}
   WindowCounter : byte = 0;

TYPE
  ScreenImage = RECORD
    ScreenPtr  : Pointer;
  END;

  WindowImage = record
    ScreenPtr: Pointer;             {pointer to screen data}
    Coord    : array[1..4] of byte; {window coords}
    CursorX  : byte;                {cursor location}
    CursorY  : byte;
    ScanTop  : byte;                {cursor shape}
    ScanBot  : byte;
  END;

  WindowPtr = ^WindowImage;
  ScreenPtr = ^ScreenImage;

VAR
  Screen       : Array[1..2] of ScreenPtr;
  Win          : array[1..Max_Windows] of WindowPtr;

{-----------------------------------------------------------------------------}

IMPLEMENTATION

{$L S_SCREEN}

{$F+}
  PROCEDURE MoveFromScreen(VAR Source,Dest;Length:Word); EXTERNAL;
  PROCEDURE MoveToScreen(VAR Source,Dest; Length:Word); EXTERNAL;
{$F-}


Procedure PartSave (X1,Y1,X2,Y2:byte; VAR Dest);
{transfers data from active virtual screen to Dest}
var
   I,width : byte;
   ScreenAdr: integer;
begin
    width := succ(X2- X1);
    For I :=  Y1 to Y2 do
    begin
     ScreenAdr := Vofs + Pred(I)*160 + Pred(X1)*2;
     MoveFromScreen(Mem[Vseg:ScreenAdr],
                    Mem[seg(Dest):ofs(dest)+(I-Y1)*width*2],
                    width);
    end;
end;


Procedure PartRestore (X1,Y1,X2,Y2:byte; VAR Source);
{restores data from Source and transfers to active virtual screen}
var
   I,width : byte;
   ScreenAdr: integer;
begin
    width := succ(X2- X1);
    For I :=  Y1 to Y2 do
    begin
     ScreenAdr := Vofs + Pred(I)*160 + Pred(X1)*2;
     MoveToScreen(Mem[Seg(Source):ofs(Source)+(I-Y1)*width*2],
                  Mem[Vseg:ScreenAdr],
                  width);
    end;
end;


PROCEDURE SaveScreen;
var tel : byte;
BEGIN
  Snowprone := CheckSnow;
  if screen[1] = nil then tel := 1 else tel := 2;

  GetMem(Screen[tel],SizeOf(Screen[tel]^));
  GetMem(Screen[tel]^.ScreenPtr,4000);
  WITH Screen[tel]^ DO
    MoveFromScreen(Mem[Baseofscreen:0],Screen[tel]^.ScreenPtr^,2000);
END;

PROCEDURE RestoreScreen;
var tel : byte;
BEGIN
  if screen[2] = nil then tel := 1 else tel := 2;

  WITH Screen[tel]^ DO
   MoveToScreen(ScreenPtr^,Mem[Baseofscreen:0],2000);
  FreeMem(Screen[tel]^.ScreenPtr,4000);
  FreeMem(Screen[tel],SizeOf(Screen[tel]^));
  screen[tel] := nil;
END;


Procedure GetScreenWord(X,Y:byte;var Attr:byte; var Ch : char);
{updates vars Attr and Ch with attribute and character bytes in screen
 location (X,Y) of the active screen}
Type
    ScreenWordRec = record
                         Ch   : char;   {5.00a}
                         Attr : byte;
                    end;
var
   ScreenAdr: integer;
   SW : ScreenWordRec;
begin
    ScreenAdr := Vofs + Pred(Y)*160 + Pred(X)*2;
    MoveFromScreen(Mem[Vseg:ScreenAdr],mem[seg(SW):ofs(SW)],1);
    Attr := SW.Attr;
    Ch   := SW.Ch;
end;

Function GetScreenChar(X,Y:byte):char;
var
  A : byte;
  C : char;
begin
  GetScreenWord(X,Y,A,C);
  GetScreenChar := C;
end;

Function GetScreenAttr(X,Y:byte):byte;
var
  A : byte;
  C : char;
begin
  GetScreenWord(X,Y,A,C);
  GetScreenAttr := A;
end;


Procedure CreateWin(x1,y1,x2,y2:byte);   {called by MkWin}
begin
  If WindowCounter >= Max_Windows then
    begin
      writeln(#7+'max windows exceeded');
      exit;
    end;
  If MaxAvail < sizeOf(Win[WindowCounter]^) then
    begin
      writeln(#7+'no memory available');
      exit;
    end;
  Inc(WindowCounter);
  GetMem(Win[WindowCounter],sizeof(Win[WindowCounter]^));    {allocate space}
  If Shadow then
    Begin
      Inc(x2,2);
      Inc(y2,1);
    End;
  If MaxAvail < succ(Y2-Y1)*succ(X2-X1)*2 then
    begin
      writeln('no memory available');
      exit;
    end;
  GetMem(Win[WindowCounter]^.ScreenPtr,succ(Y2-Y1)*succ(X2-X1)*2);
  PartSave(X1,Y1,X2,Y2,Win[WindowCounter]^.ScreenPtr^);
  with Win[WindowCounter]^ do
    begin
      Coord[1] := X1;
      Coord[2] := Y1;
      Coord[3] := X2;
      Coord[4] := Y2;
    end;  {with}
end;

procedure mkwin(x1,y1,x2,y2,F,B,boxtype:integer);
{Main procedure for creating window}
var
   u,v,x,y : byte;
   ch : char;
begin
   CreateWin(X1,Y1,X2,Y2);
   If Shadow then
     Begin
       u := x2+2;
       if u > 80 then u := 80;

       For x := x2 to u do
        For y := y1+1 to y2 do
          Begin
            ch := getscreenchar(x,y);
            writeat(x,y,8,0,ch);
          End;
       For x := x1+2 to u do
         Begin
           ch := getscreenchar(x,y2+1);
           writeat(x,y2+1,8,0,ch);
         End;
     End;
   FBox(x1,y1,x2,y2,F,B,boxtype);
end;

Procedure RmWin;
begin
  If WindowCounter > 0 then
    begin
      with  Win[WindowCounter]^ do
        begin
          PartRestore(Coord[1],Coord[2],Coord[3],Coord[4],ScreenPtr^);
          FreeMem(ScreenPtr,succ(Coord[4]-coord[2])*succ(coord[3]-coord[1])*2);
          FreeMem(Win[WindowCounter],sizeof(Win[WindowCounter]^));
        end;
      Dec(WindowCounter);
    end;
end;

BEGIN
  Shadow := False;
  Screen[1] := nil;
  Screen[2] := nil;
END.

