{
 $Id$
}
{ ========================================================================== }
{ Strg.pas - String Processing Routines                   ver 6.20, 04-30-91 }
{                                                                            }
{                 --- SPEEDPACK I, PROFESSIONAL VERSION ---                  }
{ These routines process strings, characters, and all types of numbers.      }
{ Several combinations of operations have been provided that are extremely   }
{ fast for case, classification, comparison, conversions, copy, count,       }
{ delete, format, justification, membership, parse, replace, search, sort,   }
{ tabbing, ASCIIZ, many with match/ignore case and many more - 118 routines. }
{  Copyright (C) 1989-1991 James H. LeMay for Eagle Performance Software     }
{ ========================================================================== }

{ For IEEE reals, set $N+.  For runtime selection of 80x87 and software,     }
{ also use $E+.  (Note that use of $E+ will link Turbo's 12k emulator lib if }
{ a procedure is called.)  These directives must also be reflected in the    }
{ main program as well.  This is so you can test everything in the unit.     }

{$A-,D-,E+,I-,L-,N+,R-,S-,V-}   { For IEEE }
{ $A-,D-,E-,I-,L-,N-,R-,S-,V-}  { W/o IEEE }

{ If you have the source code and have SYS620.TPU or later, set the follow-  }
{ ing conditional define by deleting the space in front of the '$'.  It will }
{ then ignore the substitute routines for Delete, Copy, and Pos which are    }
{ duplicates. This is optional.                                              }

{ $Define SysTpu    }
{^ delete this space. }


UNIT Strg;

INTERFACE

var
  AscSrcPtr:          pointer;    { For StrAsc   }
  AscDestPtr:         pointer;    { For AscStr   }
  LnSrcPtr:           pointer;    { For StrLn    }
  LnDestPtr:          pointer;    { For LnStr    }
  CmpIndex1:          integer;    { For StrCmp*  }
  CmpIndex2:          integer;    { For StrCmp*  }
  ReplIndex,ReplToDo: byte;       { For StrRepl* }
  ReplOverFlow:       boolean;    { For StrRepl* }


{ -- String Operations (6) -- }

procedure StrCap  (VAR S: string);
procedure StrLwr  (VAR S: string);
procedure StrUpr  (VAR S: string);
procedure StrRev  (VAR S: string);
procedure StrSort (VAR S: string);
procedure StrRoll (VAR S: string; Count: integer);


{ -- Character operations. (2) -- }

function  LoCase (C: char): char;
Inline(
  $58/          { pop   ax         ; Place Char in AL }
  $3C/$5A/      { cmp   al,'Z'     ; Compare with 'Z' first }
  $77/$06/      { ja    Exit       ;   Exit if not upper }
  $3C/$41/      { cmp   al,'A'     ; In upper case range? }
  $72/$02/      { jb    Exit       ;   no, exit }
  $0C/$20);     { or    al,'a'-'A' ;   yes, convert to lower }
                { Exit: }

function  UpCase (C: char): char;
Inline(
  $58/          { pop   ax         ; Place Char in AL }
  $3C/$61/      { cmp   al,'a'     ; Compare with 'a' first }
  $72/$06/      { jb    Exit       ;   Exit if not lower }
  $3C/$7A/      { cmp   al,'z'     ; In lower case range? }
  $77/$02/      { ja    Exit       ;   no, exit }
  $2C/$20);     { sub   al,'a'-'A' ;   yes, convert to upper }
                { Exit: }


{ -- String Insert/Delete (11) -- }

procedure StrIns  (VAR Dest: string; S: string; DestIndex,MaxLen: byte);
procedure ChrIns  (VAR S: string; Fill: char; Index,Count: byte);
procedure ChrInsL (VAR S: string; Fill: char; Count: byte);
procedure ChrInsR (VAR S: string; Fill: char; Count: byte);
procedure ChrPadC (VAR S: string; Fill: char; Field: byte);
procedure ChrPadL (VAR S: string; Fill: char; Field: byte);
procedure ChrPadR (VAR S: string; Fill: char; Field: byte);
procedure ChrDel  (VAR S: string; Find: char);
procedure ChrDelL (VAR S: string; Find: char);
procedure ChrDelR (VAR S: string; Find: char);
procedure StrCut  (VAR S: string; MaxLen: byte);
Inline(
  $58/     { pop   ax      ; Get MaxLen in AL  }
  $5F/     { pop   di      ; Get S offset      }
  $07/     { pop   es      ; Get S segment     }
  $26/     { es:           ; Segment override  }
  $3A/$05/ { cmp   al,[di] ; MaxLen>=S Length? }
  $73/$01/ { jae   Exit    ;   yes, length OK. }
  $AA);    { stosb         ;   no, truncate.   }
           {Exit: }


{ -- String Placement (8) -- }

procedure StrCat  (VAR Dest: string; S: string; MaxLen: byte);
procedure StrCatL (VAR Dest: string; S: string; MaxLen: byte);
procedure StrCatX (VAR Dest: string; S: string; indeX,Count,MaxLen: byte);
procedure StrCpy  (VAR Dest: string; S: string; Index,Count: byte);
procedure StrOvrC (VAR Dest: string; S: string; DestIndex: byte);
procedure StrOvrL (VAR Dest: string; S: string; DestIndex: byte);
procedure StrOvrR (VAR Dest: string; S: string; DestIndex: byte);
procedure StrMov  (VAR Dest: string; S: string);
procedure StrPoke (VAR Dest; S: string);
procedure StrPeek (VAR Dest: string; VAR Source; Count: byte);

procedure ChrOvr  (VAR S: string; Fill: char; Index,Count: byte);


{ -- String Pattern (3) -- }

procedure StrFill (VAR S: string; Fill: string; Count,MaxLen: byte);
procedure ChrFill (VAR S: string; Fill: char;   Count: byte);
procedure StrEnum (VAR S: string; First,Last: char);


{ -- String Position (12) -- }

function  StrPosL  (S,Find: string; Nth: byte):          byte;
function  StrPosLI (S,Find: string; Nth: byte):          byte;
function  StrPosR  (S,Find: string; Nth: byte):          byte;
function  StrPosRI (S,Find: string; Nth: byte):          byte;
function  StrPosX  (S,Find: string; indeX: byte):        byte;
function  StrPosXI (S,Find: string; indeX: byte):        byte;

function  ChrPosL  (S: string; Find: char; Nth: byte):   byte;
function  ChrPosLI (S: string; Find: char; Nth: byte):   byte;
function  ChrPosR  (S: string; Find: char; Nth: byte):   byte;
function  ChrPosRI (S: string; Find: char; Nth: byte):   byte;
function  ChrPosX  (S: string; Find: char; indeX: byte): byte;
function  ChrPosXI (S: string; Find: char; indeX: byte): byte;


{ -- String Count (4) -- }

function  StrQty   (S,Find: string):        byte;
function  StrQtyI  (S,Find: string):        byte;
function  ChrQty   (S: string; Find: char): byte;
function  ChrQtyI  (S: string; Find: char): byte;


{ -- String Comparison (2) -- }

function  StrCmp   (S1,S2: string; Index1,Index2,Count: byte): shortint;
function  StrCmpI  (S1,S2: string; Index1,Index2,Count: byte): shortint;


{ -- String Find and Replace Operations (4) -- }

procedure ChrRepl  (VAR S: string; Find,Repl: char; Index,Qty: byte);
procedure ChrReplI (VAR S: string; Find,Repl: char; Index,Qty: byte);
procedure StrRepl  (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: byte);
procedure StrReplI (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: byte);


{ -- String Member/Non-member (3) -- }

function  StrBrk   (S,Breaks:  string; Index: byte): byte;
function  StrSpn   (S,Members: string; Index: byte): byte;
procedure StrMemb  (VAR Dest: string; S: string);


{ -- String Parsing routines (11) -- }

function  WrdQty   (S: string):              byte;
function  WrdPosL  (S: string; Nth: byte):   byte;
function  WrdPosR  (S: string; Nth: byte):   byte;
function  WrdPosLX (S: string; indeX: byte): byte;
function  WrdPosRX (S: string; indeX: byte): byte;
procedure WrdL     (VAR Dest: string; S: string; Nth: byte);
procedure WrdR     (VAR Dest: string; S: string; Nth: byte);
procedure WrdLX    (VAR Dest: string; S: string; indeX: byte);
procedure WrdRX    (VAR Dest: string; S: string; indeX: byte);
procedure WrdToken (VAR Dest: string; S,Delims: string; VAR Index: byte);
procedure WrdParse (VAR Dest: string; S,Delims: string; VAR Index: byte);


{ -- String Conversions (10) -- }

function  StrHex (Num: longint; Field: byte):    string;
function  StrBin (Num: longint; Field: byte):    string;
function  ValBin (S: string; VAR Code: integer): longint;
function  ValHex (S: string; VAR Code: integer): longint;

procedure StrDeTab (VAR Dest: string; S: string; TabSpaces: byte);
procedure StrReTab (VAR Dest: string; S: string; TabSpaces: byte);

procedure AscStr (VAR AscDest; S: string);
procedure LnStr  (VAR LnDest;  S: string);
procedure StrAsc (VAR Dest: string; VAR AscSrc; MaxLen: byte);
procedure StrLn  (VAR Dest: string; VAR LnSrc;  MaxLen: byte);


{ -- Automatic and FASTER replacement for Pascal standard routines (3) -- }

{$ifndef SysTpu }
procedure Delete (VAR S: string; Index,Count: integer);
function  Copy   (    S: string; Index,Count: integer): string;
function  Pos    (Find,S: string): byte;
{$endif }


{ -- String Justification (3) -- }

function  StrJL  (S: string; Field: byte): string;
function  StrJC  (S: string; Field: byte): string;
function  StrJR  (S: string; Field: byte): string;


{ ** Function forms of the standard STR procedure ** }
{ -- String Formatting (17) -- }

function  StrL   (L: longint):                       string;
function  StrLF  (L: longint; Field: integer):       string;
function  StrR   (R: real):                          string;
function  StrRF  (R: real; Field: integer):          string;
function  StrRFD (R: real; Field,Decimals: integer): string;


{ -- IEEE reals -- }

{$ifopt N+ }
function  StrS   (S: single):                            string;
function  StrSF  (S: single; Field: integer):            string;
function  StrSFD (S: single; Field,Decimals: integer):   string;
function  StrD   (D: double):                            string;
function  StrDF  (D: double; Field: integer):            string;
function  StrDFD (D: double; Field,Decimals: integer):   string;
function  StrE   (E: extended):                          string;
function  StrEF  (E: extended; Field: integer):          string;
function  StrEFD (E: extended; Field,Decimals: integer): string;
function  StrC   (C: comp):                              string;
function  StrCF  (C: comp; Field: integer):              string;
function  StrCFD (C: comp; Field,Decimals: integer):     string;
{$endif N+ }


{ -- Character classification functions. (17) -- }

function  IsAlNum  (C: char): boolean;
function  IsAlpha  (C: char): boolean;
function  IsDigit  (C: char): boolean;
function  IsDOS    (C: char): boolean;
function  IsFile   (C: char): boolean;
function  IsLower  (C: char): boolean;
function  IsPath   (C: char): boolean;
function  IsPunct  (C: char): boolean;
function  IsReal   (C: char): boolean;
function  IsSigned (C: char): boolean;
function  IsSpace  (C: char): boolean;
function  IsUpper  (C: char): boolean;
function  IsXDigit (C: char): boolean;

function  IsASCII  (C: char): boolean;
Inline(
  $5B/          { pop  bx     ; Place Char in BL}
  $31/$C0/      { xor  ax,ax  ; Set false}
  $D0/$E3/      { shl  bl,1   ; Test Bit 7}
  $1C/$FF);     { sbb  al,-1  ; If Char<128, set true}

function  IsCntrl  (C: char): boolean;
Inline(
  $5B/          { pop  bx     ; Place Char in BL}
  $B0/$01/      { mov  al,1   ; Set true}
  $80/$FB/$7F/  { cmp  bl,$7F ; Char =$7F?}
  $74/$05/      { je   Exit   ;   yes, true}
  $80/$FB/$20/  { cmp  bl,$20 ; Char <$20?}
  $14/$FF);     { adc  al,-1  ;   if no, set false}
                { Exit:}

function  IsGraph  (C: char): boolean;
Inline(
  $5B/          { pop  bx     ; Place Char in BL}
  $31/$C0/      { xor  ax,ax  ; Set false}
  $80/$FB/$21/  { cmp  bl,$21 ; Char <$21?}
  $72/$05/      { jb   Exit   ;   yes, false}
  $80/$FB/$7F/  { cmp  bl,$7F ; Char <$7F?}
  $10/$C0);     { adc  al,al  ;   if yes, set true}
                { Exit:}

function  IsPrint  (C: char): boolean;
Inline(
  $5B/          { pop  bx     ; Place Char in BL}
  $31/$C0/      { xor  ax,ax  ; Set false}
  $80/$FB/$20/  { cmp  bl,$20 ; Char <$20?}
  $72/$05/      { jb   Exit   ;   yes, false}
  $80/$FB/$7F/  { cmp  bl,$7F ; Char <$7F?}
  $10/$C0);     { adc  al,al  ;   if yes, set true}
                { Exit:}

{ 97 unique / 118 total routines }


IMPLEMENTATION

{ Fast array routines for local use: }
{$L RepMovsB.obj }
{$L RepStosB.obj }
{$L RepMovBR.obj }
{$L RepStoBR.obj }
{$L RepCmpsB.obj }
procedure RepMovsB;    external;
procedure RepStosB;    external;
procedure RepMovsBRev; external;
procedure RepStosBRev; external;
procedure RepCmpsB;    external;

{$L StrCap.obj   }
{$L StrCase.obj  }
{$L StrRev.obj   }
{$L StrSort.obj  }
{$L StrRoll.obj  }
procedure StrCap;   external;
procedure StrLwr;   external;
procedure StrUpr;   external;
procedure StrRev;   external;
procedure StrSort;  external;
procedure StrRoll;  external;

{$L ChrInsL.obj  }
{$L ChrInsR.obj  }
{$L ChrPadC.obj  }
{$L ChrPadL.obj  }
{$L ChrPadR.obj  }
{$L ChrDel.obj   }
{$L ChrDelL.obj  }
{$L ChrDelR.obj  }
{$L ChrIns.obj   }
{$L StrIns.obj   }
procedure ChrInsL;  external;
procedure ChrInsR;  external;
procedure ChrPadC;  external;
procedure ChrPadL;  external;
procedure ChrPadR;  external;
procedure ChrDel;   external;
procedure ChrDelL;  external;
procedure ChrDelR;  external;
procedure ChrIns;   external;
procedure StrIns;   external;

{$L StrCat.obj   }
{$L StrCatX.obj  }
{$L StrCpy.obj   }
{$L StrMov.obj   }
{$L StrOvrC.obj  }
{$L StrOvrL.obj  }
{$L StrOvrR.obj  }
{$L ChrOvr.obj   }
procedure StrCat;   external;
procedure StrCatL;  external;
procedure StrCatX;  external;
procedure StrCpy;   external;
procedure StrMov;   external;
procedure StrOvrC;  external;
procedure StrOvrL;  external;
procedure StrOvrR;  external;
procedure ChrOvr;   external;

{$L StrFill.obj  }
{$L ChrFill.obj  }
{$L StrEnum.obj  }
procedure StrFill;  external;
procedure ChrFill;  external;
procedure StrEnum;  external;

{$L ToStack.obj  }
{$L StrPosL.obj  }  { Includes StrQty, too }
{$L StrPosLI.obj }  { Includes StrQtyI, too }
{$L StrPosR.obj  }
{$L StrPosRI.obj }
{$L StrPosX.obj  }
{$L StrPosXI.obj }
{$L ChrQty.obj   }
{$L ChrQtyI.obj  }
{$L ChrPosL.obj  }
{$L ChrPosLI.obj }
{$L ChrPosR.obj  }
{$L ChrPosRI.obj }
{$L ChrPosX.obj  }
{$L ChrPosXI.obj }
procedure ToStack;  external;  { Local use }
procedure ChrSrchI; external;  { Local use }
procedure CopyStr;  external;  { Local use }
procedure CopyStr2; external;  { Local use }
function  StrPosLI; external;
function  StrPosRI; external;
function  StrPosXI; external;
function  StrQtyI;  external;
function  StrPosL;  external;
function  StrPosR;  external;
function  StrPosX;  external;
function  StrQty;   external;

function  ChrPosL;  external;
function  ChrPosLI; external;
function  ChrPosR;  external;
function  ChrPosRI; external;
function  ChrPosX;  external;
function  ChrPosXI; external;
function  ChrQty;   external;
function  ChrQtyI;  external;

{$L StrCmp.obj   }
function  StrCmp;   external;
function  StrCmpI;  external;

{$L ChrRepl.obj  }
{$L ChrReplI.obj }
{$L StrRepl.obj  }  { includes StrReplI, too }
procedure ChrRepl;  external;
procedure ChrReplI; external;
procedure StrRepl;  external;
procedure StrReplI; external;

{$L StrBrk.obj   }
{$L StrSpn.obj   }
{$L StrMemb.obj  }
function  StrBrk;   external;
function  StrSpn;   external;
procedure StrMemb;  external;

{$L WrdQty.obj   }
{$L WrdPosL.obj  }
{$L WrdPosR.obj  }
{$L WrdPosLX.obj }
{$L WrdPosRX.obj }
{$L WrdL.obj     }
{$L WrdR.obj     }
{$L WrdLX.obj    }
{$L WrdRX.obj    }
{$L WrdParse.obj }
function  WrdQty;   external;
function  WrdPosL;  external;
function  WrdPosR;  external;
function  WrdPosLX; external;
function  WrdPosRX; external;
procedure WrdL;     external;
procedure WrdR;     external;
procedure WrdLX;    external;
procedure WrdRX;    external;
procedure WrdToken; external;
procedure WrdParse; external;

{$L StrHex.obj   }
{$L StrBin.obj   }
{$L ValBin.obj   }
{$L ValHex.obj   }
{$L StrDeTab.obj }
{$L StrReTab.obj }
{$L AscStr.obj   }
{$L LnStr.obj    }
{$L StrAsc.obj   }
{$L StrLn.obj    }
{$L StrPeek.obj  }  { Includes StrPoke, too }
function  StrHex;   external;
function  StrBin;   external;
function  ValBin;   external;
function  ValHex;   external;
procedure StrDeTab; external;
procedure StrReTab; external;
procedure AscStr;   external;
procedure LnStr;    external;
procedure StrAsc;   external;
procedure StrLn;    external;
procedure StrPeek;  external;
procedure StrPoke;  external;

{$ifndef SysTpu }
{$L Delete.obj   }
{$L Copy.obj     }
{$L Pos.obj      }
procedure Delete;   external;
function  Copy;     external;
function  Pos;      external;
{$endif }

{$L StrJ.obj     }
{$L StrJC.obj    }
function StrJL;     external;
function StrJC;     external;
function StrJR;     external;

function StrL; { (L: longint): string; }
var  Result: ^string;
begin
Inline(            { Typical code: }
  $89/$EC/         { mov  sp,bp      ; Drop Result }
  $16/             { push ss         ; Result segment }
  $FF/$76/$0A);    { push [bp+$0A]   ; Result offset ($08 for near) }
  str (L,Result^);
end;

function StrLF; { (L: longint; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0C);
  str (L:Field,Result^);
end;

function StrR; { (R: real): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0C);
  str (R,Result^);
end;

function StrRF; { (R: real; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0E);
  str (R:Field,Result^);
end;

function StrRFD; { (R: real; Field,Decimals: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$10);
  str (R:Field:Decimals,Result^);
end;


{$ifopt N+ }

function StrS; { (S: single): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0A);
  str (S,Result^);
end;

function StrSF; { (S: single; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0C);
  str (S:Field,Result^);
end;

function StrSFD; { (S: single; Field,Decimals: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0E);
  str (S:Field:Decimals,Result^);
end;

function StrD; { (D: double): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0E);
  str (D,Result^);
end;

function StrDF; { (D: double; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$10);
  str (D:Field,Result^);
end;

function StrDFD; { (D: double; Field,Decimals: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$12);
  str (D:Field:Decimals,Result^);
end;

function StrE; { (E: extended): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$10);
  str (E,Result^);
end;

function StrEF; { (E: extended; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$12);
  str (E:Field,Result^);
end;

function StrEFD; { (E: extended; Field,Decimals: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$14);
  str (E:Field:Decimals,Result^);
end;

function StrC; { (C: comp): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0E);
  str (C,Result^);
end;

function StrCF; { (C: comp; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$10);
  str (C:Field,Result^);
end;

function StrCFD; { (C: comp; Field,Decimals: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$12);
  str (C:Field:Decimals,Result^);
end;

{$endif N+ }

const
  ChrClass: array[0..127] of byte =
   ($00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $00,$48,$08,$48,$48,$48,$48,$48,$48,$48,$88,$28,$08,$68,$68,$08,
    $44,$44,$44,$44,$44,$44,$44,$44,$44,$44,$88,$08,$08,$08,$08,$88,
    $48,$52,$52,$52,$52,$72,$52,$42,$42,$42,$42,$42,$42,$42,$42,$42,
    $42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$08,$88,$08,$48,$48,
    $48,$51,$51,$51,$51,$71,$51,$41,$41,$41,$41,$41,$41,$41,$41,$41,
    $41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$48,$08,$48,$48,$00);

{$L Is.obj       }
{$L IsPath.obj   }
{$L IsSigned.obj }
{$L IsSpace.obj  }
function IsAlNum;   external;
function IsAlpha;   external;
function IsDigit;   external;
function IsDOS;     external;
function IsFile;    external;
function IsLower;   external;
function IsPath;    external;
function IsPunct;   external;
function IsReal;    external;
function IsSigned;  external;
function IsSpace;   external;
function IsUpper;   external;
function IsXDigit;  external;


END.
