{
 $Id$
}

 {*****************************************************************************
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Nw_Msg;                  {mark may's msg routines used}

Interface

Uses Dos, Fm_Struct, S_String, Fm_Basic, Crosslib,
     MKMsgAbs, MKOpen, MKDos, MKstring, MKGlobt,
     MkMsgTxt, MkMsgPkt, MkMsgSqu, MkMsgHud, MkMsgFid, MkMsgJam, MkmsgEzy;

{-----------------------------------------------------------------------------}


Procedure Init_Message (id:string; kludge:boolean; aka:byte;
                        status:msgstatustype; destination,origin:nodetype;
                        fromname,toname,subject:string);

                {nu kan er met dostring en dostringln msgtxt toegevoegd worden}

Function  Open_Message : boolean;
                   {tearline en origline toevoegen, evt fattach en andere bits}

Function  Save_Message : Boolean;          {incl het sluiten van de messagebase}


Procedure DoStringLn(Str:String);                     {tekst toevoegen aan msg}
Procedure DoString(Str:String);
Procedure DoKludgeLn(Str:String);

Function  Big_MessageText (toadd, maxkbsize :byte) : Boolean;
                            {om te controleren of de msgtxt niet te groot wordt}

Procedure Set_Attrib(attrib:msgattribset; id:string);
     {sets private, crashmail, direct, filerequest, fattach, fileupdatereq bits}
Procedure Set_Attrib2(attrib:mailstatustype);

Function  Orig_Line(str:string;aka:byte):string;
                                    {returns proper orig line incl aka matching}

Procedure SendSysopMsg(subject:string);


Var
  TMsg : AbsMsgPtr;

{-----------------------------------------------------------------------------}

Implementation

Var
  MsgCount  : Longint;


Procedure SendSysopMsg(subject:string);
Var t   : text;
      tmp : string;
Begin
    Init_Message ('F'+setup.netmailpath,true,1,[net],setup.address[1],setup.address[1],
                  'FileMgr',setup.sysopname, subject);
    Open_Message;
    Set_Attrib([privat,killsent],'F');
    Assign(t,systempath+'fmsystmp.#$');
    {$I-} reset(t); {$I+}
    If ioresult = 0 then
      Begin
        while not eof(t) do
          begin
            readln(t,tmp);
            dostringln(tmp);
          end;
        close(t);
        erase(t);
      End;
    DoStringln('');
    DoStringln('--- ' + msgtearline);
    Save_Message;
End;


Procedure Init_Message (id:string; kludge:boolean; aka:byte;
                        status:msgstatustype; destination,origin:nodetype;
                        fromname,toname,subject:string);
Var
  FrNode    : nodetype;
  D         : Addrtype;
  idp       : string;
  areatag   : string;
Begin
  areatag := '';
  if id[1] = 'P' then
    begin
     areatag := upper(strip('B',' ',last(15,first(16,id))));
     id := 'P'+last(length(id)-16,id);
     idp := id + 'FM'+UniqueName('PKT');
    end else idp := id;

  If idp[1] <> 'F' then
    begin
      if not openorcreatemsgarea(tmsg,checkepath(idp,false)) then exit;
    end else
    begin
      If not OpenMsgArea(tMsg, checkepath(Idp,false)) Then exit;
    end;

  Tmsg^.StartNewMsg;

  TMsg^.SetTo( toname );                {Set to name}
  TMsg^.SetFrom( fromname );            {Set from name}
  TMsg^.SetSubj( subject );             {Set message subject}

  if (id[1] = 'P') and (areatag <> '') then dostring('AREA:'+areatag+#13);

  If AKA = 0 then
    FrNode.Zone := 0 else
      FrNode := SETUP.Address[AKA];
  MatchAKA (FrNode, destination);

  If ((Net in Status) and (idp[1] <> 'T')) or (idp[1] = 'P') then  {set msg type}
    Begin
      If idp[1] <> 'P' then TMsg^.SetMailType(mmtNetmail);

      If origin.zone = 0 then
        Move(frnode,d,sizeof(frnode)) else
          Move(origin,d,sizeof(origin));
      TMsg^.SetOrig(d);

      Move(destination,d,sizeof(destination));
      TMsg^.SetDest(d);
    End;

  If (echo in status) and (id[1] <> 'T') then
    Begin
      TMsg^.SetMAilType(mmtEchoMail);
      TMsg^.SetEcho(True);                  {Should msg be echoed}
    End;

  if id[1] <> 'T' then
    begin
      TMsg^.SetDate(DateStr(GetDosDate));   {Set msg date mm-dd-yy}
      TMsg^.SetTime(TimeStr(GetDosDate));   {Set msg time hh:mm}
      TMsg^.SetRefer(0);                    {Set reference #, often 0}
      TMsg^.Setlocal(true);
    end;

  If idp[1] <> 'T' then
    Begin
      TMsg^.DoKludgeln(msgid(frnode));
      If kludge then TMsg^.DoKludgeLn(#1'PID: FileMgr '+versionstr(versionnr));
    End;
  MsgCount := 0;
End;

Function Open_Message : boolean;
Begin
End;

Function Save_Message : Boolean;
Begin
  Save_Message := True;
  If TMsg^.WriteMsg <> 0 then Save_Message := False;
  If Not CloseMsgArea(Tmsg) then Save_Message := False;
End;

Procedure DoStringLn(Str:String);
Begin
  TMsg^.DoStringLn(Str);
  Inc(MsgCount,length(str));
End;

Procedure DoString(Str:String);
Begin
  TMsg^.DoString(Str);
  Inc(MsgCount,length(str));
End;

Procedure DoKludgeLn(Str:String);
Begin
  TMsg^.DoKLudgeln(Str);
End;

Function Big_MessageText (toadd, maxkbsize :byte) : Boolean;
Var
  K : Longint;
Begin
  K := maxkbsize * 1024;
  k := k + toadd;
  If msgcount > k then
    Big_MessageText := True Else
      Big_MessageText := False;
End;

Procedure Set_Attrib(attrib:msgattribset; id:string);
Begin
  if Privat in attrib then TMsg^.SetPriv(true);
  if CrashMail in attrib then TMsg^.SetCrash(true);
  {rcvd}
  {sent}
  if FAttach in Attrib then TMsg^.SetFAttach(true);
  {transit}
  {orphan}
  If killsent in attrib then
    Begin
      If id[1] = 'F' then
        Tmsg^.putbyte(Tmsg^.getbyte(186) or 128, 186);
    End;
  {loc}
  If holdmail in attrib then
    Begin
      if id[1] = 'F' then
        tmsg^.PutByte(Tmsg^.GetByte(187) or 2, 187) else
          Tmsg^.sethold(true);  {hold}
    End;
  if DirectMail in Attrib then TMsg^.DoKludgeln(#1+'FLAGS DIR');
  if FileRequest in Attrib then TMsg^.SetFileReq(true);
  {returnreceiptrequest}
  {isreturnreceipt}
  if FileUpdateReq in Attrib then TMsg^.SetReqAud(true);
  {fileupdatereq}
End;

Procedure Set_Attrib2(attrib:mailstatustype);
Begin
  if Crash in attrib then TMsg^.SetCrash(true);
  If hold in attrib Then Tmsg^.PutByte(Tmsg^.GetByte(187) or 2, 187); {hold}
  if Direct in Attrib then TMsg^.DoKludgeln(#1+'FLAGS DIR');
End;


Function Orig_Line(str:string;aka:byte):string;
Var
  FrNode : NodeType;
  Tmp    : String;
Begin
  if AKA = 0 then FrNode.Zone := 0 else FrNode := SETUP.Address[AKA];
  MatchAKA (FrNode, {sc.}Tonode);
  Tmp := ' * Origin: '+str+' '+'('+Node2Str(FrNode)+')';
  Orig_Line := Tmp;
End;

End.
