{
 $Id$
}
{$O+}


 {*****************************************************************************
 *
 *  Purpose :  File / Tic forwarding
 *
 * vbc 19/03/08 -  add build to version (near end of source)
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Nw_Forw;

Interface


Uses Dos, S_String, F_File, Crosslib, Crc32,
     MkMsgFid, MkMsgAbs, MkGlobt,
     Fm_Struct, Fm_Basic, Nw_Msg, Fm_Log, Fm_Hex, FM_Rear, Nw_Tpl, Fm_Init;


Function  WriteForwardInfo1(name:string): String;
Procedure WriteForwardInfo(expo:exporttype; addressee:nodetype; forwardname:string); {--}
Procedure ForwardFiles;
Procedure CleanForwardFiles( st:string );
Procedure RescanMailer;
Function MakeTIC (Pwd:String; ToNode:NodeType; Advanced:Boolean) : String;

Type
  List = ^Element;

  Element = Record
    Node    : Nodetype;
    Name    : String[12];
    Msgname : String[12];
    Next    : List;
  End;
Var
  Start,
  Current  : List;


Implementation


Function MakeTIC (Pwd:String; ToNode:NodeType; Advanced:Boolean) : String;
VAR
  dt : datetime;
  x, tel,
  tal     : word;
  TIK     : Text;
  Name    : String[12];
  P,I     : Byte;
  pWord   : String[15];
  tmp     : string;
  NotSeen : Boolean;
  ss : word;
begin  { save TIC info to file }
  while info.longdesc[info.longcount] = #13 do
    begin
      info.longdesc[info.longcount] := #0;
      dec(info.longcount);
    end;

  NotSeen := true;

  if Advanced
    then Name := 'FM'+UniqueName('TIC')
      else Name := 'TK'+UniqueName('TIC');

  Assign (TIK, SETUP.OutBoundPath+Name);
  {$I-} ReWrite (TIK); {$I+}
  if IOresult = 0 then
    begin                                { vbc 190308 }
      WriteLn (TIK, 'Created by FileMgr ', VERSION, '/', versionstr(versionnr)+build,' ',copyright);
      WriteLn (TIK, 'File ', info.FileSpec);

      if info.author <> '' then writeln(TIK,'Author ',info.author);

      if info.release <> 0 then
        begin
          FillChar (DT, SizeOf(DT), 0);
          With DT do GetDate(Year, Month, Day, tal);
          if info.release > GetUnixDate(DT) then
            Writeln(TIK,'Release ',info.release);
        end;

      If info.Replaces <> '' then WriteLn (TIK,'Replaces ',info.Replaces);
      if info.encrypted <> '' then writeln(TIK,'Encrypted ',info.encrypted);
      if info.garbled <> '' then writeln(TIK,'Garbled ',info.garbled);

      info.Description := Strip('A',#0,info.description);
      WriteLn (TIK, 'Desc ', info.Description);
      WriteLn (TIK, 'Area ', info.TAG);
      If info.Magic <> '' then    writeln (TIK, 'Magic ', info.magic);
      If info.CRCstr <> '' then   WriteLn (TIK, 'CRC ', info.CRCstr);
      If info.AreaDesc <> '' then Writeln (TIK, 'Areadesc ',info.Areadesc);

      if info.cost <> 0 then
        begin
          if node.addpercent > 0 then
            begin
              info.cost := info.cost + ( node.addpercent * ( info.cost / 100 ));
            end;
          Writeln(TIK,'Cost '+real_to_str(info.cost,2));
        end;

      If (info.longcount > 0) and advanced then
        Begin
          Repeat
            Tmp := '';
            tel := 75;
            if tel-1 > info.longcount then tel := info.longcount;
            repeat
              dec(tel);
            until (tel = 0) or (info.longdesc[tel] = ' ') or (info.longdesc[tel] = #13);
            if tel = 0 then tel := 75;
            if tel-1 > info.longcount then tel := info.longcount;
            if info.longcount < 75 then tel := info.longcount;
            tal := 0;
            while tal < tel do
              begin
                inc(tal);
                tmp := tmp + info.longdesc[1];
                for x := 1 to info.longcount-1 do info.longdesc[x] := info.longdesc[x+1];
                dec(info.longcount);
                if (info.longcount > 0) and (info.longdesc[1] = #13) then
                  begin
                    tal := tel+1;
                    for x := 1 to info.longcount-1 do info.longdesc[x] := info.longdesc[x+1];
                    dec(info.longcount);
                  end;
                if tmp = #13 then
                  begin
                    tmp := '';
                    tal := tel+1;
                  end;
              end;
            Writeln(TIK, 'LDesc ', Tmp);
          Until Info.longcount = 0;
        End;

      MatchAKA(info.Origin, ToNode);
      WriteLn (TIK, 'Origin ', Node2Str(info.Origin));
      If advanced then
        Writeln(TIK,'To ',Node2str(tonode));
      MatchAKA(info.From, ToNode);
      WriteLn (TIK, 'From ', Node2Str(info.From));

      if info.source.zone <> 0 then writeln(TIK,'Source ',node2str(info.source));
      if info.report.zone <> 0 then writeln(TIK,'Report ',node2str(info.report));
      if info.rtrcpttrue then
        begin
          write(TIK,'Rtrcpt ');
          for i := 1 to 10 do
            if info.rtrcpt[i].zone <> 0 then
              write(node2str(info.rtrcpt[i]));
          writeln(tik,'');
        end;

      if info.topotrue then
        begin
          write(TIK,'TOPO ');
          if info.topo.zone <> 0 then write(node2str(info.topo));
          writeln(TIK,'');
        end;

      if info.cPath>1 then for P := 1 to info.cPath-1 do
        WriteLn (TIK, 'Path ',Node2Str(info.Path[P]),' ',info.PathUnix[P],' ',info.PathStamp[P]);
      MatchAKA (info.Path[info.cPath], ToNode);
      WriteLn (TIK, 'Path ',Node2Str(info.Path[info.cPath]),' ',info.PathUnix[info.cPath],' ',info.PathStamp[info.cPath]);
      P := 1;
      While (P<=MAXSEENBY) and (P<=info.cSeen) do
        begin
          I := 1;
          While (I<=20) and (SETUP.Address[I].Zone > 0) do
            begin
              if NodeEQ(info.SeenByLst[P], SETUP.Address[I]) then
                begin
                  if NotSeen then
                    begin
                      tal := 0;
                      while (tal <= info.cseen) and not nodeeq(tonode,info.seenbylst[tal]) do inc(tal);
                      if tal <= info.cseen then {als tonode in seenbylst}
                        begin
                          info.SeenByLst[P].Zone := 0;
                          MatchAKA (info.SeenByLst[P], ToNode);
                        end;
                      NotSeen := True;
                    end else
                    begin
                      Move (info.SeenByLst[P+1], info.SeenByLst[P], (info.cSeen-P)*SizeOf(NodeType));
                      Dec (info.cSeen);
                    end;
                end;
              Inc (I);
            end;
          Inc (P);
        end;
      if not Advanced then
        begin
          For P := 1 to info.cSeen do
            if info.seenbylst[p].zone > 0 then
              WriteLn (TIK, 'Seenby ', Node2Str(info.SeenByLst[P]))
        end else
        begin
          Write (TIK, 'Seenby');
          I := 6;
          for P := 1 to info.cSeen do
            if info.seenbylst[p].zone > 0 then
              begin
                pWord := Node2Str(info.SeenByLst[P]);
                if P > 1 then
                  begin
                    if info.SeenByLst[P].Zone = info.SeenByLst[P-1].Zone then Delete (pWord,1,Pos(':',pWord));
                    if info.SeenByLst[P].Net  = info.SeenByLst[P-1].Net  then Delete (pWord,1,Pos('/',pWord));
                  end;
                pWord := ' ' + pWord;
                if Length(pWord) + I > 255 then
                  begin
                    WriteLn (TIK, '');
                    Write (TIK, 'Seenby');
                    I := 7;
                  end else I := I + Length(pWord);
                Write (TIK, pWord);
              end;
          WriteLn (TIK, '');
        end;


      if info.logstring <> '' then writeln(TIK,'Log ',info.logstring);

      if (not Advanced) and (Pwd = '') then Pwd := setup.defaultpwd;
      if Pwd <> '' then WriteLn (TIK, 'Pw ',Pwd);
      Close (TIK);
    end else Error (8,'Error creating '+Name);
  MakeTIC := Name;
end;

Procedure RescanMailer;
Var
  F : file;
Begin
  if setup.rescanfile <> '' then
    begin
      assign(f,setup.rescanfile);
      {$I-} rewrite(f); {$I+}
      If ioresult <> 0 then writelogcr(2,'Cannot update '+setup.rescanfile+' semaphore');
      close(f);
    end;
End;

Function WriteForwardInfo1(name:string): String;
var
  F    : forwardtype1;
  fbak : file of forwardtype1;
  tmp  : string;
Begin
  F.name := name;
  F.Info := info;
  tmp := uniquename('F_1');

  assign(fbak,tmp);
  rewrite(fbak);
  write(fbak,f);
  close(fbak);

  writeforwardinfo1 := tmp;
End;

Procedure WriteForwardInfo(expo:exporttype; addressee:nodetype; forwardname:string); {--}
Var
  F    : forwardtype;
  fbak : file of forwardtype;
  tmp  : string[27];
  crc  : longint;
  inx  : word;
Begin
  f.expo := expo;
  f.forwardname := forwardname;
  f.addressee := addressee;
  f.pwd := node.password;

  if not nodeeq(addressee,f.expo.a) then notify(9,' (via '+node2str(addressee)+')');

  tmp := node2str(addressee {f.expo.a} );

  crc := $ffffffff;
  for inx := 1 to length(tmp) do crc := updatecrc32(ord(tmp[inx]),crc);
  crc := not(crc);
  tmp := strhex(crc,8)+'.FM_';

  assign(fbak,systempath+tmp);
  {$I-} reset(fbak); {$I+}
  If ioresult <> 0 then
    begin
      {$I-} rewrite(fbak); {$I+}
      If ioresult <> 0 then
        begin
          notifycr(2,'Cannot open/create '+systempath+tmp);
          exit;
        end;
    end;
  Seek(fbak,filesize(fbak));
  Write(fbak,f);
  Close(fbak);
End;

Procedure CleanForwardFiles(st:string); {-----------------------------------}
  { als st = '' then worden alle *.IC files opgeslagen in }
  { de lijst, en verder niets...  (voor proc. Add_to_Old) }
Type
  List2 = ^Element2;
  Element2 = Record
    Node    : Nodetype;
    Name    : String[12];
    Next    : List2;
  End;
Var
  Start2,
  Current2  : List2;
CONST
  DaySec     = 60*60*24;
Var
  Amount   : Word;
  Sr, Sa,
  Sp       : Searchrec;
  Found    : Boolean;
  Tmp      : String;
  Correct  : Boolean;
  Bt_att   : text;          { bt attachfile }
  Bt_cur,
  Bt_out   : pathstr;
  DT       : DateTime;
  Compare  : LongInt;

  Procedure MsgMethod;
  Var Tot : Word;
  Begin
    Tot := 0;
    FindFirst(setup.netmailpath+'*.MSG', $0, Sr);
    While DosError = 0 do
      Begin
        If correct then
          Begin
            inc(tot);
            write( expand( '('+int_to_Str(tot)+')' ,15) ,#13);
            If not Lees_bericht(compare, false, setup.netmailpath+Sr.Name) then
              begin
                if st <> '' then Correct := false;
                notifycr(2,'Could not read '+setup.netmailpath+sr.name);
              end;
            If fromname <> '' then
              Begin
                Repeat
                  Tmp := extractwords(1,1,subject);
                  If wordcnt(subject) > 1 then subject := extractwords(2,wordcnt(subject)-1,subject)
                    else subject := '';

                  If (st <> '') then
                    begin
                      if (pos(setup.outboundpath,tmp) <> 0) then
                        begin {add to list}
                          Tmp := file_Split(2,tmp);
                          Current2^.name := Tmp;
                          If (MaxAvail-1024) > Sizeof(current2^) then
                            New(Current2^.Next) else
                              begin
                                notifycr(2,'Out of memory (cleanforwardfiles)');
                                correct := false;
                              end;
                          if correct then
                            begin
                              Current2 := Current2^.Next;
                              Current2^.Next := Nil;
                              Inc(Amount);
                            end;
                        end;
                    end else
                    begin
                      If (last(2,tmp) = 'IC') and (pos(upper(setup.outboundpath),upper(tmp)) <> 0) then
                        begin
                          Tmp := file_Split(2,tmp);
                          current^.name := tmp;
                          current^.msgname := sr.name;
                          current^.node := tonode;
                          If (maxavail-1024) > sizeof(current) then
                            New(Current^.Next) else
                              begin
                                notifycr(2,'Out of memory (cleanforwardfiles)');
                                correct := false;
                              end;
                          if correct then
                            begin
                              Current := Current^.Next;
                              Current^.Next := Nil;
                              Inc(Amount);
                            end;
                        end;
                     end;
                Until (wordcnt(subject) = 0) or not correct;
              End;
          End;
        FindNext(Sr);
      End;
  End;

Begin
  With DT do { get todays time }
    begin
      GetDate (Year, Month, Day, amount);
      GetTime (Hour, Min, Sec, amount);
    end;
  Compare := GetUnixDate(DT) - (DaySec * SETUP.Days2Keep);

  Amount := 0;
  Correct := true;

  If st <> '' then
    begin
      NotifyCR(8,ST);  {removing sent files}
      New(Start2);  { init list}
      Current2 := Start2;
      Current2^.Next := Nil;
    end else
    begin
      New(Start);  { init list}
      Current := Start;
      Current^.Next := Nil;
    end;

  {create list of all files forwarded to nodes}
  Case setup.mailer of
    1,  {frontdoor}
    5 : {intermail} MsgMethod;
    2,  {binkley}
    4 : {Pop}
        Begin
          bt_out := udir(setup.quepath);
          { scan all outbound dirs for fileattaches }
          findfirst (bt_out+'.*', directory, sr);
          while doserror = 0 do
            begin
              if directory and sr.attr = directory then
                begin
                  bt_cur := lastdir(bt_out)+'\'+sr.name+'\';
                  findfirst (bt_cur + '*.?LO', $0, sa);
                  while doserror = 0 do
                    begin
                      if correct then
                        begin
                          assign (bt_att, bt_cur + sa.name);
                          {$i-} reset (bt_att); {$i+}
                          if ioresult = 0 then
                            begin
                              while not eof(bt_att) do
                                begin
                                  readln (bt_att, tmp);
                                  Tmp := upper(tmp);
                                  if tmp[1] in ['~','^','#'] then delete (tmp,1,1);
                                  if (st <> '') then
                                    begin
                                      if (pos(setup.outboundpath,tmp) <> 0) then
                                        begin {add to list}
                                          Tmp := file_Split(2,tmp);
                                          Current2^.name := Tmp;
                                          New(Current2^.Next);
                                          Current2 := Current2^.Next;
                                          Current2^.Next := Nil;
                                          Inc(Amount);
                                        end;
                                    end;
                                end;
                              close (bt_att);
                            end else
                            begin
                              correct := false;
                              notifycr(2,'Could not open '+bt_cur+sa.name+', cleaning aborted...');
                            end;
                        end;
                      findnext (sa);
                    end;

                  findfirst (bt_cur + '*.?FM', $0, sa); {find alternatieve files}
                  while doserror = 0 do
                    begin
                      if correct then
                        begin
                          assign (bt_att, bt_cur + sa.name);
                          {$i-} reset (bt_att); {$i+}
                          if ioresult = 0 then
                            begin
                              while not eof(bt_att) do
                                begin
                                  readln (bt_att, tmp);
                                  Tmp := upper(tmp);
                                  if tmp[1] in ['~','^','#'] then delete (tmp,1,1);
                                  if (st <> '') and (pos(setup.outboundpath,tmp) <> 0) then
                                    begin {add to list}
                                      Tmp := file_Split(2,tmp);
                                      Current2^.name := Tmp;
                                      New(Current2^.Next);
                                      Current2 := Current2^.Next;
                                      Current2^.Next := Nil;
                                      Inc(Amount);
                                    end;
                                end;
                              close (bt_att);
                            end else
                            begin
                              notifycr(2,'Could not open '+bt_cur+sa.name+', cleaning aborted...');
                              correct := false;
                            end;
                        end;
                      findnext (sa);
                    end;

                  { now check pnt dir }
                  findfirst (bt_cur + '????????.PNT', directory, sa);
                  while doserror = 0 do
                    begin
                      { search this pnt directory }
                      findfirst (bt_cur + sa.name + '\*.?LO', $0, sp);
                      while doserror = 0 do
                        begin
                          if correct then
                            begin
                              assign (bt_att, bt_cur + sa.name + '\' + sp.name);
                              {$i-} reset (bt_att); {$i+}
                              if ioresult = 0 then
                                begin
                                  while not eof(bt_att) do
                                    begin
                                      readln (bt_att, tmp);
                                      tmp := upper(tmp);
                                      if tmp[1] in ['~','^','#'] then delete (tmp,1,1);
                                      if (st <> '') and (pos(setup.outboundpath,tmp) <> 0) then
                                        begin {add to list}
                                          Tmp := file_Split(2,tmp);
                                          Current2^.name := Tmp;
                                          New(Current2^.Next);
                                          Current2 := Current2^.Next;
                                          Current2^.Next := Nil;
                                          Inc(Amount);
                                        end;
                                    End;
                                  Close (bt_att);
                                End Else
                                Begin
                                  notifycr(2,'Could not open '+bt_cur+sa.name+'\'+sp.name+', cleaning aborted...');
                                  correct := false;
                                End;
                            End;
                          Findnext (sp);
                        End;


                      {alternatieve files}
                      findfirst (bt_cur + sa.name + '\*.?FM', $0, sp);
                      while doserror = 0 do
                        begin
                          if correct then
                            begin
                              assign (bt_att, bt_cur + sa.name + '\' + sp.name);
                              {$i-} reset (bt_att); {$i+}
                              if ioresult = 0 then
                                begin
                                  while not eof(bt_att) do
                                    begin
                                      readln (bt_att, tmp);
                                      tmp := upper(tmp);
                                      if tmp[1] in ['~','^','#'] then delete (tmp,1,1);
                                      if (st <> '') and (pos(setup.outboundpath,tmp) <> 0) then
                                        begin {add to list}
                                          Tmp := file_Split(2,tmp);
                                          Current2^.name := Tmp;
                                          New(Current2^.Next);
                                          Current2 := Current2^.Next;
                                          Current2^.Next := Nil;
                                          Inc(Amount);
                                        end;
                                    End;
                                  Close (bt_att);
                                End Else
                                Begin
                                  notifycr(2,'Could not open '+bt_cur+sa.name+'\'+sp.name+', cleaning aborted...');
                                  correct := false;
                                End;
                            End;
                          Findnext (sp);
                        End;
                      Findnext (sa);
                    End;
                End;
              Findnext(sr);
            End;
        End;
    3 : Begin {dbridge}
          MsgMethod; {use both frontdoor and dbidge method}
          If correct then
            Begin
              findfirst (setup.quepath+'Q-*.???', $0, sr);
              while doserror = 0 do
                Begin
                  If filematch(sr.name, 'Q-??????.???') or filematch(sr.name, 'Q-POINT.???') then
                    Begin
                      Assign (bt_att, setup.quepath + sr.name);
                      {$i-} reset (bt_att); {$i+}
                      If ioresult = 0 then
                        Begin
                          While not Eof(bt_att) do
                            Begin
                              Readln (bt_att, tmp);
                              tmp := upper(Tmp);
                              If (tmp[1] in ['N','I','C','H']) and (tmp[3] = 'T') then
                                Begin
                                  Tmp := Extractwords(4,1,Tmp);
                                  if st <> '' then
                                    begin {add to list}
                                      Current2^.name := Tmp;
                                      New(Current2^.Next);
                                      Current2 := Current2^.Next;
                                      Current2^.Next := Nil;
                                      Inc(Amount);
                                    end;
                                End;
                            End;
                          Close(bt_att);
                        End Else
                        Begin
                          notifycr(2,'Could not open '+setup.quepath+sr.name+', cleaning aborted...');
                          Correct := False;
                        End;
                    End;
                  Findnext(sr);
                End;
            End; { if correct}
        End; {dbridge}
  End; {Case}

  If st <> '' then
    begin
      If correct then
        Begin
          {check with outbound dir}
          FindFirst (setup.outboundpath+'*.*', $0, SR);
          While DOSerror = 0 do
            Begin
              Write(expand(SR.Name,12));
              Current2 := start2;
              Found := false;
              While not found and (current2^.next <> nil) do
                begin
                  if upper(sr.name) = upper(current2^.name) then
                    found := true;
                  current2 := current2^.next;
                end;
              If not found then
                Begin
                  delete_file(setup.outboundpath+SR.Name);
                  write(' X',#13);
                End Else Write(#13);
              FindNext (SR);
              Write(expand(' ',14),#13);
            End;
          Write(expand(' ',14),#13);
        End;

      if start2^.next <> nil then {remove list}
        Begin
          Repeat
            Current2 := start2;
            Start2 := current2^.next;
            Dispose(current2);
          Until start2^.next = nil;
        End;
      Dispose(start2);
    End;
End;

Function NodeOnHold(n:nodetype):Longint;
Var
  OnHold : Longint;
  X,
  Method : Byte;
  bt_zone : word;
  bt_cur,
  bt_out  : pathstr;
  bt_att  : text;          { bt attachfile }
  bt_name : string[12];    { bt name of attach }
  Sr      : Searchrec;
  T       : Text;
  Tmp     : String;
Begin
  OnHold := 0;
  Method := setup.mailer;
  If (method = 3) and (n.point > 0) and
     (n.node <> setup.address[1].node) then method := 1;

  Setup.outboundpath := FExpand(setup.outboundpath);
  If (method = 2) { binkley } or (method = 4) {Pop} then
    begin
      bt_out  := setup.quepath;
      bt_zone := setup.address[1].zone;
    end;

  Case method of
    1,  {frontdoor}
    5 : Begin {intermail}

          FindFirst(setup.netmailpath+'*.MSG', $0, Sr);
          While DosError = 0 do
            Begin
              If not Lees_bericht(0, false, setup.netmailpath+Sr.Name) then
                notifycr(2,'Could not read '+setup.netmailpath+sr.name);
              If nodeeq(tonode,n) then
                Begin
                  Tmp := extractwords(1,wordcnt(subject),subject);
                  For x := 1 to wordcnt(tmp) do
                    Begin
                      inc(onhold,(file_size(extractwords(x,1,tmp)) div 1024));
                    End;
                End;
              FindNext(Sr);
            End;

        End;
    2, {binkley}
    4 : Begin {Pop}
          { hlo naam opzoeken }
          bt_out  := setup.quepath;
          bt_zone := setup.address[1].zone;
          if n.zone = bt_zone
            then bt_cur := bt_out
              else bt_cur := udir(bt_out)+'.'+strhex(n.zone,3)+'\';

          { create attach name to find/create }
          bt_name := strhex(n.net,4) + strhex(n.node,4);
          if n.point > 0 then
            begin
              bt_cur  := bt_cur + bt_name + '.PNT\';
              bt_name := '0000' + strhex(n.point,4);
            end;

          findfirst(bt_cur+bt_name+'.?LO',archive,sr);
          while doserror = 0 do
            begin
              assign(t,bt_cur+sr.name);
              {$I-} reset(t); {$I+}
              if ioresult = 0 then
                begin
                  while not eof(t) do
                    begin
                      readln(t,tmp);
                      if tmp[1] in ['~','^','#'] then delete (tmp,1,1);
                      inc(onhold,(file_size(tmp) div 1024));
                    end;
                  close(t);
                end;
              findnext(sr);
            end;

        End;
    3 : Begin {dbridge}
        End;
  End;
  NodeOnHold := (OnHold);
End;


Procedure ForwardFiles;  {--------------------------------------------------}
var
  F        : ForwardType;
  F1       : File of ForwardType;     { forward.ext file }

  ft1      : ForwardType1;
  ft1file  : File of ForwardType1;

  N        : NodeType;                { current active node }
  Sr, Sa   : Searchrec;
  pre      : file;
  errorp   : boolean;

  Procedure ReadFt1file(name:string);
  Begin
    Assign(ft1file,systempath+name);
    {$I-} reset(ft1file); {$I+}
    If ioresult <> 0 then
      begin
        notifycr(1,'Cannot open/find '+systempath+name);
      end else
      begin
        read(ft1file,ft1);
        close(ft1file);
      end;
  End;

  Function NodeOnline : Boolean;  { semaphores }
  Var
    crc     : longint;
    tmp     : string;
    x       : word;
    bt_zone : word;
    bt_cur,
    bt_out  : pathstr;
    bt_name : string[12];
  Begin
    Case setup.semamode of
      0 : NodeOnline := False; {none}
      1, {binkley}
      4 : Begin {pop}
            bt_out  := setup.quepath;
            bt_zone := setup.address[1].zone;
            if node.address.zone = bt_zone
              then bt_cur := bt_out
                else bt_cur := udir(bt_out)+'.'+strhex(node.address.zone,3)+'\';
            bt_name := strhex(node.address.net,4) + strhex(node.address.node,4);
            if node.address.point > 0 then
              begin
                bt_cur  := bt_cur + bt_name + '.PNT\';
                bt_name := '0000' + strhex(node.address.point,4);
              end;
            if exist(bt_cur+bt_name+'.bsy') then NodeOnline := true else
              NodeOnline := false;
          End;
      2 : Begin {fd}
            tmp := node2str(node.address);
            crc := -1;
            for x := 1 to length(tmp) do
               crc := updatecrc32(ord(tmp[x]),crc);
            tmp := strhex(crc,8);
            if exist(setup.semaphorepath+tmp+'.`??') then
              NodeOnline := true else nodeOnline := false;
          End;
      3 : Begin {im}
            crc := -1;
            crc := updatecrc32(lo(node.address.zone),crc);
            crc := updatecrc32(hi(node.address.zone),crc);
            crc := updatecrc32(lo(node.address.net),crc);
            crc := updatecrc32(hi(node.address.net),crc);
            crc := updatecrc32(lo(node.address.node),crc);
            crc := updatecrc32(hi(node.address.node),crc);
            crc := updatecrc32(lo(node.address.point),crc);
            crc := updatecrc32(hi(node.address.point),crc);
            tmp := strhex(crc,8);
            tmp := 'X'+first(7,tmp)+'.'+last(1,tmp)+'??';
            If exist(setup.semaphorepath+tmp) then
              NodeOnline := true else NodeOnline := false;
          End;
    End;
  End;


  Procedure SortNodeList(name:string);
  Var
    first : boolean;
    fnew,       { no pre-release bit }
    fbak1,      { pack none }
    fbak2,      { pack tic  }
    fbak3,      { pack all  }
    fbak4 : file of forwardtype;  { msg attach }
    x     : word;
    tel   : word;
    onhold : longint;

    Procedure Telop;
    Begin
      Write(Replicate(length(int_to_str(tel))+2,#8));
      Inc(tel);
      Write('('+int_to_str(tel)+')');
    End;

  Begin
    tel := 0;
    onhold := 0;
    first:= true;
    Assign(f1,systempath+name);
    {$i-} Reset(f1); {$I+}
    If ioresult <> 0 then
      begin
        notifycr(2,'Cannot open '+systempath+name);
        exit;
      end;
    Assign(fnew,systempath+file_split(3,name)+'._PR');
    Rewrite(fnew);
    Assign(fbak1,systempath+'FORW-EXT.1');  {pack none}
    Rewrite(fbak1);
    Assign(fbak2,systempath+'FORW-EXT.2');  {pack tic}
    Rewrite(fbak2);
    Assign(fbak3,systempath+'FORW-EXT.3');  {pack all}
    Rewrite(fbak3);
    Assign(fbak4,systempath+'FORW-EXT.4');  { msg attach }
    Rewrite(fbak4);
    While not eof(f1) do
      Begin
        {$I-} Read(f1,f); {$I+}
        if ioresult = 0 then
          Begin

            ReadFt1file(f.forwardname);

            If first then
              begin
                first := false;
                n := f.addressee {expo.a};
                x := 1;
                fillchar(node,sizeof(node),0);
                While (x <= Nodeidx) and (Not NodeEQ(n,nfxt^[x].address)) do Inc(x);
                If x <= Nodeidx then
                  begin
                    Seek (NF, NFXt^[x].NodeRec);
                    blockRead (NF, NODE, sizeof(node));

                    if node.avaraging <> 0 then
                      begin
                        onhold := nodeonhold(n);
                        {kijken hoeveel node op hold heeft staan}
                      end else onhold := 0;

                  end else
                  begin
                    node.sysopname := 'Sysop';
                    node.address := f.expo.a;
                    node.mgrstatus := [Hold,Direct];
                    node.tictype := 1;
                  end;

                notify(5,'To '+node2str(n)+' - '+node.sysopname+' ');
                if onhold <> 0 then notifycr(5,'(Onhold: '+int_to_str(onhold)+' Kb) ') else
                  write('   ');

                if nodeonline and (node.avaraging <> 0) then
                  begin
                    notifycr(5,'Skipping, node currently online...');
                    onhold := node.avaraging + 1;
                  end;
              end;

            If f.expo.m = [] then
              Begin
                If (not date_past(datestring(ft1.info.release))) and (not (prerelease in f.expo.s)) then
                  begin
                    notifycr(5,'');
                    notifycr(5,'Pre-release date ('+datestring(ft1.info.release)+') not yet reached, holding file '
                      +file_split(2,ft1.name));
                    write(fnew,f);
                  end else
                If ((onhold > node.avaraging) and (node.avaraging <> 0)) then
                  begin
                    notifycr(5,'(holding '+file_split(2,ft1.name)+', '
                       +int_to_str(file_size(ft1.name) div 1024)+' Kb) ');
                    write(fnew,f);
                  end else
                  Begin
                    inc(onhold,(file_size(ft1.name) div 1024));
                    Telop;
                    If (ft1.info.msgfile <> '') and (setup.mailer in [1,3,5]) and (netmail in node.status)
                      then write(fbak4,f) else
                        If packfile in node.defstatus then write(fbak3,f) else
                          If packtic in node.defstatus then write(fbak2,f) else
                            write(fbak1,f);
                  End;
              End else
              Begin
                If (not date_past(datestring(ft1.info.release))) and (not (prerelease in f.expo.s)) then
                  begin
                    notifycr(5,'');
                    notifycr(5,'Pre-release date ('+datestring(ft1.info.release)+') not yet reached, holding file '
                     +file_split(2,ft1.name));
                    write(fnew,f);
                  end else
                If (onhold > node.avaraging) and (node.avaraging <> 0) then
                  begin
                    notifycr(5,'(holding '+file_split(2,ft1.name)+', '
                      +int_to_str(file_size(ft1.name) div 1024)+' Kb) ');
                    write(fnew,f);
                  end else
                  Begin
                    Telop;
                    inc(onhold,(file_size(ft1.name) div 1024));
                    If (ft1.info.msgfile <> '') and (setup.mailer in [1,3,5]) then write(fbak4,f) else
                      If packfile in f.expo.m then write(fbak3,f) else
                        If packtic in f.expo.m then write(fbak2,f) else
                          write(fbak1,f);
                  End;
              End;

          End;
      End;
    If tel > 0 then
      Begin
        Writelogcr(5,'('+int_to_Str(tel)+' files)');
        Write(' ');
      end;
    Close(f1);
    Close(fbak1);
    Close(fbak2);
    Close(fbak3);
    Close(fbak4);
    Close(fnew);
    if file_size(systempath+'FORW-EXT.1') = 0 then delete_file(systempath+'FORW-EXT.1');
    if file_size(systempath+'FORW-EXT.2') = 0 then delete_file(systempath+'FORW-EXT.2');
    if file_size(systempath+'FORW-EXT.3') = 0 then delete_file(systempath+'FORW-EXT.3');
    If file_size(systempath+'FORW-EXT.4') = 0 then delete_file(systempath+'FORW-EXT.4');
    If file_size(systempath+file_split(3,name)+'._PR') = 0 then delete_file(systempath+file_split(3,name)+'._PR');
  End;

  Procedure Create_Ticks(ext:byte);
  Var T1   : Text;
      tt3 : word;
      Tmp : String;
  Begin
    tt3 := 0;
    if node.tictype <> 0 then write('     ');
    Assign(t1,systempath+'FORW-LST.'+int_to_str(ext));
    Rewrite(t1);
    Assign(f1,systempath+'FORW-EXT.'+int_to_Str(ext));
    Reset(f1);
    While not eof(f1) do
      Begin
        Read(f1,f);
        ReadFt1file(f.forwardname);

        if node.tictype <> 0 {no ticks} then
          begin
            inc(tt3);
            write( #8#8#8#8#8+ expand('('+int_to_Str(tt3)+')',5) );

            info := ft1.info;
            Tmp := makeTIC (f.pwd, n, node.tictype = 2);
            Writeln(t1,setup.outboundpath+tmp);
          end;
      End;
    Close(f1);
    Close(t1);
    if node.tictype <> 0 then write(' ');
  End;

  Function StrB36 (w:word; b:byte) : String;
  Const
    Base36 : array[0..35] of char = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  Var
    T, S : string;
  Begin
    S := '';
    Repeat
      S := S + base36[W mod 36];
      W := W div 36;
    Until W = 0;

    t := '';
    repeat
      t := t + s[length(s)];
      s := first(length(s)-1,s);
    until s = '';
    s := t;           { Strrev(S); }  {string omdraaien}
    while length(s) < b do s := '0'+s;

    Strb36 := S;
  End;

  Procedure PlakAan(dir,fromfile,tofile:string);
  Var a1,a2 : text;
      pline : string;
  Begin
    Assign(a1,dir+fromfile);
    {$i-} reset(a1); {$I+}
    If ioresult = 0 then
      begin
        assign(a2,dir+tofile);
        {$I-} append(a2); {$I+}
        If ioresult <> 0 then
          begin
            {$I-} rewrite(a2); {$I+}
            If ioresult <> 0 then
              begin
                {$i-} mkdir(udir(dir)); {$i+}
                if ioresult <> 0 then error(1, 'Error creating outboundpath 2 '+dir);
                assign(a2, dir+tofile);
                {$i-} rewrite(a2); {$i+}
                if ioresult <> 0 then error(1, 'Error creating '+dir+tofile);
              end;
          end;
        while not eof(a1) do
          begin
            readln(a1,pline);
            writeln(a2,pline);
          end;
        close(a2);
        close(a1);
        erase(a1);
      end;
  End;


  Procedure Create_Attach(name:string);
  Var
    Method  : Byte;
    K       : Text;
    Tmp     : String;
    Tmp1    : String;
    Subject : String;
    Tel     : Word;

    bt_zone : word;
    bt_cur,
    bt_out  : pathstr;
    bt_att  : text;          { bt attachfile }
    bt_name : string[12];    { bt name of attach }

    Procedure Telop;
    Begin
      Write(Replicate(length(int_to_str(tel))+2,#8));
      Inc(tel);
      Write('('+int_to_str(tel)+')');
    End;

  Begin
    Tmp1 := '';
    Tel := 0;

    method := setup.mailer;
    if (method = 3) and (node.address.point > 0) and
      (node.address.node <> setup.address[1].node) then method := 1;

    setup.outboundpath := FExpand(setup.outboundpath);
    if (method = 2) { binkley } or (method = 4) {Pop} then
      begin
        bt_out  := setup.quepath;
        bt_zone := setup.address[1].zone;
      end;

    Assign(k,systempath+name);
    {$I-} Reset(k); {$I+}
    if ioresult <> 0 then exit;

    Case method of
      1,  {frontdoor}
      5 : Begin {intermail}
            While not eof(k) do
              Begin
                Readln(k,tmp);
                If Tmp1 = '' then tmp1 := tmp else
                  Begin
                    If (length(tmp+' '+tmp1) < 71) and not ((last(2,tmp) = 'IC') and (last(2,tmp1) = 'IC')) then
                      begin
                        subject := tmp1+' '+tmp;
                        tmp1 := '';
                      end else
                      begin
                        subject := tmp1;
                        tmp1 := tmp;
                      end;

                    Init_Message ('F'+setup.netmailpath, true, 0, [net],
                                   n, ft1.info.from, 'FileMgr '+version,
                                   node.sysopname, strip('B',' ',subject));
                    Open_Message;
                    Set_Attrib([fattach,Privat,Killsent],'F');
                    Set_Attrib2(node.defstatus);
                    Save_Message;
                    Telop;
                  End;
              End;
            If tmp1 <> '' then
              Begin
                Init_Message ('F'+setup.netmailpath, true, 0, [net],
                               n, ft1.info.from, 'FileMgr '+version,
                               node.sysopname, tmp1);
                Open_Message;
                Set_Attrib([fattach,Privat,Killsent],'F');
                Set_Attrib2(node.defstatus);
                Save_Message;
                Telop;
              End;
            Writelog(5,int_to_str(tel)+' messages');
            Write(' ');
          End;
      2, {binkley}
      4 : Begin {Pop}
            { find zone-path }
            if node.address.zone = bt_zone
              then bt_cur := bt_out
                else bt_cur := udir(bt_out)+'.'+strhex(node.address.zone,3)+'\';

            { create attach name to find/create }
            bt_name := strhex(node.address.net,4) + strhex(node.address.node,4);
            if node.address.point > 0 then
              begin
                bt_cur  := bt_cur + bt_name + '.PNT\';
                bt_name := '0000' + strhex(node.address.point,4);
              end;

            { check if outbound/pointdir exists }
            findfirst(udir(bt_cur), directory, sa);
            if doserror <> 0 then
              begin
                {$i-} mkdir(udir(bt_cur)); {$i+}
                if ioresult > 0 then error(1, 'Error creating outbound path '+bt_cur);
              end else
              begin
                while doserror = 0 do findnext(sa);
              end;

            if (setup.semamode = 1) {binkly} or (setup.semamode = 4) {Pop} then
              begin
                if exist(bt_cur+bt_name+'.bsy') then
                  begin
                    {creeer alternatieve naam}
                    if crash in node.defstatus
                      then bt_name := bt_name + '.CFM'
                        else if hold in node.defstatus
                          then bt_name := bt_name + '.HFM'
                            else if direct in node.defstatus
                              then bt_name := bt_name + '.DFM'
                                else bt_name := bt_name + '.FFM';
                  end else
                  begin
                    if not create_file(bt_cur+bt_name+'.bsy') then
                      begin
                        {creeer alternatieve naam}
                        if crash in node.defstatus
                          then bt_name := bt_name + '.CFM'
                            else if hold in node.defstatus
                              then bt_name := bt_name + '.HFM'
                                else if direct in node.defstatus
                                  then bt_name := bt_name + '.DFM'
                                    else bt_name := bt_name + '.FFM';
                      end else
                      begin
                        {kijk of er alternatieve files zijn: als ze er zijn: rename}
                        If exist(bt_cur+bt_name+'.CFM') then
                          plakaan(bt_cur, bt_name+'.CFM', bt_name+'.CLO'); {plak aan CLO file}
                        If exist(bt_cur+bt_name+'.HFM') then
                          plakaan(bt_cur, bt_name+'.HFM', bt_name+'.HLO'); {plak aan HLO file}
                        If exist(bt_cur+bt_name+'.DFM') then
                          plakaan(bt_cur, bt_name+'.DFM', bt_name+'.DLO'); {plak aan DLO file}
                        If exist(bt_cur+bt_name+'.FFM') then
                          plakaan(bt_cur, bt_name+'.FFM', bt_name+'.FLO'); {plak aan FLO file}

                        if crash in node.defstatus
                          then bt_name := bt_name + '.CLO'
                            else if hold in node.defstatus
                              then bt_name := bt_name + '.HLO'
                                else if direct in node.defstatus
                                  then bt_name := bt_name + '.DLO'
                                    else bt_name := bt_name + '.FLO';
                      end;
                  end;
              end else
              begin
                if crash in node.defstatus
                  then bt_name := bt_name + '.CLO'
                    else if hold in node.defstatus
                      then bt_name := bt_name + '.HLO'
                        else if direct in node.defstatus
                          then bt_name := bt_name + '.DLO'
                            else bt_name := bt_name + '.FLO';
              end;

            assign (bt_att, bt_cur+bt_name);
            {$i-} append(bt_att); {$i+}
            if ioresult <> 0 then
              begin
                {$i-} rewrite(bt_att); {$i+}
                if ioresult <> 0 then
                  begin
                    {$i-} mkdir(udir(bt_cur)); {$i+}
                    if ioresult <> 0 then error(1, 'Error creating point dir path '+bt_cur);
                    assign (bt_att, bt_cur + bt_name);
                    {$i-} rewrite(bt_att); {$i+}
                    if ioresult <> 0 then error(1, 'Error creating '+bt_cur+bt_name);
                  end;
              end;

            while not eof(k) do
              begin
                telop;
                readln(k,tmp);
                if (pos(setup.outboundpath,tmp) <> 0) and (last(2,tmp) = 'IC') then
                  writeln(bt_att,'^'+tmp) else
                    writeln(bt_att,tmp);
              end;
            writelog(5,'('+bt_name+')');
            close (bt_att);

            If (setup.semamode = 1) {binkly} or (setup.semamode = 4) {Pop} then  {delete semaphore}
              Begin
                If last(2,bt_name) <> 'FM' then {alleen als we hem zelf gecreeerd hebben}
                  begin
                    bt_name := first(length(bt_name)-4,bt_name);
                    delete_file(bt_cur+bt_name+'.BSY');
                  end;
              End;
          End;
      3 : Begin {dbridge}
            { make db name }
            If node.address.point = 0 then
              bt_name := 'Q-' +strb36(node.address.zone,3)
                              +strb36(node.address.net, 3)
                              +'.'+strb36(node.address.node,3) else
              bt_name := 'Q-POINT.'+strb36(node.address.point,3);

            Assign (bt_att, setup.quepath + bt_name);
            {$i-} append(bt_att); {$i+}
            If ioresult > 0 then
              Begin
                {$i-} rewrite(bt_att); {$i+}
                if ioresult > 0 then error(1, 'Error finding queue path '+setup.quepath);
              End;

            While not eof(k) do
               Begin
                 readln(k,tmp);
                 tmp1 := file_split(2,tmp);
                 If strip('B',' ',tmp1) <> '' then
                   Begin
                     If crash in node.defstatus
                       then writeln (bt_att, 'C T '+tmp+' '+tmp1)
                         else if hold in node.defstatus
                           then writeln (bt_att, 'H T '+tmp+' '+tmp1)
                             else writeln (bt_att, 'N T '+tmp+' '+tmp1);
                   End;
               End;

            Close (bt_att);
          End;
    End;

    Close(k);
    Erase(k);
  End;


  Procedure RemoveExisting;
  Begin
    if start^.next <> nil then
      begin
        repeat
          current := start;
          start := current^.next;
          dispose(current);
        until start^.next = nil;
      end;
    dispose(start);
  End;

  Procedure Pack_Ticks(name:string);
  Var
    p      : text;  { name file }
    p1     : text;  { result file }
    tmp    : string;
    t      : longint;
    line   : string;

    Procedure PackNew;  { pack files in nieuwe archive }
    Var Tel  : LongInt;
        K    : Text;
        Size : Longint;
        tsi  : longint;
    Begin
      While not eof(p) do
        Begin
          Assign(k,systempath+'_fm_pack.lst');
          Rewrite(k);
          Tel := 0;
          Tsi := 0;
          Tmp := 'FM'+uniquename(arcext[node.archiver]);       { unique name }
          Repeat
            Readln(p,line);
            Size := (file_size(line) div 1024);
            Writeln(k,line);                                      { voeg toe }
            Inc(tsi,length(line));
            Inc(tel,size);
          Until (eof(p)) or ((tel > node.maxsize) and (node.maxsize <> 0)) or (tsi >= 3500);
          Close(k);
          If not packarc('_fm_pack.lst', setup.outboundpath+tmp, node.archiver, false) then
            Begin { oeps, packing ging verkeerd }
              notifycr(1,'Error packing '+setup.outboundpath+tmp); {}
              Create_Attach('_fm_pack.lst');
              Errorp := True;
            End Else writelog(5,'(created '+tmp+') ');
          Writeln(p1,setup.outboundpath+tmp);  { add unique name to packres.lst }
        End; { totdat geen files meer }
    End;

    Procedure Add_to_Old;
    Var
      X      : Word;
      K, k1  : Text;
      Tel,
      Tsi,
      Size   : Longint;
      ftime  : longint;
      dummy  : word;
      dt     : datetime;
      tmp    : string;

      bt_zone : word;
      bt_cur,
      bt_out  : pathstr;
    bt_name : string[12];

    Begin
      Case setup.mailer of
        1, {frontdoor}
        5 : Begin {intermail}
              current := start;
              while (current^.next <> nil) and not eof(p) do
                Begin
                  If nodeeq(current^.node, node.address) then
                    Begin
                      For X := 1 to WordCnt(current^.name) do
                        Begin
                          If (last(3,extractwords(x,1,current^.name)) = arcext[node.archiver]) and
                            exist(setup.outboundpath+extractwords(x,1,current^.name)) then
                            Begin

                              { reset time van *.msg to huidige time }
                              Assign(k,setup.netmailpath+current^.msgname);
                              reset(k);

                              FillChar (DT, SizeOf(DT), 0);
                              With DT do GetDate(Year, Month, Day, dummy);
                              PackTime(dt,ftime);
                              SetFTime(k,ftime);
                              close(k);

                              Assign(k,systempath+'_fm_pack.lst');
                              Rewrite(k);
                              Tel := file_size(extractwords(x,1,current^.name)) div 1024;
                              Tsi := 0;
                              While not eof(p) and ((tel < node.maxsize) or (node.maxsize = 0)) and (tsi <= 3500) do
                                Begin
                                  Readln(p,line);
                                  Size := (file_size(line) div 1024);
                                  Writeln(k,line);                   { voeg toe }
                                  Inc(Tsi,length(line));
                                  Inc(tel,size);
                                End;
                              Close(k);
                              If file_size(systempath+'_fm_pack.lst') <> 0 then
                                If not packarc('_fm_pack.lst', setup.outboundpath+extractwords(x,1,current^.name),
                                  node.archiver,false) then
                                    Begin { oeps, packing ging verkeerd }
                                      notifycr(1,'Error packing '+extractwords(x,1,current^.name)); {}
                                      Create_Attach('_fm_pack.lst');
                                      Errorp := True;
                                    End Else Writelog(5,'(updating '+extractwords(x,1,current^.name)+') ');
                            End;
                        End;
                    End;
                  Current := Current^.Next;
                End;
            End;
        2,  { binkley }
        4 : Begin { Pop }

              { hlo naam opzoeken }

              bt_out  := setup.quepath;
              bt_zone := setup.address[1].zone;
              if node.address.zone = bt_zone
                then bt_cur := bt_out
                  else bt_cur := udir(bt_out)+'.'+strhex(node.address.zone,3)+'\';

              { create attach name to find/create }
              bt_name := strhex(node.address.net,4) + strhex(node.address.node,4);
              if node.address.point > 0 then
                begin
                  bt_cur  := bt_cur + bt_name + '.PNT\';
                  bt_name := '0000' + strhex(node.address.point,4);
                end;

              if create_file(bt_cur+bt_name+'.bsy') then   { busy flag aanmaken}
                begin

                  if crash in node.defstatus
                    then tmp := bt_name + '.CLO'
                       else if hold in node.defstatus
                         then tmp := bt_name + '.HLO'
                            else if direct in node.defstatus
                               then tmp := bt_name + '.DLO'
                                 else tmp := bt_name + '.FLO';


                  assign(k1,bt_cur+tmp);     { node queue file openen }
                  {$I-} reset(k1); {$I+}
                  If ioresult = 0 then    { queue file bestaat }
                    Begin

                      While not eof(k1) do
                        Begin
                          Readln(k1,tmp);
                          if tmp[1] in ['~','^','#'] then delete (tmp,1,1);

                          If (last(3,tmp) = arcext[node.archiver]) and
                            exist(tmp) and not eof(p) then   { if zic file found then }
                              Begin

                                Assign(k,systempath+'_fm_pack.lst');
                                Rewrite(k);
                                Tel := file_size(tmp) div 1024;
                                Tsi := 0;
                                While not eof(p) and ((tel < node.maxsize) or (node.maxsize = 0)) and (tsi <= 3500) do
                                  Begin
                                    Readln(p,line);
                                    Size := (file_size(line) div 1024);
                                    Writeln(k,line);                   { voeg toe }
                                    Inc(Tsi,length(line));
                                    Inc(tel,size);
                                  End;
                                Close(k);
                                If file_size(systempath+'_fm_pack.lst') <> 0 then
                                  If not packarc('_fm_pack.lst', tmp, node.archiver,false) then
                                    Begin { oeps, packing ging verkeerd }
                                      notifycr(1,'Error packing '+extractwords(x,1,current^.name)); {}
                                      Create_Attach('_fm_pack.lst');
                                      Errorp := True;
                                    End Else
                                     Writelog(5,'(updating '+file_split(2,tmp)+') ');

                              End;
                        End;
                      Close(k1);
                    End;   {if queue file bestaat}

                  delete_file(bt_cur+bt_name+'.bsy');

                End; {if create busy flag}
            End;
        3 : Begin { dbridge }
              { wordt niet gedaan omdat oude files niet (goed) te achterhalen zijn}
            End;
      End; {case}
    End; {proc}

  Begin
    Assign(p,systempath+name);
    reset(p);
    Assign(p1,systempath+'PACK_RES.LST');
    Rewrite(p1);
    If nodeonline then {new}
      Begin
        PackNew;
      End Else
      Begin
        If setup.updateold then Add_to_Old;        { als ze uberhaupt bestaan }
        PackNew;                           { voeg overige files toe als nieuw }
      End;
    Close(p1);
    Close(p);
  End;

  Procedure Create_List (ext:byte);
  Var T,K  : Text;
      Tmp  : String;
      Name : String;
  Begin
    Case ext of
     1 : begin {no packing}
           if (setup.mailer = 1) {fd} or (setup.mailer = 5) {im} then
             begin
               writelog(5,'Default ');
               write('(default) ');
             end else write('(default) ');
           write('   ');
           Assign(t,systempath+'FORW-LST.'+int_to_str(ext));
           Reset(t);
           Assign(f1,systempath+'FORW-EXT.'+int_to_Str(ext));
           Reset(f1);
           Assign(k,systempath+'FORWARD.LST');
           Rewrite(k);
           While not eof(f1) do
             Begin
               Read(f1,f);
               ReadFt1file(f.forwardname);
               Writeln(k,ft1.name);
               Readln(t,tmp);
               Writeln(k,tmp);
             End;
           Close(f1);
           Erase(f1);
           Close(t);
           Erase(t);
           Close(k);
         end;
     2 : begin {pack tics}
           if (setup.mailer = 1) {fd} or (setup.mailer = 5) {im} then
             begin
               writelog(5,'Pack tic ');
               write('(pack tic) ');
             end else
               write('(pack tic) ');
           Write('   ');
           Assign(f1,systempath+'FORW-EXT.'+int_to_Str(ext));
           Reset(f1);
           Assign(k,systempath+'FORWARD.LST');
           Rewrite(k);
           While not eof(f1) do
             Begin
               Read(f1,f);
               ReadFt1file(f.forwardname);
               Writeln(k,ft1.name);
             End;
           Close(f1);
           Erase(f1);

           if file_size('FORW-LST.2') <> 0 then
             Pack_ticks('FORW-LST.2'); {pack all ticks in forw-lst.2 file and add names to forward.lst}

           Assign(t,systempath+'PACK_RES.LST');
           {$I-} Reset(t); {$I+}
           If ioresult = 0 then
             begin
               While not eof(t) do
                 Begin
                   Readln(t,tmp);
                   Writeln(k,tmp);
                 End;
               Close(t);
               Erase(t);
             end;
           Close(k);
         end;
     3 : begin { pack all }
           if (setup.mailer = 1) {fd} or (setup.mailer = 5) {im} then
             begin
               writelog(5,'Pack all ');
               write('(pack all) ');
             end else
               write('(pack all) ');
           Write('   ');
           Assign(t,systempath+'FORW-LST.'+int_to_str(ext));
           Reset(t);
           Assign(f1,systempath+'FORW-EXT.'+int_to_Str(ext));
           Reset(f1);
           Assign(k,systempath+'FORWARD.LST');
           Rewrite(k);
           While not eof(f1) do
             Begin
               Read(f1,f);
               ReadFt1file(f.forwardname);
               Writeln(k,ft1.name);
               Readln(t,tmp);
               Writeln(k,tmp);
             End;
           Close(f1);
           Erase(f1);
           Close(t);
           Close(k);

           { pack all files in file forward.lst en herschrijf forward.lst }
           If file_size('FORWARD.LST') <> 0 then
             Pack_Ticks('FORWARD.LST');

           Erase(k);
           Rewrite(k);

           Assign(t,systempath+'PACK_RES.LST');
           {$I-} Reset(t); {$I+}
           If ioresult = 0 then
             Begin
               While not eof(t) do
                 Begin
                   Readln(t,tmp);
                   Writeln(k,tmp);
                 End;
               Close(t);
               Erase(t);
             End;
           Close(k);
         End;
    End;
  End;

  Function Delete_Ticks(ext:byte) : Boolean;
  Var
    k1   : text;
    tmp : string;
  Begin
    Assign(k1,systempath+'FORW-LST.'+int_to_str(ext));
    {$I-} Reset(k1); {$I+}
    If ioresult <> 0 then
      Begin
        Notifycr(1,'Cannot open '+systempath+'FORW-LST.'+int_to_str(ext));
        Delete_Ticks := false;
        Exit;
      End;
    While not eof(k1) do
      Begin
        Readln(k1,tmp);
        If not delete_file(tmp) then
          Notifycr(2,'Cannot delete '+tmp);
      End;
    {$I-} Close(k1);
    Erase(k1); {$I+}
    If ioresult <> 0 then
      Begin
        Notifycr(1,'Cannot close/delete '+systempath+'FORW-LST.'+int_to_str(ext));
        Delete_Ticks := false;
      End Else
      Begin
        Delete_Ticks := true;
      End;
  End;

  Procedure Delete_f_1_file; { fm_ files lezen, forwardname opslaan in geheugen }
  Var                        { alle f_1 files deleten die niet in geheugen staan }
    F    : forwardtype;
    fbak : file of forwardtype;
    wrong : boolean;
  Begin
    New(Start);  { init list}
    Current := Start;
    wrong := false;
    Current^.Next := Nil;
    Findfirst(systempath+'*.FM_',archive,sr);
    While doserror = 0 do
      begin

        assign(fbak,systempath+sr.name);
        {$I-} reset(fbak); {$I+}
        if ioresult <> 0 then notifycr(1,'Cannot open/read '+systempath+sr.name);
        while not eof(fbak) do
          begin
            read(fbak,f);
            current^.name := upper(f.forwardname);
            If (maxavail-1024) > sizeof(current) then
              New(Current^.Next) else Wrong := true;
            Current := Current^.Next;
            Current^.Next := Nil;
          end;
        close(fbak);

        findnext(sr);
      end;

    if not wrong then
      begin
        Findfirst(systempath+'*.F_1',archive,sr);
        While doserror = 0 do
          begin
            current := start;
            while (current^.next <> nil) and (current^.name <> sr.name) do current := current^.next;
            if (current^.next = nil) and (current^.name <> sr.name) then
              delete_file(systempath+sr.name);
            { als sr.name niet in geheugen dan deleten }
            findnext(sr);
          end;
      end;

    if start^.next <> nil then
      begin
        Repeat             { lijst uit geheugen verwijderen }
          Current := start;
          Start := current^.next;
          Dispose(current);
        Until start^.next = nil;
      end;
    Dispose(start);
  end;

  Procedure Plak_Hlm_Files;
  Var bt_out, bt_cur : string;
      sr, sa, sp : searchrec;
  Begin
    bt_out := udir(setup.quepath);

    findfirst (bt_out+'.*', directory, sr);
    while doserror = 0 do
      begin
        if directory and sr.attr = directory then
          begin
            bt_cur := lastdir(bt_out)+'\'+sr.name+'\';
            findfirst (bt_cur + '*.?FM', $0, sa);    { find alternatieve files }
            while doserror = 0 do
              begin
                if not exist(bt_cur+file_split(3,sa.name)+'.bsy') then
                  begin
                    create_file(bt_cur+file_split(3,sa.name)+'.bsy');
                    PlakAan(bt_cur,sa.name,file_split(3,sa.name)+'.'+last(1,first(2,file_split(4,sa.name)))+'LO');
                    delete_file(bt_cur+file_split(3,sa.name)+'.bsy');
                  end;
                findnext(sa);
              end;

            { now check pnt dir }
            findfirst (bt_cur + '????????.PNT', directory, sa);
            while doserror = 0 do
              begin { search this pnt directory }
                findfirst (bt_cur + sa.name + '\*.?FM', $0, sp);
                while doserror = 0 do
                  begin
                    if not exist(bt_cur+sa.name+'\'+file_split(3,sp.name)+'.bsy') then
                      begin
                        create_file(bt_cur+sa.name+'\'+file_split(3,sp.name)+'.bsy');
                        PlakAan(bt_cur+sa.name+'\',sp.name,file_split(3,sp.name)+'.'
                          +last(1,first(2,file_split(4,sp.name)))+'LO');
                        delete_file(bt_cur+sa.name+'\'+file_split(3,sp.name)+'.bsy');
                      end;
                    findnext(sp);
                  end;
                findnext(sa);
              end;
          end;
        findnext(sr);
      end;
  End;

  Procedure Create_attach_msg;
  Var T, K, L : Text;
      Tmp : String;
      Tel : integer;

    Procedure Telop;
    Begin
      Write(Replicate(length(int_to_str(tel))+2,#8));
      Inc(tel);
      Write('('+int_to_str(tel)+')');
    End;

  Begin
    tel := 0;
    notify(5,'(msg text) ');
    Case setup.mailer of
      1, {fd}
      3, {dbug}
      5  {im}  : begin
                   write('   ');
                   Assign(t,systempath+'FORW-LST.4');
                   {$i-} Reset(t); {$I+}
                   If ioresult = 0 then
                     Begin
                       Assign(f1,systempath+'FORW-EXT.4');
                       {$I-} Reset(f1); {$I+}
                       if ioresult = 0 then
                         begin
                           While not eof(f1) do
                             begin
                               telop;
                               read(f1,f);
                               ReadFt1file(f.forwardname);

                               {$I-} readln(t,tmp); {$I+}
                               If ioresult <> 0 then tmp := '';

                               If length(tmp)+1+length(ft1.name) < 71 then
                                 tmp := tmp + ' '+ft1.name else
                                   begin
                                     Init_Message ('F'+setup.netmailpath, true, 0, [net],
                                       n, ft1.info.from, 'FileMgr '+version+build,
                                       node.sysopname, tmp);
                                     Open_Message;
                                     Set_Attrib([fattach,Privat,Killsent],'F');
                                     Set_Attrib2(node.defstatus);
                                     Save_Message;
                                     tmp := ft1.name;
                                   end;

                               Init_Message ('F'+setup.netmailpath, true, 0, [net],
                                 n, ft1.info.from, 'FileMgr '+version+build,
                                 node.sysopname, strip('B',' ',tmp));
                               Open_Message;
                               Set_Attrib([fattach,Privat,Killsent],'F');
                               Set_Attrib2(node.defstatus);

                               fillchar(ann,sizeof(ann),0);
                               with ann do
                                 begin
                                   Name        := ft1.info.filespec;
                                   Replaces    := ft1.info.replaces;
                                   Area        := ft1.info.tag;
                                   Desc        := ft1.info.description;
                                   Move(ft1.info.longdesc,ldesc,sizeof(ldesc));
                                   LCount      := ft1.info.longcount;
                                   Magic       := ft1.info.magic;
                                   CRCstr      := ft1.info.crcstr;
                                   Arrived     := ft1.info.date;
                                   Date        := ft1.info.date;
                                   Size        := ft1.info.size;
                                   Origin      := ft1.info.origin;
                                   From        := ft1.info.from;
                                   Expo        := info.expo;
                                 end;

                               Convert_Tpl( ft1.info.msgfile, ann, false, area.aka, node.sysopname );
                               DoStringln('--- ' + msgtearline);
                               Save_Message;
                             end;
                           Close(f1);
                           Erase(f1);
                         End;
                       Close(t);
                       Erase(t);
                       write(' ');
                       writelog(5,'('+int_to_str(tel)+') ');
                     End;
                 End;
    End;
  End;

Begin
  If not noforward then
    begin
      NotifyCr(5,'Forwarding processed files...');
      rescan := true;

      If setup.updateold then CleanForwardFiles(''); {sla *.?IC files op in list: alleen fd and updateold}

      Findfirst(systempath+'*.FM_',archive,sr);
      while doserror = 0 do
        Begin
          WriteSetupCfg;

          inc(tsystems);
          Fillchar(n,sizeof(n),0);
          SortNodeList(sr.name);      {nodefile sorteren op mailstatus}

          If exist(systempath+'FORW-EXT.4') then { msg attach }
            Begin
              create_ticks(4);
              create_attach_msg;
            End;
          If exist(systempath+'FORW-EXT.1') then {no packing}
            Begin
              Create_Ticks(1);
              Create_List(1);                  { creeer lijst met files en ticks}
              Create_Attach('FORWARD.LST');    { ad forward.lst to attach }
            End;
          If exist(systempath+'FORW-EXT.2') then {pack tic}
            Begin
              Errorp := false;
              Create_Ticks(2);
              Create_List(2);                  { creeer lijst met files en zics}
              Create_Attach('FORWARD.LST');    { ad forward.lst to attach }
              If not Errorp then
                If not Delete_Ticks(2) then {};  { delete ticks in forw-lst.2 list en delete list itself }
            End;
          If exist(systempath+'FORW-EXT.3') then {pack all}
            Begin
              ErrorP := False;
              Create_Ticks(3);
              Create_List(3);                  { creeer lijst met zics }
              Create_Attach('FORWARD.LST');    { ad forward.lst to attach }
              If not Errorp then
                If not Delete_Ticks(3) then {};  { delete ticks in forw-lst.3 list en delete list itself }
            End;
          notifycr(5,'');

          if not delete_file(systempath+sr.name) then
            notifycr(5,'Cannot delete '+systempath+sr.name);

          Findnext(sr);
        End;

      If setup.updateold then RemoveExisting;

      if (setup.mailer = 2) {binkley} or (setup.mailer = 4) {Pop} then
        begin
          plak_hlm_files; { niet geprocesde *.?FM files aan *.?Lo files plakken }
        end;

      if exist(systempath+'*._PR') then
        begin                                         { _pr renamen naar _fm }
          findfirst(systempath+'*._PR',archive,sr);
          while doserror = 0 do
            begin
              assign(pre,systempath+sr.name);
              rename(pre,systempath+file_split(3,sr.name)+'.FM_');
              findnext(sr);
            end;
        end;

      if not (setup.mailer in [1,2,3]) then
        begin
          If Tforward > 0 then
            Begin
              CleanForwardFiles('Removing packed/sent files...')
            End Else CleanForwardFiles('Removing sent files...');
        end; {pop en blinky users should use 'filemgr clean' if backup path is used}


      delete_f_1_file;
    end;
End;

End.


