{
 $Id$
}
Unit MKOpen; {Open a message area using an MsgAreaId}

{$O+}

{$I MKB.Def}


 {*****************************************************************************
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}



Interface

Uses MKMsgAbs;

Function OpenMsgArea(Var Msg: AbsMsgPtr; MsgAreaId: String): Boolean;
Function OpenOrCreateMsgArea(Var Msg: AbsMsgPtr; MsgAreaId: String): Boolean;
Function CloseMsgArea(Var Msg: AbsMsgPtr): Boolean;
Function InitMsgPtr(Var Msg: AbsMsgPtr; MsgAreaId: String): Boolean;
Function DoneMsgPtr(Var Msg: AbsMsgPtr): Boolean;

Implementation


Uses MKMsgHud, MKMsgFid, MKMsgSqu, MKMsgEzy, MKMsgJam, MkMsgTxt, MkMsgPkt;

{ Area ids begin with identifier for msg base type }
{ The following characters are already reserved    }
{   B = PC-Board            }
{   E = Ezycomm             }
{   F = Fido *.Msg          }
{   H = Hudson              }
{   I = ISR - msg fossil    }
{   J = JAM                 }
{   M = MK-Merlin           }
{   P = *.PKT               }
{   Q = QWK/REP             }
{   R = Renegade            }
{   S = Squish              }
{   W = Wildcat             }


Function OpenMsgArea(Var Msg: AbsMsgPtr; MsgAreaId: String): Boolean;
  Begin
  If InitMsgPtr(Msg, MsgAreaId) Then
    Begin
    OpenMsgArea := True;
    If Msg^.OpenMsgBase <> 0 Then
      Begin
      OpenMsgArea := False;
      If DoneMsgPtr(Msg) Then;
      End;
    End
  Else
    OpenMsgArea := False;
  End;


Function OpenOrCreateMsgArea(Var Msg: AbsMsgPtr; MsgAreaId: String): Boolean;
  Begin
  If InitMsgPtr(Msg, MsgAreaId) Then
    Begin
    OpenOrCreateMsgArea := True;
    If Not Msg^.MsgBaseExists Then
      If Not Msg^.CreateMsgBase(200, 10) = 0 Then
        OpenOrCreateMsgArea := False;
    If Msg^.OpenMsgBase <> 0 Then
      Begin
      OpenOrCreateMsgArea := False;
      If DoneMsgPtr(Msg) Then;
      End;
    End;
  End;


Function CloseMsgArea(Var Msg: AbsMsgPtr): Boolean;
  Begin
  If Msg <> Nil Then
    Begin
    CloseMsgArea := (Msg^.CloseMsgBase = 0);
    If DoneMsgPtr(Msg) Then;
    End
  Else
    CloseMsgArea := False;
  End;


Function InitMsgPtr(Var Msg: AbsMsgPtr; MsgAreaId: String): Boolean;
  Begin
  Msg := Nil;
  InitMsgPtr := True;
  Case UpCase(MsgAreaId[1]) of
    'H': Msg := New(HudsonMsgPtr, Init);
    'S': Msg := New(SqMsgPtr, Init);
    'F': Msg := New(FidoMsgPtr, Init);
    'E': Msg := New(EzyMsgPtr, Init);
    'J': Msg := New(JamMsgPtr, Init);
    'T': Msg := New(TxtMsgPtr, Init);
    'P': Msg := New(PktMsgPtr, Init);
    Else
      InitMsgPtr := False;
    End;
  If Msg <> Nil Then
    Msg^.SetMsgPath(Copy(MsgAreaId, 2, 128));
  End;


Function DoneMsgPtr(Var Msg: AbsMsgPtr): Boolean;
  Begin
  If Msg <> Nil Then
    Dispose(Msg, Done);
  Msg := Nil;
  End;

End.
