{
 $Id$
}
{$O+,F+}  UNIT F_FIle;
 {*****************************************************************************
 *
 * Purpose ...............: File and Directory routines
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


{ v1.1 : Added findnext procedure in some occasions for novell 3.11 ncp
         search bug }

INTERFACE

USES Dos;

{-----------------------------------------------------------------------------}

FUNCTION Exist( Str:String ) : Boolean;
FUNCTION Delete_File( Str:String ) : Boolean;
FUNCTION Create_File( Str:String ) : Boolean;
FUNCTION File_Split( Part:byte ; Full:String ) : String;
FUNCTION File_Directory( Full:String ) : String;
FUNCTION CopyFile( SourceFile, TargetFile:string ): byte;
FUNCTION File_Size( Str:String ) : LongInt;

{-----------------------------------------------------------------------------}

IMPLEMENTATION

FUNCTION Exist( Str:String ) : Boolean;
{-------------------------------------}
Var
  Inf: SearchRec;
Begin
  FindFirst(Str,AnyFile,Inf);
  Exist := (DOSError = 0);
  While doserror = 0 do findnext(inf); { novell 3.11 }
End;

FUNCTION File_Size( Str:String ) : LongInt;
Var
  Sr : SearchRec;
Begin
  FindFirst(Str,AnyFile,Sr);
  If doserror <> 0 then
    File_Size := 0 Else
    File_Size := sr.size;
  While doserror= 0 do findnext(sr); { novell 3.11 }
End;

FUNCTION Delete_File ( Str:String ) : Boolean;
{--------------------------------------------}
Var
  T : Text;
Begin
  If not Exist(Str) then
    Begin
      Delete_File := False;
      Exit;
    End;
  Assign(T,Str);
  {$i-} SetFAttr(T, 0); {$I+}
  If IoResult <> 0 then {};
  {$I-} Erase(T); {$I+}
  Delete_File := (IoResult = 0);
End;

FUNCTION Create_File ( Str:String ) : Boolean;
{--------------------------------------------}
Var
  T : text;
Begin
  If Exist(Str) then
    Begin
      Create_File := False;
      Exit;
    End;
  Assign(T,Str);
  {$I-} Rewrite(t); {$I+}
  If ioresult <> 0 then
    Create_File := false else
      begin
        Close(t);
        Create_file := true;
      end;
End;

FUNCTION File_Split(Part:byte;Full:string): string;
{-------------------------------------------------}
Var
   D : DirStr;
   N : NameStr;
   E : ExtStr;
Begin
  FSplit(Full,D,N,E);
  Case Part of
    1 : File_Split := D;
    2 : File_Split := N+E;
    3 : File_Split := N;
    4 : File_Split := E;
  End;
End;

FUNCTION File_Directory(Full:string): string;
{-------------------------------------------}
Var
  Temp : string;
  P : byte;
Begin
  Temp := File_Split(1,Full);
  P := Pos(':',Temp);
  If (Temp[length(Temp)]  ='\') and (temp <> '\') then
    Delete(temp,length(Temp),1);      {remove last backslash}
   File_Directory := Temp;
End;


Function CopyFile(SourceFile, TargetFile:string): byte;
{return codes:  0 successful
                1 source and target the same
                2 cannot open source
                3 unable to create target
                4 error during copy}
var
  Source,
  Target : file;
  BRead,
  Bwrite : word;
  FileBuf  : array[1..8192] of char;
begin
    If SourceFile = TargetFile then
    begin
        CopyFile := 1;
        exit;
    end;
    Assign(Source,SourceFile);
    {$I-}
    Reset(Source,1);
    {$I+}
    If IOResult <> 0 then
    begin
        CopyFile := 2;
        exit;
    end;
    Assign(Target,TargetFile);
    {$I-}
    Rewrite(Target,1);
    {$I+}
    If IOResult <> 0 then
    begin
        CopyFile := 3;
        exit;
    end;
    Repeat
         BlockRead(Source,FileBuf,SizeOf(FileBuf),BRead);
         BlockWrite(Target,FileBuf,Bread,Bwrite);
    Until (Bread = 0) or (Bread <> BWrite);
    Close(Source);
    Close(Target);
    If Bread <> Bwrite then
       CopyFile := 4
    else
       CopyFile := 0;
end; {of func CopyFile}


END.
