{
 $Id$
}

{ 021296: changed B16 in statusbits to Langcheck }
{ 021296: added setup: 'testlang : string[80]' at the end of setuptype }
{ vbc 120208 - added const  build


 {*****************************************************************************
 *
 * Purpose:  Filemgr file structures and version details
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


Unit Fm_Struct;

Interface

Uses Dos;

CONST
  Compiled         = '19-03-08  16:00';
  Version          = 'Gamma';
  Versionnr        : word = 080;
  Build            = '.117';
  Copyright        = 'Copyright (c) Vince Coen / Ron Huiskes 1991-2008';

  MAXSEENBY        = 500;
  MAXPATH          = 50;


TYPE
  BooleanSet       = Array[1..256] of Boolean;

  SortType         = (SNONE, SFILE, SAREA, SGROUP);

  ListType         = (LIST, QUERY, UNLINKED);

  InfoStatusBits   = (Local, FileSent, FileProcessed, NoDupe, FB5, FB6, FB7, FB8);

  FrequencyType    = (Imm, Dayly, Weekly, Weekly2, Monthly, Monthly2, Monthly3);

  ArchiverType     = (ZIP,ARJ,LZH,ARC,PAK,ZOO,SQZ,RAR,HYP,DWC,ALL);

  ScheduleType     = (SC_Hatch, SC_Report, SC_Exec, SC_Post, Sc5, Sc6);

  FileStatusType   = (OK, BADCRC, BADPATH, ILLEGAL, UNKNOWN, DUPLICATE, NOTFOUND,
                      BADDESCR, NOACTION, NOACCESS, VIRUSFOUND, BADLANG);

  ExceptionType    = (Ex_Move, Ex_Adopt, Ex_NoForward, Ex_PassThru,
                    Ex_CopyFile, Ex_Otherpath, Ex_CopyArea, Ex_Magic,
                    Ex_Delete, Ex_Unpack, Ex_Exec, Ex_NoAnnounce, Ex_nodepath, Ex14, Ex15, Ex16);

  PackerBits       = (Convert, SameArchive, AvArchive, Extension, ca1, ca2, ca3, ca4);
  PackerType       = Set of PackerBits;

  StatusBits       = (FuzzyDup, Backup, Crc, Tiny, Secure, DupCheck, ImportDiz,
                      Hide, HatchNew, AnnNew, Disc, Noti, Test, Virus, LongDesc, Langcheck);
  StatusType       = Set of StatusBits;

  SystemStatusBits = (ForwReq, CanCreate, Remote, Upmagic, From, DoNotify, Pause, AddNew, Netmail, C2, C3, C4, C5, C6, C7, C8);
  SystemStatusType = Set of SystemStatusBits;

  MailStatusBits   = (Crash, Hold, Direct, PackTIC, PackFile, ms5, ms6, ms7, ms8, ms9, ms10);
  MailStatusType   = Set of MailStatusBits;

  MsgAttribType    = (Privat, CrashMail, Rcvd, Sent, FAttach, Transit, Orphan, KillSent, Loc, HoldMail, DirectMail,
                      FileRequest, ReturnReceiptRequest, IsReturnReceipt, AuditRequest, FileUpdateReq);
  MsgAttribSet     = Set of MsgAttribType;

  MsgStatusBits    = (TearLine, M2,M3,M4,M5,M6, Net,Echo);
  MsgStatusType    = Set of MsgStatusBits;

  NodeBits         = (Export,Import,Mandatory,PreRelease,n5,n6,n7,n8);
  NodeBitsType     = Set of NodeBits;

  LogBits          = (LFatal, LOther, LAccounting, LSending, LForwarding, LBrief,
                      LTrivial, Linfo, LSession, LProcess);
  LogStatusBits    = Set of LogBits;

  NodeType = Record
    Zone,
    Net,
    Node,
    Point          : Word;
  End;

  ExportType = Record
    A              : NodeType;
    S              : NodeBitsType;
    M              : MailStatusType;
  End;

  ZoneAkaRecord = Record
    Zone,
    Net            : Word;
    AKA            : Byte;
  End;

  FlowType = Array[1..12] of Record
    Bytes,
    Files          : Longint;
  End;

  UplinkRecord = Record
    Address        : Nodetype;
    Mgrname,
    Password       : String[15];
    Groups         : BooleanSet;
    Status         : Byte;                                  { $02 = + prefix }
    Areafile       : String[80];
    Aka            : Byte;
  End;

  SetupType = Record
    Version        : Word;                         { SETUP.FM -> Version nr. }

    Address        : Array[1..21] of NodeType;
    Alias          : Array[1..15] of String[20];
    ZoneToAKA      : Array[1..20] of ZoneAkaRecord;
    Uplink         : array[1..20] of UplinkRecord;

    SysopName,
    SystemName     : String[40];
    RegKey         : String[12];

    Password,
{}  SeriNum,
{}  CustNum        : String[22];

    InboundPath    : String[80];
    OutboundPath   : String[80];
    NetmailPath    : String[80];
    BadFilePath    : String[80];
    AreaPath       : String[80];
    QuoteFile      : String[80];
    TPLpath        : String[80];
    LogFile        : String[80];
    AliasFile      : Array[1..2] of String[80];                { Alias files }
    Quepath        : String[80];                          { dbridge que path }
    TempPath       : String[80];          { path for  uitpakken/virusscannen }
    Semaphorepath  : String[80];                       { path for semaphores }
    RetirePath     : String[80];           { path for 'to be replaced' files }
    AreaLog        : String[80];             { path for  areamanager logfile }
    LogStatus      : LogStatusBits;        { de verschillende logfile opties }

    KillRcvd     : Boolean;                    { misc -> kill rcvd requests }
    Touch        : Boolean;                           { misc -> touch files }
    Replace      : Boolean;     { misc -> replace older files with new ones }
    ForceIntl    : Boolean;                      { misc force ^aintl kludge }
    IgnUnknown   : Byte;   { misc -> ignore unk areas 0 = n, 1 = y, 2 = del }
    UpdAlias     : Boolean;              { misc -> update mailer alias file }
    ExtendedDiz  : Boolean;    { ignore extended ascii in file_id.diz files }
    SortArea     : Boolean;                 { misc -> sort by area or group }
    IgnBadCRC    : Byte;     { misc -> ignore bad crc  0 = n, 1 = y, 2= del }
    UseAreaDesc  : Boolean;    { misc -> use AREADESC keyword for new areas }
    Days2Keep    : Byte;             { misc -> days to keep files for nodes }
    DescStart    : Byte;      { which column desc starts -> files.bbs files }
    HistoryWeeks : Byte;                    { misc -> weeks to keep history }
    HistoryKb    : Byte;                         { misc -> max history size }
    TimeZone     : ShortInt;                       { misc -> utc difference }
    DefaultPwd   : String[15];                   { misc -> default password }
{}  Currency     : String[3];         { misc -> costsharing currency symbol }
    UpdateOld    : Boolean;   { update old *.?IC packets or only create new }
    DupChecking  : Byte;           { 0 = area only, 1 = group only, 2 = all }

{}  Garbled,
{}  Encrypted,
{}  Report,
{}  Rtrcpt,                          { not used yet }
{}  Source,
{}  Topo         : Boolean;

    Packername   : Array[1..11] of string[12];
    packswitch   : Array[1..11] of string[44];
    bannerswitch : array[1..11] of string[43];
    unpackername : array[1..10] of string[12];
    unpackswitch : array[1..10] of string[43];

    unused2 : array[1..3] of char;

    space        : word;          { misc -> minimum harddisk space required }
    expandedlog  : boolean;
    wrapdesc     : boolean;    { misc -> wrap descriptions and ignore lf/cr }
    maxfileid    : word;       { misc -> max chars to import on file_id.diz }

    ShowPack     : Boolean;                      { external -> show packing }
    ShowUnPack   : Boolean;                    { external -> show unpacking }
    Showswapping : Boolean;                  { show number of bytes swapped }
    ShowVirus    : Boolean;                  { external -> show virus check }
    VirusPath    : String[80];                { path + name to virusscanner }
    VirusParm    : String[50];               { parameters voor virusscanner }
    VirusErr     : Byte;           { hoogste errorlevel that means no virus }
    Virusfiles   : Byte;                { 0 = alleen exe,com,ovl, 1 = alles }
    SwapMethode  : Integer;                { ems / xms / disk swap volgorde }

    Mailer       : Byte; { 1 = fd, 2 = blinky, 3 = dbridge, 4 = Pop, 5 = Im }
    Filebase     : Byte;                   { 0 = files.bbs / 1 = ra 2.0 fdb }
    SemaMode     : Byte;   { 0 = none, 1 = binkley, 2 = fd, 3 = im, 4 = PoP }
    SecsToWait   : Word;
    MaxWaitTime  : Word;

    FFstar,                                   { filefind -> expand * to ?'s }
    FFone        : Byte;              { filefind -> max number of ? allowed }
    FFkeylen     : Byte;            { filefind -> minimum length of keyword }
    FFmax        : Byte;                  { filefind -> max number of files }
    FFloc        : Boolean;             { filefind -> respond to local msgs }
    FFmaxsize    : Byte;                         { filefind -> max msg size }

    OrigLine     : Array[1..15] of String[60];

    NameCount    : Longint;                { internal var }
    MaxMsgSize   : Byte;                   { max netmail msg size }

    Readkey,                               { hotkeys for filefind door }
    Scankey,
    Yellkey,
    Helpkey,
    Enterkey,
    Quitkey,
    Logoffkey   : Char;
    Yelltime    : Byte;
    FFLogfile   : String[80];
    Mainfile    : String[12];
    Helpfile    : String[12];
    Logofffile  : String[12];

    DayArray    : Array[1..7] of string[15];
    MonthArray  : Array[1..12] of string[15];

    BannerArray : Array[1..15] of string[60];
    SecurePath  : String[80];
    ExtArchiver : String[80];
    ExtEditor   : String[80];

    HelpTplMsg  : String[80];
    CsoBillMsg  : String[80];
    OocTplMsg   : String[80];
    AoocTplMsg  : String[80];

    Rescanfile  : String[80];
    Testfile    : String[80];

    Noti_bad    : Boolean;
    Noti_virus  : Boolean;
    Noti_ill    : Boolean;
    Noti_unk    : Boolean;
    Noti_other  : Boolean;
    Noti_newly  : Boolean;
    Noti_req    : Boolean;
    Noti_disco  : Boolean;
    Noti_empty  : Boolean;

    PartStr     : String[10];
    Cont1Str    : String[50];
    Cont2Str    : String[50];

    Testlang    : String[80];
    Noti_Lang   : Boolean;

    UnUsed     : Array[1..357] of byte;
  End;

  GroupType  = Record
    GroupName    : String[40];            { GROUPS.FM -> Name of this group }
    GroupNr      : Byte;

    Format       : String[12];               { files.bbs -> tpl file to use }
    Directory    : String[80];                   { group directory to files }
    ListSpec     : String[80];                        { files.bbs file name }
    Rearchive    : PackerType;                          { rearchive options }
    UseArchiver  : ArchiverType;             { rearchive -> archiver to use }
    BatchFile    : String[12];         { batchfile to execute on every file }
    Aka          : Byte;                         { aka to use on forwarding }
    Status       : StatusType;                  { status bits of this group }
    ReplaceMode  : Byte;  { 0 = no replace, 1 = hard replace, 2 = move file }
    Msgid        : BooleanSet;                      { announcements to make }
    MsgFile      : String[80];              { msgtxt to attach to this file }
    KeepDays     : Word;                        { delete files after x days }
    KeepAmount   : Word;                          { keep maximum of x files }
    Flow         : Flowtype;                     { file flow for this group }
    LastMonth    : Byte;                                { last active month }
    CostPerBlock : Word;                                   { costs per unit }
    Block        : Byte;                { 0 = 100 kb, 1 = 1024 kb, 2 = file }
    AllLinks     : Boolean;      { count all links or only active cso links }
    AddPercent   : Byte;               { percentage to add to cost per unit }

    DefaultDesc  : String[60];            { komt niet voor in area record ! }

    InclHost     : Boolean;                       { count host as link also }
    InclUplink   : Boolean;                 { use uplink costs in tic files }
    Usebanner    : Byte;
    NotUsed      : Array[1..7] of Byte;
  End;

  AreaIndexType  = Record
    Tag          : String[20];     { AREAFILE.FMX -> name used in tic files }
    AreaRec      : LongInt;                         { Offset to AREAFILE.FM }
    Grp          : Byte;                       { Group this area belongs to }
  End;

  AreaType  = Record
    Tag          : String[20];      { AREAFILE.FM -> name used in tic files }
    ExportNr     : Word;                        { number of connected links }
    Grp          : Byte;                       { group this area belongs in }
    Name         : String[50];           { name or description of this area }
    AreaNr       : Word; { 0 = use files.bbs, >0 = recnummer to areafile.fm }

    Format       : String[12];               { files.bbs -> tpl file to use }
    Directory    : String[80];                         { directory to files }
    ListSpec     : String[80];            { files.bbs file directory + name }
    Rearchive    : PackerType;                          { rearchive options }
    UseArchiver  : ArchiverType;             { rearchive -> archiver to use }
    BatchFile    : String[12];         { batchfile to execute on every file }
    Aka          : Byte;                         { aka to use on forwarding }
    Status       : StatusType;                   { status bits of this area }
    ReplaceMode  : Byte;  { 0 = no replace, 1 = hard replace, 2 = move file }
    Msgid        : BooleanSet;                      { announcements to make }
    MsgFile      : String[80];              { msgtxt to attach to this file }
    KeepDays     : Word;                        { delete files after x days }
    KeepAmount   : Word;                          { keep maximum of x files }
    Flow         : Flowtype;                      { file flow for this area }
    LastMonth    : Byte;                                { last active month }
    CostPerBlock : Word;                                   { costs per unit }
    Block        : Byte;                { 0 = 100 kb, 1 = 1024 kb, 2 = file }
    AllLinks     : Boolean;      { count all links or only active cso links }
    AddPercent   : Byte;               { percentage to add to cost per unit }

    InclHost     : Boolean;                       { count host as link also }
    InclUplink   : Boolean;                 { use uplink costs in tic files }
    UseBanner    : Byte;
    NewArea      : Boolean;   { if set to true areadesc will be used in tic }
    NotUsed      : Array[1..6] of Byte;
  End;

  NodeIndexType = Record
    Address      : NodeType;       {NODEFILE.FMX -> node adress of this node }
    NodeRec      : LongInt;                { offset to record in NODEFILE.FM }
  End;

  NodeFileType = Record
    Address      : NodeType;        { NODEFILE.FM -> node adress of this node }
    AkaAddress   : NodeType;                        { aka adress of this node }
    SysopName    : String[50];                                  { sysops name }
    Password     : String[15];                       { password in tick files }
    MgrPassword  : String[15];                         { password for manager }
    Groups       : BooleanSet;                                { groups active }
    Visible      : BooleanSet;                       { groups visible in list }
    NewGroup     : Byte;                                  { default new group }
    Tictype      : Byte;                { 0 = none; 1 = antique; 2 = advanced }
    DefStatus    : MailStatusType;         { no packing, pack tic, pack files }
    Archiver     : ArchiverType;                { archiver to use for packing }
    MaxSize      : Word;                             { maximum size of bundle }
    MgrStatus    : MailStatusType;       { default status (crash,hold,direct) }

    Billing      : Boolean;          { billing manager active for this node ? }
    BillGroups   : BooleanSet;            { billing is active in these groups }
    Credit       : Real;                 { the actual account credit in cents }
    WarnLevel    : LongInt;                       { min account to warn sysop }
    Avaraging    : Word;            { max kb's a node may have onhold for him }
    SendBill     : Byte;      { 0 = direct, 1 = daily, 2 = weekly, 3 = montly }
    SendDay      : Byte;                             { daynumber for sendbill }
    AddPercent   : Byte;              { percentage to add to total bill block }

    Status       : SystemStatusType;
    Flow         : Flowtype;
    Lastmonth    : Byte;

    WarnNot      : Boolean;                   { notified of low credit level }
    StopLevel    : Longint;   { minimum account level to switch node passive }
    Maxfilesize  : word;

    Unused       : Array[1..3] of Byte;
  End;

  MessageType = Record
    MessageNr    : Byte;                    { MESSAGES.FM -> Message group ID }
    MessageName  : String[50];                          { Message description }

    Sortorder    : SortType;                   { how to sort the file entries }
    HeaderTpl,                                           { the tpl file names }
    FooterTpl,
    EntryTpl,
    BlockHdrTpl,                     { only used with sortorder AREA or GROUP }
    BlockFtrTpl  : String[12];                { idem, only with AREA or GROUP }

    MsgBaseId    : Char;           { the msgbase id: hudson, squize, fido etc }
    MsgBaseIdStr : String[80];               { board number + path of msgbase }
    Status       : MsgStatusType;                   { tearline + echo/netmail }
    MaxSize      : Byte;                                { maximum msgtxt size }

    MsgTo,                                                  { message to name }
    MsgFrom      : String[35];                            { message from name }
    MsgRe        : String[50];                              { message subject }
    MsgAttr      : MsgAttribSet;               { attrib bits: crash, hold etc }
    Origin,                                  { origin to use, or 0 for random }
    Aka          : Byte;                              { aka (fromnode) to use }
    ToNode       : NodeType;                     { to node address if netmail }

    Freq         : FrequencyType;                                 { frequency }
    Next         : LongInt;                                      { next event }
    Day          : Byte;                        { sunday = 1, monday = 2, etc }

    NotUsed      : Array[1..10] of Byte;
  End;

 BbsAreaType = Record        { FILEAREA.FM   -> first record is different! }
   On           : Boolean;                   { true -> active for filefind }
   Name         : String[40];                              { filearea name }
   Nr           : Word;                         { ra2.0 -> filebase number }
   Path         : String[50];                    { path to files directory }
 End;

 InfoType = Record     { PROCESS.FM -> Internal after processing *.TIC files }
   InfoTypeName : String[12];   { name of intotype1 file containing desc for this file }
   FilePath     : String[80];   { ok for dos but not for linux/ NTFs }
   FileSpec     : String[12];
   Replaces     : String[12];
   Magic        : String[20];
   Status       : set of INFOstatusBits;
   Size,                                   {file size}
   Release,                                {release date}
   Date,                                   {date of file}
   Forwar       : LongInt;                 {hatch date}
   Description  : String;                {could this get as big as 1023 char?}
   LongDesc     : Array[1..2048] of char;  {long description}
   LongCount    : Word;                    {chars in long description}
   MsgFile      : String[80];              {msgtxt to attach to this file}
   Areadesc     : String[50];
   TAG,
   Password     : String[20];
   cost         : real;                    {cost per node for this file}
   totalcost    : real;                    {totalcosts for this file}
   CRCstr       : String[16];
   Origin,
   From         : NodeType;
   cPath,
   cSeen        : Byte;
   Expo         : Word;                    {how many nodes receive this file}
   Nodes        : Word;                    {how many paying nodes receive this file}
   MatchIt      : Boolean;
   Path         : Array[1..MAXPATH] of NodeType;
   PathStamp    : Array[1..MAXPATH] of String[50];
   PathUnix     : Array[1..MAXPATH] of LongInt;
   SeenByLst    : Array[1..MAXSEENBY] of NodeType;
   hatdups,                                      { interactive hatch var's }
   hatmove,
   hatviru,
   hatimpo,
   hatrear      : Boolean;
   author       : string[60];
   encrypted    : string[60];
   garbled      : string[60];
   logstring    : string[60];
   report       : Nodetype;
   rtrcpt       : Array[1..10] of nodetype;
   rtrcpttrue   : boolean;
   source       : Nodetype;
   topotrue     : Boolean;
   topo         : Nodetype;
  End;

  AnnouncePtr      = ^AnnounceLinkType;
  AnnounceLinkType = Record  { ANNOUNCE.FM -> internal announcements record }
    Name,
    Replaces    : String[12];
    Area        : String[35];
    Desc        : String;
    LDesc       : Array[1..2048] of char;  {lange description}
    LCount      : Word;    {aantal chars in lange description}
    Magic       : String[20];
    CRCstr      : String[16];
    Arrived,
    Date,
    Size        : LongInt;
    Origin,
    From        : NodeType;
    Msg         : Byte;
    Grp         : Byte;
    Expo        : Byte;
    Path        : Array[1..MAXPATH] of NodeType;
    CPath       : Byte;
    Next,
    Prev        : AnnouncePtr;
  End;


 ExceptionRec = Record
   Kind         : ExceptionType;
   Mask         : String[12];

   FromArea     : String[20];
   ToArea       : String[20];
   FromNode     : Nodetype;
   Line         : Array[1..2] of String[80];

   NotUsed      : Array[1..10] of Byte;
 End;

 ForwardType1 = Record
   Name   : String[100];        { filespec }
   Info   : InfoType;
 End;

 ForwardType = Record
   Forwardname : String[12]; {wijst naar de forwardtype1 file waar er maar 1 van is}
   Expo        : ExportType;
   Addressee   : Nodetype;
   Pwd         : String[15];
 End;

TYPE
  Nfxtlist   = Array[1..1000] of NodeIndexType;                { nodes index }
  Afxtlist   = Array[1..2000] of AreaIndexType;                { areas index }
  SystemList = Array[1..256]  of ExportType;                { area downlinks }

  ExtDateTime      = record
    Year, Month, Day,
    Hour, Min, Sec,
    Dow, Hs        : Word;
  End;

  HistoryType = record
    Name         : String[12];
    Group        : Byte;
    Size         : LongInt;
    CRC_32       : LongInt;
    DT           : LongInt;
    TAG          : String[15];
    Forwards     : Byte;
  End;

Var
  History      : HistoryType;
  HF           : File;

  Setup        : SetupType;                                   { setup.fm     }
  SF           : File of SetupType;                           { setup.fm     }

  Group        : GroupType;                                   { groups.fm    }
  GF           : File of GroupType;                           { groups.fm    }

  Area         : AreaType;                                    { areafile.fm  }
  AF           : File;                                        { areafile.fm  }
  Afx          : File;                                        { areafile.fmx }
  AreaIdx      : Word;                               { number of fmx records }
  Afxt         : ^AfxtList;                                   { areafile.fmx }
  Sfxt         : ^SystemList;                                 { areafile.fm  }

  Node         : NodeFileType;                                { nodefile.fm  }
  NF           : File;                                        { nodefile.fm  }
  Nfx          : File;                                        { nodefile.fmx }
  NodeIdx      : Word;                               { number of fmx records }
  Nfxt         : ^NfxtList;                                   { nodefile.fmx }

  Message      : MessageType;                                  {  message.fm }
  MF           : File of MessageType;                          {  message.fm }

  Exfile        : File of ExceptionRec;                        { filemask.fm }
  Ex            : ExceptionRec;                                { filemask.fm }

  BF            : File;                                        { filearea.fm }
  BbsArea       : BbsAreaType;                                 { filearea.fm }

  ANF           : File of AnnounceLinkType;                    { announce.fm }
  ANN           : AnnounceLinkType;                            { announce.fm }

  PF            : File of InfoType;                            { process.fm }
  PFNew         : File of InfoType;                            { process.new }
  Info          : InfoType;

  { ---- general var's ---- }

  DT            : DateTime;          { DateTime record, for timestamp etc   }
  currcrc       : Longint;
  xticname      : String[13];           { holds currently processed tic file name }

  tForward,                                     { filemgr running statistics }
  tRequest,
  tFiles,
  tBad,
  tAnnounce,
  tSystems   : Word;

  parNode    : NodeType;                          { filemgr batchhatch var's }
  Part       : Boolean;
  pnod       : String[15];
  parTAG     : String[15];
  parFile    : String[79];
  parRepl    : String[12];
  parMagic   : String[20];
  parDesc    : String;
  parNop     : Boolean;
  BatchHatch : Boolean;

  nolist,
  noquery,
  nounlinked,
  nohelp,
  nostatus,
  noforward,
  nomaint,
  nobill     : Boolean;

  Rescan     : Boolean;
  SystemPath : String[80];                   { systempath to filemgr's files }
  SearchArg  : String[70];                   { search argument voor filefind }
  DirStack   : PathStr;                             { contains original path }
  Run        : Byte;                                   { for paramcount loop }
  ParamWord  : String;                        { string to hold paramcount in }
  ValidNode  : Boolean;                     { for notify <nodenummer> verify }
  MsgTearLine: String[30];                              { tearline for msg's }
  FileStatus : FileStatusType;               { var to hold processed file in }
  AFXinx     : Word;
  Today      : ExtDateTime;

  fromnode   : Nodetype;  { voor leesbericht procedure }
  tonode     : Nodetype;
  fromname,
  toname     : String[36];
  subject    : String[72];

CONST
  ARCEXT : Array[ZIP..DWC] of String[3] = ('ZIC','JIC','LIC','AIC','PIC',
                                           'OIC','SIC','RIC','HIC','DIC');
  ZIPSTR : Array[ZIP..DWC] of String[3] = ('ZIP','ARJ','LZH','ARC','PAK',
                                           'ZOO','SQZ','RAR','HYP','DWC');
  Days  : Array[0..6] of String[3]   = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');

  Months : Array[1..12] of String[3] = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');



IMPLEMENTATION

END.
