 {
 $Id$
}

{*****************************************************************************
 *
 * Purpose:  Incomming file processing stage 2
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_proc2;

{$O+}

Interface

Uses
  Dos, S_string, F_File,
  Nw_tpl, fm_hex, fm_struct, fm_basic, fm_proc, fm_log, fm_exec, fm_rear;

Procedure Check_Adopt_Exception;
Procedure Check_Copy_Exception;
Procedure Check_The_Exceptions;


Implementation


Procedure Check_Copy_Exception;
var
  Match      : Boolean;
  Statusbak  : set of INFOstatusBits;
Begin
  If filestatus = ok then
    Begin
      match := exceptionMatch ( info.filespec, ex_copyarea, info.tag );
      If match then
        Begin
          notifyCR (8,'> Copying '+info.filespec+' to area '+ex.toarea);
          info.tag    := ex.toarea;
          statusbak := info.status;
          info.status := info.status + [local,nodupe];
          processfile;
          info.status := statusbak;
        End;
    End;
End;



Procedure Check_The_Exceptions;
Var
  pWord            : String[25];
  errorexec, x     : word;
  sr               : searchrec;
  currentdir,
  Cmdprog, cmdline : string;
Begin
  x := 0;
  Assign(exfile,systempath+'filemask.fm');
  {$I-} reset(exfile); {$I+}
  if ioresult <> 0 then exit;

  While x < filesize(exfile) do
    Begin
      inc(x);
      seek(Exfile,x-1);
      read(exfile,ex);

      if (ex.kind in [ex_exec,ex_unpack,ex_delete]) and (ex.fromarea = '') then
        Begin
          pWord   := ex.mask;

          { convert to DOS mask, for faster search }
          pword := Replace('#','?',pWord);
          pword := replace('@','?',pWord);

          FindFirst (SETUP.InboundPath + pWord, $0, SR);
          While DOSerror = 0 do
            Begin  { do FileMgr special matching }
              If FileMatch (SR.Name, ex.Mask) then
                Begin
                  If ex.kind = ex_exec then
                    Begin
                      NotifyCR (8,'Executing '+ex.line[1]);
                      Getdir(0,currentdir);
                      cmdprog := extractwords(1,1,ex.line[1]);
                      cmdline := extractwords(2,wordcnt(ex.line[1])-1,ex.line[1]);
                      ErrorExec := fmExec (cmdprog, CmdLine, setup.swapmethode, $3200, false,
                                 setup.showswapping);
                      chdir(currentdir);
                      If ErrorExec > 0 then
                        Begin
                          If ErrorExec > 255
                            then NotifyCR (2,ExecError(ErrorExec)+' ('+StrHex(ErrorExec,4)+')') else
                              NotifyCr (2,'(Program reports error '+StrHex(ErrorExec,4)+')');
                        End;
                    End;
                  If ex.kind = ex_unpack then
                    Begin
                      NotifyCR (8,'Unpacking '+SETUP.InBoundPath+SR.Name);
                      If UnPackArc (setup.inboundpath+sr.name+' '+ex.line[1],false) then
                        Begin { move to inbound }
                          Getdir(0,currentdir);
                          MoveToInBound(setup.temppath+unpackdir);
                          chdir(currentdir);
                          RemoveUnPackDir;
                        End;
                    End;
                  If ex.kind = ex_delete then
                    Begin
                      Notifycr (8,'Deleting '+SETUP.Inboundpath+SR.Name);
                      If not Delete_File(setup.inboundpath+sr.name) then
                        NotifyCr(2,'Cannot delete '+setup.inboundpath+sr.name);
                    End;
                End;
              FindNext(sr);
            End;
        End;
    End;
  Close(exfile);
End;



Procedure Check_Adopt_Exception;
var
  rtmp : string;
  pWord : String[25];
  Sr    : Searchrec;
  TMP   : File;
  I     : Word;
  x     : word;
Begin   { scan for MASKs }
  x := 0;
  Assign(exfile,systempath+'filemask.fm');
  {$I-} reset(exfile); {$I+}
  if ioresult <> 0 then exit;

  while x < filesize(exfile) do
    begin
      inc(x);
      seek(Exfile,x-1);
      read(exfile,ex);
      close(exfile);

      if ex.kind = ex_adopt then
        begin
          pWord   := ex.mask;

          { convert to DOS mask, for faster search }
          pword := Replace('#','?',pWord);
          pword := replace('@','?',pWord);

          FindFirst (SETUP.InboundPath + pWord, $0, SR);
          While DOSerror = 0 do
            begin  { do FileMgr special matching }

              reset(exfile);
              seek(Exfile,x-1);
              read(exfile,ex);
              close(exfile);

              if FileMatch (SR.Name, ex.Mask) then
                begin
                  NotifyCr  (4,'> Adopting '+SR.Name);
                  FileStatus := OK;
                  With INFO do
                    begin
                      FillChar (INFO, SizeOf(INFO), 0);
                      Fillchar (info.longdesc, sizeof(info.longdesc),#0);
                      TAG         := ex.toarea;
                      FilePath    := SETUP.InboundPath;
                      FileSpec    := SR.Name;
                      Assign (tmp, SETUP.InboundPath + SR.Name);
                      {$I-} Reset (tmp); {$I+}
                      if IOresult=0 then
                        begin
                          Size        := FileSize(tmp);
                          CRCstr      := StrHex(FileCRC(Tmp),8);
                          if ex.FromNode.Zone > 0 then
                            begin
                              Origin    := ex.FromNode;
                              cSeen     := 2;
                              SeenbyLst[1] := Origin;
                              SeenByLst[2] := SETUP.Address[1];
                              Status    := [];
                            end else
                            begin
                              Origin    := SETUP.Address[1];
                              Status    := [Local];
                              cSeen     := 1;
                              SeenbyLst[1] := Origin;
                            end;
                          From        := Origin;


                          assign(tplfile,systempath+'FM_DESC.#$#');
                          {$I-} rewrite(tplfile); {$I+}
                          if ioresult = 0 then
                            begin
                              writeln(tplfile,ex.line[1]);
                              close(tplfile);

                              assign(tplfile,systempath+'FM_DESC2.#$#');
                              {$I-} rewrite(tplfile); {$I+}
                              if ioresult = 0 then
                                begin

                                  fillchar(ann,sizeof(ann),0);
                                  with ann do
                                    begin
                                      Name   := sr.name;
                                      Replaces  := '';
                                      Area  := info.tag;
                                      Desc  := ex.line[1];
                                      LCount := 0;
                                      Magic  := info.magic;
                                      Date := info.date;
                                      Size  := info.size;
                                      Origin := info.origin;
                                      From := info.from;
                                    end;
                                  Convert_Tpl(systempath+'FM_DESC.#$#', ann, true, 0, '');
                                  delete_file(systempath+'FM_DESC.#$#');
                                  {$I-} reset(tplfile); {$I+}
                                  if ioresult = 0 then
                                    begin
                                      while not eof(tplfile) do
                                        begin
                                          readln(tplfile,rtmp);
                                          info.description := info.description + rtmp;
                                          move(rtmp[1],info.longdesc,length(rtmp));
                                          inc(longcount,length(rtmp));
                                        end;
                                      close(tplfile);
                                      erase(tplfile);
                                    end;
                                end;
                            end;

                          longcount := length(description);
                          for i := 1 to longcount do longdesc[i] := description[i];
                        end else
                        begin
                          NotifyCr (2,'Can''t access '+SETUP.InboundPath+SR.Name);
                          FileStatus := NOACCESS;
                        end;
                    end; {with info do}
                  If FileStatus = OK then ProcessFile;
                  If FileStatus = OK then Delete_file(setup.inboundpath+SR.NAME);
                end; {if filematch}
              FindNext (SR);
            end; {while doserror=0}
        end;
      reset(exfile);
    end;
  close(exfile);
End;

End.
