{
 $Id$
}

{ 050596 : line 1209 and further, pswd checking }
{ 021296 : line 1348 added lang_test line }
{ 021296 : added Lang_Test procedure }
{ vbc - 290208 - added code for unknown area with .tic filename
                 and from tic filename }
 {*****************************************************************************
 *
 *  Purpose:  File Processing ie .tic and file tossing
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit fm_proc;  {process file}

Interface

Uses
  dos, crt, crosslib, s_string, f_file, crc32,
  fm_exec, fm_struct, fm_basic, fm_bbs, fm_log, fm_rear, fm_dup,
  fm_hex, fm_bill, nw_tpl, nw_forw, nw_msg;


Procedure ProcessFile;

Implementation

procedure checkdup;
begin
  if not (local in info.status) or not info.hatdups then
    begin

      { check history file }
      Case setup.dupchecking of
       0 : History.dt := Is_Dup( info.filespec, area.tag, area.grp,
           CurrCrc, info.size, true, false, true, true, fuzzydup in area.status);
       1 : History.dt := Is_Dup( info.filespec, area.tag, area.grp,
           CurrCrc, info.size, false, true, true, true, fuzzydup in area.status);
       2 : History.dt := Is_Dup( info.filespec, area.tag, area.grp,
           CurrCrc, info.size, false ,false, true, true, fuzzydup in area.status);
      End;
      If History.Dt <> 0 then
        Begin
          if (DupCheck in AREA.Status) and (not (nodupe in info.status)) then
            begin
              NotifyCR (4,'Duplicate (on '+DaTi(History.dt)+')');
              FileStatus := DUPLICATE;
            end;
        End;
    end;
end;

Procedure ProcessFile;
var
  sizetel       : real;
  name1,
  name : string[100];
  errorexec,
  cSeenTmp,
  S, Dow        : Word;
  I ,N          : Byte;              { INX index byte for seenby indexing   }
  YetNoAction,
  Firs,
  Match,
  GotMagic      : Boolean;
  Lpath,
  ToPath        : String;
  CurrentDir    : PathStr;
  SR            : SearchRec;
  SeenbyTMP     : Array[1..MAXSEENBY] of NodeType;
  cmdprog, cmdline : string;
{  ErrorExec : word; }






Procedure DoMagicThing;
Var
  X        : Word;
  tmp : string;
  txtfile,
  txtfile2 : text;
  txtline  : string;

  procedure renametxt (what : byte);
  begin
    close (txtfile);
    erase (txtfile);

    close (txtfile2);
    {$i-} rename (txtfile2, setup.aliasfile[what]); {$i+}
    if ioresult > 0 then
      begin
        reset (txtfile2);
        assign (txtfile, setup.aliasfile[what]);
        rewrite (txtfile);
        while not eof(txtfile2) do
          begin
            readln (txtfile2, txtline);
            writeln (txtfile, txtline);
          end;
        close (txtfile);
        erase (txtfile2);
      end;
  end;

Begin  { update magic info if }

  if area.directory = '' then exit;

  match := ExceptionMatch ( info.filespec, ex_magic, info.tag );
  gotmagic := false;
  if match then
    begin { this is cool -- we know we must add a magic }
      if setup.aliasfile[1] <> '' then
        begin
          assign (txtfile, setup.aliasfile[1]);
          {$i-} reset (txtfile); {$i+}
          if ioresult = 0 then
            begin
              assign (txtfile2, 'ALIAS.$$$');
              {$I-} rewrite (txtfile2); {$I+}
              if ioresult = 0 then
                begin
                  gotmagic := false;
                  while not eof(txtfile) do
                    begin
                      readln (txtfile, txtline);
                      tmp := txtline;
                      if first(1,tmp) = '@' then tmp := last(length(tmp)-1,tmp);
                      if extractwords(1,1,upper(tmp)) = upper(ex.line[1]) then
                        begin
                          if (setup.mailer = 2) {binkley} or (setup.mailer = 4) {pop} then
                            writeln(txtfile2, '@'+expand(ex.line[1],13)+fexpand(checkepath(topath,true)
                               +info.filespec)) else
                              writeln(txtfile2, expand(ex.line[1],13)+fexpand(checkepath(topath,true)
                                +info.filespec));
                          gotmagic := true;
                        end else writeln (txtfile2, txtline);
                    end;
                  if not gotmagic then
                    begin
                      if (setup.mailer = 2) or (setup.mailer = 4) then
                        writeln(txtfile2, '@'+expand(ex.line[1],13)+fexpand(checkepath(topath,true)
                           +info.filespec)) else
                          writeln(txtfile2, expand(ex.line[1],13)+fexpand(checkepath(topath,true)
                            +info.filespec));
                    end;
                  renametxt(1);
               end;
            end;
        end; { aliasfile = '' }

      { update descriptionlist }
      if setup.aliasfile[2] <> '' then
        begin
          assign (txtfile, setup.aliasfile[2]);
          {$i-} reset (txtfile); {$i+}
          if ioresult=0 then
            begin
              assign (txtfile2, 'ALIAS.$$$');
              {$I-} rewrite (txtfile2); {$I+}
              if ioresult = 0 then
                begin
                  gotmagic := false;
                  while not eof(txtfile) do
                    begin
                      readln (txtfile, txtline);
                      if extractwords(1,1,upper(txtline)) = upper(ex.line[1]) then
                        begin
                          writeln (txtfile2, expand(ex.line[1],13) + info.description);
                          gotmagic := true;
                        end else writeln (txtfile2, txtline);
                    end;
                  if not gotmagic
                    then writeln (txtfile2, expand(ex.line[1],13) + info.description);
                  renametxt(2);
                end;
            end;
        end;

    end else

     if ((setup.updalias) or (local in info.status))
       and ((match) or (info.magic <> '') or (info.replaces <> '')) then
         begin
           (* check if allowed *)
           x := 1;
           while (x <= nodeidx) and (not nodeeq(nfxt^[x].address, info.from)) do inc(x);
           if (x <= nodeidx) then
             begin
               seek (nf, nfxt^[x].noderec);
               blockread(nf, node, sizeof(node));
             end;
           if ((x <= nodeidx) and (upmagic in node.status)) or (local in info.status) then
             begin
               { this is the 'fuzzy' part -- dunno about magics }
               { update magicfile list }
               if (info.magic <> '') and (setup.aliasfile[1] <> '') then
                 begin
                   assign (txtfile, setup.aliasfile[1]);
                   {$i-} reset (txtfile); {$i+}
                   if ioresult=0 then
                     begin
                       assign (txtfile2, 'ALIAS.$$$');
                       rewrite (txtfile2);
                       gotmagic := false;
                       while not eof(txtfile) do
                         begin
                           readln (txtfile, txtline);
                           tmp := txtline;
                           if first(1,tmp) = '@' then tmp := last(length(tmp)-1,tmp);
                           if extractwords(1,1,upper(tmp)) = upper(info.magic) then
                             begin
                               txtline := expand(info.magic,13) + fexpand(checkepath(topath,true)+info.filespec);
                               if (setup.mailer = 2) or (setup.mailer = 4) then
                                 writeln(txtfile2, '@'+txtline) else
                                   writeln (txtfile2, txtline);
                               gotmagic := true;
                             end else writeln (txtfile2, txtline);
                         end;
                       if not gotmagic then
                         begin
                           gotmagic := true;
                           txtline := expand(info.magic,13) + fexpand(checkepath(topath,true)+info.filespec);
                           if (setup.mailer = 2) or (setup.mailer = 4) then
                             writeln(txtfile2, '@'+txtline) else
                               writeln (txtfile2, txtline);
                         end;
                       renametxt(1);
                     end;
                 end;

               if (info.replaces <> '') and (setup.aliasfile[1] <> '') then
                 begin
                   assign (txtfile, setup.aliasfile[1]);
                   {$i-} reset (txtfile); {$i+}
                   if ioresult=0 then
                     begin
                       assign (txtfile2, 'ALIAS.$$$');
                       rewrite (txtfile2);
                       gotmagic := false;
                       while not eof(txtfile) do
                         begin
                           readln (txtfile, txtline);
                           tmp := txtline;
                           if first(1,tmp) = '@' then tmp := last(length(tmp)-1,tmp);
                           if extractwords(1,1,upper(tmp)) = upper(fexpand(checkepath(topath,true)+info.replaces)) then
{                           last(length(fexpand(checkepath(topath,true)+info.replaces)),tmp)
                             = fexpand(checkepath(topath,true)+info.replaces) then }
                             begin
                               tmp := extractwords(1,1,tmp)+' '+fexpand(checkepath(topath,true)+info.filespec);
{                              strrepli (tmp, fexpand(checkepath(topath,true) + info.replaces),
                                 fexpand(checkepath(topath,true)+ info.filespec), 1,1,255); }

                               if (setup.mailer = 2) or (setup.mailer = 4) then
                                 writeln(txtfile2, '@'+tmp) else
                                   writeln (txtfile2, tmp);
                               gotmagic := true;
                             end else writeln (txtfile2, txtline);
                         end;
                       renametxt(1);
                     end;
                 end;

               { update descriptionlist }
               if (info.magic <> '') and (setup.aliasfile[2] <> '') then
                 begin
                   assign (txtfile, setup.aliasfile[2]);
                   {$i-} reset (txtfile); {$i+}
                   if ioresult=0 then
                     begin
                       assign (txtfile2, 'ALIAS.$$$');
                       rewrite (txtfile2);
                       gotmagic := false;
                       while not eof(txtfile) do
                         begin
                           readln (txtfile, txtline);
                           if extractwords(1,1,upper(txtline)) = upper(info.magic) then
{                           if strposli(txtline, info.magic, 1) = 1 then }
                             begin
                               txtline := expand(info.magic,13) + info.description;
                               writeln (txtfile2, txtline);
                               gotmagic := true;
                             end else writeln (txtfile2, txtline);
                         end;
                       if not gotmagic then
                         begin
                           txtline := expand(info.magic,13) + info.description;
                           writeln (txtfile2, txtline);
                           gotmagic := true;
                         end;
                       renametxt(2);
                     end;
                 end;
             end;
         end;
  if gotmagic then notify (4,'(magic) ');
End;



Procedure Do_Virus_Scan;
Var
  Error       : Byte;
  Arci        : archivertype;
  unpacked    : Boolean;
  tm1, tm2    : string;
  Tmp,
  Newfilename : string;
  Errorexec   : INteger;
  CmdProg,
  Cmdline     : string;
  Ch          : Char;
  Txtfile     : Text;
  sr          : searchrec;
Begin
  if setup.temppath = '' then setup.temppath := systempath;
  unpacked := false;

  { virusscannen, import file_diz en re-archiven }
  If (filestatus = ok) then
    Begin                          { archive detecteren }
      Getdir(0,currentdir);

      arci := detectarchive;

      if setup.expandedlog then
        begin
          notify(4,'   ');
          if arci <> all then
            notifycr(4,co^.compressortype+' archive detected') else
              notifycr(4,'Unknown archive format');
        end;

      if not (local in info.status) or info.hatimpo or info.hatviru or info.hatrear then
        begin

          If ((virus in area.status) or (importdiz in area.status) or
             info.hatimpo or info.hatviru or info.hatrear or
             ((convert in area.rearchive) and (setup.extarchiver = ''))) then
            begin {uitpakken}

              if ((not (local in info.status) and not (virus in area.status) and not (convert in area.rearchive)) or
                 ((local in info.status) and not info.hatviru and not info.hatrear)) and
                  (arci <> all) then
                begin

                  {archive lezen, en als er file_id.diz in zit dan }
                  error := 0;
                  CO^.FindFirstEntry;                   { Find the first file inside }
                  While Not CO^.LastEntry Do            { The compressed file        }
                    Begin
                      co^.returnentry(tmp);
                      if tmp = 'FILE_ID.DIZ' then error := 1;
                      CO^.FindNextEntry;                   { Find the next entry        }
                    End;
                  filemode := 66;
                  if error <> 0 {file_id.diz gevonden} then
                    begin
                      notify(4,'(unpacking) ');
                      if not unpackarc(info.filepath+info.filespec+' FILE_ID.DIZ',false) then
                        unpacked := false else unpacked := true;
                    end;
                end else
                begin
                  notify(4,'(unpacking) ');
                  If not unpackarc(info.filepath+info.filespec,false) then
                    unpacked := false else unpacked := true;
                end;
            end;

          If ((not (local in info.status) and (virus in area.status)) or
             ((local in info.status) and info.hatviru)) and
             (unpacked) then
            Begin  {virusscannen}
              If not exist(SETUP.VIRUSPATH) then
                Begin {scanner niet aanwezig}
                  Notifycr(2,'');
                  NotifyCR(2,'Cannot find virus scanner: '+setup.viruspath);
                End Else
                Begin
                  Chdir(setup.temppath+unpackdir);
                  CmdLine := ' *.* '+SETUP.virusparm;
                  If not SETUP.Showvirus then CmdLine := CmdLine + ' > NUL';

                  ErrorExec := 0;
                  Case setup.virusfiles of
                    0 : Begin {alleen exe,com &ovl}
                          If exist('*.EXE') or exist('*.COM') or exist('*.OVL') then
                            Begin
                              Notify(4,'(vscan) ');
                              ErrorExec := fmExec (setup.viruspath, CmdLine,setup.swapmethode, $3200,
                                 false, setup.showswapping);
                            End;
                        End;
                    1 : Begin
                          Notify(4,'(vscan) ');
                          ErrorExec := fmExec (setup.viruspath, CmdLine,setup.swapmethode, $3200,
                             false, setup.showswapping);
                        End;
                  End;

                  chdir(currentdir);
                  If ErrorExec > setup.VirusErr then
                    Begin
                      If ErrorExec > 255
                        then NotifyCR (2,ExecError(ErrorExec)+' ('+StrHex(ErrorExec,4)+')') else
                          Begin
                            notifycr (2,'');
                            NotifyCr (2,'(virus scanner reports error '+StrHex(ErrorExec,4)+')');
                            NotifyCr (2,'VIRUS FOUND IN '+info.filespec+'!');
                            filestatus := VIRUSFOUND;
                          End;
                    End;
                End;
            End;

          If  ((not (local in info.status) and (Importdiz in area.status)) or
              ((local in info.status) and info.hatimpo)) and (unpacked) and (filestatus = ok) then
            Begin
              ch := #0;
              {$I-} Chdir(setup.temppath+unpackdir); {$I+}
              If ioresult = 0 then
                Begin
                  If Exist('FILE_ID.DIZ') then
                    Begin
                      Notify(4,'(diz) ');
                      Assign(Txtfile,'FILE_ID.DIZ');
                      {$I-} Reset(Txtfile); {$I+}
                      If ioresult = 0 then
                        Begin
                          Info.longcount := 0;
                          While not eof(Txtfile) and (ch <> #27) and (info.longcount < 2048) do
                            Begin
                              Read(Txtfile,Ch);
                              if setup.wrapdesc then
                                If Ch = #13 then Ch := ' ';
                              If not (Ch in [#0,#10,#27]) then
                                Begin
                                  If (not setup.extendeddiz) or
                                     (setup.extendeddiz and (ch in [#32..#127])) then
                                    Begin
                                      while (ch = #13) and (info.longdesc[info.longcount] = #32) do dec(info.longcount);
                                      Inc(info.longcount);
                                      Info.Longdesc[info.longcount] := Ch;
                                    End;
                                End;
                            End;
                          Close(txtfile);
                          Info.LongDesc[info.longcount+1] := #0;

                          while (info.longdesc[info.longcount] = #13) do
                            begin
                              info.longdesc[info.longcount] := #0;
                              dec(info.longcount);
                            end;
                        End Else
                          NotifyCr(2,'Cannot read FILE_ID.DIZ file');
                      If info.longcount > 0 then strip_buffer(info);
                      if setup.maxfileid <> 0 then
                        if info.longcount > setup.maxfileid then
                          begin
                            info.longcount := setup.maxfileid;
                            info.longdesc[setup.maxfileid+1] := #0;
                          end;
                    End;
                  Chdir(currentdir);
                End;
            End;

          {  PackerBits = (Convert, SameArchive, AvArchive, Extension);  }
          If ((not (local in info.status) and (convert in area.rearchive)) or
               ((local in info.status) and info.hatrear)) and
               (filestatus = ok) then
            Begin

              If (setup.extarchiver = '') and unpacked then
                Begin

                  If ((samearchive in area.rearchive) and (arci = area.usearchiver))
                  or (arci <> area.usearchiver) then
                    Begin {creeren naar zelfde archive formaat?}

                      if (co^.protectedfile and (not (avarchive in area.rearchive)))
                         or not co^.protectedfile then
                        Begin  {is oude archive av archive en mogen we veranderen
                                                 of is oude archive geen archiver}
                          Chdir(setup.temppath+unpackdir);

                          newfilename := file_split(3,info.filespec);
                          newfilename := newfilename+'.'+zipstr[area.usearchiver];
                          arci := area.usearchiver;

                          if (file_split(4,info.filespec) <> '.ZIP') and
                             (file_split(4,info.filespec) <> '.ARC') and
                             (file_split(4,info.filespec) <> '.PAK') and
                             (file_split(4,info.filespec) <> '.ARJ') and
                             (file_split(4,info.filespec) <> '.EXE') and
                             (file_split(4,info.filespec) <> '.LZH') and
                             (file_split(4,info.filespec) <> '.RAR') and
                             (file_split(4,info.filespec) <> '.SQZ') and
                             (file_split(4,info.filespec) <> '.DWC') and
                             (file_split(4,info.filespec) <> '.HYP') and
                             (file_split(4,info.filespec) <> '.ZOO') then
                               begin
                                 if not (extension in area.rearchive) then
                                   begin {keep strange extension}
                                     newfilename := first(length(newfilename)-2,newfilename)+
                                       last(2,  file_split(4,info.filespec) );
                                   end;
                               end;

                          if exist(systempath+'DELETE.FM') then
                            begin
                              assign(txtfile,systempath+'DELETE.FM');
                              {$I-} reset(txtfile); {$I+}
                              if ioresult <> 0 then
                                begin
                                  notifycr(2,'');
                                  notifycr(2,'Cannot open '+systempath+'DELETE.FM');
                                end else
                                begin
                                  while not eof(txtfile) do
                                    begin
                                      readln(txtfile,tmp);
                                      tmp := strip('A',' ',tmp);
                                      if length(tmp) <> 0 then
                                        begin
                                          findfirst(setup.temppath+unpackdir+'\'+tmp,readonly+archive,sr);
                                          while doserror = 0 do
                                            begin
                                              if delete_file(setup.temppath+unpackdir+'\'+sr.name) then
                                                writelogcr(4,sr.name+' deleted');
                                              findnext(sr);
                                            end;
                                        end;
                                    end;
                                  close(txtfile);
                                end;
                            end;


                          notify(4,'(packing) ');
                          if packarc('',currentdir+'\'+newfilename,area.usearchiver,true) then
                            Begin
                              If not Delete_File(info.filepath+info.filespec) then
                              NotifyCr(2,'Cannot delete '+info.filepath+info.filespec);
                                         {old archive deleted}
                              If not Copy_File (currentdir, newfilename, newfilename, info.filepath, false) then
                              NotifyCr(2,'Cannot copy '+currentdir+'\'+newfilename+' to '+info.filepath);
                                         {copieren naar inbound}
                              If not Delete_File(currentdir+'\'+newfilename) then
                              NotifyCr(2,'Cannot delete '+currentdir+'\'+newfilename);
                                       {new archive deleted}
                              Info.FileSpec := newfilename;
                              currcrc := GetInfoDate(info.filepath);
                              Info.CRCstr := StrHex (CurrCRC,0);
                                      {info gegevens goed zetten}
                            End else
                            begin
                              notifycr(2,'');
                              notifycr(2,'Error re-archiving file '+newfilename);
                            end;

                          chdir(currentdir);
                        End Else notify(4,'(skip -av file) ');
                    End;
                End Else {external archiver}
                Begin

                  If (setup.extarchiver <> '') then
                    Begin

                      If unpacked then
                        Begin
                          EmptyUnpackDir(setup.temppath+unpackdir); {uitgepakte files deleten}
                        End;

                      chdir(currentdir);
                      If CreateTmp then
                        Begin

                          copyfile(info.filepath+info.filespec,setup.temppath+unpackdir+'\'+info.filespec);
                          { copy orig file naar tmp dir }

                          CmdProg := extractwords(1,1,setup.extarchiver);
                          errorexec := fmexec (CmdProg,' '+'*.*',setup.swapmethode, $3200, false, setup.showswapping);
                          { call ext archiver }

                          if errorexec <> 0 then
                            Begin
                              If ErrorExec > 255
                                then NotifyCR (2,ExecError(ErrorExec)+' ('+StrHex(ErrorExec,4)+')') else
                                  Notifycr(2,'External archiver reported errorlevel '+int_to_str(errorexec));
                            End else
                            Begin
                              delete_file(info.filepath+info.filespec);
                              { if no error then orig file deleted }

                              newfilename := file_split(3,info.filespec);
                              findfirst(setup.temppath+unpackdir+'\'+newfilename+'.*',anyfile,sr);
                              if doserror = 0 then
                                begin
                                  newfilename := sr.name;
                                  while doserror = 0 do findnext(sr); {novell bug}
                                end else
                                begin
                                  findfirst(setup.temppath+unpackdir+'\*.*',anyfile,sr);
                                  if doserror = 0 then
                                    begin
                                      newfilename := sr.name;
                                      while doserror = 0 do findnext(sr); {novell bug}
                                    end else
                                      newfilename := '';
                                end;
                              {checken of de naam niet toevallig veranderd is}

                              if newfilename <> '' then
                                begin
                                  copyfile(setup.temppath+unpackdir+'\'+newfilename,info.filepath+newfilename);
                                  { converted file copieeren naar orig dir }

                                  Info.FileSpec := newfilename;
                                  currcrc := GetInfoDate(info.filepath);
                                  Info.CRCstr := StrHex (CurrCRC,0);
                                  { settings aanpassen }

                                  arci := detectarchive;

                                end else
                                 notifycr(2,'Cannot find converted file '+info.filespec);
                            End;
                        End;
                    End;
                End;
            End;

          If (convert in area.rearchive) and (area.usebanner <> 0) and (arci <> all) and (filestatus = ok) then
            Begin
              if strip('B',' ',setup.bannerarray[area.usebanner]) <> '' then
                Begin
                  If exist(setup.bannerarray[area.usebanner]) then
                    Begin
                      case arci of
                       zip : error := 1;
                       arj : error := 2;
                       lzh : error := 3;
                       arc : error := 4;
                       pak : error := 5;
                       zoo : error := 6;
                       sqz : error := 7;
                       rar : error := 8;
                       hyp : error := 9;
                       dwc : error := 10;
                       else error := 11;
                      end;

                      cmdprog := setup.packername[error];
                      cmdline := setup.bannerswitch[error];

                      if Pos('%1',CmdLine) > 0 then
                        begin
                          if pos('%1',cmdline) <> 1 then
                            tm1 := first( pos('%1',cmdline)-1 ,cmdline) else tm1 := '';
                          if pos('%1',cmdline) <> (length(cmdline)-1) then
                            tm2 := last(length(cmdline)-(pos('%1',cmdline)+1),cmdline) else tm2 := '';
                          cmdline := tm1 + info.filespec + tm2;
                        end else CmdLine := CmdLine + ' ' + info.filespec;

                      if Pos('%2',CmdLine) > 0 then
                        begin
                          if pos('%2',cmdline) <> 1 then
                            tm1 := first( pos('%2',cmdline)-1 ,cmdline) else tm1 := '';
                          if pos('%2',cmdline) <> (length(cmdline)-1) then
                            tm2 := last(length(cmdline)-(pos('%2',cmdline)+1),cmdline) else tm2 := '';
                          cmdline := tm1 + setup.bannerarray[area.usebanner] + tm2;
                        end else CmdLine := CmdLine + ' ' + setup.bannerarray[area.usebanner];

                      if not SETUP.ShowPack then CmdLine := CmdLine + ' > NUL';
                      if (strip('B',' ',setup.bannerswitch[error]) <> '') and
                         (strip('B',' ',setup.packername[error]) <> '') and
                         (error <> 11) then
                          begin
                            chdir(udir(info.filepath));
                            Notify(4,'(banner) ');
                            Error := fmExec (CmdProg, CmdLine,setup.swapmethode, $3200, false, setup.showswapping);
                            If Error <> 0 then
                              Begin
                                If setup.showpack then NotifyCR(2,'') else writelogcr(2,'');
                                If Error > 255
                                  then NotifyCR (2,ExecError(Error)+' ('+StrHex(Error,4)+')')
                                    else NotifyCR (2,'(packer error '+StrHex(Error,4)+')');
                              End Else writeln;
                            currcrc := GetInfoDate('');
                            Info.CRCstr := StrHex (CurrCRC,0);
                                             {info gegevens goed zetten}
                            chdir(currentdir);
                          end Else Notifycr(2,'Empty banner switch line');
                    End Else Notifycr(2,'Cannot find banner file '+setup.bannerarray[area.usebanner]);
                End Else Notifycr(2,'Empty banner file specified');
            End;

          EmptyUnpackDir(setup.temppath+unpackdir); {uitgepakte files deleten}
          chdir(currentdir);
          RemoveUnpackDir;     {unpackdir deleten}

        End;
    End; { filestatus = ok }
End;

Procedure Check_Other_Secs;
Var
  CnvErr : Integer;
  Tmp    : String;
Begin                        { perform the other security checks if no dupe }
  Cnverr := 0;
  With AFXt^[AFXinx] do
    Begin
      If (FileStatus = OK) and (not (Local in INFO.Status)) then
        Begin
          if CRC in AREA.Status then
            begin
              if (INFO.CRCstr <> '') then
                begin
                  tmp := strhex(currcrc,0);
                  while length(tmp) < 8 do tmp := '0' + tmp;
                  if (upper(tmp) <> upper(info.CRCstr)) then
                    begin
                      NotifyCR (4,'CRC bad '+upper(tmp)+' - '+upper(info.CRCstr));
                      FileStatus := BADCRC;
                    end;
                end else INFO.CRCstr := StrHex (CurrCRC,0);
            end else info.crcstr := strhex (currcrc,0);
          if (filestatus = ok) and (secure in area.status) then
            begin
              i := 1;
              while (i <= area.exportnr) and (not nodeeq(info.from, sfxt^[i].a)) do inc(i);
              if i > area.exportnr then
                begin
                  notifyCR (4,'Secure ('+node2str(info.from)+' not in exportlist)');
                  filestatus := ILLEGAL;
                end else
                begin
                  if not (import in sfxt^[i].s) { and _rcv <> _rcv} then
                    begin
                      notifyCR (4,'Secure ('+node2str(info.from)+' not allowed to send)');
                      filestatus := ILLEGAL;
                    end;
                end;
            end;
        End Else
          If info.crcstr = '' then info.crcstr := strhex(currcrc,0);

      Do_Virus_Scan; {virus scan, import file_id, re-archiving}
   End;
End;

Procedure Check_Copyfile_Exception;
Begin  { check for CopyFile }
  match := ExceptionMatch ( info.filespec, ex_copyfile, info.tag );
  if Match and (not (FileProcessed in INFO.Status)) then
    Begin
      Notify (4,'(copy) ');
      Copy_File (info.FilePath, info.FileSpec, info.filespec, ex.line[1], SETUP.Touch);
    End;
End;

Procedure Check_OtherPath_Exception;
Begin
  Match := ExceptionMatch ( info.filespec, ex_otherpath, info.tag );
  If Match then
    Begin
      ToPath := ex.line[1];
      Lpath  := topath + 'FILES.BBS';
      Notify (4,'(otherpath) ');
    End Else ToPath := checkepath(AREA.Directory,true);
End;

Procedure GetNodeRec(updateflow:boolean);
Var X : word;
Begin
  x := 1;
  fillchar(node,sizeof(node),0);
  node.Archiver     := ZIP;  { voor unknown sysops }
  node.Status       := [];
  node.address      := sfxt^[i].a;
  node.tictype      := 1;
  While (x <= Nodeidx) and (Not NodeEQ(NFXt^[x].ADDRESS, sfxt^[I].A)) Do Inc(x);
  if x <= Nodeidx then
    begin
      Seek (NF, NFXt^[x].NodeRec);
      blockRead (NF, NODE, sizeof(node));
      if updateflow then
        begin
          with dt do
            begin
              gettime (hour, min, sec, today.hs);
              getdate (year, month, day, today.dow);
              if month <> node.lastmonth then
                begin
                  node.lastmonth                  := month;
                  node.flow[node.lastmonth].bytes := info.size;
                  node.flow[node.lastmonth].files := 1;
                end else
                begin
                  inc(node.flow[node.lastmonth].bytes, info.size);
                  inc(node.flow[node.lastmonth].files);
                end;
              seek (nf, nfxt^[x].noderec);
              blockwrite(nf, node, sizeof(node));
            end;
        end;
    end;
End;


Procedure Check_And_Create_Area;
Var
  bg : word;
  X : Word;
  k1,k2 : string;
Begin
  AFXinx := 0;
  k1 := ' ';
  k2 := info.tag;
  if length(k2) > 16 then k2 := first(16,k2);
  While (AFXinx <= Areaidx) and (upper(k1) <> upper(k2)) do
    begin
      Inc(AFXinx);
      k1 := afxt^[afxinx].tag;
      if length(k1) > 16 then k1 := first(16,k1);
    end;

  if AFXinx > Areaidx then
    begin
      FileStatus := UNKNOWN;
      x := 1;
      While (x <= Nodeidx) and (not NodeEQ(NFXt^[x].Address, INFO.From)) do Inc(x);
      if x <= Nodeidx then
        begin
          Seek (NF, NFXt^[x].NodeRec);
          blockread(NF, NODE, sizeof(node));
          if (CanCreate in NODE.Status) and (NODE.NewGroup <> 0)
            and NODE.Groups[node.newgroup] then
            begin
              GROUP.groupnr := 0;
              Seek (GF, 0);
              While (not EOF(GF)) and (GROUP.groupnr <> NODE.NewGroup) do Read (GF, GROUP);
              if GROUP.groupnr <> NODE.NewGroup then FillChar (GROUP, SizeOf(GROUP), 0);

              inc(areaidx);
              FillChar (afxt^[areaidx],SizeOf(afxt^[areaidx]), 0);
              FillChar (AREA, SizeOf(AREA), 0);
              FillChar (sfxt^, SizeOf(sfxt^), 0);

              Afxt^[areaidx].tag     := INFO.TAG;
              afxt^[areaidx].grp     := NODE.NewGroup;
              afxt^[areaidx].arearec := filesize(af);
              bg := node.newgroup;

              if (info.areadesc <> '') and setup.useareadesc then
                area.name := info.areadesc else
                  area.Name := info.tag + ' [created by '+Node2Str(INFO.From)+']';

              AREA.TAG       := INFO.TAG;
              area.grp       := node.newgroup;
              area.aka       := group.aka;
              area.listspec  := group.listspec;
              area.batchfile := group.batchfile;
              area.msgid     := group.msgid;
              area.format    := group.format;
              area.status    := group.status;
              area.newarea   := true;

              area.CostPerBlock := group.costperblock;
              area.Block        := group.block;
              area.AllLinks     := group.alllinks;
              area.AddPercent   := group.addpercent;
              area.InclHost     := group.inclhost;
              area.InclUplink   := group.incluplink;
              area.Usebanner    := group.usebanner;

              area.Rearchive    := group.rearchive;
              area.UseArchiver  := group.usearchiver;

              area.directory := info.tag;
              area.directory := strip('A',' ',area.directory); {spaties eruit}
              area.directory := strip('A','.',area.directory); {punten eruit}
              area.directory := strip('A','*',area.directory); {sterren eruit}
              area.directory := strip('A','?',area.directory); {? eruit}

              if Length(AREA.Directory) > 11 then AREA.Directory := first(11,AREA.Directory);
              if length(area.directory) > 8 then area.directory := first(8,area.directory);
{                +'.'+last(length(area.directory)-8,area.directory); }

              if group.directory <> '' then
                begin
                  AREA.Directory := checkepath(GROUP.Directory,true) + AREA.Directory;
                  FindFirst (AREA.Directory, $10, SR);
                  if DOSerror <> 0 then
                    begin
                      {$I-} MkDir (AREA.Directory); {$I+}
                      if IOresult > 0 then
                        begin
                          AREA.Directory := checkepath(GROUP.Directory,true);
                          writelogcr(2,'');
                          writelogcr(2,'Cannot create '+area.directory+', using group dir!');
                        end;
                    end else
                    begin  {for novell 3.11 -> outstanding ncp searches}
                      while doserror = 0 do findnext(sr);
                    end;

{fout:}
                  area.directory := area.directory + '\';

                  if last(1,area.directory) <> '\' then
                    AREA.ListSpec  := AREA.Directory+'\FILES.BBS' else
                      area.listspec := area.directory +'FILES.BBS';
{moet zijn:
 <filespec> ipv standaard FILES.BBS }

                end else
                begin
                  area.directory := '';
                end;


              AREA.ExportNr  := 1;
              sfxt^[area.exportnr].a := info.from;
              sfxt^[area.exportnr].s := [import];
              for x := 1 to Nodeidx do
                begin
                  Seek (NF, NFXt^[x].NodeRec);
                  blockread(NF, NODE, sizeof(node));
                  if (AddNew in NODE.Status) and NODE.Groups[bg] then
                    begin
                      if (node.newgroup = 0) or (node.newgroup = bg) then
                        begin
                          if not nodeeq(nfxt^[x].address, info.from) then
                            begin
                              Inc (AREA.ExportNr);
                              sfxt^[AREA.ExportNr].A := NFXt^[x].Address;
                              sfxt^[AREA.ExportNr].S := [export];
                            end else sfxt^[1].s := sfxt^[1].s + [export];
                        end;
                    end;
                end;

              Seek(af,afxt^[afxinx].arearec);
              blockwrite(af,area,sizeof(area));
              blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype));

              FileStatus := OK;
              NotifyCr (4,'in '+Afxt^[afxinx].tAG+' (new)');

              k1 := 'Area '+afxt^[afxinx].tag+' created by '+node2str(info.from);
              if area.directory = '' then k1 := k1 + ' (passthru)' else
                k1 := k1 + ' in '+area.directory;
              if setup.noti_newly then Writetotmpfile('fmsystmp.#$',k1);

              if area.exportnr > 1 then notifycr(4,'   '+int_to_str(area.exportnr-1)+' nodes auto-added');

            end;
        end;
    end else NotifyCr (4,'in '+AFXt^[AFXinx].TAG);
End;


Procedure Update_Flow;
var r : integer;
Begin
  With dt do
    begin
      gettime (hour, min, sec, today.hs);
      getdate (year, month, day, today.dow);

      { update flow area statistics }
      if month <> area.lastmonth then
        begin
          area.lastmonth                  := month;
          area.flow[area.lastmonth].bytes := info.size;
          area.flow[area.lastmonth].files := 1;
        end else
        begin
          inc(area.flow[area.lastmonth].bytes, info.size);
          inc(area.flow[area.lastmonth].files);
        end;

      seek (af, afxt^[afxinx].arearec);
      blockwrite (af, area, sizeof(area));

      { update flow group statistics }
      Seek (GF, 0);
      r := 0;
      While (not EOF(GF)) and (GROUP.groupnr <> area.grp) do
        begin
          Read (GF, GROUP);
          inc(r);
        end;
      if (GROUP.groupnr = area.grp) and (r <> 0) then
        Begin
          if month <> group.lastmonth then
            begin
              group.lastmonth                  := month;
              group.flow[area.lastmonth].bytes := info.size;
              group.flow[area.lastmonth].files := 1;
            end else
            begin
              inc(group.flow[area.lastmonth].bytes, info.size);
              inc(group.flow[area.lastmonth].files);
            end;
          inoutres := 0;
          {$I-}
          seek(gf,r-1);
          write(gf,group); {$I+}
          If ioresult <> 0 then notifycr(1,'Cannot update group flow statistics');
        End;
    End;
End;

Procedure Move_File;
Var
  cf            : file of longint;  {voor files.fm file}
  crcr          : longint;

  procedure schrijfbij; { files.fm }
  var
    inx : byte;
  begin          {bijschrijven in files.fm file}
    if ((hatchnew in area.status) or (annnew in area.status)) and (filestatus = ok) then
      begin
        assign (cf, checkepath(area.directory,true)+'FILES.FM');
        setfattr (cf, 0);
        {$i-} reset (cf); {$i+}
        If ioresult <> 0 then rewrite(cf);
        seek(cf,filesize(cf));

        crcr := $ffffffff;
        for inx := 1 to length(info.filespec) do crcr := updatecrc32(ord(info.filespec[inx]),crcr);

        if setup.touch then {} else crcr := updatecrc32(sr.time,crcr);
        crcr := updatecrc32(info.size,crcr);
        crcr := not(crcr);
        write(cf,crcr);
        close(cf);
        setfattr (cf, readonly + hidden + archive);
      end;
  end;

Begin    { move file to BBS path }
  if (ToPath <> '') and (not (FileProcessed in INFO.Status)) and (upper(info.filepath) <> upper(topath)) then
    begin
      Notify (4,'(move) ');

      if exist(topath+info.filespec) then {file exist: duplicate name or replace}
        begin
          if area.ReplaceMode = 2 {move file} then
            begin
              copy_file(topath,info.filespec, info.filespec, setup.retirepath, false);
              writelogcr(4,'');
              writelogcr(4,'Copied replace file '+info.filespec+' to '+setup.retirepath);
            end;
          delete_file(topath+info.filespec);
        end;

      If NOT Copy_File (info.FilePath, info.FileSpec, info.filespec, ToPath, SETUP.Touch) then
        FileStatus := BADPATH else
          begin
            if (lpath <> '') or (area.areanr > 0) then
              begin
                lpath := checkepath(lpath,false);
                if NOT AddtoList (ToPath, Lpath, Area.AreaNr, AREA.Format, area.replacemode)
                  then FileStatus := BADDESCR
                    else YetNoAction := False;
              end else Notify (4,'(no list) ');
            schrijfbij;
          end;
    end else
    begin
      If (local in info.status) and (upper(topath) = upper(info.filepath)) then
        begin
          if (lpath <> '') or (area.areanr > 0) then
            begin
              lpath := checkepath(lpath,false);
              if NOT AddtoList (ToPath, Lpath, Area.AreaNr, AREA.Format, area.replacemode)
                then FileStatus := BADDESCR
                  else begin notify(4,'(list) '); YetNoAction := False; end;
            end else Notify (4,'(no list) ');
        end else Notify (4,'(passthru) ');
    end;
End;


Function checkpswd:boolean; {true if correct pswd}
var x : integer;
Begin
  checkpswd := true;
  {check pswd in tick file}
  x := 1;
  fillchar(node,sizeof(node),0);
  if info.password <> '' then
    begin
      While (x <= Nodeidx) and (Not NodeEQ(NFXt^[x].ADDRESS, info.from)) Do Inc(x);
      if x <= Nodeidx then
        begin
          Seek (NF, NFXt^[x].NodeRec);
          blockRead (NF, NODE, sizeof(node));

          if upper(info.password) <> upper(node.password) then
            begin
              Notify (4,info.FileSpec+' ');
              if Local in INFO.Status
                then Notifycr (4,'(local) ')
{vbc 290208 }   else Notifycr (4,'from '+Node2Str(INFO.From)+' '+' in '+xticname+' ');

              notifyCR (2,'Password in tick file does not match with node password');
              filestatus := illegal;
              checkpswd := false;
            end;
        end;
    end;
End;

{-------------}

Begin
  FileStatus := OK;

  if not Checkpswd then exit;

  if filestatus = ok then
    begin
      if ExceptionMatch ( info.filespec, ex_move, info.tag ) then
        begin
          INFO.TAG := ex.toarea;
          if ex.fromnode.zone <> 0 then
            info.from := ex.fromnode;
        end;

      YetNoAction := True;

      match := exceptionMatch ( info.filespec, ex_unpack, info.tag );
      If match then
        Begin
          notifyCR (8,'Unpacking '+info.filespec);
          If UnPackArc (setup.inboundpath+info.filespec+' '+ex.line[1],false) then
            Begin { move to inbound }
              MoveToInBound(setup.temppath+unpackdir);
              RemoveUnPackDir;
            End;
        End;

      match := exceptionMatch ( info.filespec, ex_exec, info.tag );
      If match then
        Begin
          NotifyCR (8,'Executing '+ex.line[1]);
          Getdir(0,currentdir);
          cmdprog := extractwords(1,1,ex.line[1]);
          cmdline := extractwords(2,wordcnt(ex.line[1])-1,ex.line[1]);
          ErrorExec := fmExec (cmdprog, CmdLine, setup.swapmethode, $3200, false,
                               setup.showswapping);
          chdir(currentdir);
          If ErrorExec > 0 then
            Begin
              If ErrorExec > 255
                then NotifyCR (2,ExecError(ErrorExec)+' ('+StrHex(ErrorExec,4)+')') else
                  NotifyCr (2,'(Program reports error '+StrHex(ErrorExec,4)+')');
            End;
        End;

      Notify (4,info.FileSpec+' ');
      if Local in INFO.Status
        then Notify (4,'(local) ')
          else Notify (4,'from '+Node2Str(INFO.From)+' '+' in '+xticname+' ');
      if info.totalcost > 0 then notify(4,'(uplink charged '+real_to_str(info.totalcost,0)+' cents) ');

      if info.logstring <> '' then
        NotifyCR(9,'LOG: '+ info.logstring);

      Check_And_Create_Area; { find area, if not exists -> try to create it}
    End;


  if FileStatus = OK then
    Begin                 { valid area }
      GetArea(AFXinx);

      if area.directory <> '' then
        Notifycr(4,'   '+checkepath(area.directory,false));
      if setup.expandedlog then
        Notify(4,'   ') else notify(4,'   ');
      notifycr(4,'area '+int_to_str(afxinx)+' '+area.name);

      INFO.MatchIt := (AREA.AKA = 0);
      INFO.Expo    := AREA.ExportNr;

      If NOT (Local in INFO.Status) then info.FilePath := SETUP.InboundPath;
      FindFirst (info.FilePath + info.FileSpec, AnyFile, sR);
      If DosError = 0 then
        Begin
          currcrc := GetInfoDate(info.Filepath);

          checkdup;

          If fileStatus = OK then Check_Other_secs; { incl virus scan etc }

          If fileStatus = Ok then
            If (test in area.status) and (setup.testfile <> '') then Test_File;

          If filestatus = Ok then
            if (langcheck in area.status) and (setup.testlang <> '') then Lang_Test;

          If FileStatus = OK then
            Begin { good file }

              if area.newarea then
                begin
                  info.areadesc := area.name;
                  area.newarea := false;
                end;

              Update_Flow;

              { find default description if one's missing }
              if (info.Description = '') and (info.longcount = 0) then
                begin
                  if (GROUP.groupnr = AREA.Grp)
                    then info.Description := GROUP.DefaultDesc
                      else info.Description := '[Description missing, Inform Sysop]';
                end;

              topath := '';
              lpath := area.listspec;
              Match := ExceptionMatch ( info.filespec, ex_passthru, info.tag );
              if not Match then Check_OtherPath_Exception;
              Check_Copyfile_Exception;

              Move_File;

              { save seenby information }
              If filestatus = ok then
                begin
                  Move (info.SeenbyLst, SeenbyTMP, SizeOf(info.SeenbyLst));
                  cSeenTMP := info.cSeen;
                end;

              writeimportlog;

              if (filestatus = ok) and (Tiny in AREA.Status) then
                begin
                  { strip the stuff }
                  if area.aka = 0
                    then fillchar (info.origin, sizeof(info.origin), 0)
                      else info.origin := setup.address[area.aka];
                  info.from   := info.origin;
                  FillChar (info.SeenbyLst, SizeOf(info.SeenbyLst), 0);
                  FillChar (info.Path,      SizeOf(info.Path), 0);
                  FillChar (info.PathUnix,  SizeOf(info.PathUnix), 0);
                  FillChar (info.PathStamp, SizeOf(info.PathStamp), 0);
                  info.cSeen := 0;
                  info.cPath := 0;
                 end;

              { find magic exception }
              if filestatus = ok then domagicthing;

              if filestatus = ok then
                begin  { check for forwarding }
                  Firs := True;

                  history.forwards := 0;
                  for i := 1 to area.exportnr do
                    begin
                      if export in sfxt^[i].s then inc(history.forwards);
                    end;
                  match := ExceptionMatch ( info.filespec, ex_noannounce, info.tag);
                  if match then Notify(4,'(noannounce) ') else doannouncement;
                  history.forwards := 0;

                  Match := ExceptionMatch ( info.filespec, ex_noforward, info.tag);
                  if Match then Notify (4,'(noforward) ') else
                    begin

                      write('('+int_to_str(area.exportnr)+')');

                      for I := 1 to AREA.ExportNr do
                        begin

                          write(#8+replicate(length(int_to_str((area.exportnr-i)+1)),#8) + int_to_str(area.exportnr-i) +')');

                          getnoderec(false);

                          S := 1;
                          dow := ( file_size(info.filepath+info.filespec) div 1024 );
                          While (S <= cSeenTMP) and (not NodeEQ(SeenByTMP[S], sfxt^[I].A)) do Inc(S);

                          if (S > cSeenTMP)
                            and (not (pause in node.status))
                            and (not NodeEQ(info.From, sfxt^[I].A))
                            and (not nodeeq(info.origin, sfxt^[i].a))
                            and (export in sfxt^[i].s)
                            and ((dow <= node.maxfilesize) or (node.maxfilesize = 0))
                            then
                              begin

                                Inc (HISTORY.Forwards);
                                Inc (Tforward);

                                if Firs then
                                  begin
                                    { make sure there is a file to send }
                                    if (Backup in AREA.Status) then
                                      begin
                                        Notify (4,'(backup) ');
                                        Copy_File (info.FilePath, info.filespec, info.FileSpec, SETUP.OutboundPath, False);
                                      end else
                                    if (ToPath = '') or (AREA.Directory = '') then
                                      begin
                                        Notify (4,'(outbound) ');
                                        Copy_File (info.Filepath, info.FileSpec, info.filespec, SETUP.OutboundPath, False);
                                      end else
                                    if ToPath = '' then ToPath := checkepath(AREA.Directory,true);
                                    if (Backup in AREA.Status) or (ToPath = '')
                                      then name := fexpand(udir(setup.OutBoundPath)+'\'+INFO.FileSpec)
                                        else name := fexpand(udir(ToPath)+'\'+ INFO.FileSpec);

                                    { update TIC info }
                                    if info.cPath < MAXPATH then Inc(info.cPath) else
                                      begin
                                        Move (info.Path[2], info.Path[1], (MAXPATH-1)*SizeOf(NodeType));
                                        Move (info.PathStamp[2], info.PathStamp[1], (MAXPATH-1)*SizeOf(info.PathStamp[1]));
                                        Move (info.PathUnix[2], info.PathStamp[1], (MAXPATH-1)*SizeOf(info.PathUnix[1]));
                                      end;
                                    if AREA.AKA > 0
                                      then info.Path[info.cPath] := SETUP.Address[AREA.AKA]
                                        else info.Path[info.cPath].Zone := 0;

                                    { find SEENBY entry }
                                    N := 1;
                                    While (N <= info.cSeen) and (NotAKA(info.SeenbyLst[N])) do Inc(N);
                                    if N > info.cSeen then
                                      begin
                                        if info.cSeen < MAXSEENBY
                                          then Inc(info.cSeen)
                                            else Move (info.SeenByLst[2], info.SeenByLst[1], (MAXSEENBY-1)*SizeOf(NodeType));
                                        if AREA.AKA > 0
                                          then info.SeenByLst[info.cSeen]  := SETUP.Address[AREA.AKA]
                                            else info.SeenByLst[info.cSeen]  := SETUP.Address[1];
                                      end else
                                      begin
                                        if AREA.AKA > 0
                                          then info.SeenByLst[N] := SETUP.Address[AREA.AKA]
                                            else info.SeenbyLst[N] := SETUP.Address[1];
                                      end;
                                    With DT do
                                      begin
                                        GetTime (Hour, Min, Sec, DOW);
                                        GetDate (Year, Month, Day, DOW);
                                      end;
                                    info.PathUnix[info.cPath]  := GetUnixDate(DT);
                                    info.PathStamp[info.cPath] := ZoneString(DT, DOW);
                                    if AREA.AKA > 0
                                      then info.From  := SETUP.Address[AREA.AKA]
                                        else info.From.Zone := 0;

                                    Firs        := False;
                                    YetNoAction := False;

                                    if wherex > 1 then notifycr(4,'');
                                  end; { if first then }

                                if sfxt^[I].A.Point = 0 then  { add to seen-by }
                                  begin
                                    if info.cSeen < MAXSEENBY
                                      then Inc(info.cSeen)
                                        else Move (info.SeenByLst[2], info.SeenbyLst[1], (MAXSEENBY-1)*SizeOf(NodeType));
                                    info.SeenbyLst[info.cSeen] := sfxt^[I].A;
                                  end;

                                if (area.costperblock > 0) or area.incluplink then
                                  begin
                                    if node.credit > node.stoplevel then
                                      begin  {tellen van aantal betalende downlinks}
                                        if node.billing and
                                          node.billgroups[area.grp] then inc(info.nodes);
                                      end else
                                      begin
                                        if node.billing and node.billgroups[area.grp] then
                                          begin
                                            dec(HISTORY.Forwards);
                                            dec(Tforward);
                                            writelogcr(3,'Not send to '+node2str(node.address)+
                                              ' for insufficient credit amount!');
                                          end;
                                      end;
                                  end;
                              end else
                              begin  {node on pause of no export flg etc}
                                {if (S > cSeenTMP) dan staat node (nog) niet in de seenbylst}
                              end;
                        end;


                      write('#8#8#8');

                      if ((area.costperblock > 0) or area.incluplink) and (history.forwards > 0) then {bill bedrag uitrekenen}
                        begin
                          if not area.incluplink then info.totalcost := 0;
                          case area.block of
                            0 : begin {100kb}
                                  sizetel := info.size / (1024*100);
                                  info.cost := area.costperblock * sizetel;
                                  info.cost := round(info.cost);
                                  if area.costperblock * sizetel > info.cost then info.cost := info.cost + 1;
                                  info.totalcost := info.totalcost + round(info.cost);
                                  info.cost := 0;
                                end;
                            1 : begin {1024kb}
                                  sizetel := info.size / (1024*1024);
                                  info.cost := area.costperblock * sizetel;
                                  info.cost := round(info.cost);
                                  if area.costperblock * sizetel > info.cost then info.cost := info.cost + 1;
                                  info.totalcost := info.totalcost + round(info.cost);
                                  info.cost := 0;
                                end;
                            2 : begin {file}
                                  info.totalcost := info.totalcost + area.costperblock;
                                end;
                          end;

                          if area.addpercent > 0 then
                            info.totalcost := info.totalcost + ((info.totalcost / 100)*area.addpercent);

                          if area.inclhost then
                            begin
                              if area.alllinks then
                                info.cost := info.totalcost / (history.forwards+1) else
                                  begin
                                    if info.nodes > 0 then
                                      info.cost := info.totalcost / (info.nodes+1) else
                                        info.cost := info.totalcost;
                                  end;
                            end else
                            begin
                              if area.alllinks then
                                info.cost := info.totalcost / history.forwards else
                                  begin
                                    if info.nodes > 1 then
                                      info.cost := info.totalcost / info.nodes else
                                        info.cost := info.totalcost;
                                  end;
                            end;

                          writelogcr(3,'total costs : '+real_to_str(info.totalcost,2));
                          if info.nodes > 0 then
                            begin
                              writelog(3,'downlinks   : '+int_to_str(info.nodes));
                              if area.inclhost then writelogcr(3,' (+ host)') else writelogcr(3,'');
                              writelogcr(3,'per node    : '+real_to_str(info.cost,2));
                            end;
                        end else info.cost := 0;

                      if history.forwards > 0 then
                        begin
                          Notify (5,INFO.FileSpec);
                          if (info.totalcost > 0) and ((area.incluplink) or (area.costperblock > 0))
                            then notify(5,' ('+real_to_str(info.totalcost,0)+' cents)');
                          Notify (5,' to');
                        end;

                      if history.forwards > 0 then
                        begin

                          if area.msgfile <> '' then
                            info.msgfile := area.msgfile;

                          name1 := writeforwardinfo1(name);
                          { info1 wegschrijven }

                          for I := 1 to AREA.ExportNr do
                            begin
                              Getnoderec(true);
                              dow := ( file_size(info.filepath+info.filespec) div 1024 );
                              S := 1;
                              While (S <= cSeenTMP) and (not NodeEQ(SeenByTMP[S], sfxt^[I].A)) do Inc(S);

                              If (S > cSeenTMP)
                                and (not (pause in node.status))
                                and (not NodeEQ(info.From, sfxt^[I].A))
                                and (not nodeeq(info.origin, sfxt^[i].a))
                                and (export in sfxt^[i].s)
                                and ((dow <= node.maxfilesize) or (node.maxfilesize = 0))
                                and (
                                  (info.cost = 0)
                                  or (not node.billing)
                                  or (not node.billgroups[area.grp])
                                  or ((info.cost > 0) and (Node.credit > node.stoplevel)
                                    and node.billing and (node.billgroups[area.grp]))
                                    ) then
                                  begin
                                    Notify (5,' ' + Node2Str(sfxt^[I].A));

                                    if sfxt^[I].A.Point <> 0 then  { add to seen-bye }
                                      begin
                                        inc(info.cseen);
                                        info.SeenbyLst[info.cSeen] := sfxt^[I].A;
                                      end;


                                    match := ExceptionMatch (info.filespec, ex_nodepath, info.tag );
                                    if match then
                                      begin  {alternative node path}
                                        notify(5,' '+'(->)');
                                        copyfile(info.filepath+info.filespec,ex.line[1]+info.filespec);
                                        if node.tictype <> 0 {no ticks} then
                                          begin
                                            cmdprog := makeTIC (node.password, ex.fromnode, node.tictype = 2);
                                            if copyfile(SETUP.OutBoundPath+cmdprog,ex.line[1]+cmdprog) = 0 then
                                              delete_file(setup.outboundpath+cmdprog);
                                          end;

                                      end else
                                      begin
                                        if node.akaaddress.zone <> 0 then { forwarding to node's main address }
                                          writeforwardinfo(sfxt^[i],node.akaaddress,name1) else
                                            WriteForwardInfo(sfxt^[i],sfxt^[i].a,name1);
                                              { Add_System_to_Forward_List; }
                                      end;

                                    if sfxt^[i].a.point <> 0 then dec(info.cseen);
                                  end;
                            end;
                        end;

                      if history.forwards > 0 then Notifycr(5,'');

                      for I := 1 to AREA.ExportNr do
                        begin
                          Getnoderec(true);
                          dow := ( file_size(info.filepath+info.filespec) div 1024 );
                          S := 1;
                          While (S <= cSeenTMP) and (not NodeEQ(SeenByTMP[S], sfxt^[I].A)) do Inc(S);

                          If (S > cSeenTMP)
                            and (not (pause in node.status))
                            and (not NodeEQ(info.From, sfxt^[I].A))
                            and (not nodeEQ(info.origin, sfxt^[i].a))
                            and (export in sfxt^[i].s)
                            and ((dow <= node.maxfilesize) or (node.maxfilesize = 0))
                            and (info.cost > 0)
                            and node.billing
                            and (node.billgroups[area.grp])
                            and (node.credit > node.stoplevel) then
                              begin
                                if ((area.costperblock > 0) or area.incluplink) and
                                  node.billing and node.billgroups[area.grp] then
                                     begin
                                       WriteBillHistory( writebillinfo(false) );
                                     end;
                              end;
                        end;
                    end; {noforward}
                end;

              If filestatus = ok then
                begin
                  Update_History(currcrc);
                  If area.batchfile <> '' then DoBatchFile;
                end;

              {$I-} ChDir(udir(systempath)); {$I+}
              if IOresult <> 0 then WriteLn ('Unable to change path to '+udir(systempath));

            End; {filestatus = ok}

          While Doserror = 0 do findnext(sr);

        End else
        Begin
          NotifyCR (2,'Can''t find '+info.FilePath+info.FileSpec);
          FileStatus := NOTFOUND;
        End;
    End else
    Begin
      Notify (4,'Unknown area '''+info.TAG+''''); {vbc 290208 }
      NotifyCr (4,' in '+xticname+' ');                {vbc 290208 }
      FileStatus := UNKNOWN;
    End;

  If (FileStatus = OK) and (YetNoAction = True) then
    Begin
      FileStatus := NOACTION;
      NotifyCR (4,'No target directory and no forward info!');
    End Else

  If (Area.Keepdays <> 0) or (Area.Keepamount <> 0) then
    Begin
      gotmagic := false;
      Assign(tplfile,systempath+'FM_$A_MA.INT');
      {$I-} reset(tplfile); {$I+}
      if ioresult <> 0 then
        begin
          rewrite(tplfile);
        end else
        begin
          while not eof(tplfile) do
            begin
              readln(tplfile,topath);
              if topath = area.tag then gotmagic := true;
            end;
        end;
      if not gotmagic then
        begin
          append(tplfile);
          writeln(tplfile,area.tag);
        end;
      close(tplfile);
    End;

  notifycr(12,'');
End;


END.
