 {
 $Id$
}

 {*****************************************************************************
 *
 * Purpose ...............: Overlay unit
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Ovr; { FileMgr.exe overlay handler }

{$O-}  { can't be overlayed! }

Interface

Implementation

Uses Fm_Init, S_String, Overlay; { for program termination }

Var
  OldExitProc : Pointer;

{$f+} Procedure fmExitProc; {$f-}
Begin
  ExitProgram;
  ExitProc := OldExitProc;
End;

Function NoEms : Boolean;
Var X : Byte;
Begin
  NoEms := False;
  For X := 1 to ParamCount do
    If pos('NOEMS',Upper(ParamStr(X))) = 0 then NoEms := True;
End;

BEGIN
  OvrInit('FILEMGR.EXE');
  If OvrResult <> OvrOk then
    Begin
      OvrInit('FILEMGR.OVR');
      If OvrResult <> OvrOk then
        Begin
          Writeln(#7+'FILEMGR.OVR overlay file not found');
          Halt;
        End;
    End;

  If not NoEms then OvrInitEms;
  If OvrResult <> OvrOk then {};

  OldExitPRoc := ExitProc;
  ExitProc    := @FMExitProc;
END.
