{
 $Id$
}
{*****************************************************************************
 *
 * Produces:    Log file control
 * vbc 290208 - Added Build to version details in log file
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Log;  {$O+}

Interface

Uses Dos, Fm_Struct, S_String;

{---------------------------------------------------------------------------}

{ action: logtype:

    0     alleen op scherm, niet in logfile
    1     ! Fatal errors
    2     ? Other errors
    3     $ Accounting info
    4     * Processing of files
    5     : Forwarding of files
    10    = Sending of files
    6     + Brief messages
    7     - Trivial messages
    8     % Info messages
    9     ~ Session information
    11    # Manager info (will be in seperate logfile if setup)
    12      geen symbool vooraan tijd  }

Function  Verstr ( ver : word ) : string;
Procedure InitLog;

Procedure WriteLog   (Action : Byte; S : String);
Procedure WriteLogCR (Action : Byte; S : String);

Procedure Notify     (Action : Byte; S : String);
Procedure NotifyCR   (Action : Byte; S : String);

{---------------------------------------------------------------------------}

Implementation

Var
   Log    : Text;  {the logfile itself}
   LogIpx : Byte;  {schrijven op dezelfde regel (geen datum)}
   LogMgr : Byte;  {of logmgr logfile al geopend is geweest}


Function  VerStr ( ver : word ) : String;
Var Tmp : String;
Begin
  Tmp := Int_to_str(ver);
  While length(tmp) < 3 do Tmp := '0' + Tmp;
  Verstr := First(1,tmp)+'.'+last(2,Tmp);
End;


Function DateString : String;
Const
  Days  : array [0..6] of String[3] = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
  Month : array[1..12] of String[3] = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
Var
  YY,MM,DD,DW : Word;
Begin
  GetDate (YY,MM,DD,DW);
  if DD < 10 then
    DateString := Days[DW] + ' 0' + int_to_str(DD) + ' ' + Month[MM] + ' ' + int_to_str(YY)
      else DateString := Days[DW] + ' ' + int_to_str(DD) + ' ' + Month[MM] + ' ' + int_to_str(YY);
End;


Procedure Initlog;
Begin
  if setup.logfile = '' then exit;

  Assign (LOG, SETUP.Logfile);
  {$I-} Reset (LOG); {$I+}
  If IOresult <> 0 then
    Begin
      {$I-} Rewrite(log); {$I+}
      If ioresult <> 0 then
        Begin
          WriteLn ('Error opening ' + SETUP.Logfile + ' for output');
          Halt(1);
        End;
    End;

  Append(log);
  WriteLn(log, #13#10+'----------  '+DateString+' (FileMgr v'+verstr(VERSIONNR)+Build+' '+COMPILED+')');
  Close(Log);
  LogIpx := 0;
  LogMgr := 0;
End;


Procedure WriteLog (Action : Byte; S : String);
Var
  Time  : String[15];
  HH,MM,
  SS,HS : Word;
  No    : Char;
  dal   : boolean;
  logm  : text;
Begin
  if setup.logfile = '' then exit;

  Dal := False; {for areamanager logfile}

  Case Action of
   0 : Exit;
   1 : Begin
         No := '!';
         If not (LFatal in setup.logstatus) then exit;
       End;
   2 : Begin
         No := '?';
         If not (LOther in setup.logstatus) then exit;
       End;
   3 : Begin
         No := '$';
         If not (LAccounting in setup.logstatus) then exit;
       End;
   4 : Begin
         No := '*';
         If not (Lprocess in setup.logstatus) then exit;
       End;
   5 : Begin
         No := ':';
         If not (LForwarding in setup.logstatus) then exit;
       End;
   6 : Begin
         No := '+';
         If not (LBrief in setup.logstatus) then exit;
       End;
   7 : Begin
         No := '-';
         If not (LTrivial in setup.logstatus) then exit;
       End;
   8 : Begin
         No := '%';
         If not (Linfo in setup.logstatus) then exit;
       End;
   9 : Begin
         No := '~';
         If not (lsession in setup.logstatus) then exit;
       End;
  10 : Begin
         No := '=';
         If not (Lsending in setup.logstatus) then exit;
       End;
  11 : Begin
         No := '#';
         If setup.arealog <> '' then dal := true;
       End;
  12 : Begin
         No := ' ';
       End;
  End;

  GetTime (HH,MM,SS,HS);
  if HH < 10 then Time := '0' + int_to_str(HH) else Time := int_to_str(HH);
  if MM < 10 then Time := Time + ':0' + int_to_str(MM)
    else Time := Time + ':'  + int_to_str(MM);
  if SS < 10 then Time := Time + ':0' + int_to_str(SS)
    else Time := Time + ':'  + int_to_str(SS);

  If Dal then
    Begin
      Assign(logm,setup.arealog);
      {$I-} reset(logm); {$I+}
      If ioresult <> 0 then
        Begin
          {$I-} rewrite(logm); {$I+}
          If ioresult <> 0 then
            Begin
              WriteLog(1,'Cannot rewrite areamanager logfile '+setup.arealog);
              Exit;
            End;
        End Else append(logm);
      If LogMgr = 0 then
        Begin
          WriteLn(logm, #13#10+'----------  '+DateString+' MANAGER (FileMgr v'+verstr(VERSIONNR)+Build+' '+COMPILED+')');
          LogMgr := 1;
        End;
      If S <> '' then Write(logm, No + ' ' + Time + '  ' + S)
        Else Write(logm,'');
      Close(logm);
    End Else
    Begin
      {$I-} Append(Log); {$I+}
      If ioresult <> 0 then
        Begin
          Initlog;
          Append(log);
        End;
      If LogIpx = 0 then
        Begin
          Write(log, No + ' ' + Time + '  ' + S);
          LogIpx := 1;
        End Else
          Write(log,S);
      Close(Log);
    End;
End;

Procedure WriteLogCR (Action : Byte; S : String);
Begin
  WriteLog(Action,S+#13#10);
  LogIpx := 0;
End;

Procedure Notify (Action : Byte; S : String);
Begin
  Write(S);
  WriteLog(Action,S);
End;

Procedure NotifyCR (Action : Byte; S : String);
Begin
  Notify(Action,S+#13#10);
  LogIpx := 0;
End;

End.
