{
 $Id$
}
{*****************************************************************************
 *
 * produces: Report control
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_List;

{$O+}

Interface

Uses Crt, M_Window, F_Fast, S_String;

{---------------------------------------------------------------------------}

Procedure Create_List;
Procedure Remove_List;

Procedure Add_To_List ( Str:String );
Function  Get_From_List ( Entry:Word ) : String;

Function  Show_List (Window:Byte; Arrows,Jump:Boolean; JumpWord:Byte;
                     Active:Word) : String;

Var
  List_Amount : Word;

Ins_Hook       : Procedure;
Del_Hook       : Function( entry:word ) : boolean;
F3_Hook        : Procedure( entry:word );
InfoScreenHook : Procedure;
DosShellHook   : Procedure;
F1_Hook        : Procedure;

{---------------------------------------------------------------------------}

Implementation

{$F+} Procedure Dummy1; {$F-}
Begin
End;

{$F+} Function Dummy2(rec:word):Boolean; {$F-}
Begin
End;

{$F+} Procedure Dummy3(rec:word); {$F-}
Begin
End;


Type
  List = ^Element;

  Element = Record
    Str  : String[75];
    Next : List;
  End;

Var
  Start,
  Current  : List;


Procedure Create_List;
Begin
  New(Start);
  Current := Start;
  Current^.Next := Nil;
  List_Amount := 0;
End;


Procedure Remove_List;
Begin
  if start^.next <> nil then
    begin
      repeat
        current := start;
        start := current^.next;
        dispose(current);
      until start^.next = nil;
    end;
  dispose(start);
  list_amount := 0;
End;


Procedure Add_To_List ( Str:String );
Begin
  Current^.Str := Str;
  If maxavail > 3000 then
    begin
      New(Current^.Next);
      Current := Current^.Next;
      Current^.Next := Nil;
      Inc(List_Amount);
    end;
End;


Function Get_From_List ( Entry:Word ) : String;
Var X : Word;
Begin
  Current := Start;
  X := 1;
  While (X < Entry) and (Current^.Next <> Nil) do
    Begin
      Inc(x);
      Current := Current^.Next;
    End;
  If Entry > List_Amount then Get_From_List := '' Else
    Get_From_List := Current^.Str;
End;


Function Show_List(Window:Byte; Arrows,Jump:Boolean; JumpWord:Byte; Active:Word):String;
Var
  Ch     : Char;
  Top    : Integer;
  Index  : Byte;
  MaxIn  : Byte;
  Leng   : Byte;
  Input  : String;

  Procedure Arrow;
  Var Str : String;
  Begin
    Str := '';
    If MaxIn < List_Amount then
      Begin
        If Top > 1 then Str := Chr(24);
        If Top+Maxin-1 < List_Amount then Str := Str + Chr(25);
      End;
    Writeat(mwin[window].y1-3,mwin[window].y2,11,0,Str+'');
  End;

  Procedure Search;
  Var X : Integer;
  Begin
    Writeat(mwin[window].x1+2,mwin[window].y2,11,0,Input);

    Current := Start;
    X := 1;
    While (X < Top+Index) and (Current^.Next <> Nil) do
      Begin
        Inc(x);
        Current := Current^.Next;
      End;

    While (First(length(input), Extractwords(Jumpword,1,Upper(Current^.Str))) <> Upper(Input)) and (Current^.Next <> Nil) do
      Begin
        Inc(x);
        Current := Current^.Next;
      End;

    If Current^.Next = Nil then
      Begin
        Writeat(mwin[window].x1+2,mwin[window].y2,11,0,replicate(length(Input),''));
        Input := '';
      End Else
      Begin
        If (Top < X) and (Top+Maxin-1 > X) then
          Begin
            Index := X-Top+1;
          End Else
          Begin
            Top := (X-Maxin)+2;
            If Top+Maxin > List_Amount then Top := (List_Amount-Maxin)+1;
            Index := (X-Top)+1;
          End;
      End;
  End;

  Procedure ShowList;
  Var X : Integer;
  Begin
    For X := 1 to MaxIn do
      Begin
        If X = Index then
          Writeat(Mwin[window].x1+1,mwin[window].x2+x,kl4,kl5,
               ' '+expand(get_from_list(top+x-1),leng-2)+' ') Else
            Writeat(Mwin[window].x1+1,mwin[window].x2+x,3,0,
               ' '+expand(get_from_list(top+x-1),leng-2)+' ');
      End;
  End;

Begin
  MaxIn := (Mwin[window].y2 - MWin[window].x2)-1;
  Leng := (Mwin[window].y1 - MWin[window].x1)-1;

  if active <= maxin then
    begin
      top := 1;
      index := active;
    end else
    begin
      Top := Active-Maxin+1;
      Index := Maxin;
    end;

  Input := '';

  Repeat
    If List_Amount > 0 then ShowList else
      FillScreen(mwin[window].x1+1,mwin[window].x2+1,mwin[window].y1-1,mwin[window].y2-1,7,0,' ');
    If Arrows then Arrow;
    Ch := Readkey;
    If Ch = #0 then
      Begin

        Writeat(mwin[window].x1+2,mwin[window].y2,11,0,replicate(length(Input),''));
        Input := '';

        Ch := Readkey;
        Case Ch of
          #82 : Begin
                  Ins_hook;
                  If (index = 0) and (list_amount > index) then
                    begin
                      index := 1;
                    end else
                    begin
                      if index < maxin then inc(index) else inc(top);
                      while top+index-1 > list_amount do dec(index);
                    end;
                End;
          #83 : If List_Amount > 0 then
                  Begin
                    If Del_Hook(top+index-1) then {};
                    If top > 1 then dec(top) else
                      if top+index-1 > list_amount then dec(index);
                  End;
          #72 : begin  {up}
                  if index > 1 then dec(index) else
                    if top > 1 then dec(top);
                end;
          #80 : begin  {down}
                  if index < maxin then
                    begin
                      inc(index);
                      if index > list_amount then index := list_amount;
                    end else
                    if top+maxin-1 < list_amount then inc(top);
                end;
          #71 : begin  {home}
                  index := 1;
                  top := 1;
                end;
          #79 : begin  {end}
                  index := maxin;
                  if index > list_amount then
                    begin
                      top := 1;
                      index := list_amount;
                    end else
                      top := list_amount-maxin+1;
                end;
          #73 : begin  {pgup}
                  if index = 1 then
                    begin
                      dec(top,maxin);
                      if top < 1 then top := 1;
                    end else index := 1;
                end;
          #81 : begin  {pgdn}
                  if index = maxin then
                    begin
                      inc(top,maxin);
                      if top+maxin-1 > list_amount then top := list_amount-maxin+1;
                    end else index := maxin;
                  if index > list_amount then
                    begin
                      index := list_amount;
                      top := 1;
                    end;
                end;
          #61 : begin {f3}
                  F3_Hook(top+index-1);
                end;
          #59 : f1_hook;
        End;
      End Else
      Begin
        If Ch in [#32..#122] then
          Begin
            Input := Input + Upcase(Ch);
            If Jump then Search;
          End Else
        If (Ch = #13) and (List_Amount = 0) then Ch := #0 else
        If Ch = #9 then InfoScreenHook Else
        If Ch = #26 then DosShellHook;
      End;
  Until Ch in [#27,#13];

  If Ch = #27 then Show_List := '' Else Show_List := Get_From_List(top+index-1);
End;

Begin
 Ins_Hook := Dummy1;
 Del_Hook := Dummy2;
 F3_Hook := Dummy3;
 F1_Hook := Dummy1;
 DosShellHook := Dummy1;
 InfoScreenHook := Dummy1;
End.
